/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.control;

import com.acmerobotics.roadrunner.control.RobotKinematics;
import com.acmerobotics.roadrunner.geometry.DualNum;
import com.acmerobotics.roadrunner.geometry.Pose2d;
import com.acmerobotics.roadrunner.geometry.PoseVelocity2d;
import com.acmerobotics.roadrunner.geometry.PoseVelocity2dDual;
import com.acmerobotics.roadrunner.geometry.RobotState;
import com.acmerobotics.roadrunner.paths.PosePath;
import com.acmerobotics.roadrunner.profiles.VelConstraint;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0016R\u0018\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/acmerobotics/roadrunner/control/WheelVelConstraint;", "Lcom/acmerobotics/roadrunner/profiles/VelConstraint;", "kinematics", "Lcom/acmerobotics/roadrunner/control/RobotKinematics;", "maxWheelVel", "", "<init>", "(Lcom/acmerobotics/roadrunner/control/RobotKinematics;D)V", "maxRobotVel", "robotState", "Lcom/acmerobotics/roadrunner/geometry/RobotState;", "path", "Lcom/acmerobotics/roadrunner/paths/PosePath;", "s", "core"})
@SourceDebugExtension(value={"SMAP\nKinematics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Kinematics.kt\ncom/acmerobotics/roadrunner/control/WheelVelConstraint\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,301:1\n1#2:302\n*E\n"})
public final class WheelVelConstraint
implements VelConstraint {
    @JvmField
    @NotNull
    public final RobotKinematics<?, ?> kinematics;
    @JvmField
    public final double maxWheelVel;

    public WheelVelConstraint(@NotNull RobotKinematics<?, ?> kinematics, double maxWheelVel) {
        Intrinsics.checkNotNullParameter(kinematics, (String)"kinematics");
        this.kinematics = kinematics;
        this.maxWheelVel = maxWheelVel;
    }

    @Override
    public double maxRobotVel(@NotNull RobotState robotState, @NotNull PosePath path, double s) {
        Intrinsics.checkNotNullParameter((Object)robotState, (String)"robotState");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Pose2d txRobotWorld = robotState.pose.inverse();
        PoseVelocity2d robotVelWorld = robotState.vel;
        PoseVelocity2d robotVelRobot = txRobotWorld.times(robotVelWorld);
        Iterator iterator = ((Iterable)this.kinematics.inverse(PoseVelocity2dDual.Companion.constant(robotVelRobot, 1)).all()).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        DualNum it = (DualNum)iterator.next();
        boolean bl = false;
        double d = Math.abs(this.maxWheelVel / it.value());
        while (iterator.hasNext()) {
            DualNum it2 = (DualNum)iterator.next();
            $i$a$-minOf-WheelVelConstraint$maxRobotVel$1 = false;
            double d2 = Math.abs(this.maxWheelVel / it2.value());
            d = Math.min(d, d2);
        }
        return d;
    }
}

