/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.geometry;

import com.acmerobotics.roadrunner.geometry.DualNum;
import com.acmerobotics.roadrunner.geometry.DualParameter;
import com.acmerobotics.roadrunner.geometry.Math;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\u001aJ\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\u001a2\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\u00a8\u0006\f"}, d2={"lerpDual", "Lcom/acmerobotics/roadrunner/geometry/DualNum;", "Param", "Lcom/acmerobotics/roadrunner/geometry/DualParameter;", "x", "", "fromLo", "fromHi", "toLo", "toHi", "atan2", "y", "core"})
@SourceDebugExtension(value={"SMAP\nDualNum.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DualNum.kt\ncom/acmerobotics/roadrunner/geometry/DualNumKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,405:1\n1#2:406\n*E\n"})
public final class DualNumKt {
    @NotNull
    public static final <Param extends DualParameter> DualNum<Param> lerpDual(double x, double fromLo, double fromHi, @NotNull DualNum<Param> toLo, @NotNull DualNum<Param> toHi) {
        Intrinsics.checkNotNullParameter(toLo, (String)"toLo");
        Intrinsics.checkNotNullParameter(toHi, (String)"toHi");
        if (!(toLo.size() == toHi.size())) {
            boolean bl = false;
            String string = "Lower and upper bounds must have the same size";
            throw new IllegalArgumentException(string.toString());
        }
        int n = 0;
        int n2 = toLo.size();
        double[] dArray = new double[n2];
        while (n < n2) {
            int n3 = n++;
            dArray[n3] = Math.lerp(x, fromLo, fromHi, toLo.get(n3), toHi.get(n3));
        }
        double[] dArray2 = dArray;
        return new DualNum(dArray2);
    }

    @NotNull
    public static final <Param extends DualParameter> DualNum<Param> atan2(@NotNull DualNum<Param> y, @NotNull DualNum<Param> x) {
        Intrinsics.checkNotNullParameter(y, (String)"y");
        Intrinsics.checkNotNullParameter(x, (String)"x");
        if (!(x.size() == y.size())) {
            boolean $i$a$-require-DualNumKt$atan2$22 = false;
            String $i$a$-require-DualNumKt$atan2$22 = "x and y must have the same size";
            throw new IllegalArgumentException($i$a$-require-DualNumKt$atan2$22.toString());
        }
        DualNum out = new DualNum(new double[x.size()]);
        if (out.size() == 0) {
            return out;
        }
        double atan2Val = java.lang.Math.atan2(y.get(0), x.get(0));
        double[] result = new double[x.size()];
        result[0] = atan2Val;
        if (out.size() == 1) {
            return new DualNum(result);
        }
        double denom = x.get(0) * x.get(0) + y.get(0) * y.get(0);
        result[1] = (x.get(0) * y.get(1) - y.get(0) * x.get(1)) / denom;
        if (out.size() == 2) {
            return new DualNum(result);
        }
        double f = x.get(0) * y.get(1) - y.get(0) * x.get(1);
        double dfdt = x.get(0) * y.get(2) - y.get(0) * x.get(2);
        double dgdt = (double)2 * (x.get(0) * x.get(1) + y.get(0) * y.get(1));
        result[2] = (denom * dfdt - f * dgdt) / (denom * denom);
        if (out.size() == 3) {
            return new DualNum(result);
        }
        double x0 = x.get(0);
        double y0 = y.get(0);
        double x1 = x.get(1);
        double y1 = y.get(1);
        double x2 = x.get(2);
        double y2 = y.get(2);
        double x3 = x.get(3);
        double y3 = y.get(3);
        double d2fdt2 = x1 * y2 + x0 * y3 - y1 * x2 - y0 * x3;
        double d2gdt2 = (double)2 * (x1 * x1 + x0 * x2 + y1 * y1 + y0 * y2);
        double numerator = denom * d2fdt2 + dgdt * dfdt - dgdt * dfdt - f * d2gdt2;
        double denomDerivative = (double)2 * denom * dgdt;
        result[3] = (denom * denom * numerator - (denom * dfdt - f * dgdt) * denomDerivative) / (denom * denom * denom);
        return new DualNum(result);
    }
}

