/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.geometry;

import com.acmerobotics.roadrunner.geometry.DualNum;
import com.acmerobotics.roadrunner.geometry.DualNumKt;
import com.acmerobotics.roadrunner.geometry.DualParameter;
import com.acmerobotics.roadrunner.geometry.Math;
import com.acmerobotics.roadrunner.geometry.Pose2d;
import com.acmerobotics.roadrunner.geometry.Pose2dDual;
import com.acmerobotics.roadrunner.geometry.Rotation2d;
import com.acmerobotics.roadrunner.geometry.Rotation2dDual;
import com.acmerobotics.roadrunner.geometry.Vector2d;
import com.acmerobotics.roadrunner.geometry.Vector2dDual;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u0001\u001a\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u0001\u001a,\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\u00060\u0001\"\b\b\u0000\u0010\u0007*\u00020\b*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\t0\u0001\u001a,\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\u00060\u0001\"\b\b\u0000\u0010\u0007*\u00020\b*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\t0\u0001\u001a,\u0010\u000b\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\f0\u0001*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0001\u001aX\u0010\r\u001a&\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000e0\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000f0\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00100\u00010\f\"\u0004\b\u0000\u0010\u000e\"\u0004\b\u0001\u0010\u000f\"\u0004\b\u0002\u0010\u0010*\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u00100\f0\u0011\u001a\u001e\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0002\u001a:\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00070\t\"\b\b\u0000\u0010\u0007*\u00020\b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0006\u0010\u0015\u001a\u00020\u0002\u001a\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0002\u001a:\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00070\u001a\"\b\b\u0000\u0010\u0007*\u00020\b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00070\u001a2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00070\u001a2\u0006\u0010\u0015\u001a\u00020\u0002\u001a\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u0002\u001a:\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00070\u001e\"\b\b\u0000\u0010\u0007*\u00020\b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00070\u001e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00070\u001e2\u0006\u0010\u0015\u001a\u00020\u0002\u001a*\u0010\u001f\u001a\u00020\u001c2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00012\u0006\u0010\"\u001a\u00020\u0002\u001a@\u0010#\u001a\b\u0012\u0004\u0012\u0002H\u00070\u001e\"\b\b\u0000\u0010\u0007*\u00020\b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0012\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\u001e0\u00012\u0006\u0010\"\u001a\u00020\u0002\u00a8\u0006$"}, d2={"xs", "", "", "Lcom/acmerobotics/roadrunner/geometry/Vector2d;", "ys", "xsDual", "Lcom/acmerobotics/roadrunner/geometry/DualNum;", "Param", "Lcom/acmerobotics/roadrunner/geometry/DualParameter;", "Lcom/acmerobotics/roadrunner/geometry/Vector2dDual;", "ysDual", "dva", "Lkotlin/Triple;", "unzip", "A", "B", "C", "", "lerpVector2d", "start", "end", "t", "lerpVector2dDual", "lerpRotation2d", "Lcom/acmerobotics/roadrunner/geometry/Rotation2d;", "lerpRotation2dDual", "Lcom/acmerobotics/roadrunner/geometry/Rotation2dDual;", "lerpPose2d", "Lcom/acmerobotics/roadrunner/geometry/Pose2d;", "lerpPose2dDual", "Lcom/acmerobotics/roadrunner/geometry/Pose2dDual;", "lerpPoseLookup", "times", "poses", "query", "lerpPoseLookupDual", "core"})
@JvmName(name="Geometry")
@SourceDebugExtension(value={"SMAP\nGeometry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Geometry.kt\ncom/acmerobotics/roadrunner/geometry/Geometry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,531:1\n1563#2:532\n1634#2,3:533\n1563#2:536\n1634#2,3:537\n1563#2:540\n1634#2,3:541\n1563#2:544\n1634#2,3:545\n1563#2:548\n1634#2,3:549\n1#3:552\n*S KotlinDebug\n*F\n+ 1 Geometry.kt\ncom/acmerobotics/roadrunner/geometry/Geometry\n*L\n39#1:532\n39#1:533,3\n40#1:536\n40#1:537,3\n81#1:540\n81#1:541,3\n82#1:544\n82#1:545,3\n86#1:548\n86#1:549,3\n*E\n"})
public final class Geometry {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Double> xs(@NotNull List<Vector2d> $this$xs) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$xs, (String)"<this>");
        Iterable $this$map$iv = $this$xs;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Vector2d vector2d = (Vector2d)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.asPair());
        }
        return (List)CollectionsKt.unzip((Iterable)((List)destination$iv$iv)).getFirst();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Double> ys(@NotNull List<Vector2d> $this$ys) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$ys, (String)"<this>");
        Iterable $this$map$iv = $this$ys;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Vector2d vector2d = (Vector2d)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.asPair());
        }
        return (List)CollectionsKt.unzip((Iterable)((List)destination$iv$iv)).getSecond();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <Param extends DualParameter> List<DualNum<Param>> xsDual(@NotNull List<Vector2dDual<Param>> $this$xsDual) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$xsDual, (String)"<this>");
        Iterable $this$map$iv = $this$xsDual;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Vector2dDual vector2dDual = (Vector2dDual)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.asPair());
        }
        return (List)CollectionsKt.unzip((Iterable)((List)destination$iv$iv)).getFirst();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <Param extends DualParameter> List<DualNum<Param>> ysDual(@NotNull List<Vector2dDual<Param>> $this$ysDual) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$ysDual, (String)"<this>");
        Iterable $this$map$iv = $this$ysDual;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Vector2dDual vector2dDual = (Vector2dDual)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.asPair());
        }
        return (List)CollectionsKt.unzip((Iterable)((List)destination$iv$iv)).getSecond();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Triple<Double, Double, Double>> dva(@NotNull List<? extends Vector2dDual<?>> $this$dva) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$dva, (String)"<this>");
        if (!(((Vector2dDual)CollectionsKt.first($this$dva)).x.size() >= 3)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Iterable $this$map$iv = $this$dva;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Vector2dDual vector2dDual = (Vector2dDual)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Triple((Object)it.value().norm(), (Object)it.drop(1).value().norm(), (Object)it.drop(2).value().norm()));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final <A, B, C> Triple<List<A>, List<B>, List<C>> unzip(@NotNull Iterable<? extends Triple<? extends A, ? extends B, ? extends C>> $this$unzip) {
        Intrinsics.checkNotNullParameter($this$unzip, (String)"<this>");
        List first = new ArrayList();
        List second = new ArrayList();
        List third = new ArrayList();
        for (Triple<A, B, C> triple : $this$unzip) {
            first.add(triple.getFirst());
            second.add(triple.getSecond());
            third.add(triple.getThird());
        }
        return new Triple((Object)first, (Object)second, (Object)third);
    }

    @NotNull
    public static final Vector2d lerpVector2d(@NotNull Vector2d start, @NotNull Vector2d end, double t) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        double x = Math.lerp(t, 0.0, 1.0, start.x, end.x);
        double y = Math.lerp(t, 0.0, 1.0, start.y, end.y);
        return new Vector2d(x, y);
    }

    @NotNull
    public static final <Param extends DualParameter> Vector2dDual<Param> lerpVector2dDual(@NotNull Vector2dDual<Param> start, @NotNull Vector2dDual<Param> end, double t) {
        Intrinsics.checkNotNullParameter(start, (String)"start");
        Intrinsics.checkNotNullParameter(end, (String)"end");
        DualNum x = DualNumKt.lerpDual(t, 0.0, 1.0, start.x, end.x);
        DualNum y = DualNumKt.lerpDual(t, 0.0, 1.0, start.y, end.y);
        return new Vector2dDual(x, y);
    }

    @NotNull
    public static final Rotation2d lerpRotation2d(@NotNull Rotation2d start, @NotNull Rotation2d end, double t) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        double diff = end.minus(start);
        return Rotation2d.Companion.exp(start.log() + diff * t);
    }

    @NotNull
    public static final <Param extends DualParameter> Rotation2dDual<Param> lerpRotation2dDual(@NotNull Rotation2dDual<Param> start, @NotNull Rotation2dDual<Param> end, double t) {
        Intrinsics.checkNotNullParameter(start, (String)"start");
        Intrinsics.checkNotNullParameter(end, (String)"end");
        return Rotation2dDual.Companion.exp(DualNumKt.lerpDual(t, 0.0, 1.0, start.log(), end.log()));
    }

    @NotNull
    public static final Pose2d lerpPose2d(@NotNull Pose2d start, @NotNull Pose2d end, double t) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        if (!(0.0 <= t ? t <= 1.0 : false)) {
            boolean $i$a$-require-Geometry$lerpPose2d$22 = false;
            String $i$a$-require-Geometry$lerpPose2d$22 = "Interpolation parameter t must be between 0.0 and 1.0, but was " + t;
            throw new IllegalArgumentException($i$a$-require-Geometry$lerpPose2d$22.toString());
        }
        Vector2d position = Geometry.lerpVector2d(start.position, end.position, t);
        Rotation2d heading = Geometry.lerpRotation2d(start.heading, end.heading, t);
        return new Pose2d(position, heading);
    }

    @NotNull
    public static final <Param extends DualParameter> Pose2dDual<Param> lerpPose2dDual(@NotNull Pose2dDual<Param> start, @NotNull Pose2dDual<Param> end, double t) {
        Intrinsics.checkNotNullParameter(start, (String)"start");
        Intrinsics.checkNotNullParameter(end, (String)"end");
        if (!(0.0 <= t ? t <= 1.0 : false)) {
            boolean $i$a$-require-Geometry$lerpPose2dDual$22 = false;
            String $i$a$-require-Geometry$lerpPose2dDual$22 = "Interpolation parameter t must be between 0.0 and 1.0, but was " + t;
            throw new IllegalArgumentException($i$a$-require-Geometry$lerpPose2dDual$22.toString());
        }
        Vector2dDual position = Geometry.lerpVector2dDual(start.position, end.position, t);
        Rotation2dDual heading = Geometry.lerpRotation2dDual(start.heading, end.heading, t);
        return new Pose2dDual(position, heading);
    }

    @NotNull
    public static final Pose2d lerpPoseLookup(@NotNull List<Double> times, @NotNull List<Pose2d> poses, double query) {
        Intrinsics.checkNotNullParameter(times, (String)"times");
        Intrinsics.checkNotNullParameter(poses, (String)"poses");
        int index = CollectionsKt.binarySearch$default(times, (Comparable)Double.valueOf(query), (int)0, (int)0, (int)6, null);
        if (index >= 0) {
            return poses.get(index);
        }
        int nextIdx = -(index + 1);
        int prevIdx = -index;
        return Geometry.lerpPose2d(poses.get(prevIdx), poses.get(nextIdx), Math.lerp(query, ((Number)times.get(prevIdx)).doubleValue(), ((Number)times.get(nextIdx)).doubleValue(), 0.0, 1.0));
    }

    @NotNull
    public static final <Param extends DualParameter> Pose2dDual<Param> lerpPoseLookupDual(@NotNull List<Double> times, @NotNull List<Pose2dDual<Param>> poses, double query) {
        Intrinsics.checkNotNullParameter(times, (String)"times");
        Intrinsics.checkNotNullParameter(poses, (String)"poses");
        int index = CollectionsKt.binarySearch$default(times, (Comparable)Double.valueOf(query), (int)0, (int)0, (int)6, null);
        if (index >= 0) {
            return poses.get(index);
        }
        int nextIdx = -(index + 1);
        int prevIdx = -index;
        return Geometry.lerpPose2dDual(poses.get(prevIdx), poses.get(nextIdx), Math.lerp(query, ((Number)times.get(prevIdx)).doubleValue(), ((Number)times.get(nextIdx)).doubleValue(), 0.0, 1.0));
    }
}

