/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.geometry;

import com.acmerobotics.roadrunner.geometry.Math;
import com.acmerobotics.roadrunner.geometry.Matrix;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.ejml.dense.row.decomposition.lu.LUDecompositionAlt_DDRM;
import org.ejml.simple.ConstMatrix;
import org.ejml.simple.SimpleBase;
import org.ejml.simple.SimpleMatrix;
import org.jetbrains.annotations.NotNull;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0003\u001a\r\u0010\u0000\u001a\u00020\u0001*\u00020\u0001H\u0080\u0002\u001a\u0015\u0010\u0002\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001H\u0080\u0002\u001a\u0015\u0010\u0002\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0080\u0002\u001a\u0015\u0010\u0002\u001a\u00020\u0001*\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0001H\u0080\u0002\u001a\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006\u001a\u001d\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a2\u0006\u0002\u0010\f\u001a\u0012\u0010\r\u001a\u00020\u00062\n\u0010\u000e\u001a\u00020\u000b\"\u00020\u0004\u001a\u0018\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u00010\u00012\u0006\u0010\u000e\u001a\u00020\u000bH\u0000\u001a\u0014\u0010\u0010\u001a\n \u000f*\u0004\u0018\u00010\u00010\u0001*\u00020\u0001H\u0000\u001a\u001e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0004\u001a \u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0004H\u0000\u001a*\u0010\u0015\u001a\u00020\u00062\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u00162\u0006\u0010\u0018\u001a\u00020\u0004\u001a,\u0010\u0015\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u0004H\u0000\u00a8\u0006\u0019"}, d2={"unaryMinus", "Lorg/ejml/simple/SimpleMatrix;", "times", "other", "", "solveMatrices", "Lcom/acmerobotics/roadrunner/geometry/Matrix;", "a", "b", "transpose", "", "", "([[D)[[D", "makeBrysonMatrix", "tolerances", "kotlin.jvm.PlatformType", "lu", "lerpMatrix", "start", "end", "t", "lerpMatrixLookup", "", "matrices", "query", "core"})
@JvmName(name="Matrices")
@SourceDebugExtension(value={"SMAP\nMatrices.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Matrices.kt\ncom/acmerobotics/roadrunner/geometry/Matrices\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,257:1\n11288#2:258\n11623#2,3:259\n1#3:262\n1563#4:263\n1634#4,3:264\n*S KotlinDebug\n*F\n+ 1 Matrices.kt\ncom/acmerobotics/roadrunner/geometry/Matrices\n*L\n219#1:258\n219#1:259,3\n257#1:263\n257#1:264,3\n*E\n"})
public final class Matrices {
    @NotNull
    public static final SimpleMatrix unaryMinus(@NotNull SimpleMatrix $this$unaryMinus) {
        Intrinsics.checkNotNullParameter((Object)$this$unaryMinus, (String)"<this>");
        return Matrices.times($this$unaryMinus, -1.0);
    }

    @NotNull
    public static final SimpleMatrix times(@NotNull SimpleMatrix $this$times, @NotNull SimpleMatrix other) {
        Intrinsics.checkNotNullParameter((Object)$this$times, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        SimpleBase simpleBase = $this$times.mult((ConstMatrix)other);
        Intrinsics.checkNotNullExpressionValue((Object)simpleBase, (String)"mult(...)");
        return (SimpleMatrix)simpleBase;
    }

    @NotNull
    public static final SimpleMatrix times(@NotNull SimpleMatrix $this$times, double other) {
        Intrinsics.checkNotNullParameter((Object)$this$times, (String)"<this>");
        SimpleBase simpleBase = $this$times.scale(other);
        Intrinsics.checkNotNullExpressionValue((Object)simpleBase, (String)"scale(...)");
        return (SimpleMatrix)simpleBase;
    }

    @NotNull
    public static final SimpleMatrix times(double $this$times, @NotNull SimpleMatrix other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Matrices.times(other, $this$times);
    }

    @NotNull
    public static final Matrix solveMatrices(@NotNull Matrix a, @NotNull Matrix b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return a.solve(b);
    }

    private static final double[][] transpose(double[][] $this$transpose) {
        int rows = ((Object[])$this$transpose).length;
        int cols = $this$transpose[0].length;
        int n = 0;
        double[][] dArrayArray = new double[cols][];
        while (n < cols) {
            int n2 = n++;
            dArrayArray[n2] = new double[rows];
        }
        double[][] ret = dArrayArray;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                ret[j][i] = $this$transpose[i][j];
            }
        }
        return ret;
    }

    @NotNull
    public static final Matrix makeBrysonMatrix(double ... tolerances) {
        Intrinsics.checkNotNullParameter((Object)tolerances, (String)"tolerances");
        SimpleMatrix simpleMatrix = Matrices.makeBrysonMatrix(tolerances);
        Intrinsics.checkNotNullExpressionValue((Object)simpleMatrix, (String)"makeBrysonMatrix(...)");
        return new Matrix(simpleMatrix);
    }

    /*
     * WARNING - void declaration
     */
    public static final SimpleMatrix makeBrysonMatrix(@NotNull double[] tolerances) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tolerances, (String)"tolerances");
        double[] $this$map$iv = tolerances;
        boolean $i$f$map = false;
        double[] dArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_9 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(java.lang.Math.abs((double)it) <= Double.MAX_VALUE ? 1.0 / java.lang.Math.pow((double)it, 2) : 0.0);
        }
        double[] dArray2 = CollectionsKt.toDoubleArray((Collection)((List)destination$iv$iv));
        return SimpleMatrix.diag((double[])Arrays.copyOf(dArray2, dArray2.length));
    }

    public static final SimpleMatrix lu(@NotNull SimpleMatrix $this$lu) {
        Intrinsics.checkNotNullParameter((Object)$this$lu, (String)"<this>");
        LUDecompositionAlt_DDRM it = new LUDecompositionAlt_DDRM();
        boolean bl = false;
        it.decompose($this$lu.getDDRM());
        return SimpleMatrix.wrap((org.ejml.data.Matrix)((org.ejml.data.Matrix)it.getLU()));
    }

    @NotNull
    public static final Matrix lerpMatrix(@NotNull Matrix start, @NotNull Matrix end, double t) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        if (!Intrinsics.areEqual(start.size, end.size)) {
            boolean bl = false;
            String string = "Matrices must have the same size";
            throw new IllegalArgumentException(string.toString());
        }
        return end.minus(start).times(t).plus(start);
    }

    @NotNull
    public static final SimpleMatrix lerpMatrix(@NotNull SimpleMatrix start, @NotNull SimpleMatrix end, double t) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        return Matrices.lerpMatrix(new Matrix(start), new Matrix(end), t).getSimple$core();
    }

    @NotNull
    public static final Matrix lerpMatrixLookup(@NotNull List<Double> times, @NotNull List<Matrix> matrices, double query) {
        Intrinsics.checkNotNullParameter(times, (String)"times");
        Intrinsics.checkNotNullParameter(matrices, (String)"matrices");
        int index = CollectionsKt.binarySearch$default(times, (Comparable)Double.valueOf(query), (int)0, (int)0, (int)6, null);
        if (index >= 0) {
            return matrices.get(index);
        }
        int nextIdx = -(index + 1);
        int prevIdx = -index;
        return Matrices.lerpMatrix(matrices.get(prevIdx), matrices.get(nextIdx), Math.lerp(query, ((Number)times.get(prevIdx)).doubleValue(), ((Number)times.get(nextIdx)).doubleValue(), 0.0, 1.0));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SimpleMatrix lerpMatrixLookup(@NotNull List<Double> times, @NotNull List<? extends SimpleMatrix> matrices, double query) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(times, (String)"times");
        Intrinsics.checkNotNullParameter(matrices, (String)"matrices");
        Iterable iterable = matrices;
        List<Double> list = times;
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SimpleMatrix simpleMatrix = (SimpleMatrix)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Matrix((SimpleMatrix)it));
        }
        return Matrices.lerpMatrixLookup(list, (List)destination$iv$iv, query).getSimple$core();
    }
}

