/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.geometry;

import com.acmerobotics.roadrunner.geometry.DualNum;
import com.acmerobotics.roadrunner.geometry.DualParameter;
import com.acmerobotics.roadrunner.geometry.Pose2d;
import com.acmerobotics.roadrunner.geometry.Pose2dDual;
import com.acmerobotics.roadrunner.geometry.PoseVelocity2dDual;
import com.acmerobotics.roadrunner.geometry.Rotation2d;
import com.acmerobotics.roadrunner.geometry.Rotation2dDual$;
import com.acmerobotics.roadrunner.geometry.Vector2d;
import com.acmerobotics.roadrunner.geometry.Vector2dDual;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.PluginGeneratedSerialDescriptor;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 8*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u000289B#\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB;\b\u0010\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0005\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\u0007\u0010\rJ\u0006\u0010\u000e\u001a\u00020\nJ\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0010\u001a\u00020\u0011H\u0086\u0002J\u001d\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0086\u0002J\u001d\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0086\u0002J\u001d\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0086\u0002J\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0086\u0002J\u001d\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0086\u0002J\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0019\u001a\u00020\u001aH\u0086\u0002J\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0086\u0002J\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J$\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H 0\u0000\"\b\b\u0001\u0010 *\u00020\u00022\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H 0\u0005J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005J\u0006\u0010#\u001a\u00020\u001aJ\f\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005J\u000f\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c6\u0003J\u000f\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c6\u0003J/\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c6\u0001J\u0013\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\t\u0010+\u001a\u00020\nH\u00d6\u0001J\t\u0010,\u001a\u00020-H\u00d6\u0001JE\u0010.\u001a\u00020/\"\n\b\u0001\u0010\u0001*\u0004\u0018\u00010\u00032\f\u00100\u001a\b\u0012\u0004\u0012\u0002H\u00010\u00002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\f\u00105\u001a\b\u0012\u0004\u0012\u0002H\u000106H\u0001\u00a2\u0006\u0002\b7R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/acmerobotics/roadrunner/geometry/Rotation2dDual;", "Param", "Lcom/acmerobotics/roadrunner/geometry/DualParameter;", "", "real", "Lcom/acmerobotics/roadrunner/geometry/DualNum;", "imag", "<init>", "(Lcom/acmerobotics/roadrunner/geometry/DualNum;Lcom/acmerobotics/roadrunner/geometry/DualNum;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILcom/acmerobotics/roadrunner/geometry/DualNum;Lcom/acmerobotics/roadrunner/geometry/DualNum;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "size", "plus", "x", "", "d", "times", "Lcom/acmerobotics/roadrunner/geometry/PoseVelocity2dDual;", "pv", "Lcom/acmerobotics/roadrunner/geometry/Vector2dDual;", "v", "Lcom/acmerobotics/roadrunner/geometry/Vector2d;", "r", "Lcom/acmerobotics/roadrunner/geometry/Rotation2d;", "Lcom/acmerobotics/roadrunner/geometry/Pose2dDual;", "p", "Lcom/acmerobotics/roadrunner/geometry/Pose2d;", "inverse", "reparam", "NewParam", "oldParam", "velocity", "value", "log", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "typeSerial0", "Lkotlinx/serialization/KSerializer;", "write$Self$core", "Companion", "$serializer", "core"})
@SourceDebugExtension(value={"SMAP\nGeometry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Geometry.kt\ncom/acmerobotics/roadrunner/geometry/Rotation2dDual\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,531:1\n1#2:532\n*E\n"})
public final class Rotation2dDual<Param extends DualParameter> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final DualNum<Param> real;
    @JvmField
    @NotNull
    public final DualNum<Param> imag;
    @JvmField
    @NotNull
    private static final SerialDescriptor $cachedDescriptor;

    public Rotation2dDual(@NotNull DualNum<Param> real, @NotNull DualNum<Param> imag) {
        Intrinsics.checkNotNullParameter(real, (String)"real");
        Intrinsics.checkNotNullParameter(imag, (String)"imag");
        this.real = real;
        this.imag = imag;
        if (!(this.real.size() == this.imag.size())) {
            boolean $i$a$-require-Rotation2dDual$32 = false;
            String $i$a$-require-Rotation2dDual$32 = "Real and imaginary parts must have the same size";
            throw new IllegalArgumentException($i$a$-require-Rotation2dDual$32.toString());
        }
        if (!(this.real.size() <= 3)) {
            boolean bl = false;
            String string = "Only derivatives up to 2nd order are supported";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final int size() {
        return this.real.size();
    }

    @NotNull
    public final Rotation2dDual<Param> plus(double x) {
        return this.times(Rotation2d.Companion.exp(x));
    }

    @NotNull
    public final Rotation2dDual<Param> plus(@NotNull DualNum<Param> d) {
        Intrinsics.checkNotNullParameter(d, (String)"d");
        return this.times(Companion.exp(d));
    }

    @NotNull
    public final PoseVelocity2dDual<Param> times(@NotNull PoseVelocity2dDual<Param> pv) {
        Intrinsics.checkNotNullParameter(pv, (String)"pv");
        return new PoseVelocity2dDual(this.times(pv.linearVel), pv.angVel);
    }

    @NotNull
    public final Vector2dDual<Param> times(@NotNull Vector2dDual<Param> v) {
        Intrinsics.checkNotNullParameter(v, (String)"v");
        return new Vector2dDual<Param>(this.real.times(v.x).minus(this.imag.times(v.y)), this.imag.times(v.x).plus(this.real.times(v.y)));
    }

    @NotNull
    public final Vector2dDual<Param> times(@NotNull Vector2d v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return new Vector2dDual<Param>(this.real.times(v.x).minus(this.imag.times(v.y)), this.imag.times(v.x).plus(this.real.times(v.y)));
    }

    @NotNull
    public final Rotation2dDual<Param> times(@NotNull Rotation2dDual<Param> r) {
        Intrinsics.checkNotNullParameter(r, (String)"r");
        return new Rotation2dDual<Param>(this.real.times(r.real).minus(this.imag.times(r.imag)), this.real.times(r.imag).plus(this.imag.times(r.real)));
    }

    @NotNull
    public final Rotation2dDual<Param> times(@NotNull Rotation2d r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return new Rotation2dDual<Param>(this.real.times(r.real).minus(this.imag.times(r.imag)), this.real.times(r.imag).plus(this.imag.times(r.real)));
    }

    @NotNull
    public final Pose2dDual<Param> times(@NotNull Pose2d p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return new Pose2dDual<Param>(this.times(p.position), this.times(p.heading));
    }

    @NotNull
    public final Rotation2dDual<Param> inverse() {
        return new Rotation2dDual<Param>(this.real, this.imag.unaryMinus());
    }

    @NotNull
    public final <NewParam extends DualParameter> Rotation2dDual<NewParam> reparam(@NotNull DualNum<NewParam> oldParam) {
        Intrinsics.checkNotNullParameter(oldParam, (String)"oldParam");
        return new Rotation2dDual<NewParam>(this.real.reparam(oldParam), this.imag.reparam(oldParam));
    }

    @NotNull
    public final DualNum<Param> velocity() {
        return this.real.times(this.imag.drop(1)).minus(this.imag.times(this.real.drop(1)));
    }

    @NotNull
    public final Rotation2d value() {
        return new Rotation2d(this.real.value(), this.imag.value());
    }

    @NotNull
    public final DualNum<Param> log() {
        int n = 0;
        int n2 = this.size();
        double[] dArray = new double[n2];
        while (n < n2) {
            int n3 = n++;
            dArray[n3] = new Rotation2d(this.real.get(n3), this.imag.get(n3)).log();
        }
        double[] dArray2 = dArray;
        return new DualNum(dArray2);
    }

    @NotNull
    public final DualNum<Param> component1() {
        return this.real;
    }

    @NotNull
    public final DualNum<Param> component2() {
        return this.imag;
    }

    @NotNull
    public final Rotation2dDual<Param> copy(@NotNull DualNum<Param> real, @NotNull DualNum<Param> imag) {
        Intrinsics.checkNotNullParameter(real, (String)"real");
        Intrinsics.checkNotNullParameter(imag, (String)"imag");
        return new Rotation2dDual<Param>(real, imag);
    }

    public static /* synthetic */ Rotation2dDual copy$default(Rotation2dDual rotation2dDual, DualNum dualNum, DualNum dualNum2, int n, Object object) {
        if ((n & 1) != 0) {
            dualNum = rotation2dDual.real;
        }
        if ((n & 2) != 0) {
            dualNum2 = rotation2dDual.imag;
        }
        return rotation2dDual.copy(dualNum, dualNum2);
    }

    @NotNull
    public String toString() {
        return "Rotation2dDual(real=" + this.real + ", imag=" + this.imag + ")";
    }

    public int hashCode() {
        int result = this.real.hashCode();
        result = result * 31 + this.imag.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Rotation2dDual)) {
            return false;
        }
        Rotation2dDual rotation2dDual = (Rotation2dDual)other;
        if (!Intrinsics.areEqual(this.real, rotation2dDual.real)) {
            return false;
        }
        return Intrinsics.areEqual(this.imag, rotation2dDual.imag);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$core(Rotation2dDual self, CompositeEncoder output, SerialDescriptor serialDesc, KSerializer typeSerial0) {
        output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)DualNum.Companion.serializer(typeSerial0), self.real);
        output.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)DualNum.Companion.serializer(typeSerial0), self.imag);
    }

    public /* synthetic */ Rotation2dDual(int seen0, DualNum real, DualNum imag, SerializationConstructorMarker serializationConstructorMarker) {
        if (3 != (3 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)3, (SerialDescriptor)$cachedDescriptor);
        }
        this.real = real;
        this.imag = imag;
        if (!(this.real.size() == this.imag.size())) {
            boolean $i$a$-require-Rotation2dDual$32 = false;
            String $i$a$-require-Rotation2dDual$32 = "Real and imaginary parts must have the same size";
            throw new IllegalArgumentException($i$a$-require-Rotation2dDual$32.toString());
        }
        if (!(this.real.size() <= 3)) {
            boolean bl = false;
            String string = "Only derivatives up to 2nd order are supported";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @JvmStatic
    @NotNull
    public static final <Param extends DualParameter> Rotation2dDual<Param> exp(@NotNull DualNum<Param> theta) {
        return Companion.exp(theta);
    }

    @JvmStatic
    @NotNull
    public static final <Param extends DualParameter> Rotation2dDual<Param> constant(@NotNull Rotation2d r, int n) {
        return Companion.constant(r, n);
    }

    @JvmStatic
    @NotNull
    public static final <Param extends DualParameter> Rotation2dDual<Param> zero() {
        return Companion.zero();
    }

    static {
        PluginGeneratedSerialDescriptor pluginGeneratedSerialDescriptor = new PluginGeneratedSerialDescriptor("com.acmerobotics.roadrunner.geometry.Rotation2dDual", null, 2);
        pluginGeneratedSerialDescriptor.addElement("real", false);
        pluginGeneratedSerialDescriptor.addElement("imag", false);
        $cachedDescriptor = (SerialDescriptor)pluginGeneratedSerialDescriptor;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0001\u0010\u0006*\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\tH\u0007J(\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0001\u0010\u0006*\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0001\u0010\u0006*\u00020\u0007H\u0007J&\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u00050\u0011\"\u0004\b\u0001\u0010\u00062\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0011\u00a8\u0006\u0013"}, d2={"Lcom/acmerobotics/roadrunner/geometry/Rotation2dDual$Companion;", "", "<init>", "()V", "exp", "Lcom/acmerobotics/roadrunner/geometry/Rotation2dDual;", "Param", "Lcom/acmerobotics/roadrunner/geometry/DualParameter;", "theta", "Lcom/acmerobotics/roadrunner/geometry/DualNum;", "constant", "r", "Lcom/acmerobotics/roadrunner/geometry/Rotation2d;", "n", "", "zero", "serializer", "Lkotlinx/serialization/KSerializer;", "typeSerial0", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final <Param extends DualParameter> Rotation2dDual<Param> exp(@NotNull DualNum<Param> theta) {
            Intrinsics.checkNotNullParameter(theta, (String)"theta");
            return new Rotation2dDual<Param>(theta.cos(), theta.sin());
        }

        @JvmStatic
        @NotNull
        public final <Param extends DualParameter> Rotation2dDual<Param> constant(@NotNull Rotation2d r, int n) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            return new Rotation2dDual(DualNum.Companion.constant(r.real, n), DualNum.Companion.constant(r.imag, n));
        }

        @JvmStatic
        @NotNull
        public final <Param extends DualParameter> Rotation2dDual<Param> zero() {
            return this.constant(Rotation2d.zero, 1);
        }

        @NotNull
        public final <Param> KSerializer<Rotation2dDual<Param>> serializer(@NotNull KSerializer<Param> typeSerial0) {
            Intrinsics.checkNotNullParameter(typeSerial0, (String)"typeSerial0");
            return (KSerializer)new $serializer<Param>(typeSerial0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

