/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.profiles;

import com.acmerobotics.roadrunner.geometry.DualNum;
import com.acmerobotics.roadrunner.geometry.Time;
import com.acmerobotics.roadrunner.profiles.DisplacementProfile$;
import com.acmerobotics.roadrunner.profiles.Profile;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialName;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.DoubleSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@SerialName(value="DisplacementProfile")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 '2\u00020\u0001:\u0002&'B1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0007\u0010\bBS\b\u0010\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0004\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u0007\u0010\u000eJ\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0004H\u0096\u0002J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J9\u0010\u0016\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\nH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J%\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0001\u00a2\u0006\u0002\b%R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/acmerobotics/roadrunner/profiles/DisplacementProfile;", "Lcom/acmerobotics/roadrunner/profiles/Profile;", "disps", "", "", "vels", "accels", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "seen0", "", "length", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/util/List;Ljava/util/List;Ljava/util/List;DLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "get", "Lcom/acmerobotics/roadrunner/geometry/DualNum;", "Lcom/acmerobotics/roadrunner/geometry/Time;", "x", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$core", "$serializer", "Companion", "core"})
public final class DisplacementProfile
implements Profile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final List<Double> disps;
    @JvmField
    @NotNull
    public final List<Double> vels;
    @JvmField
    @NotNull
    public final List<Double> accels;
    @JvmField
    public final double length;
    @JvmField
    @NotNull
    private static final Lazy<KSerializer<Object>>[] $childSerializers;

    public DisplacementProfile(@NotNull List<Double> disps, @NotNull List<Double> vels, @NotNull List<Double> accels) {
        Intrinsics.checkNotNullParameter(disps, (String)"disps");
        Intrinsics.checkNotNullParameter(vels, (String)"vels");
        Intrinsics.checkNotNullParameter(accels, (String)"accels");
        this.disps = disps;
        this.vels = vels;
        this.accels = accels;
        this.length = ((Number)CollectionsKt.last(this.disps)).doubleValue();
        if (!(this.disps.size() == this.vels.size())) {
            boolean $i$a$-require-DisplacementProfile$32 = false;
            String $i$a$-require-DisplacementProfile$32 = "disps.size() (" + this.disps.size() + ") != vels.size() (" + this.vels.size() + ")";
            throw new IllegalArgumentException($i$a$-require-DisplacementProfile$32.toString());
        }
        if (!(this.disps.size() == this.accels.size() + 1)) {
            boolean bl = false;
            String string = "disps.size() (" + this.disps.size() + ") != accels.size() + 1 (" + (this.accels.size() + 1) + ")";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    public DualNum<Time> get(double x) {
        DualNum dualNum;
        int index = CollectionsKt.binarySearch$default(this.disps, (Comparable)Double.valueOf(x), (int)0, (int)0, (int)6, null);
        if (index >= CollectionsKt.getLastIndex(this.disps)) {
            double[] dArray = new double[]{x, ((Number)this.vels.get(index)).doubleValue(), 0.0};
            DualNum dualNum2 = new DualNum(dArray);
            dualNum = dualNum2;
        } else if (index >= 0) {
            double[] dArray = new double[]{x, ((Number)this.vels.get(index)).doubleValue(), ((Number)this.accels.get(index)).doubleValue()};
            DualNum dualNum3 = new DualNum(dArray);
            dualNum = dualNum3;
        } else {
            int insIndex = -(index + 1);
            if (insIndex <= 0) {
                double[] dArray = new double[]{x, ((Number)CollectionsKt.first(this.vels)).doubleValue(), 0.0};
                DualNum dualNum4 = new DualNum(dArray);
                dualNum = dualNum4;
            } else if (insIndex >= this.disps.size()) {
                double[] dArray = new double[]{x, ((Number)CollectionsKt.last(this.vels)).doubleValue(), 0.0};
                DualNum dualNum5 = new DualNum(dArray);
                dualNum = dualNum5;
            } else {
                double dx = x - ((Number)this.disps.get(insIndex - 1)).doubleValue();
                double v0 = ((Number)this.vels.get(insIndex - 1)).doubleValue();
                double a = ((Number)this.accels.get(insIndex - 1)).doubleValue();
                double[] dArray = new double[]{x, Math.sqrt(v0 * v0 + (double)2 * a * dx), a};
                DualNum dualNum6 = new DualNum(dArray);
                dualNum = dualNum6;
            }
        }
        return dualNum;
    }

    @NotNull
    public final List<Double> component1() {
        return this.disps;
    }

    @NotNull
    public final List<Double> component2() {
        return this.vels;
    }

    @NotNull
    public final List<Double> component3() {
        return this.accels;
    }

    @NotNull
    public final DisplacementProfile copy(@NotNull List<Double> disps, @NotNull List<Double> vels, @NotNull List<Double> accels) {
        Intrinsics.checkNotNullParameter(disps, (String)"disps");
        Intrinsics.checkNotNullParameter(vels, (String)"vels");
        Intrinsics.checkNotNullParameter(accels, (String)"accels");
        return new DisplacementProfile(disps, vels, accels);
    }

    public static /* synthetic */ DisplacementProfile copy$default(DisplacementProfile displacementProfile, List list, List list2, List list3, int n, Object object) {
        if ((n & 1) != 0) {
            list = displacementProfile.disps;
        }
        if ((n & 2) != 0) {
            list2 = displacementProfile.vels;
        }
        if ((n & 4) != 0) {
            list3 = displacementProfile.accels;
        }
        return displacementProfile.copy(list, list2, list3);
    }

    @NotNull
    public String toString() {
        return "DisplacementProfile(disps=" + this.disps + ", vels=" + this.vels + ", accels=" + this.accels + ")";
    }

    public int hashCode() {
        int result = ((Object)this.disps).hashCode();
        result = result * 31 + ((Object)this.vels).hashCode();
        result = result * 31 + ((Object)this.accels).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DisplacementProfile)) {
            return false;
        }
        DisplacementProfile displacementProfile = (DisplacementProfile)other;
        if (!Intrinsics.areEqual(this.disps, displacementProfile.disps)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.vels, displacementProfile.vels)) {
            return false;
        }
        return Intrinsics.areEqual(this.accels, displacementProfile.accels);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$core(DisplacementProfile self, CompositeEncoder output, SerialDescriptor serialDesc) {
        Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
        output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)lazyArray[0].getValue(), self.disps);
        output.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)lazyArray[1].getValue(), self.vels);
        output.encodeSerializableElement(serialDesc, 2, (SerializationStrategy)lazyArray[2].getValue(), self.accels);
        if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : Double.compare(self.length, ((Number)CollectionsKt.last(self.disps)).doubleValue()) != 0) {
            output.encodeDoubleElement(serialDesc, 3, self.length);
        }
    }

    public /* synthetic */ DisplacementProfile(int seen0, List disps, List vels, List accels, double length, SerializationConstructorMarker serializationConstructorMarker) {
        if (7 != (7 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)7, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.disps = disps;
        this.vels = vels;
        this.accels = accels;
        this.length = (seen0 & 8) == 0 ? ((Number)CollectionsKt.last(this.disps)).doubleValue() : length;
        if (!(this.disps.size() == this.vels.size())) {
            boolean $i$a$-require-DisplacementProfile$32 = false;
            String $i$a$-require-DisplacementProfile$32 = "disps.size() (" + this.disps.size() + ") != vels.size() (" + this.vels.size() + ")";
            throw new IllegalArgumentException($i$a$-require-DisplacementProfile$32.toString());
        }
        if (!(this.disps.size() == this.accels.size() + 1)) {
            boolean bl = false;
            String string = "disps.size() (" + this.disps.size() + ") != accels.size() + 1 (" + (this.accels.size() + 1) + ")";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        Lazy[] lazyArray = new Lazy[]{LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)DoubleSerializer.INSTANCE)), LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)DoubleSerializer.INSTANCE)), LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)DoubleSerializer.INSTANCE)), null};
        $childSerializers = lazyArray;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/acmerobotics/roadrunner/profiles/DisplacementProfile$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/acmerobotics/roadrunner/profiles/DisplacementProfile;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<DisplacementProfile> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

