/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.profiles;

import com.acmerobotics.roadrunner.geometry.Arclength;
import com.acmerobotics.roadrunner.geometry.IntegralScanResult;
import com.acmerobotics.roadrunner.geometry.MinMax;
import com.acmerobotics.roadrunner.geometry.Pose2dDual;
import com.acmerobotics.roadrunner.geometry.RobotState;
import com.acmerobotics.roadrunner.paths.PosePath;
import com.acmerobotics.roadrunner.profiles.AccelConstraint;
import com.acmerobotics.roadrunner.profiles.CancelableProfile;
import com.acmerobotics.roadrunner.profiles.DisplacementProfile;
import com.acmerobotics.roadrunner.profiles.ProfileParams;
import com.acmerobotics.roadrunner.profiles.VelConstraint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a.\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002\u001aZ\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\r2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\r2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002\u001aF\u0010\f\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\b\u001a\u00020\u00022\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001aF\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00022\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\r2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002\u001a8\u0010\u0013\u001a\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00022\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001aF\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00022\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00022\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002\u001a8\u0010\u0015\u001a\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00022\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0016\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004\u001a$\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0002\u001a.\u0010\f\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$\u001a.\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$\u001a.\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010#\u001a\u00020$\u001a\u0015\u0010%\u001a\u00020\u0004*\u00020\u00042\u0006\u0010&\u001a\u00020\u0004H\u0086\u0002\u00a8\u0006'"}, d2={"timeScan", "", "", "p", "Lcom/acmerobotics/roadrunner/profiles/DisplacementProfile;", "constantProfile", "Lcom/acmerobotics/roadrunner/profiles/CancelableProfile;", "length", "beginEndVel", "maxVel", "minAccel", "maxAccel", "profile", "Lkotlin/Function1;", "resolution", "disps", "maxVels", "minAccels", "maxAccels", "forwardProfile", "beginVel", "backwardProfile", "endVel", "merge", "p1", "p2", "samplePathByRotation", "path", "Lcom/acmerobotics/roadrunner/paths/PosePath;", "angResolution", "eps", "params", "Lcom/acmerobotics/roadrunner/profiles/ProfileParams;", "velConstraint", "Lcom/acmerobotics/roadrunner/profiles/VelConstraint;", "accelConstraint", "Lcom/acmerobotics/roadrunner/profiles/AccelConstraint;", "plus", "other", "core"})
@JvmName(name="Profiles")
@SourceDebugExtension(value={"SMAP\nProfiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Profiles.kt\ncom/acmerobotics/roadrunner/profiles/Profiles\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,681:1\n1#2:682\n1563#3:683\n1634#3,3:684\n1563#3:687\n1634#3,3:688\n1563#3:691\n1634#3,3:692\n1563#3:695\n1634#3,3:696\n1563#3:699\n1634#3,3:700\n1740#3,3:703\n1740#3,3:706\n1803#3,3:709\n1563#3:712\n1634#3,3:713\n1563#3:716\n1634#3,3:717\n1563#3:720\n1634#3,3:721\n1563#3:724\n1634#3,3:725\n1563#3:728\n1634#3,3:729\n1563#3:732\n1634#3,3:733\n1563#3:736\n1634#3,3:737\n1563#3:740\n1634#3,3:741\n1563#3:744\n1634#3,3:745\n*S KotlinDebug\n*F\n+ 1 Profiles.kt\ncom/acmerobotics/roadrunner/profiles/Profiles\n*L\n280#1:683\n280#1:684,3\n281#1:687\n281#1:688,3\n282#1:691\n282#1:692,3\n339#1:695\n339#1:696,3\n340#1:699\n340#1:700,3\n367#1:703,3\n368#1:706,3\n377#1:709,3\n430#1:712\n430#1:713,3\n431#1:716\n431#1:717,3\n453#1:720\n453#1:721,3\n454#1:724\n454#1:725,3\n457#1:728\n457#1:729,3\n459#1:732\n459#1:733,3\n608#1:736\n608#1:737,3\n638#1:740\n638#1:741,3\n668#1:744\n668#1:745,3\n*E\n"})
public final class Profiles {
    private static final List<Double> timeScan(DisplacementProfile p) {
        Object[] objectArray = new Double[]{0.0};
        List times = CollectionsKt.mutableListOf((Object[])objectArray);
        int n = ((Collection)p.accels).size();
        for (int i = 0; i < n; ++i) {
            times.add(((Number)CollectionsKt.last((List)times)).doubleValue() + (((Number)p.accels.get(i)).doubleValue() == 0.0 ? (((Number)p.disps.get(i + 1)).doubleValue() - ((Number)p.disps.get(i)).doubleValue()) / ((Number)p.vels.get(i)).doubleValue() : (((Number)p.vels.get(i + 1)).doubleValue() - ((Number)p.vels.get(i)).doubleValue()) / ((Number)p.accels.get(i)).doubleValue()));
        }
        return times;
    }

    @NotNull
    public static final CancelableProfile constantProfile(double length, double beginEndVel, double maxVel, double minAccel, double maxAccel) {
        return Profiles.profile(length, beginEndVel, (Function1<? super Double, Double>)((Function1)arg_0 -> Profiles.constantProfile$lambda$0(maxVel, arg_0)), (Function1<? super Double, Double>)((Function1)arg_0 -> Profiles.constantProfile$lambda$1(minAccel, arg_0)), (Function1<? super Double, Double>)((Function1)arg_0 -> Profiles.constantProfile$lambda$2(maxAccel, arg_0)), length);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final CancelableProfile profile(double length, double beginEndVel, @NotNull Function1<? super Double, Double> maxVel, @NotNull Function1<? super Double, Double> minAccel, @NotNull Function1<? super Double, Double> maxAccel, double resolution) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        void $this$mapTo$iv$iv3;
        Intrinsics.checkNotNullParameter(maxVel, (String)"maxVel");
        Intrinsics.checkNotNullParameter(minAccel, (String)"minAccel");
        Intrinsics.checkNotNullParameter(maxAccel, (String)"maxAccel");
        if (!(length > 0.0)) {
            boolean $i$a$-require-Profiles$profile$42 = false;
            String $i$a$-require-Profiles$profile$42 = "length (" + length + ") must be positive";
            throw new IllegalArgumentException($i$a$-require-Profiles$profile$42.toString());
        }
        if (!(resolution > 0.0)) {
            boolean $i$a$-require-Profiles$profile$52 = false;
            String $i$a$-require-Profiles$profile$52 = "resolution (" + resolution + ") must be positive";
            throw new IllegalArgumentException($i$a$-require-Profiles$profile$52.toString());
        }
        if (!(beginEndVel >= 0.0)) {
            boolean $i$a$-require-Profiles$profile$62 = false;
            String $i$a$-require-Profiles$profile$62 = "beginEndVel (" + beginEndVel + ") must be non-negative";
            throw new IllegalArgumentException($i$a$-require-Profiles$profile$62.toString());
        }
        int samples = Math.max(1, (int)Math.ceil(length / resolution));
        List<Double> disps = com.acmerobotics.roadrunner.geometry.Math.rangeCentered(0.0, length, samples);
        Iterable $this$map$iv = disps;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            destination$iv$iv.add(maxVel.invoke(item$iv$iv));
        }
        List maxVels = (List)destination$iv$iv;
        Iterable $this$map$iv2 = disps;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            destination$iv$iv2.add(minAccel.invoke(item$iv$iv));
        }
        List minAccels = (List)destination$iv$iv2;
        Iterable $this$map$iv3 = disps;
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv3;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            destination$iv$iv3.add(maxAccel.invoke(item$iv$iv));
        }
        List maxAccels = (List)destination$iv$iv3;
        return Profiles.profile(com.acmerobotics.roadrunner.geometry.Math.range(0.0, length, samples + 1), beginEndVel, maxVels, minAccels, maxAccels);
    }

    @NotNull
    public static final CancelableProfile profile(@NotNull List<Double> disps, double beginEndVel, @NotNull List<Double> maxVels, @NotNull List<Double> minAccels, @NotNull List<Double> maxAccels) {
        Intrinsics.checkNotNullParameter(disps, (String)"disps");
        Intrinsics.checkNotNullParameter(maxVels, (String)"maxVels");
        Intrinsics.checkNotNullParameter(minAccels, (String)"minAccels");
        Intrinsics.checkNotNullParameter(maxAccels, (String)"maxAccels");
        if (!(maxVels.size() == minAccels.size())) {
            boolean $i$a$-require-Profiles$profile$62 = false;
            String $i$a$-require-Profiles$profile$62 = "maxVels.size() (" + maxVels.size() + ") != minAccels.size() (" + minAccels.size() + ")";
            throw new IllegalArgumentException($i$a$-require-Profiles$profile$62.toString());
        }
        if (!(maxVels.size() == maxAccels.size())) {
            boolean bl = false;
            String string = "maxVels.size() (" + maxVels.size() + ") != maxAccels.size() (" + maxAccels.size() + ")";
            throw new IllegalArgumentException(string.toString());
        }
        return new CancelableProfile(Profiles.merge(Profiles.forwardProfile(disps, beginEndVel, maxVels, maxAccels), Profiles.backwardProfile(disps, maxVels, beginEndVel, minAccels)), disps, minAccels);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DisplacementProfile forwardProfile(double length, double beginVel, @NotNull Function1<? super Double, Double> maxVel, @NotNull Function1<? super Double, Double> maxAccel, double resolution) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(maxVel, (String)"maxVel");
        Intrinsics.checkNotNullParameter(maxAccel, (String)"maxAccel");
        int samples = Math.max(1, (int)Math.ceil(length / resolution));
        List<Double> disps = com.acmerobotics.roadrunner.geometry.Math.rangeCentered(0.0, length, samples);
        Iterable $this$map$iv = disps;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            destination$iv$iv.add(maxVel.invoke(item$iv$iv));
        }
        List maxVels = (List)destination$iv$iv;
        Iterable $this$map$iv2 = disps;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            destination$iv$iv2.add(maxAccel.invoke(item$iv$iv));
        }
        List maxAccels = (List)destination$iv$iv2;
        return Profiles.forwardProfile(com.acmerobotics.roadrunner.geometry.Math.range(0.0, length, samples + 1), beginVel, maxVels, maxAccels);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DisplacementProfile forwardProfile(@NotNull List<Double> disps, double beginVel, @NotNull List<Double> maxVels, @NotNull List<Double> maxAccels) {
        void $this$fold$iv;
        boolean bl;
        Object element$iv2;
        block15: {
            double v;
            boolean bl2;
            boolean $i$f$all;
            Iterable $this$all$iv;
            block14: {
                Intrinsics.checkNotNullParameter(disps, (String)"disps");
                Intrinsics.checkNotNullParameter(maxVels, (String)"maxVels");
                Intrinsics.checkNotNullParameter(maxAccels, (String)"maxAccels");
                if (!(beginVel >= 0.0)) {
                    boolean $i$a$-require-Profiles$forwardProfile$22 = false;
                    String $i$a$-require-Profiles$forwardProfile$22 = "beginVel (" + beginVel + ") must be non-negative";
                    throw new IllegalArgumentException($i$a$-require-Profiles$forwardProfile$22.toString());
                }
                $this$all$iv = maxVels;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv2 : $this$all$iv) {
                        v = ((Number)element$iv2).doubleValue();
                        boolean bl3 = false;
                        if (v > 0.0) continue;
                        bl2 = false;
                        break block14;
                    }
                    bl2 = true;
                }
            }
            if (!bl2) {
                boolean $i$a$-require-Profiles$forwardProfile$42 = false;
                String $i$a$-require-Profiles$forwardProfile$42 = "maxVels must be positive";
                throw new IllegalArgumentException($i$a$-require-Profiles$forwardProfile$42.toString());
            }
            $this$all$iv = maxAccels;
            $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv2 : $this$all$iv) {
                    v = ((Number)element$iv2).doubleValue();
                    boolean bl4 = false;
                    if (v > 0.0) continue;
                    bl = false;
                    break block15;
                }
                bl = true;
            }
        }
        if (!bl) {
            boolean $i$a$-require-Profiles$forwardProfile$62 = false;
            String $i$a$-require-Profiles$forwardProfile$62 = "maxAccels must be positive";
            throw new IllegalArgumentException($i$a$-require-Profiles$forwardProfile$62.toString());
        }
        Object[] $i$a$-require-Profiles$forwardProfile$62 = new Double[]{0.0};
        List newDisps = CollectionsKt.mutableListOf((Object[])$i$a$-require-Profiles$forwardProfile$62);
        Object[] objectArray = new Double[]{beginVel};
        List vels = CollectionsKt.mutableListOf((Object[])objectArray);
        List accels = new ArrayList();
        element$iv2 = CollectionsKt.zip((Iterable)CollectionsKt.zip((Iterable)maxVels, (Iterable)maxAccels), (Iterable)CollectionsKt.drop((Iterable)disps, (int)1));
        Double initial$iv = disps.get(0);
        boolean $i$f$fold = false;
        Double accumulator$iv = initial$iv;
        for (Object element$iv3 : $this$fold$iv) {
            Pair pair = (Pair)element$iv3;
            double beginDisp = ((Number)accumulator$iv).doubleValue();
            boolean bl5 = false;
            Pair c = (Pair)pair.component1();
            double endDisp = ((Number)pair.component2()).doubleValue();
            double maxVel = ((Number)c.component1()).doubleValue();
            double maxAccel = ((Number)c.component2()).doubleValue();
            double beginVel2 = ((Number)CollectionsKt.last((List)vels)).doubleValue();
            if (beginVel2 >= maxVel) {
                newDisps.add(endDisp);
                vels.add(maxVel);
                v2 = accels.add(0.0);
            } else {
                double endVel = Math.sqrt(beginVel2 * beginVel2 + (double)2 * maxAccel * (endDisp - beginDisp));
                if (endVel <= maxVel) {
                    newDisps.add(endDisp);
                    vels.add(endVel);
                    v2 = accels.add(maxAccel);
                } else {
                    double accelDx = (maxVel * maxVel - beginVel2 * beginVel2) / ((double)2 * maxAccel);
                    newDisps.add(beginDisp + accelDx);
                    vels.add(maxVel);
                    accels.add(maxAccel);
                    newDisps.add(endDisp);
                    vels.add(maxVel);
                    v2 = accels.add(0.0);
                }
            }
            accumulator$iv = endDisp;
        }
        return new DisplacementProfile(newDisps, vels, accels);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DisplacementProfile backwardProfile(double length, @NotNull Function1<? super Double, Double> maxVel, double endVel, @NotNull Function1<? super Double, Double> minAccel, double resolution) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(maxVel, (String)"maxVel");
        Intrinsics.checkNotNullParameter(minAccel, (String)"minAccel");
        if (!(endVel >= 0.0)) {
            boolean $i$a$-require-Profiles$backwardProfile$22 = false;
            String $i$a$-require-Profiles$backwardProfile$22 = "endVel (" + endVel + ") must be non-negative";
            throw new IllegalArgumentException($i$a$-require-Profiles$backwardProfile$22.toString());
        }
        int samples = Math.max(1, (int)Math.ceil(length / resolution));
        List<Double> disps = com.acmerobotics.roadrunner.geometry.Math.rangeCentered(0.0, length, samples);
        Iterable $this$map$iv = disps;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            destination$iv$iv.add(maxVel.invoke(item$iv$iv));
        }
        List maxVels = (List)destination$iv$iv;
        Iterable $this$map$iv2 = disps;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            destination$iv$iv2.add(minAccel.invoke(item$iv$iv));
        }
        List minAccels = (List)destination$iv$iv2;
        return Profiles.backwardProfile(com.acmerobotics.roadrunner.geometry.Math.range(0.0, length, samples + 1), maxVels, endVel, minAccels);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DisplacementProfile backwardProfile(@NotNull List<Double> disps, @NotNull List<Double> maxVels, double endVel, @NotNull List<Double> minAccels) {
        Collection<Double> collection;
        double x;
        Collection collection2;
        Iterable $this$mapTo$iv$iv;
        Collection<Double> collection3;
        double it;
        Collection collection4;
        Iterable $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(disps, (String)"disps");
        Intrinsics.checkNotNullParameter(maxVels, (String)"maxVels");
        Intrinsics.checkNotNullParameter(minAccels, (String)"minAccels");
        Iterable $this$map$iv = CollectionsKt.reversed((Iterable)disps);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            double d = ((Number)item$iv$iv).doubleValue();
            collection4 = destination$iv$iv;
            boolean bl = false;
            collection4.add(((Number)CollectionsKt.last(disps)).doubleValue() - it);
        }
        $this$map$iv = CollectionsKt.reversed((Iterable)minAccels);
        List list = CollectionsKt.reversed((Iterable)maxVels);
        double d = endVel;
        collection4 = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv2 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = ((Number)item$iv$iv).doubleValue();
            collection3 = destination$iv$iv;
            boolean bl = false;
            collection3.add(-it);
        }
        collection3 = (List)destination$iv$iv;
        DisplacementProfile it2 = Profiles.forwardProfile((List<Double>)collection4, d, list, (List<Double>)collection3);
        boolean bl = false;
        Iterable $this$map$iv2 = it2.disps;
        boolean $i$f$map2 = false;
        Iterable it3 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            double d2 = ((Number)item$iv$iv).doubleValue();
            collection2 = destination$iv$iv2;
            boolean bl2 = false;
            collection2.add(it2.length - x);
        }
        $this$map$iv2 = CollectionsKt.reversed((Iterable)it2.accels);
        List list2 = CollectionsKt.reversed((Iterable)it2.vels);
        collection2 = CollectionsKt.reversed((Iterable)((List)destination$iv$iv2));
        $i$f$map2 = false;
        $this$mapTo$iv$iv = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void a;
            x = ((Number)item$iv$iv).doubleValue();
            collection = destination$iv$iv2;
            boolean bl3 = false;
            collection.add((double)(-a));
        }
        collection = (List)destination$iv$iv2;
        List list3 = collection;
        List list4 = list2;
        Collection collection5 = collection2;
        return new DisplacementProfile((List<Double>)collection5, list4, list3);
    }

    @NotNull
    public static final DisplacementProfile merge(@NotNull DisplacementProfile p1, @NotNull DisplacementProfile p2) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        Object[] objectArray = new Double[]{0.0};
        List disps = CollectionsKt.mutableListOf((Object[])objectArray);
        Object[] objectArray2 = new Double[]{Math.min(((Number)p1.vels.get(0)).doubleValue(), ((Number)p2.vels.get(0)).doubleValue())};
        List vels = CollectionsKt.mutableListOf((Object[])objectArray2);
        List accels = new ArrayList();
        boolean lastMin1 = ((Number)p1.vels.get(0)).doubleValue() < ((Number)p2.vels.get(0)).doubleValue();
        int i = 1;
        int j = 1;
        while (i < p1.disps.size() && j < p2.disps.size()) {
            boolean min1;
            Pair pair;
            double endDisp = Math.min(((Number)p1.disps.get(i)).doubleValue(), ((Number)p2.disps.get(j)).doubleValue());
            double accel1 = ((Number)p1.accels.get(i - 1)).doubleValue();
            double accel2 = ((Number)p2.accels.get(j - 1)).doubleValue();
            if (((Number)p1.disps.get(i)).doubleValue() == ((Number)p2.disps.get(j)).doubleValue()) {
                p = new Pair((Object)p1.vels.get(i), (Object)p2.vels.get(j));
                ++i;
                ++j;
                pair = p;
            } else if (((Number)p1.disps.get(i)).doubleValue() < ((Number)p2.disps.get(j)).doubleValue()) {
                p = new Pair((Object)p1.vels.get(i), (Object)Math.sqrt(Math.max(0.0, ((Number)p2.vels.get(j)).doubleValue() * ((Number)p2.vels.get(j)).doubleValue() - (double)2 * accel2 * (((Number)p2.disps.get(j)).doubleValue() - ((Number)p1.disps.get(i)).doubleValue()))));
                ++i;
                pair = p;
            } else {
                p = new Pair((Object)Math.sqrt(Math.max(0.0, ((Number)p1.vels.get(i)).doubleValue() * ((Number)p1.vels.get(i)).doubleValue() - (double)2 * accel1 * (((Number)p1.disps.get(i)).doubleValue() - ((Number)p2.disps.get(j)).doubleValue()))), (Object)p2.vels.get(j));
                ++j;
                pair = p;
            }
            Pair pair2 = pair;
            double endVel1 = ((Number)pair2.component1()).doubleValue();
            double endVel2 = ((Number)pair2.component2()).doubleValue();
            boolean bl = min1 = endVel1 < endVel2;
            if (min1 == lastMin1) {
                disps.add(endDisp);
                if (min1) {
                    vels.add(endVel1);
                    v2 = accels.add(accel1);
                } else {
                    vels.add(endVel2);
                    v2 = accels.add(accel2);
                }
            } else if (accel1 == accel2) {
                disps.add(endDisp);
                vels.add(Math.min(endVel1, endVel2));
                v2 = accels.add(accel1);
            } else {
                double dx = (endVel2 * endVel2 - endVel1 * endVel1) / ((double)2 * (accel2 - accel1));
                disps.add(endDisp - dx);
                vels.add(Math.sqrt(endVel1 * endVel1 - (double)2 * accel1 * dx));
                accels.add(Math.max(accel1, accel2));
                disps.add(endDisp);
                vels.add(Math.min(endVel1, endVel2));
                v2 = accels.add(Math.min(accel1, accel2));
            }
            lastMin1 = min1;
        }
        return new DisplacementProfile(disps, vels, accels);
    }

    @NotNull
    public static final List<Double> samplePathByRotation(@NotNull PosePath path, double angResolution, double eps) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        IntegralScanResult integralScanResult = com.acmerobotics.roadrunner.geometry.Math.integralScan(0.0, path.length(), eps, (Function1<? super Double, Double>)((Function1)arg_0 -> Profiles.samplePathByRotation$lambda$20(path, arg_0)));
        List<Double> values = integralScanResult.component1();
        List<Double> sums = integralScanResult.component2();
        return com.acmerobotics.roadrunner.geometry.Math.lerpLookupMap(sums, values, com.acmerobotics.roadrunner.geometry.Math.rangeCentered(0.0, ((Number)CollectionsKt.last(sums)).doubleValue(), Math.max(1, (int)Math.ceil(((Number)CollectionsKt.last(sums)).doubleValue() / angResolution))));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final CancelableProfile profile(@NotNull ProfileParams params, @NotNull PosePath path, double beginEndVel, @NotNull VelConstraint velConstraint, @NotNull AccelConstraint accelConstraint) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)velConstraint, (String)"velConstraint");
        Intrinsics.checkNotNullParameter((Object)accelConstraint, (String)"accelConstraint");
        double len = path.length();
        List<Double> dispSamples = com.acmerobotics.roadrunner.geometry.Math.rangeCentered(0.0, len, Math.max(1, (int)Math.ceil(len / params.getDispResolution())));
        List<Double> angSamples = Profiles.samplePathByRotation(path, params.getAngResolution(), params.getAngSamplingEps());
        List samples = CollectionsKt.sorted((Iterable)CollectionsKt.plus((Collection)dispSamples, (Iterable)angSamples));
        List maxVels = new ArrayList();
        List minAccels = new ArrayList();
        List maxAccels = new ArrayList();
        Object object = samples.iterator();
        while (object.hasNext()) {
            double s = ((Number)object.next()).doubleValue();
            Pose2dDual<Arclength> pose = path.get(s, 2);
            maxVels.add(velConstraint.maxRobotVel(RobotState.Companion.fromDualPose(pose), path, s));
            MinMax minMax = accelConstraint.minMaxProfileAccel(RobotState.Companion.fromDualPose(pose), path, s);
            double minAccel = minMax.component1();
            double maxAccel = minMax.component2();
            minAccels.add(minAccel);
            maxAccels.add(maxAccel);
        }
        object = CollectionsKt.zip((Iterable)samples, (Iterable)CollectionsKt.drop((Iterable)samples, (int)1));
        Collection collection = CollectionsKt.listOf((Object)0.0);
        boolean $i$f$map = false;
        void var16_23 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            double a = ((Number)pair.component1()).doubleValue();
            double b = ((Number)pair.component2()).doubleValue();
            collection2.add(0.5 * (a + b));
        }
        return Profiles.profile(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv)), (Iterable)CollectionsKt.listOf((Object)path.length())), beginEndVel, maxVels, minAccels, maxAccels);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DisplacementProfile forwardProfile(@NotNull ProfileParams params, @NotNull PosePath path, double beginVel, @NotNull VelConstraint velConstraint, @NotNull AccelConstraint accelConstraint) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)velConstraint, (String)"velConstraint");
        Intrinsics.checkNotNullParameter((Object)accelConstraint, (String)"accelConstraint");
        double len = path.length();
        List<Double> dispSamples = com.acmerobotics.roadrunner.geometry.Math.rangeCentered(0.0, len, Math.max(1, (int)Math.ceil(len / params.getDispResolution())));
        List<Double> angSamples = Profiles.samplePathByRotation(path, params.getAngResolution(), params.getAngSamplingEps());
        List samples = CollectionsKt.sorted((Iterable)CollectionsKt.plus((Collection)dispSamples, (Iterable)angSamples));
        List maxVels = new ArrayList();
        List maxAccels = new ArrayList();
        Object object = samples.iterator();
        while (object.hasNext()) {
            double s = ((Number)object.next()).doubleValue();
            Pose2dDual<Arclength> pose = path.get(s, 2);
            maxVels.add(velConstraint.maxRobotVel(RobotState.Companion.fromDualPose(pose), path, s));
            double maxAccel = accelConstraint.minMaxProfileAccel(RobotState.Companion.fromDualPose(pose), path, s).component2();
            maxAccels.add(maxAccel);
        }
        object = CollectionsKt.zip((Iterable)samples, (Iterable)CollectionsKt.drop((Iterable)samples, (int)1));
        Collection collection = CollectionsKt.listOf((Object)0.0);
        boolean $i$f$map = false;
        void var15_18 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            double a = ((Number)pair.component1()).doubleValue();
            double b = ((Number)pair.component2()).doubleValue();
            collection2.add(0.5 * (a + b));
        }
        return Profiles.forwardProfile(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv)), (Iterable)CollectionsKt.listOf((Object)path.length())), beginVel, maxVels, maxAccels);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DisplacementProfile backwardProfile(@NotNull ProfileParams params, @NotNull PosePath path, @NotNull VelConstraint velConstraint, double endVel, @NotNull AccelConstraint accelConstraint) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)velConstraint, (String)"velConstraint");
        Intrinsics.checkNotNullParameter((Object)accelConstraint, (String)"accelConstraint");
        double len = path.length();
        List<Double> dispSamples = com.acmerobotics.roadrunner.geometry.Math.rangeCentered(0.0, len, Math.max(1, (int)Math.ceil(len / params.getDispResolution())));
        List<Double> angSamples = Profiles.samplePathByRotation(path, params.getAngResolution(), params.getAngSamplingEps());
        List samples = CollectionsKt.sorted((Iterable)CollectionsKt.plus((Collection)dispSamples, (Iterable)angSamples));
        List maxVels = new ArrayList();
        List minAccels = new ArrayList();
        Object object = samples.iterator();
        while (object.hasNext()) {
            double s = ((Number)object.next()).doubleValue();
            Pose2dDual<Arclength> pose = path.get(s, 2);
            maxVels.add(velConstraint.maxRobotVel(RobotState.Companion.fromDualPose(pose), path, s));
            double minAccel = accelConstraint.minMaxProfileAccel(RobotState.Companion.fromDualPose(pose), path, s).component1();
            minAccels.add(minAccel);
        }
        object = CollectionsKt.zip((Iterable)samples, (Iterable)CollectionsKt.drop((Iterable)samples, (int)1));
        Collection collection = CollectionsKt.listOf((Object)0.0);
        boolean $i$f$map = false;
        void var15_18 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            double a = ((Number)pair.component1()).doubleValue();
            double b = ((Number)pair.component2()).doubleValue();
            collection2.add(0.5 * (a + b));
        }
        return Profiles.backwardProfile(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv)), (Iterable)CollectionsKt.listOf((Object)path.length())), maxVels, endVel, minAccels);
    }

    @NotNull
    public static final DisplacementProfile plus(@NotNull DisplacementProfile $this$plus, @NotNull DisplacementProfile other) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(((Number)CollectionsKt.last($this$plus.vels)).doubleValue() == ((Number)CollectionsKt.first(other.vels)).doubleValue())) {
            boolean bl = false;
            String string = "this.vels.last() (" + CollectionsKt.last($this$plus.vels) + ") != other.vels.first() (" + CollectionsKt.first(other.vels) + ")";
            throw new IllegalArgumentException(string.toString());
        }
        return new DisplacementProfile(CollectionsKt.plus((Collection)$this$plus.disps, (Iterable)CollectionsKt.drop((Iterable)other.disps, (int)1)), CollectionsKt.plus((Collection)$this$plus.vels, (Iterable)CollectionsKt.drop((Iterable)other.vels, (int)1)), CollectionsKt.plus((Collection)$this$plus.accels, (Iterable)other.accels));
    }

    private static final double constantProfile$lambda$0(double $maxVel, double it) {
        return $maxVel;
    }

    private static final double constantProfile$lambda$1(double $minAccel, double it) {
        return $minAccel;
    }

    private static final double constantProfile$lambda$2(double $maxAccel, double it) {
        return $maxAccel;
    }

    private static final double samplePathByRotation$lambda$20(PosePath $path, double it) {
        return Math.abs($path.get((double)it, (int)2).heading.velocity().value());
    }

    public static final /* synthetic */ List access$timeScan(DisplacementProfile p) {
        return Profiles.timeScan(p);
    }
}

