/*
 * Decompiled with CFR 0.152.
 */
package me.zwave.zway;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class ZWay {
    public static final int deviceAdded = 1;
    public static final int deviceRemoved = 2;
    public static final int instanceAdded = 4;
    public static final int instanceRemoved = 8;
    public static final int commandAdded = 16;
    public static final int commandRemoved = 32;
    private final long jzway;
    public Controller controller;
    public Map<Integer, Device> devices;
    private Set<DeviceCallback> deviceCallbacks;
    private Set<StatusCallback> statusCallbacks;
    private Set<TerminateCallback> terminateCallbacks;
    public static final Map<String, Integer> commandClassIdByName;
    public static final Map<Integer, String> commandClassNameById;

    public ZWay(String name, String port, int speed, String config_folder, String translations_folder, String zddx_folder) throws Exception {
        this.jzway = this.jni_zwayInit(name, port, speed, config_folder, translations_folder, zddx_folder);
        this.controller = new Controller();
        this.devices = new HashMap<Integer, Device>();
        this.deviceCallbacks = new HashSet<DeviceCallback>();
        this.statusCallbacks = new HashSet<StatusCallback>();
        this.terminateCallbacks = new HashSet<TerminateCallback>();
    }

    public void finalize() {
        this.jni_finalize(this.jzway);
    }

    public void bind(DeviceCallback func) throws Exception {
        this.deviceCallbacks.add(func);
    }

    public void unbind(DeviceCallback func) throws Exception {
        this.deviceCallbacks.remove(func);
    }

    public void bind(StatusCallback func) {
        this.statusCallbacks.add(func);
    }

    public void unbind(StatusCallback func) {
        this.statusCallbacks.remove(func);
    }

    public void bind(TerminateCallback func) {
        this.terminateCallbacks.add(func);
    }

    public void unbind(TerminateCallback func) {
        this.terminateCallbacks.remove(func);
    }

    public boolean isRunning() {
        return this.jni_isRunning(this.jzway);
    }

    public boolean isIdle() {
        return this.jni_isIdle(this.jzway);
    }

    public void stop() {
        this.jni_stop(this.jzway);
    }

    public void discover() {
        this.jni_discover(this.jzway);
    }

    public Device.Instance.Basic basic(Integer deviceId, Integer instanceId) {
        return (Device.Instance.Basic)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("basic");
    }

    public Device.Instance.Wakeup wakeup(Integer deviceId, Integer instanceId) {
        return (Device.Instance.Wakeup)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("wakeup");
    }

    public Device.Instance.NoOperation noOperation(Integer deviceId, Integer instanceId) {
        return (Device.Instance.NoOperation)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("noOperation");
    }

    public Device.Instance.Battery battery(Integer deviceId, Integer instanceId) {
        return (Device.Instance.Battery)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("battery");
    }

    public Device.Instance.ManufacturerSpecific manufacturerSpecific(Integer deviceId, Integer instanceId) {
        return (Device.Instance.ManufacturerSpecific)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("manufacturerSpecific");
    }

    public Device.Instance.Proprietary proprietary(Integer deviceId, Integer instanceId) {
        return (Device.Instance.Proprietary)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("proprietary");
    }

    public Device.Instance.Configuration configuration(Integer deviceId, Integer instanceId) {
        return (Device.Instance.Configuration)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("configuration");
    }

    public Device.Instance.SensorBinary sensorBinary(Integer deviceId, Integer instanceId) {
        return (Device.Instance.SensorBinary)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("sensorBinary");
    }

    public Device.Instance.Association association(Integer deviceId, Integer instanceId) {
        return (Device.Instance.Association)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("association");
    }

    public Device.Instance.Meter meter(Integer deviceId, Integer instanceId) {
        return (Device.Instance.Meter)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("meter");
    }

    public Device.Instance.MeterPulse meterPulse(Integer deviceId, Integer instanceId) {
        return (Device.Instance.MeterPulse)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("meterPulse");
    }

    public Device.Instance.SensorMultilevel sensorMultilevel(Integer deviceId, Integer instanceId) {
        return (Device.Instance.SensorMultilevel)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("sensorMultilevel");
    }

    public Device.Instance.SensorConfiguration sensorConfiguration(Integer deviceId, Integer instanceId) {
        return (Device.Instance.SensorConfiguration)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("sensorConfiguration");
    }

    public Device.Instance.SwitchAll switchAll(Integer deviceId, Integer instanceId) {
        return (Device.Instance.SwitchAll)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("switchAll");
    }

    public Device.Instance.SwitchBinary switchBinary(Integer deviceId, Integer instanceId) {
        return (Device.Instance.SwitchBinary)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("switchBinary");
    }

    public Device.Instance.SwitchMultilevel switchMultilevel(Integer deviceId, Integer instanceId) {
        return (Device.Instance.SwitchMultilevel)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("switchMultilevel");
    }

    public Device.Instance.MultiChannelAssociation multiChannelAssociation(Integer deviceId, Integer instanceId) {
        return (Device.Instance.MultiChannelAssociation)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("multiChannelAssociation");
    }

    public Device.Instance.MultiChannel multiChannel(Integer deviceId, Integer instanceId) {
        return (Device.Instance.MultiChannel)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("multiChannel");
    }

    public Device.Instance.NodeNaming nodeNaming(Integer deviceId, Integer instanceId) {
        return (Device.Instance.NodeNaming)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("nodeNaming");
    }

    public Device.Instance.ThermostatSetPoint thermostatSetPoint(Integer deviceId, Integer instanceId) {
        return (Device.Instance.ThermostatSetPoint)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("thermostatSetPoint");
    }

    public Device.Instance.ThermostatMode thermostatMode(Integer deviceId, Integer instanceId) {
        return (Device.Instance.ThermostatMode)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("thermostatMode");
    }

    public Device.Instance.ThermostatFanMode thermostatFanMode(Integer deviceId, Integer instanceId) {
        return (Device.Instance.ThermostatFanMode)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("thermostatFanMode");
    }

    public Device.Instance.ThermostatFanState thermostatFanState(Integer deviceId, Integer instanceId) {
        return (Device.Instance.ThermostatFanState)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("thermostatFanState");
    }

    public Device.Instance.ThermostatOperatingState thermostatOperatingState(Integer deviceId, Integer instanceId) {
        return (Device.Instance.ThermostatOperatingState)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("thermostatOperatingState");
    }

    public Device.Instance.ThermostatSetBack thermostatSetBack(Integer deviceId, Integer instanceId) {
        return (Device.Instance.ThermostatSetBack)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("thermostatSetBack");
    }

    public Device.Instance.AlarmSensor alarmSensor(Integer deviceId, Integer instanceId) {
        return (Device.Instance.AlarmSensor)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("alarmSensor");
    }

    public Device.Instance.DoorLock doorLock(Integer deviceId, Integer instanceId) {
        return (Device.Instance.DoorLock)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("doorLock");
    }

    public Device.Instance.DoorLockLogging doorLockLogging(Integer deviceId, Integer instanceId) {
        return (Device.Instance.DoorLockLogging)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("doorLockLogging");
    }

    public Device.Instance.UserCode userCode(Integer deviceId, Integer instanceId) {
        return (Device.Instance.UserCode)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("userCode");
    }

    public Device.Instance.Time time(Integer deviceId, Integer instanceId) {
        return (Device.Instance.Time)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("time");
    }

    public Device.Instance.TimeParameters timeParameters(Integer deviceId, Integer instanceId) {
        return (Device.Instance.TimeParameters)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("timeParameters");
    }

    public Device.Instance.Clock clock(Integer deviceId, Integer instanceId) {
        return (Device.Instance.Clock)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("clock");
    }

    public Device.Instance.SceneActivation sceneActivation(Integer deviceId, Integer instanceId) {
        return (Device.Instance.SceneActivation)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("sceneActivation");
    }

    public Device.Instance.SceneControllerConf sceneControllerConf(Integer deviceId, Integer instanceId) {
        return (Device.Instance.SceneControllerConf)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("sceneControllerConf");
    }

    public Device.Instance.SceneActuatorConf sceneActuatorConf(Integer deviceId, Integer instanceId) {
        return (Device.Instance.SceneActuatorConf)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("sceneActuatorConf");
    }

    public Device.Instance.Indicator indicator(Integer deviceId, Integer instanceId) {
        return (Device.Instance.Indicator)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("indicator");
    }

    public Device.Instance.Protection protection(Integer deviceId, Integer instanceId) {
        return (Device.Instance.Protection)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("protection");
    }

    public Device.Instance.ScheduleEntryLock scheduleEntryLock(Integer deviceId, Integer instanceId) {
        return (Device.Instance.ScheduleEntryLock)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("scheduleEntryLock");
    }

    public Device.Instance.ClimateControlSchedule climateControlSchedule(Integer deviceId, Integer instanceId) {
        return (Device.Instance.ClimateControlSchedule)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("climateControlSchedule");
    }

    public Device.Instance.MeterTableMonitor meterTableMonitor(Integer deviceId, Integer instanceId) {
        return (Device.Instance.MeterTableMonitor)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("meterTableMonitor");
    }

    public Device.Instance.Alarm alarm(Integer deviceId, Integer instanceId) {
        return (Device.Instance.Alarm)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("alarm");
    }

    public Device.Instance.PowerLevel powerLevel(Integer deviceId, Integer instanceId) {
        return (Device.Instance.PowerLevel)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("powerLevel");
    }

    public Device.Instance.ZWavePlusInfo zWavePlusInfo(Integer deviceId, Integer instanceId) {
        return (Device.Instance.ZWavePlusInfo)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("zWavePlusInfo");
    }

    public Device.Instance.FirmwareUpdate firmwareUpdate(Integer deviceId, Integer instanceId) {
        return (Device.Instance.FirmwareUpdate)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("firmwareUpdate");
    }

    public Device.Instance.AssociationGroupInformation associationGroupInformation(Integer deviceId, Integer instanceId) {
        return (Device.Instance.AssociationGroupInformation)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("associationGroupInformation");
    }

    public Device.Instance.SwitchColor switchColor(Integer deviceId, Integer instanceId) {
        return (Device.Instance.SwitchColor)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("switchColor");
    }

    public Device.Instance.SoundSwitch soundSwitch(Integer deviceId, Integer instanceId) {
        return (Device.Instance.SoundSwitch)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("soundSwitch");
    }

    public Device.Instance.BarrierOperator barrierOperator(Integer deviceId, Integer instanceId) {
        return (Device.Instance.BarrierOperator)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("barrierOperator");
    }

    public Device.Instance.SimpleAVControl simpleAVControl(Integer deviceId, Integer instanceId) {
        return (Device.Instance.SimpleAVControl)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("simpleAVControl");
    }

    public Device.Instance.Security security(Integer deviceId, Integer instanceId) {
        return (Device.Instance.Security)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("security");
    }

    public Device.Instance.SecurityS2 securityS2(Integer deviceId, Integer instanceId) {
        return (Device.Instance.SecurityS2)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("securityS2");
    }

    public Device.Instance.EntryControl entryControl(Integer deviceId, Integer instanceId) {
        return (Device.Instance.EntryControl)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("entryControl");
    }

    public Device.Instance.Hail hail(Integer deviceId, Integer instanceId) {
        return (Device.Instance.Hail)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("hail");
    }

    public Device.Instance.CRC16 cRC16(Integer deviceId, Integer instanceId) {
        return (Device.Instance.CRC16)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("cRC16");
    }

    public Device.Instance.MultiCmd multiCmd(Integer deviceId, Integer instanceId) {
        return (Device.Instance.MultiCmd)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("multiCmd");
    }

    public Device.Instance.Supervision supervision(Integer deviceId, Integer instanceId) {
        return (Device.Instance.Supervision)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("supervision");
    }

    public Device.Instance.ApplicationStatus applicationStatus(Integer deviceId, Integer instanceId) {
        return (Device.Instance.ApplicationStatus)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("applicationStatus");
    }

    public Device.Instance.Version version(Integer deviceId, Integer instanceId) {
        return (Device.Instance.Version)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("version");
    }

    public Device.Instance.DeviceResetLocally deviceResetLocally(Integer deviceId, Integer instanceId) {
        return (Device.Instance.DeviceResetLocally)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("deviceResetLocally");
    }

    public Device.Instance.CentralScene centralScene(Integer deviceId, Integer instanceId) {
        return (Device.Instance.CentralScene)this.devices.get((Object)deviceId).instances.get((Object)instanceId).commandClassesByName.get("centralScene");
    }

    public static Type commandClassClassById(Integer id) {
        switch (id) {
            case 32: {
                return Device.Instance.Basic.class;
            }
            case 132: {
                return Device.Instance.Wakeup.class;
            }
            case 0: {
                return Device.Instance.NoOperation.class;
            }
            case 128: {
                return Device.Instance.Battery.class;
            }
            case 114: {
                return Device.Instance.ManufacturerSpecific.class;
            }
            case 136: {
                return Device.Instance.Proprietary.class;
            }
            case 112: {
                return Device.Instance.Configuration.class;
            }
            case 48: {
                return Device.Instance.SensorBinary.class;
            }
            case 133: {
                return Device.Instance.Association.class;
            }
            case 50: {
                return Device.Instance.Meter.class;
            }
            case 53: {
                return Device.Instance.MeterPulse.class;
            }
            case 49: {
                return Device.Instance.SensorMultilevel.class;
            }
            case 158: {
                return Device.Instance.SensorConfiguration.class;
            }
            case 39: {
                return Device.Instance.SwitchAll.class;
            }
            case 37: {
                return Device.Instance.SwitchBinary.class;
            }
            case 38: {
                return Device.Instance.SwitchMultilevel.class;
            }
            case 142: {
                return Device.Instance.MultiChannelAssociation.class;
            }
            case 96: {
                return Device.Instance.MultiChannel.class;
            }
            case 119: {
                return Device.Instance.NodeNaming.class;
            }
            case 67: {
                return Device.Instance.ThermostatSetPoint.class;
            }
            case 64: {
                return Device.Instance.ThermostatMode.class;
            }
            case 68: {
                return Device.Instance.ThermostatFanMode.class;
            }
            case 69: {
                return Device.Instance.ThermostatFanState.class;
            }
            case 66: {
                return Device.Instance.ThermostatOperatingState.class;
            }
            case 71: {
                return Device.Instance.ThermostatSetBack.class;
            }
            case 156: {
                return Device.Instance.AlarmSensor.class;
            }
            case 98: {
                return Device.Instance.DoorLock.class;
            }
            case 76: {
                return Device.Instance.DoorLockLogging.class;
            }
            case 99: {
                return Device.Instance.UserCode.class;
            }
            case 138: {
                return Device.Instance.Time.class;
            }
            case 139: {
                return Device.Instance.TimeParameters.class;
            }
            case 129: {
                return Device.Instance.Clock.class;
            }
            case 43: {
                return Device.Instance.SceneActivation.class;
            }
            case 45: {
                return Device.Instance.SceneControllerConf.class;
            }
            case 44: {
                return Device.Instance.SceneActuatorConf.class;
            }
            case 135: {
                return Device.Instance.Indicator.class;
            }
            case 117: {
                return Device.Instance.Protection.class;
            }
            case 78: {
                return Device.Instance.ScheduleEntryLock.class;
            }
            case 70: {
                return Device.Instance.ClimateControlSchedule.class;
            }
            case 61: {
                return Device.Instance.MeterTableMonitor.class;
            }
            case 113: {
                return Device.Instance.Alarm.class;
            }
            case 115: {
                return Device.Instance.PowerLevel.class;
            }
            case 94: {
                return Device.Instance.ZWavePlusInfo.class;
            }
            case 122: {
                return Device.Instance.FirmwareUpdate.class;
            }
            case 89: {
                return Device.Instance.AssociationGroupInformation.class;
            }
            case 51: {
                return Device.Instance.SwitchColor.class;
            }
            case 121: {
                return Device.Instance.SoundSwitch.class;
            }
            case 102: {
                return Device.Instance.BarrierOperator.class;
            }
            case 148: {
                return Device.Instance.SimpleAVControl.class;
            }
            case 152: {
                return Device.Instance.Security.class;
            }
            case 159: {
                return Device.Instance.SecurityS2.class;
            }
            case 111: {
                return Device.Instance.EntryControl.class;
            }
            case 130: {
                return Device.Instance.Hail.class;
            }
            case 86: {
                return Device.Instance.CRC16.class;
            }
            case 143: {
                return Device.Instance.MultiCmd.class;
            }
            case 108: {
                return Device.Instance.Supervision.class;
            }
            case 34: {
                return Device.Instance.ApplicationStatus.class;
            }
            case 134: {
                return Device.Instance.Version.class;
            }
            case 90: {
                return Device.Instance.DeviceResetLocally.class;
            }
            case 91: {
                return Device.Instance.CentralScene.class;
            }
        }
        return null;
    }

    public static String commandClassNameById(Integer id) {
        switch (id) {
            case 32: {
                return "basic";
            }
            case 132: {
                return "wakeup";
            }
            case 0: {
                return "noOperation";
            }
            case 128: {
                return "battery";
            }
            case 114: {
                return "manufacturerSpecific";
            }
            case 136: {
                return "proprietary";
            }
            case 112: {
                return "configuration";
            }
            case 48: {
                return "sensorBinary";
            }
            case 133: {
                return "association";
            }
            case 50: {
                return "meter";
            }
            case 53: {
                return "meterPulse";
            }
            case 49: {
                return "sensorMultilevel";
            }
            case 158: {
                return "sensorConfiguration";
            }
            case 39: {
                return "switchAll";
            }
            case 37: {
                return "switchBinary";
            }
            case 38: {
                return "switchMultilevel";
            }
            case 142: {
                return "multiChannelAssociation";
            }
            case 96: {
                return "multiChannel";
            }
            case 119: {
                return "nodeNaming";
            }
            case 67: {
                return "thermostatSetPoint";
            }
            case 64: {
                return "thermostatMode";
            }
            case 68: {
                return "thermostatFanMode";
            }
            case 69: {
                return "thermostatFanState";
            }
            case 66: {
                return "thermostatOperatingState";
            }
            case 71: {
                return "thermostatSetBack";
            }
            case 156: {
                return "alarmSensor";
            }
            case 98: {
                return "doorLock";
            }
            case 76: {
                return "doorLockLogging";
            }
            case 99: {
                return "userCode";
            }
            case 138: {
                return "time";
            }
            case 139: {
                return "timeParameters";
            }
            case 129: {
                return "clock";
            }
            case 43: {
                return "sceneActivation";
            }
            case 45: {
                return "sceneControllerConf";
            }
            case 44: {
                return "sceneActuatorConf";
            }
            case 135: {
                return "indicator";
            }
            case 117: {
                return "protection";
            }
            case 78: {
                return "scheduleEntryLock";
            }
            case 70: {
                return "climateControlSchedule";
            }
            case 61: {
                return "meterTableMonitor";
            }
            case 113: {
                return "alarm";
            }
            case 115: {
                return "powerLevel";
            }
            case 94: {
                return "zWavePlusInfo";
            }
            case 122: {
                return "firmwareUpdate";
            }
            case 89: {
                return "associationGroupInformation";
            }
            case 51: {
                return "switchColor";
            }
            case 121: {
                return "soundSwitch";
            }
            case 102: {
                return "barrierOperator";
            }
            case 148: {
                return "simpleAVControl";
            }
            case 152: {
                return "security";
            }
            case 159: {
                return "securityS2";
            }
            case 111: {
                return "entryControl";
            }
            case 130: {
                return "hail";
            }
            case 86: {
                return "cRC16";
            }
            case 143: {
                return "multiCmd";
            }
            case 108: {
                return "supervision";
            }
            case 34: {
                return "applicationStatus";
            }
            case 134: {
                return "version";
            }
            case 90: {
                return "deviceResetLocally";
            }
            case 91: {
                return "centralScene";
            }
        }
        return null;
    }

    private void statusCallback(boolean result, Object obj) {
        for (StatusCallback sc : this.statusCallbacks) {
            sc.statusCallback(result, obj);
        }
    }

    private void deviceCallback(int type, int deviceId, int instanceId, int commandClassId) throws Exception {
        Device device;
        if (type == 1) {
            device = new Device(this, deviceId);
            this.devices.put(deviceId, device);
            Map<Integer, Device.Instance> map = device.instances;
            Integer n = 0;
            Device device2 = device;
            device2.getClass();
            map.put(n, device2.new Device.Instance(this, device, 0));
        } else if (type == 2) {
            this.devices.remove(deviceId);
        } else if (type == 4) {
            device = this.devices.get(deviceId);
            Map<Integer, Device.Instance> map = device.instances;
            Integer n = instanceId;
            Device device3 = device;
            device3.getClass();
            map.put(n, device3.new Device.Instance(this, device, instanceId));
        } else if (type == 8) {
            this.devices.get((Object)Integer.valueOf((int)deviceId)).instances.remove(instanceId);
        } else if (type == 16) {
            device = this.devices.get(deviceId);
            Device.Instance instance = device.instances.get(instanceId);
            switch (commandClassId) {
                case 32: {
                    Device.Instance instance2 = instance;
                    instance2.getClass();
                    Device.Instance.Basic commandBasic = instance2.new Device.Instance.Basic(this, instance);
                    instance.commandClasses.put(commandClassId, commandBasic);
                    instance.commandClassesByName.put("basic", commandBasic);
                    break;
                }
                case 132: {
                    Device.Instance instance3 = instance;
                    instance3.getClass();
                    Device.Instance.Wakeup commandWakeup = instance3.new Device.Instance.Wakeup(this, instance);
                    instance.commandClasses.put(commandClassId, commandWakeup);
                    instance.commandClassesByName.put("wakeup", commandWakeup);
                    break;
                }
                case 0: {
                    Device.Instance instance4 = instance;
                    instance4.getClass();
                    Device.Instance.NoOperation commandNoOperation = instance4.new Device.Instance.NoOperation(this, instance);
                    instance.commandClasses.put(commandClassId, commandNoOperation);
                    instance.commandClassesByName.put("noOperation", commandNoOperation);
                    break;
                }
                case 128: {
                    Device.Instance instance5 = instance;
                    instance5.getClass();
                    Device.Instance.Battery commandBattery = instance5.new Device.Instance.Battery(this, instance);
                    instance.commandClasses.put(commandClassId, commandBattery);
                    instance.commandClassesByName.put("battery", commandBattery);
                    break;
                }
                case 114: {
                    Device.Instance instance6 = instance;
                    instance6.getClass();
                    Device.Instance.ManufacturerSpecific commandManufacturerSpecific = instance6.new Device.Instance.ManufacturerSpecific(this, instance);
                    instance.commandClasses.put(commandClassId, commandManufacturerSpecific);
                    instance.commandClassesByName.put("manufacturerSpecific", commandManufacturerSpecific);
                    break;
                }
                case 136: {
                    Device.Instance instance7 = instance;
                    instance7.getClass();
                    Device.Instance.Proprietary commandProprietary = instance7.new Device.Instance.Proprietary(this, instance);
                    instance.commandClasses.put(commandClassId, commandProprietary);
                    instance.commandClassesByName.put("proprietary", commandProprietary);
                    break;
                }
                case 112: {
                    Device.Instance instance8 = instance;
                    instance8.getClass();
                    Device.Instance.Configuration commandConfiguration = instance8.new Device.Instance.Configuration(this, instance);
                    instance.commandClasses.put(commandClassId, commandConfiguration);
                    instance.commandClassesByName.put("configuration", commandConfiguration);
                    break;
                }
                case 48: {
                    Device.Instance instance9 = instance;
                    instance9.getClass();
                    Device.Instance.SensorBinary commandSensorBinary = instance9.new Device.Instance.SensorBinary(this, instance);
                    instance.commandClasses.put(commandClassId, commandSensorBinary);
                    instance.commandClassesByName.put("sensorBinary", commandSensorBinary);
                    break;
                }
                case 133: {
                    Device.Instance instance10 = instance;
                    instance10.getClass();
                    Device.Instance.Association commandAssociation = instance10.new Device.Instance.Association(this, instance);
                    instance.commandClasses.put(commandClassId, commandAssociation);
                    instance.commandClassesByName.put("association", commandAssociation);
                    break;
                }
                case 50: {
                    Device.Instance instance11 = instance;
                    instance11.getClass();
                    Device.Instance.Meter commandMeter = instance11.new Device.Instance.Meter(this, instance);
                    instance.commandClasses.put(commandClassId, commandMeter);
                    instance.commandClassesByName.put("meter", commandMeter);
                    break;
                }
                case 53: {
                    Device.Instance instance12 = instance;
                    instance12.getClass();
                    Device.Instance.MeterPulse commandMeterPulse = instance12.new Device.Instance.MeterPulse(this, instance);
                    instance.commandClasses.put(commandClassId, commandMeterPulse);
                    instance.commandClassesByName.put("meterPulse", commandMeterPulse);
                    break;
                }
                case 49: {
                    Device.Instance instance13 = instance;
                    instance13.getClass();
                    Device.Instance.SensorMultilevel commandSensorMultilevel = instance13.new Device.Instance.SensorMultilevel(this, instance);
                    instance.commandClasses.put(commandClassId, commandSensorMultilevel);
                    instance.commandClassesByName.put("sensorMultilevel", commandSensorMultilevel);
                    break;
                }
                case 158: {
                    Device.Instance instance14 = instance;
                    instance14.getClass();
                    Device.Instance.SensorConfiguration commandSensorConfiguration = instance14.new Device.Instance.SensorConfiguration(this, instance);
                    instance.commandClasses.put(commandClassId, commandSensorConfiguration);
                    instance.commandClassesByName.put("sensorConfiguration", commandSensorConfiguration);
                    break;
                }
                case 39: {
                    Device.Instance instance15 = instance;
                    instance15.getClass();
                    Device.Instance.SwitchAll commandSwitchAll = instance15.new Device.Instance.SwitchAll(this, instance);
                    instance.commandClasses.put(commandClassId, commandSwitchAll);
                    instance.commandClassesByName.put("switchAll", commandSwitchAll);
                    break;
                }
                case 37: {
                    Device.Instance instance16 = instance;
                    instance16.getClass();
                    Device.Instance.SwitchBinary commandSwitchBinary = instance16.new Device.Instance.SwitchBinary(this, instance);
                    instance.commandClasses.put(commandClassId, commandSwitchBinary);
                    instance.commandClassesByName.put("switchBinary", commandSwitchBinary);
                    break;
                }
                case 38: {
                    Device.Instance instance17 = instance;
                    instance17.getClass();
                    Device.Instance.SwitchMultilevel commandSwitchMultilevel = instance17.new Device.Instance.SwitchMultilevel(this, instance);
                    instance.commandClasses.put(commandClassId, commandSwitchMultilevel);
                    instance.commandClassesByName.put("switchMultilevel", commandSwitchMultilevel);
                    break;
                }
                case 142: {
                    Device.Instance instance18 = instance;
                    instance18.getClass();
                    Device.Instance.MultiChannelAssociation commandMultiChannelAssociation = instance18.new Device.Instance.MultiChannelAssociation(this, instance);
                    instance.commandClasses.put(commandClassId, commandMultiChannelAssociation);
                    instance.commandClassesByName.put("multiChannelAssociation", commandMultiChannelAssociation);
                    break;
                }
                case 96: {
                    Device.Instance instance19 = instance;
                    instance19.getClass();
                    Device.Instance.MultiChannel commandMultiChannel = instance19.new Device.Instance.MultiChannel(this, instance);
                    instance.commandClasses.put(commandClassId, commandMultiChannel);
                    instance.commandClassesByName.put("multiChannel", commandMultiChannel);
                    break;
                }
                case 119: {
                    Device.Instance instance20 = instance;
                    instance20.getClass();
                    Device.Instance.NodeNaming commandNodeNaming = instance20.new Device.Instance.NodeNaming(this, instance);
                    instance.commandClasses.put(commandClassId, commandNodeNaming);
                    instance.commandClassesByName.put("nodeNaming", commandNodeNaming);
                    break;
                }
                case 67: {
                    Device.Instance instance21 = instance;
                    instance21.getClass();
                    Device.Instance.ThermostatSetPoint commandThermostatSetPoint = instance21.new Device.Instance.ThermostatSetPoint(this, instance);
                    instance.commandClasses.put(commandClassId, commandThermostatSetPoint);
                    instance.commandClassesByName.put("thermostatSetPoint", commandThermostatSetPoint);
                    break;
                }
                case 64: {
                    Device.Instance instance22 = instance;
                    instance22.getClass();
                    Device.Instance.ThermostatMode commandThermostatMode = instance22.new Device.Instance.ThermostatMode(this, instance);
                    instance.commandClasses.put(commandClassId, commandThermostatMode);
                    instance.commandClassesByName.put("thermostatMode", commandThermostatMode);
                    break;
                }
                case 68: {
                    Device.Instance instance23 = instance;
                    instance23.getClass();
                    Device.Instance.ThermostatFanMode commandThermostatFanMode = instance23.new Device.Instance.ThermostatFanMode(this, instance);
                    instance.commandClasses.put(commandClassId, commandThermostatFanMode);
                    instance.commandClassesByName.put("thermostatFanMode", commandThermostatFanMode);
                    break;
                }
                case 69: {
                    Device.Instance instance24 = instance;
                    instance24.getClass();
                    Device.Instance.ThermostatFanState commandThermostatFanState = instance24.new Device.Instance.ThermostatFanState(this, instance);
                    instance.commandClasses.put(commandClassId, commandThermostatFanState);
                    instance.commandClassesByName.put("thermostatFanState", commandThermostatFanState);
                    break;
                }
                case 66: {
                    Device.Instance instance25 = instance;
                    instance25.getClass();
                    Device.Instance.ThermostatOperatingState commandThermostatOperatingState = instance25.new Device.Instance.ThermostatOperatingState(this, instance);
                    instance.commandClasses.put(commandClassId, commandThermostatOperatingState);
                    instance.commandClassesByName.put("thermostatOperatingState", commandThermostatOperatingState);
                    break;
                }
                case 71: {
                    Device.Instance instance26 = instance;
                    instance26.getClass();
                    Device.Instance.ThermostatSetBack commandThermostatSetBack = instance26.new Device.Instance.ThermostatSetBack(this, instance);
                    instance.commandClasses.put(commandClassId, commandThermostatSetBack);
                    instance.commandClassesByName.put("thermostatSetBack", commandThermostatSetBack);
                    break;
                }
                case 156: {
                    Device.Instance instance27 = instance;
                    instance27.getClass();
                    Device.Instance.AlarmSensor commandAlarmSensor = instance27.new Device.Instance.AlarmSensor(this, instance);
                    instance.commandClasses.put(commandClassId, commandAlarmSensor);
                    instance.commandClassesByName.put("alarmSensor", commandAlarmSensor);
                    break;
                }
                case 98: {
                    Device.Instance instance28 = instance;
                    instance28.getClass();
                    Device.Instance.DoorLock commandDoorLock = instance28.new Device.Instance.DoorLock(this, instance);
                    instance.commandClasses.put(commandClassId, commandDoorLock);
                    instance.commandClassesByName.put("doorLock", commandDoorLock);
                    break;
                }
                case 76: {
                    Device.Instance instance29 = instance;
                    instance29.getClass();
                    Device.Instance.DoorLockLogging commandDoorLockLogging = instance29.new Device.Instance.DoorLockLogging(this, instance);
                    instance.commandClasses.put(commandClassId, commandDoorLockLogging);
                    instance.commandClassesByName.put("doorLockLogging", commandDoorLockLogging);
                    break;
                }
                case 99: {
                    Device.Instance instance30 = instance;
                    instance30.getClass();
                    Device.Instance.UserCode commandUserCode = instance30.new Device.Instance.UserCode(this, instance);
                    instance.commandClasses.put(commandClassId, commandUserCode);
                    instance.commandClassesByName.put("userCode", commandUserCode);
                    break;
                }
                case 138: {
                    Device.Instance instance31 = instance;
                    instance31.getClass();
                    Device.Instance.Time commandTime = instance31.new Device.Instance.Time(this, instance);
                    instance.commandClasses.put(commandClassId, commandTime);
                    instance.commandClassesByName.put("time", commandTime);
                    break;
                }
                case 139: {
                    Device.Instance instance32 = instance;
                    instance32.getClass();
                    Device.Instance.TimeParameters commandTimeParameters = instance32.new Device.Instance.TimeParameters(this, instance);
                    instance.commandClasses.put(commandClassId, commandTimeParameters);
                    instance.commandClassesByName.put("timeParameters", commandTimeParameters);
                    break;
                }
                case 129: {
                    Device.Instance instance33 = instance;
                    instance33.getClass();
                    Device.Instance.Clock commandClock = instance33.new Device.Instance.Clock(this, instance);
                    instance.commandClasses.put(commandClassId, commandClock);
                    instance.commandClassesByName.put("clock", commandClock);
                    break;
                }
                case 43: {
                    Device.Instance instance34 = instance;
                    instance34.getClass();
                    Device.Instance.SceneActivation commandSceneActivation = instance34.new Device.Instance.SceneActivation(this, instance);
                    instance.commandClasses.put(commandClassId, commandSceneActivation);
                    instance.commandClassesByName.put("sceneActivation", commandSceneActivation);
                    break;
                }
                case 45: {
                    Device.Instance instance35 = instance;
                    instance35.getClass();
                    Device.Instance.SceneControllerConf commandSceneControllerConf = instance35.new Device.Instance.SceneControllerConf(this, instance);
                    instance.commandClasses.put(commandClassId, commandSceneControllerConf);
                    instance.commandClassesByName.put("sceneControllerConf", commandSceneControllerConf);
                    break;
                }
                case 44: {
                    Device.Instance instance36 = instance;
                    instance36.getClass();
                    Device.Instance.SceneActuatorConf commandSceneActuatorConf = instance36.new Device.Instance.SceneActuatorConf(this, instance);
                    instance.commandClasses.put(commandClassId, commandSceneActuatorConf);
                    instance.commandClassesByName.put("sceneActuatorConf", commandSceneActuatorConf);
                    break;
                }
                case 135: {
                    Device.Instance instance37 = instance;
                    instance37.getClass();
                    Device.Instance.Indicator commandIndicator = instance37.new Device.Instance.Indicator(this, instance);
                    instance.commandClasses.put(commandClassId, commandIndicator);
                    instance.commandClassesByName.put("indicator", commandIndicator);
                    break;
                }
                case 117: {
                    Device.Instance instance38 = instance;
                    instance38.getClass();
                    Device.Instance.Protection commandProtection = instance38.new Device.Instance.Protection(this, instance);
                    instance.commandClasses.put(commandClassId, commandProtection);
                    instance.commandClassesByName.put("protection", commandProtection);
                    break;
                }
                case 78: {
                    Device.Instance instance39 = instance;
                    instance39.getClass();
                    Device.Instance.ScheduleEntryLock commandScheduleEntryLock = instance39.new Device.Instance.ScheduleEntryLock(this, instance);
                    instance.commandClasses.put(commandClassId, commandScheduleEntryLock);
                    instance.commandClassesByName.put("scheduleEntryLock", commandScheduleEntryLock);
                    break;
                }
                case 70: {
                    Device.Instance instance40 = instance;
                    instance40.getClass();
                    Device.Instance.ClimateControlSchedule commandClimateControlSchedule = instance40.new Device.Instance.ClimateControlSchedule(this, instance);
                    instance.commandClasses.put(commandClassId, commandClimateControlSchedule);
                    instance.commandClassesByName.put("climateControlSchedule", commandClimateControlSchedule);
                    break;
                }
                case 61: {
                    Device.Instance instance41 = instance;
                    instance41.getClass();
                    Device.Instance.MeterTableMonitor commandMeterTableMonitor = instance41.new Device.Instance.MeterTableMonitor(this, instance);
                    instance.commandClasses.put(commandClassId, commandMeterTableMonitor);
                    instance.commandClassesByName.put("meterTableMonitor", commandMeterTableMonitor);
                    break;
                }
                case 113: {
                    Device.Instance instance42 = instance;
                    instance42.getClass();
                    Device.Instance.Alarm commandAlarm = instance42.new Device.Instance.Alarm(this, instance);
                    instance.commandClasses.put(commandClassId, commandAlarm);
                    instance.commandClassesByName.put("alarm", commandAlarm);
                    break;
                }
                case 115: {
                    Device.Instance instance43 = instance;
                    instance43.getClass();
                    Device.Instance.PowerLevel commandPowerLevel = instance43.new Device.Instance.PowerLevel(this, instance);
                    instance.commandClasses.put(commandClassId, commandPowerLevel);
                    instance.commandClassesByName.put("powerLevel", commandPowerLevel);
                    break;
                }
                case 94: {
                    Device.Instance instance44 = instance;
                    instance44.getClass();
                    Device.Instance.ZWavePlusInfo commandZWavePlusInfo = instance44.new Device.Instance.ZWavePlusInfo(this, instance);
                    instance.commandClasses.put(commandClassId, commandZWavePlusInfo);
                    instance.commandClassesByName.put("zWavePlusInfo", commandZWavePlusInfo);
                    break;
                }
                case 122: {
                    Device.Instance instance45 = instance;
                    instance45.getClass();
                    Device.Instance.FirmwareUpdate commandFirmwareUpdate = instance45.new Device.Instance.FirmwareUpdate(this, instance);
                    instance.commandClasses.put(commandClassId, commandFirmwareUpdate);
                    instance.commandClassesByName.put("firmwareUpdate", commandFirmwareUpdate);
                    break;
                }
                case 89: {
                    Device.Instance instance46 = instance;
                    instance46.getClass();
                    Device.Instance.AssociationGroupInformation commandAssociationGroupInformation = instance46.new Device.Instance.AssociationGroupInformation(this, instance);
                    instance.commandClasses.put(commandClassId, commandAssociationGroupInformation);
                    instance.commandClassesByName.put("associationGroupInformation", commandAssociationGroupInformation);
                    break;
                }
                case 51: {
                    Device.Instance instance47 = instance;
                    instance47.getClass();
                    Device.Instance.SwitchColor commandSwitchColor = instance47.new Device.Instance.SwitchColor(this, instance);
                    instance.commandClasses.put(commandClassId, commandSwitchColor);
                    instance.commandClassesByName.put("switchColor", commandSwitchColor);
                    break;
                }
                case 121: {
                    Device.Instance instance48 = instance;
                    instance48.getClass();
                    Device.Instance.SoundSwitch commandSoundSwitch = instance48.new Device.Instance.SoundSwitch(this, instance);
                    instance.commandClasses.put(commandClassId, commandSoundSwitch);
                    instance.commandClassesByName.put("soundSwitch", commandSoundSwitch);
                    break;
                }
                case 102: {
                    Device.Instance instance49 = instance;
                    instance49.getClass();
                    Device.Instance.BarrierOperator commandBarrierOperator = instance49.new Device.Instance.BarrierOperator(this, instance);
                    instance.commandClasses.put(commandClassId, commandBarrierOperator);
                    instance.commandClassesByName.put("barrierOperator", commandBarrierOperator);
                    break;
                }
                case 148: {
                    Device.Instance instance50 = instance;
                    instance50.getClass();
                    Device.Instance.SimpleAVControl commandSimpleAVControl = instance50.new Device.Instance.SimpleAVControl(this, instance);
                    instance.commandClasses.put(commandClassId, commandSimpleAVControl);
                    instance.commandClassesByName.put("simpleAVControl", commandSimpleAVControl);
                    break;
                }
                case 152: {
                    Device.Instance instance51 = instance;
                    instance51.getClass();
                    Device.Instance.Security commandSecurity = instance51.new Device.Instance.Security(this, instance);
                    instance.commandClasses.put(commandClassId, commandSecurity);
                    instance.commandClassesByName.put("security", commandSecurity);
                    break;
                }
                case 159: {
                    Device.Instance instance52 = instance;
                    instance52.getClass();
                    Device.Instance.SecurityS2 commandSecurityS2 = instance52.new Device.Instance.SecurityS2(this, instance);
                    instance.commandClasses.put(commandClassId, commandSecurityS2);
                    instance.commandClassesByName.put("securityS2", commandSecurityS2);
                    break;
                }
                case 111: {
                    Device.Instance instance53 = instance;
                    instance53.getClass();
                    Device.Instance.EntryControl commandEntryControl = instance53.new Device.Instance.EntryControl(this, instance);
                    instance.commandClasses.put(commandClassId, commandEntryControl);
                    instance.commandClassesByName.put("entryControl", commandEntryControl);
                    break;
                }
                case 130: {
                    Device.Instance instance54 = instance;
                    instance54.getClass();
                    Device.Instance.Hail commandHail = instance54.new Device.Instance.Hail(this, instance);
                    instance.commandClasses.put(commandClassId, commandHail);
                    instance.commandClassesByName.put("hail", commandHail);
                    break;
                }
                case 86: {
                    Device.Instance instance55 = instance;
                    instance55.getClass();
                    Device.Instance.CRC16 commandCRC16 = instance55.new Device.Instance.CRC16(this, instance);
                    instance.commandClasses.put(commandClassId, commandCRC16);
                    instance.commandClassesByName.put("cRC16", commandCRC16);
                    break;
                }
                case 143: {
                    Device.Instance instance56 = instance;
                    instance56.getClass();
                    Device.Instance.MultiCmd commandMultiCmd = instance56.new Device.Instance.MultiCmd(this, instance);
                    instance.commandClasses.put(commandClassId, commandMultiCmd);
                    instance.commandClassesByName.put("multiCmd", commandMultiCmd);
                    break;
                }
                case 108: {
                    Device.Instance instance57 = instance;
                    instance57.getClass();
                    Device.Instance.Supervision commandSupervision = instance57.new Device.Instance.Supervision(this, instance);
                    instance.commandClasses.put(commandClassId, commandSupervision);
                    instance.commandClassesByName.put("supervision", commandSupervision);
                    break;
                }
                case 34: {
                    Device.Instance instance58 = instance;
                    instance58.getClass();
                    Device.Instance.ApplicationStatus commandApplicationStatus = instance58.new Device.Instance.ApplicationStatus(this, instance);
                    instance.commandClasses.put(commandClassId, commandApplicationStatus);
                    instance.commandClassesByName.put("applicationStatus", commandApplicationStatus);
                    break;
                }
                case 134: {
                    Device.Instance instance59 = instance;
                    instance59.getClass();
                    Device.Instance.Version commandVersion = instance59.new Device.Instance.Version(this, instance);
                    instance.commandClasses.put(commandClassId, commandVersion);
                    instance.commandClassesByName.put("version", commandVersion);
                    break;
                }
                case 90: {
                    Device.Instance instance60 = instance;
                    instance60.getClass();
                    Device.Instance.DeviceResetLocally commandDeviceResetLocally = instance60.new Device.Instance.DeviceResetLocally(this, instance);
                    instance.commandClasses.put(commandClassId, commandDeviceResetLocally);
                    instance.commandClassesByName.put("deviceResetLocally", commandDeviceResetLocally);
                    break;
                }
                case 91: {
                    Device.Instance instance61 = instance;
                    instance61.getClass();
                    Device.Instance.CentralScene commandCentralScene = instance61.new Device.Instance.CentralScene(this, instance);
                    instance.commandClasses.put(commandClassId, commandCentralScene);
                    instance.commandClassesByName.put("centralScene", commandCentralScene);
                }
            }
        } else if (type == 32) {
            Device.Instance instance = this.devices.get((Object)Integer.valueOf((int)deviceId)).instances.get(instanceId);
            instance.commandClasses.remove(commandClassId);
            switch (commandClassId) {
                case 32: {
                    instance.commandClassesByName.remove("basic");
                    break;
                }
                case 132: {
                    instance.commandClassesByName.remove("wakeup");
                    break;
                }
                case 0: {
                    instance.commandClassesByName.remove("noOperation");
                    break;
                }
                case 128: {
                    instance.commandClassesByName.remove("battery");
                    break;
                }
                case 114: {
                    instance.commandClassesByName.remove("manufacturerSpecific");
                    break;
                }
                case 136: {
                    instance.commandClassesByName.remove("proprietary");
                    break;
                }
                case 112: {
                    instance.commandClassesByName.remove("configuration");
                    break;
                }
                case 48: {
                    instance.commandClassesByName.remove("sensorBinary");
                    break;
                }
                case 133: {
                    instance.commandClassesByName.remove("association");
                    break;
                }
                case 50: {
                    instance.commandClassesByName.remove("meter");
                    break;
                }
                case 53: {
                    instance.commandClassesByName.remove("meterPulse");
                    break;
                }
                case 49: {
                    instance.commandClassesByName.remove("sensorMultilevel");
                    break;
                }
                case 158: {
                    instance.commandClassesByName.remove("sensorConfiguration");
                    break;
                }
                case 39: {
                    instance.commandClassesByName.remove("switchAll");
                    break;
                }
                case 37: {
                    instance.commandClassesByName.remove("switchBinary");
                    break;
                }
                case 38: {
                    instance.commandClassesByName.remove("switchMultilevel");
                    break;
                }
                case 142: {
                    instance.commandClassesByName.remove("multiChannelAssociation");
                    break;
                }
                case 96: {
                    instance.commandClassesByName.remove("multiChannel");
                    break;
                }
                case 119: {
                    instance.commandClassesByName.remove("nodeNaming");
                    break;
                }
                case 67: {
                    instance.commandClassesByName.remove("thermostatSetPoint");
                    break;
                }
                case 64: {
                    instance.commandClassesByName.remove("thermostatMode");
                    break;
                }
                case 68: {
                    instance.commandClassesByName.remove("thermostatFanMode");
                    break;
                }
                case 69: {
                    instance.commandClassesByName.remove("thermostatFanState");
                    break;
                }
                case 66: {
                    instance.commandClassesByName.remove("thermostatOperatingState");
                    break;
                }
                case 71: {
                    instance.commandClassesByName.remove("thermostatSetBack");
                    break;
                }
                case 156: {
                    instance.commandClassesByName.remove("alarmSensor");
                    break;
                }
                case 98: {
                    instance.commandClassesByName.remove("doorLock");
                    break;
                }
                case 76: {
                    instance.commandClassesByName.remove("doorLockLogging");
                    break;
                }
                case 99: {
                    instance.commandClassesByName.remove("userCode");
                    break;
                }
                case 138: {
                    instance.commandClassesByName.remove("time");
                    break;
                }
                case 139: {
                    instance.commandClassesByName.remove("timeParameters");
                    break;
                }
                case 129: {
                    instance.commandClassesByName.remove("clock");
                    break;
                }
                case 43: {
                    instance.commandClassesByName.remove("sceneActivation");
                    break;
                }
                case 45: {
                    instance.commandClassesByName.remove("sceneControllerConf");
                    break;
                }
                case 44: {
                    instance.commandClassesByName.remove("sceneActuatorConf");
                    break;
                }
                case 135: {
                    instance.commandClassesByName.remove("indicator");
                    break;
                }
                case 117: {
                    instance.commandClassesByName.remove("protection");
                    break;
                }
                case 78: {
                    instance.commandClassesByName.remove("scheduleEntryLock");
                    break;
                }
                case 70: {
                    instance.commandClassesByName.remove("climateControlSchedule");
                    break;
                }
                case 61: {
                    instance.commandClassesByName.remove("meterTableMonitor");
                    break;
                }
                case 113: {
                    instance.commandClassesByName.remove("alarm");
                    break;
                }
                case 115: {
                    instance.commandClassesByName.remove("powerLevel");
                    break;
                }
                case 94: {
                    instance.commandClassesByName.remove("zWavePlusInfo");
                    break;
                }
                case 122: {
                    instance.commandClassesByName.remove("firmwareUpdate");
                    break;
                }
                case 89: {
                    instance.commandClassesByName.remove("associationGroupInformation");
                    break;
                }
                case 51: {
                    instance.commandClassesByName.remove("switchColor");
                    break;
                }
                case 121: {
                    instance.commandClassesByName.remove("soundSwitch");
                    break;
                }
                case 102: {
                    instance.commandClassesByName.remove("barrierOperator");
                    break;
                }
                case 148: {
                    instance.commandClassesByName.remove("simpleAVControl");
                    break;
                }
                case 152: {
                    instance.commandClassesByName.remove("security");
                    break;
                }
                case 159: {
                    instance.commandClassesByName.remove("securityS2");
                    break;
                }
                case 111: {
                    instance.commandClassesByName.remove("entryControl");
                    break;
                }
                case 130: {
                    instance.commandClassesByName.remove("hail");
                    break;
                }
                case 86: {
                    instance.commandClassesByName.remove("cRC16");
                    break;
                }
                case 143: {
                    instance.commandClassesByName.remove("multiCmd");
                    break;
                }
                case 108: {
                    instance.commandClassesByName.remove("supervision");
                    break;
                }
                case 34: {
                    instance.commandClassesByName.remove("applicationStatus");
                    break;
                }
                case 134: {
                    instance.commandClassesByName.remove("version");
                    break;
                }
                case 90: {
                    instance.commandClassesByName.remove("deviceResetLocally");
                    break;
                }
                case 91: {
                    instance.commandClassesByName.remove("centralScene");
                }
            }
        } else {
            System.out.println("Unhandled deviceCallback: type = " + type + ", id = " + deviceId + ", instance = " + instanceId + ", commandClass = " + commandClassId);
        }
        for (DeviceCallback dc : this.deviceCallbacks) {
            dc.deviceCallback(type, deviceId, instanceId, commandClassId);
        }
    }

    private void terminateCallback() {
        for (TerminateCallback tc : this.terminateCallbacks) {
            tc.terminateCallback();
        }
    }

    private native long jni_zwayInit(String var1, String var2, int var3, String var4, String var5, String var6);

    private native void jni_finalize(long var1);

    private native void jni_discover(long var1);

    private native void jni_stop(long var1);

    private native boolean jni_isIdle(long var1);

    private native boolean jni_isRunning(long var1);

    private native void jni_addNodeToNetwork(long var1, boolean var3);

    private native void jni_removeNodeFromNetwork(long var1, boolean var3);

    private native void jni_controllerChange(long var1, boolean var3);

    private native void jni_setSUCNodeId(long var1, int var3);

    private native void jni_setSISNodeId(long var1, int var3);

    private native void jni_disableSUCNodeId(long var1, int var3);

    private native void jni_setDefault(long var1);

    private native void jni_requestNetworkUpdate(long var1);

    private native void jni_setLearnMode(long var1, boolean var3);

    private native int[] jni_backup(long var1);

    private native void jni_restore(long var1, int[] var3, boolean var4);

    private native void jni_nodeProvisioningDSKAdd(long var1, int[] var3);

    private native void jni_nodeProvisioningDSKRemove(long var1, int[] var3);

    private native long jni_zdataFind(long var1, String var3, long var4);

    private native long jni_zdataControllerFind(String var1, long var2);

    private native long jni_zdataDeviceFind(String var1, int var2, long var3);

    private native long jni_zdataInstanceFind(String var1, int var2, int var3, long var4);

    private native long jni_zdataCommandClassFind(String var1, int var2, int var3, int var4, long var5);

    private native void jni_deviceSendNOP(long var1, int var3, Object var4);

    private native void jni_deviceAwakeQueue(long var1, int var3);

    private native void jni_deviceInterviewForce(long var1, int var3);

    private native boolean jni_deviceIsInterviewDone(long var1, int var3);

    private native void jni_deviceDelayCommunication(long var1, int var3, int var4);

    private native void jni_deviceAssignReturnRoute(long var1, int var3, int var4);

    private native void jni_deviceAssignPriorityReturnRoute(long var1, int var3, int var4, int var5, int var6, int var7, int var8);

    private native void jni_deviceDeleteReturnRoute(long var1, int var3);

    private native void jni_deviceAssignSUCReturnRoute(long var1, int var3);

    private native void jni_deviceAssignPrioritySUCReturnRoute(long var1, int var3, int var4, int var5, int var6, int var7);

    private native void jni_deviceDeleteSUCReturnRoute(long var1, int var3);

    private native void jni_ZDDXSaveToXML(long var1);

    private native void jni_commmandInterview(long var1, int var3, int var4, int var5);

    private native void jni_fc_getSerialApiCapabilities(long var1, Object var3);

    private native void jni_fc_serialApiSetTimeouts(long var1, int var3, int var4, Object var5);

    private native void jni_fc_serialApiGetInitData(long var1, Object var3);

    private native void jni_fc_serialApiApplicationNodeInfo(long var1, boolean var3, boolean var4, boolean var5, boolean var6, int var7, int var8, int[] var9, Object var10);

    private native void jni_fc_watchdogStart(long var1, Object var3);

    private native void jni_fc_watchdogStop(long var1, Object var3);

    private native void jni_fc_getHomeId(long var1, Object var3);

    private native void jni_fc_getControllerCapabilities(long var1, Object var3);

    private native void jni_fc_getVersion(long var1, Object var3);

    private native void jni_fc_getSucNodeId(long var1, Object var3);

    private native void jni_fc_enableSuc(long var1, boolean var3, boolean var4, Object var5);

    private native void jni_fc_setSucNodeId(long var1, int var3, boolean var4, boolean var5, Object var6);

    private native void jni_fc_memoryGetByte(long var1, int var3, Object var4);

    private native void jni_fc_memoryGetBuffer(long var1, int var3, int var4, Object var5);

    private native void jni_fc_memoryPutByte(long var1, int var3, int var4, Object var5);

    private native void jni_fc_memoryPutBuffer(long var1, int var3, int[] var4, Object var5);

    private native void jni_fc_nvmGetId(long var1, Object var3);

    private native void jni_fc_nvmExtReadLongByte(long var1, int var3, Object var4);

    private native void jni_fc_nvmExtReadLongBuffer(long var1, int var3, int var4, Object var5);

    private native void jni_fc_nvmExtWriteLongByte(long var1, int var3, int var4, Object var5);

    private native void jni_fc_nvmExtWriteLongBuffer(long var1, int var3, int[] var4, Object var5);

    private native void jni_fc_isFailedNode(long var1, int var3, Object var4);

    private native void jni_fc_sendDataAbort(long var1, Object var3);

    private native void jni_fc_serialApiSoftReset(long var1, Object var3);

    private native void jni_fc_sendData(long var1, int var3, int[] var4, String var5, Object var6);

    private native void jni_fc_sendDataSecure(long var1, int var3, int[] var4, String var5, int var6, Object var7);

    private native void jni_fc_getNodeProtocolInfo(long var1, int var3, Object var4);

    private native void jni_fc_getRoutingTableLine(long var1, int var3, boolean var4, boolean var5, Object var6);

    private native void jni_fc_assignReturnRoute(long var1, int var3, int var4, Object var5);

    private native void jni_fc_assignSucReturnRoute(long var1, int var3, Object var4);

    private native void jni_fc_deleteReturnRoute(long var1, int var3, Object var4);

    private native void jni_fc_deleteSucReturnRoute(long var1, int var3, Object var4);

    private native void jni_fc_setDefault(long var1, Object var3);

    private native void jni_fc_sendSucNodeId(long var1, int var3, Object var4);

    private native void jni_fc_sendNodeInformation(long var1, int var3, Object var4);

    private native void jni_fc_requestNodeInformation(long var1, int var3, Object var4);

    private native void jni_fc_removeFailedNode(long var1, int var3, Object var4);

    private native void jni_fc_replaceFailedNode(long var1, int var3, Object var4);

    private native void jni_fc_requestNetworkUpdate(long var1, Object var3);

    private native void jni_fc_requestNodeNeighbourUpdate(long var1, int var3, Object var4);

    private native void jni_fc_setLearnMode(long var1, boolean var3, Object var4);

    private native void jni_fc_addNodeToNetwork(long var1, boolean var3, boolean var4, Object var5);

    private native void jni_fc_smartStartEnable(long var1, Object var3);

    private native void jni_fc_removeNodeFromNetwork(long var1, boolean var3, boolean var4, Object var5);

    private native void jni_fc_removeNodeIdFromNetwork(long var1, int var3, boolean var4, boolean var5, Object var6);

    private native void jni_fc_controllerChange(long var1, boolean var3, boolean var4, Object var5);

    private native void jni_fc_createNewPrimary(long var1, boolean var3, Object var4);

    private native void jni_fc_zmeFreqChange(long var1, int var3, Object var4);

    private native void jni_fc_rfPowerLevelSet(long var1, int var3, Object var4);

    private native void jni_fc_rfPowerLevelGet(long var1, Object var3);

    private native void jni_fc_sendTestFrame(long var1, int var3, int var4, Object var5);

    private native void jni_fc_flashAutoProgSet(long var1, Object var3);

    private native void jni_fc_exploreRequestInclusion(long var1, Object var3);

    private native void jni_fc_exploreRequestExclusion(long var1, Object var3);

    private native void jni_fc_zmeBootloaderFlash(long var1, int var3, Object var4);

    private native void jni_fc_zmeBootloaderLoadFlash(long var1, int[] var3, Object var4);

    private native void jni_fc_zmeCapabilities(long var1, int[] var3, Object var4);

    private native void jni_fc_zmeLicenseSet(long var1, int[] var3, Object var4);

    private native void jni_fc_applicationCommandHandlerInject(long var1, int var3, int[] var4, Object var5);

    private native void jni_fc_getBackgroundRssi(long var1, Object var3);

    private native void jni_fc_serialApiSetupSetIma(long var1, boolean var3, Object var4);

    private native void jni_fc_serialApiSetupSetTxPower(long var1, int var3, Object var4);

    private native void jni_fc_clearNetworkStats(long var1, Object var3);

    private native void jni_fc_getNetworkStats(long var1, Object var3);

    private native void jni_fc_getPriorityRoute(long var1, int var3, Object var4);

    private native void jni_fc_setPriorityRoute(long var1, int var3, int var4, int var5, int var6, int var7, int var8, Object var9);

    private native void jni_fc_setPromiscuousMode(long var1, boolean var3, Object var4);

    private native void jni_fc_assignPriorityReturnRoute(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9, Object var10);

    private native void jni_fc_assignPrioritySucReturnRoute(long var1, int var3, int var4, int var5, int var6, int var7, int var8, Object var9);

    private native void jni_fc_zmeSerialapiOptionsJammingDetectionSet(long var1, int var3, int var4, int var5, Object var6);

    private native void jni_fc_zmeSerialapiOptionsAdvancedImaSet(long var1, boolean var3, Object var4);

    private native void jni_fc_zmeSerialapiOptionsStaticApiSet(long var1, boolean var3, Object var4);

    private native void jni_fc_zmeSerialapiOptionsUartSpeedSet(long var1, int var3, Object var4);

    private native void jni_fc_getLongRangeChannel(long var1, Object var3);

    private native void jni_fc_setLongRangeChannel(long var1, int var3, Object var4);

    private native void jni_fc_getLongRangeNodes(long var1, Object var3);

    private native void jni_cc_basicGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_basicSet(long var1, int var3, int var4, int var5, Object var6);

    private native void jni_cc_wakeupGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_wakeupCapabilitiesGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_wakeupSleep(long var1, int var3, int var4, Object var5);

    private native void jni_cc_wakeupSet(long var1, int var3, int var4, int var5, int var6, Object var7);

    private native void jni_cc_batteryGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_manufacturerSpecificGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_manufacturerSpecificDeviceIdGet(long var1, int var3, int var4, int var5, Object var6);

    private native void jni_cc_proprietaryGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_proprietarySet(long var1, int var3, int var4, int[] var5, Object var6);

    private native void jni_cc_configurationGet(long var1, int var3, int var4, int var5, Object var6);

    private native void jni_cc_configurationSet(long var1, int var3, int var4, int var5, int var6, int var7, Object var8);

    private native void jni_cc_configurationSetDefault(long var1, int var3, int var4, int var5, Object var6);

    private native void jni_cc_configurationDefaultReset(long var1, int var3, int var4, Object var5);

    private native void jni_cc_sensorBinaryGet(long var1, int var3, int var4, int var5, Object var6);

    private native void jni_cc_associationGet(long var1, int var3, int var4, int var5, Object var6);

    private native void jni_cc_associationSet(long var1, int var3, int var4, int var5, int var6, Object var7);

    private native void jni_cc_associationRemove(long var1, int var3, int var4, int var5, int var6, Object var7);

    private native void jni_cc_associationGroupingsGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_meterGet(long var1, int var3, int var4, int var5, Object var6);

    private native void jni_cc_meterReset(long var1, int var3, int var4, Object var5);

    private native void jni_cc_meterSupported(long var1, int var3, int var4, Object var5);

    private native void jni_cc_meterPulseGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_sensorMultilevelGet(long var1, int var3, int var4, int var5, Object var6);

    private native void jni_cc_sensorConfigurationGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_sensorConfigurationSet(long var1, int var3, int var4, int var5, float var6, Object var7);

    private native void jni_cc_switchAllGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_switchAllSet(long var1, int var3, int var4, int var5, Object var6);

    private native void jni_cc_switchAllSetOn(long var1, int var3, int var4, Object var5);

    private native void jni_cc_switchAllSetOff(long var1, int var3, int var4, Object var5);

    private native void jni_cc_switchBinaryGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_switchBinarySet(long var1, int var3, int var4, boolean var5, int var6, Object var7);

    private native void jni_cc_switchMultilevelGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_switchMultilevelSet(long var1, int var3, int var4, int var5, int var6, Object var7);

    private native void jni_cc_switchMultilevelStartLevelChange(long var1, int var3, int var4, int var5, int var6, boolean var7, int var8, int var9, int var10, Object var11);

    private native void jni_cc_switchMultilevelStopLevelChange(long var1, int var3, int var4, Object var5);

    private native void jni_cc_multichannelAssociationGet(long var1, int var3, int var4, int var5, Object var6);

    private native void jni_cc_multichannelAssociationSet(long var1, int var3, int var4, int var5, int var6, int var7, Object var8);

    private native void jni_cc_multichannelAssociationRemove(long var1, int var3, int var4, int var5, int var6, int var7, Object var8);

    private native void jni_cc_multichannelAssociationGroupingsGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_multichannelGet(long var1, int var3, int var4, int var5, Object var6);

    private native void jni_cc_multichannelEndpointFind(long var1, int var3, int var4, int var5, int var6, Object var7);

    private native void jni_cc_multichannelEndpointGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_multichannelCapabilitiesGet(long var1, int var3, int var4, int var5, Object var6);

    private native void jni_cc_multichannelAggregatedMembersGet(long var1, int var3, int var4, int var5, Object var6);

    private native void jni_cc_nodeNamingGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_nodeNamingGetName(long var1, int var3, int var4, Object var5);

    private native void jni_cc_nodeNamingGetLocation(long var1, int var3, int var4, Object var5);

    private native void jni_cc_nodeNamingSetName(long var1, int var3, int var4, String var5, Object var6);

    private native void jni_cc_nodeNamingSetLocation(long var1, int var3, int var4, String var5, Object var6);

    private native void jni_cc_thermostatSetpointGet(long var1, int var3, int var4, int var5, Object var6);

    private native void jni_cc_thermostatSetpointSet(long var1, int var3, int var4, int var5, float var6, Object var7);

    private native void jni_cc_thermostatModeGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_thermostatModeSet(long var1, int var3, int var4, int var5, Object var6);

    private native void jni_cc_thermostatModeSetManufacturerSpecific(long var1, int var3, int var4, int[] var5, Object var6);

    private native void jni_cc_thermostatFanModeGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_thermostatFanModeSet(long var1, int var3, int var4, boolean var5, int var6, Object var7);

    private native void jni_cc_thermostatFanStateGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_thermostatOperatingStateGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_thermostatOperatingStateLoggingGet(long var1, int var3, int var4, int var5, Object var6);

    private native void jni_cc_thermostatSetbackGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_thermostatSetbackSet(long var1, int var3, int var4, int var5, int var6, float var7, Object var8);

    private native void jni_cc_alarmSensorSupportedGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_alarmSensorGet(long var1, int var3, int var4, int var5, Object var6);

    private native void jni_cc_doorLockGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_doorLockConfigurationGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_doorLockSet(long var1, int var3, int var4, int var5, Object var6);

    private native void jni_cc_doorLockConfigurationSet(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, boolean var11, boolean var12, Object var13);

    private native void jni_cc_doorLockLoggingGet(long var1, int var3, int var4, int var5, Object var6);

    private native void jni_cc_userCodeGet(long var1, int var3, int var4, int var5, Object var6);

    private native void jni_cc_userCodeGetAll(long var1, int var3, int var4, Object var5);

    private native void jni_cc_userCodeSet(long var1, int var3, int var4, int var5, String var6, int var7, Object var8);

    private native void jni_cc_userCodeSetRaw(long var1, int var3, int var4, int var5, int[] var6, int var7, Object var8);

    private native void jni_cc_userCodeMasterCodeGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_userCodeMasterCodeSet(long var1, int var3, int var4, String var5, Object var6);

    private native void jni_cc_userCodeMasterCodeSetRaw(long var1, int var3, int var4, int[] var5, Object var6);

    private native void jni_cc_userCodeKeypadModeGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_userCodeKeypadModeSet(long var1, int var3, int var4, int var5, Object var6);

    private native void jni_cc_userCodeChecksumGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_timeTimeGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_timeDateGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_timeOffsetGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_timeParametersGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_timeParametersSet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_clockGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_clockSet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_sceneActivationSet(long var1, int var3, int var4, int var5, int var6, Object var7);

    private native void jni_cc_sceneControllerConfGet(long var1, int var3, int var4, int var5, Object var6);

    private native void jni_cc_sceneControllerConfSet(long var1, int var3, int var4, int var5, int var6, int var7, Object var8);

    private native void jni_cc_sceneActuatorConfGet(long var1, int var3, int var4, int var5, Object var6);

    private native void jni_cc_sceneActuatorConfSet(long var1, int var3, int var4, int var5, int var6, int var7, boolean var8, Object var9);

    private native void jni_cc_indicatorGet(long var1, int var3, int var4, int var5, Object var6);

    private native void jni_cc_indicatorSet(long var1, int var3, int var4, int var5, int var6, int var7, Object var8);

    private native void jni_cc_indicatorSetMultiple(long var1, int var3, int var4, int var5, int[] var6, int[] var7, Object var8);

    private native void jni_cc_indicatorIdentify(long var1, int var3, int var4, Object var5);

    private native void jni_cc_protectionGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_protectionSet(long var1, int var3, int var4, int var5, int var6, Object var7);

    private native void jni_cc_protectionExclusiveGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_protectionExclusiveSet(long var1, int var3, int var4, int var5, Object var6);

    private native void jni_cc_protectionTimeoutGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_protectionTimeoutSet(long var1, int var3, int var4, int var5, Object var6);

    private native void jni_cc_scheduleEntryLockEnable(long var1, int var3, int var4, int var5, boolean var6, Object var7);

    private native void jni_cc_scheduleEntryLockWeekdayGet(long var1, int var3, int var4, int var5, int var6, Object var7);

    private native void jni_cc_scheduleEntryLockWeekdaySet(long var1, int var3, int var4, boolean var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, Object var13);

    private native void jni_cc_scheduleEntryLockYearGet(long var1, int var3, int var4, int var5, int var6, Object var7);

    private native void jni_cc_scheduleEntryLockYearSet(long var1, int var3, int var4, boolean var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16, int var17, Object var18);

    private native void jni_cc_climateControlScheduleOverrideGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_climateControlScheduleOverrideSet(long var1, int var3, int var4, int var5, int var6, Object var7);

    private native void jni_cc_meterTableMonitorStatusDateGet(long var1, int var3, int var4, int var5, long var6, long var8, Object var10);

    private native void jni_cc_meterTableMonitorStatusDepthGet(long var1, int var3, int var4, int var5, Object var6);

    private native void jni_cc_meterTableMonitorCurrentDataGet(long var1, int var3, int var4, int var5, Object var6);

    private native void jni_cc_meterTableMonitorHistoricalDataGet(long var1, int var3, int var4, int var5, int var6, long var7, long var9, Object var11);

    private native void jni_cc_alarmGet(long var1, int var3, int var4, int var5, int var6, Object var7);

    private native void jni_cc_alarmSet(long var1, int var3, int var4, int var5, int var6, Object var7);

    private native void jni_cc_powerLevelGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_powerLevelSet(long var1, int var3, int var4, int var5, int var6, Object var7);

    private native void jni_cc_powerLevelTestNodeGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_powerLevelTestNodeSet(long var1, int var3, int var4, int var5, int var6, int var7, Object var8);

    private native void jni_cc_zwavePlusInfoGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_firmwareUpdateGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_firmwareUpdatePerform(long var1, int var3, int var4, int var5, int var6, int var7, int[] var8, boolean var9, Object var10);

    private native void jni_cc_firmwareUpdateActivation(long var1, int var3, int var4, int var5, int var6, int var7, int[] var8, Object var9);

    private native void jni_cc_firmwareUpdatePrepare(long var1, int var3, int var4, int var5, int var6, int var7, Object var8);

    private native void jni_cc_associationGroupInformationGetInfo(long var1, int var3, int var4, int var5, Object var6);

    private native void jni_cc_associationGroupInformationGetName(long var1, int var3, int var4, int var5, Object var6);

    private native void jni_cc_associationGroupInformationGetCommands(long var1, int var3, int var4, int var5, Object var6);

    private native void jni_cc_switchColorGet(long var1, int var3, int var4, int var5, Object var6);

    private native void jni_cc_switchColorSet(long var1, int var3, int var4, int var5, int var6, int var7, Object var8);

    private native void jni_cc_switchColorSetMultiple(long var1, int var3, int var4, int[] var5, int[] var6, int var7, Object var8);

    private native void jni_cc_switchColorStartStateChange(long var1, int var3, int var4, int var5, int var6, int var7, boolean var8, int var9, Object var10);

    private native void jni_cc_switchColorStopStateChange(long var1, int var3, int var4, int var5, Object var6);

    private native void jni_cc_soundSwitchTonePlayGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_soundSwitchTonePlaySet(long var1, int var3, int var4, int var5, int var6, Object var7);

    private native void jni_cc_soundSwitchConfigurationGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_soundSwitchConfigurationSet(long var1, int var3, int var4, int var5, int var6, Object var7);

    private native void jni_cc_barrierOperatorGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_barrierOperatorSet(long var1, int var3, int var4, int var5, Object var6);

    private native void jni_cc_barrierOperatorSignalGet(long var1, int var3, int var4, int var5, Object var6);

    private native void jni_cc_barrierOperatorSignalSet(long var1, int var3, int var4, int var5, int var6, Object var7);

    private native void jni_cc_simpleAvControlSet(long var1, int var3, int var4, int var5, int var6, Object var7);

    private native void jni_cc_securityInject(long var1, int var3, int var4, int[] var5, Object var6);

    private native void jni_cc_securityS2Inject(long var1, int var3, int var4, int[] var5, int var6, Object var7);

    private native void jni_cc_entryControlConfigurationGet(long var1, int var3, int var4, Object var5);

    private native void jni_cc_entryControlConfigurationSet(long var1, int var3, int var4, int var5, int var6, Object var7);

    public void getSerialApiCapabilities(Object callbackArg) {
        this.jni_fc_getSerialApiCapabilities(this.jzway, callbackArg);
    }

    public void getSerialApiCapabilities() {
        this.jni_fc_getSerialApiCapabilities(this.jzway, 0);
    }

    public void serialApiSetTimeouts(int ackTimeout, int byteTimeout, Object callbackArg) {
        this.jni_fc_serialApiSetTimeouts(this.jzway, ackTimeout, byteTimeout, callbackArg);
    }

    public void serialApiSetTimeouts(int ackTimeout, int byteTimeout) {
        this.jni_fc_serialApiSetTimeouts(this.jzway, ackTimeout, byteTimeout, 0);
    }

    public void serialApiGetInitData(Object callbackArg) {
        this.jni_fc_serialApiGetInitData(this.jzway, callbackArg);
    }

    public void serialApiGetInitData() {
        this.jni_fc_serialApiGetInitData(this.jzway, 0);
    }

    public void serialApiApplicationNodeInfo(boolean listening, boolean optional, boolean flirs1000, boolean flirs250, int generic_class, int specific_class, int[] nif, Object callbackArg) {
        this.jni_fc_serialApiApplicationNodeInfo(this.jzway, listening, optional, flirs1000, flirs250, generic_class, specific_class, nif, callbackArg);
    }

    public void serialApiApplicationNodeInfo(boolean listening, boolean optional, boolean flirs1000, boolean flirs250, int generic_class, int specific_class, int[] nif) {
        this.jni_fc_serialApiApplicationNodeInfo(this.jzway, listening, optional, flirs1000, flirs250, generic_class, specific_class, nif, 0);
    }

    public void watchdogStart(Object callbackArg) {
        this.jni_fc_watchdogStart(this.jzway, callbackArg);
    }

    public void watchdogStart() {
        this.jni_fc_watchdogStart(this.jzway, 0);
    }

    public void watchdogStop(Object callbackArg) {
        this.jni_fc_watchdogStop(this.jzway, callbackArg);
    }

    public void watchdogStop() {
        this.jni_fc_watchdogStop(this.jzway, 0);
    }

    public void getHomeId(Object callbackArg) {
        this.jni_fc_getHomeId(this.jzway, callbackArg);
    }

    public void getHomeId() {
        this.jni_fc_getHomeId(this.jzway, 0);
    }

    public void getControllerCapabilities(Object callbackArg) {
        this.jni_fc_getControllerCapabilities(this.jzway, callbackArg);
    }

    public void getControllerCapabilities() {
        this.jni_fc_getControllerCapabilities(this.jzway, 0);
    }

    public void getVersion(Object callbackArg) {
        this.jni_fc_getVersion(this.jzway, callbackArg);
    }

    public void getVersion() {
        this.jni_fc_getVersion(this.jzway, 0);
    }

    public void getSucNodeId(Object callbackArg) {
        this.jni_fc_getSucNodeId(this.jzway, callbackArg);
    }

    public void getSucNodeId() {
        this.jni_fc_getSucNodeId(this.jzway, 0);
    }

    public void enableSuc(boolean enable, boolean sis, Object callbackArg) {
        this.jni_fc_enableSuc(this.jzway, enable, sis, callbackArg);
    }

    public void enableSuc(boolean enable, boolean sis) {
        this.jni_fc_enableSuc(this.jzway, enable, sis, 0);
    }

    public void setSucNodeId(int node_id, boolean enable, boolean sis, Object callbackArg) {
        this.jni_fc_setSucNodeId(this.jzway, node_id, enable, sis, callbackArg);
    }

    public void setSucNodeId(int node_id, boolean enable, boolean sis) {
        this.jni_fc_setSucNodeId(this.jzway, node_id, enable, sis, 0);
    }

    public void memoryGetByte(int offset, Object callbackArg) {
        this.jni_fc_memoryGetByte(this.jzway, offset, callbackArg);
    }

    public void memoryGetByte(int offset) {
        this.jni_fc_memoryGetByte(this.jzway, offset, 0);
    }

    public void memoryGetBuffer(int offset, int length, Object callbackArg) {
        this.jni_fc_memoryGetBuffer(this.jzway, offset, length, callbackArg);
    }

    public void memoryGetBuffer(int offset, int length) {
        this.jni_fc_memoryGetBuffer(this.jzway, offset, length, 0);
    }

    public void memoryPutByte(int offset, int data, Object callbackArg) {
        this.jni_fc_memoryPutByte(this.jzway, offset, data, callbackArg);
    }

    public void memoryPutByte(int offset, int data) {
        this.jni_fc_memoryPutByte(this.jzway, offset, data, 0);
    }

    public void memoryPutBuffer(int offset, int[] data, Object callbackArg) {
        this.jni_fc_memoryPutBuffer(this.jzway, offset, data, callbackArg);
    }

    public void memoryPutBuffer(int offset, int[] data) {
        this.jni_fc_memoryPutBuffer(this.jzway, offset, data, 0);
    }

    public void nvmGetId(Object callbackArg) {
        this.jni_fc_nvmGetId(this.jzway, callbackArg);
    }

    public void nvmGetId() {
        this.jni_fc_nvmGetId(this.jzway, 0);
    }

    public void nvmExtReadLongByte(int offset, Object callbackArg) {
        this.jni_fc_nvmExtReadLongByte(this.jzway, offset, callbackArg);
    }

    public void nvmExtReadLongByte(int offset) {
        this.jni_fc_nvmExtReadLongByte(this.jzway, offset, 0);
    }

    public void nvmExtReadLongBuffer(int offset, int length, Object callbackArg) {
        this.jni_fc_nvmExtReadLongBuffer(this.jzway, offset, length, callbackArg);
    }

    public void nvmExtReadLongBuffer(int offset, int length) {
        this.jni_fc_nvmExtReadLongBuffer(this.jzway, offset, length, 0);
    }

    public void nvmExtWriteLongByte(int offset, int data, Object callbackArg) {
        this.jni_fc_nvmExtWriteLongByte(this.jzway, offset, data, callbackArg);
    }

    public void nvmExtWriteLongByte(int offset, int data) {
        this.jni_fc_nvmExtWriteLongByte(this.jzway, offset, data, 0);
    }

    public void nvmExtWriteLongBuffer(int offset, int[] data, Object callbackArg) {
        this.jni_fc_nvmExtWriteLongBuffer(this.jzway, offset, data, callbackArg);
    }

    public void nvmExtWriteLongBuffer(int offset, int[] data) {
        this.jni_fc_nvmExtWriteLongBuffer(this.jzway, offset, data, 0);
    }

    public void isFailedNode(int node_id, Object callbackArg) {
        this.jni_fc_isFailedNode(this.jzway, node_id, callbackArg);
    }

    public void isFailedNode(int node_id) {
        this.jni_fc_isFailedNode(this.jzway, node_id, 0);
    }

    public void sendDataAbort(Object callbackArg) {
        this.jni_fc_sendDataAbort(this.jzway, callbackArg);
    }

    public void sendDataAbort() {
        this.jni_fc_sendDataAbort(this.jzway, 0);
    }

    public void serialApiSoftReset(Object callbackArg) {
        this.jni_fc_serialApiSoftReset(this.jzway, callbackArg);
    }

    public void serialApiSoftReset() {
        this.jni_fc_serialApiSoftReset(this.jzway, 0);
    }

    public void sendData(int node_id, int[] data, String description, Object callbackArg) {
        this.jni_fc_sendData(this.jzway, node_id, data, description, callbackArg);
    }

    public void sendData(int node_id, int[] data, String description) {
        this.jni_fc_sendData(this.jzway, node_id, data, description, 0);
    }

    public void sendDataSecure(int node_id, int[] data, String description, int key_class, Object callbackArg) {
        this.jni_fc_sendDataSecure(this.jzway, node_id, data, description, key_class, callbackArg);
    }

    public void sendDataSecure(int node_id, int[] data, String description, int key_class) {
        this.jni_fc_sendDataSecure(this.jzway, node_id, data, description, key_class, 0);
    }

    public void getNodeProtocolInfo(int node_id, Object callbackArg) {
        this.jni_fc_getNodeProtocolInfo(this.jzway, node_id, callbackArg);
    }

    public void getNodeProtocolInfo(int node_id) {
        this.jni_fc_getNodeProtocolInfo(this.jzway, node_id, 0);
    }

    public void getRoutingTableLine(int node_id, boolean remove_bad, boolean remove_repeaters, Object callbackArg) {
        this.jni_fc_getRoutingTableLine(this.jzway, node_id, remove_bad, remove_repeaters, callbackArg);
    }

    public void getRoutingTableLine(int node_id, boolean remove_bad, boolean remove_repeaters) {
        this.jni_fc_getRoutingTableLine(this.jzway, node_id, remove_bad, remove_repeaters, 0);
    }

    public void assignReturnRoute(int node_id, int dest_id, Object callbackArg) {
        this.jni_fc_assignReturnRoute(this.jzway, node_id, dest_id, callbackArg);
    }

    public void assignReturnRoute(int node_id, int dest_id) {
        this.jni_fc_assignReturnRoute(this.jzway, node_id, dest_id, 0);
    }

    public void assignSucReturnRoute(int node_id, Object callbackArg) {
        this.jni_fc_assignSucReturnRoute(this.jzway, node_id, callbackArg);
    }

    public void assignSucReturnRoute(int node_id) {
        this.jni_fc_assignSucReturnRoute(this.jzway, node_id, 0);
    }

    public void deleteReturnRoute(int node_id, Object callbackArg) {
        this.jni_fc_deleteReturnRoute(this.jzway, node_id, callbackArg);
    }

    public void deleteReturnRoute(int node_id) {
        this.jni_fc_deleteReturnRoute(this.jzway, node_id, 0);
    }

    public void deleteSucReturnRoute(int node_id, Object callbackArg) {
        this.jni_fc_deleteSucReturnRoute(this.jzway, node_id, callbackArg);
    }

    public void deleteSucReturnRoute(int node_id) {
        this.jni_fc_deleteSucReturnRoute(this.jzway, node_id, 0);
    }

    public void setDefault(Object callbackArg) {
        this.jni_fc_setDefault(this.jzway, callbackArg);
    }

    public void setDefault() {
        this.jni_fc_setDefault(this.jzway, 0);
    }

    public void sendSucNodeId(int node_id, Object callbackArg) {
        this.jni_fc_sendSucNodeId(this.jzway, node_id, callbackArg);
    }

    public void sendSucNodeId(int node_id) {
        this.jni_fc_sendSucNodeId(this.jzway, node_id, 0);
    }

    public void sendNodeInformation(int node_id, Object callbackArg) {
        this.jni_fc_sendNodeInformation(this.jzway, node_id, callbackArg);
    }

    public void sendNodeInformation(int node_id) {
        this.jni_fc_sendNodeInformation(this.jzway, node_id, 0);
    }

    public void requestNodeInformation(int node_id, Object callbackArg) {
        this.jni_fc_requestNodeInformation(this.jzway, node_id, callbackArg);
    }

    public void requestNodeInformation(int node_id) {
        this.jni_fc_requestNodeInformation(this.jzway, node_id, 0);
    }

    public void removeFailedNode(int node_id, Object callbackArg) {
        this.jni_fc_removeFailedNode(this.jzway, node_id, callbackArg);
    }

    public void removeFailedNode(int node_id) {
        this.jni_fc_removeFailedNode(this.jzway, node_id, 0);
    }

    public void replaceFailedNode(int node_id, Object callbackArg) {
        this.jni_fc_replaceFailedNode(this.jzway, node_id, callbackArg);
    }

    public void replaceFailedNode(int node_id) {
        this.jni_fc_replaceFailedNode(this.jzway, node_id, 0);
    }

    public void requestNetworkUpdate(Object callbackArg) {
        this.jni_fc_requestNetworkUpdate(this.jzway, callbackArg);
    }

    public void requestNetworkUpdate() {
        this.jni_fc_requestNetworkUpdate(this.jzway, 0);
    }

    public void requestNodeNeighbourUpdate(int node_id, Object callbackArg) {
        this.jni_fc_requestNodeNeighbourUpdate(this.jzway, node_id, callbackArg);
    }

    public void requestNodeNeighbourUpdate(int node_id) {
        this.jni_fc_requestNodeNeighbourUpdate(this.jzway, node_id, 0);
    }

    public void setLearnMode(boolean startStop, Object callbackArg) {
        this.jni_fc_setLearnMode(this.jzway, startStop, callbackArg);
    }

    public void setLearnMode(boolean startStop) {
        this.jni_fc_setLearnMode(this.jzway, startStop, 0);
    }

    public void addNodeToNetwork(boolean startStop, boolean highPower, Object callbackArg) {
        this.jni_fc_addNodeToNetwork(this.jzway, startStop, highPower, callbackArg);
    }

    public void addNodeToNetwork(boolean startStop, boolean highPower) {
        this.jni_fc_addNodeToNetwork(this.jzway, startStop, highPower, 0);
    }

    public void smartStartEnable(Object callbackArg) {
        this.jni_fc_smartStartEnable(this.jzway, callbackArg);
    }

    public void smartStartEnable() {
        this.jni_fc_smartStartEnable(this.jzway, 0);
    }

    public void removeNodeFromNetwork(boolean startStop, boolean highPower, Object callbackArg) {
        this.jni_fc_removeNodeFromNetwork(this.jzway, startStop, highPower, callbackArg);
    }

    public void removeNodeFromNetwork(boolean startStop, boolean highPower) {
        this.jni_fc_removeNodeFromNetwork(this.jzway, startStop, highPower, 0);
    }

    public void removeNodeIdFromNetwork(int nodeId, boolean startStop, boolean highPower, Object callbackArg) {
        this.jni_fc_removeNodeIdFromNetwork(this.jzway, nodeId, startStop, highPower, callbackArg);
    }

    public void removeNodeIdFromNetwork(int nodeId, boolean startStop, boolean highPower) {
        this.jni_fc_removeNodeIdFromNetwork(this.jzway, nodeId, startStop, highPower, 0);
    }

    public void controllerChange(boolean startStop, boolean highPower, Object callbackArg) {
        this.jni_fc_controllerChange(this.jzway, startStop, highPower, callbackArg);
    }

    public void controllerChange(boolean startStop, boolean highPower) {
        this.jni_fc_controllerChange(this.jzway, startStop, highPower, 0);
    }

    public void createNewPrimary(boolean startStop, Object callbackArg) {
        this.jni_fc_createNewPrimary(this.jzway, startStop, callbackArg);
    }

    public void createNewPrimary(boolean startStop) {
        this.jni_fc_createNewPrimary(this.jzway, startStop, 0);
    }

    public void zmeFreqChange(int freq, Object callbackArg) {
        this.jni_fc_zmeFreqChange(this.jzway, freq, callbackArg);
    }

    public void zmeFreqChange(int freq) {
        this.jni_fc_zmeFreqChange(this.jzway, freq, 0);
    }

    public void rfPowerLevelSet(int level, Object callbackArg) {
        this.jni_fc_rfPowerLevelSet(this.jzway, level, callbackArg);
    }

    public void rfPowerLevelSet(int level) {
        this.jni_fc_rfPowerLevelSet(this.jzway, level, 0);
    }

    public void rfPowerLevelGet(Object callbackArg) {
        this.jni_fc_rfPowerLevelGet(this.jzway, callbackArg);
    }

    public void rfPowerLevelGet() {
        this.jni_fc_rfPowerLevelGet(this.jzway, 0);
    }

    public void sendTestFrame(int node_id, int level, Object callbackArg) {
        this.jni_fc_sendTestFrame(this.jzway, node_id, level, callbackArg);
    }

    public void sendTestFrame(int node_id, int level) {
        this.jni_fc_sendTestFrame(this.jzway, node_id, level, 0);
    }

    public void flashAutoProgSet(Object callbackArg) {
        this.jni_fc_flashAutoProgSet(this.jzway, callbackArg);
    }

    public void flashAutoProgSet() {
        this.jni_fc_flashAutoProgSet(this.jzway, 0);
    }

    public void exploreRequestInclusion(Object callbackArg) {
        this.jni_fc_exploreRequestInclusion(this.jzway, callbackArg);
    }

    public void exploreRequestInclusion() {
        this.jni_fc_exploreRequestInclusion(this.jzway, 0);
    }

    public void exploreRequestExclusion(Object callbackArg) {
        this.jni_fc_exploreRequestExclusion(this.jzway, callbackArg);
    }

    public void exploreRequestExclusion() {
        this.jni_fc_exploreRequestExclusion(this.jzway, 0);
    }

    public void zmeBootloaderFlash(int seg, Object callbackArg) {
        this.jni_fc_zmeBootloaderFlash(this.jzway, seg, callbackArg);
    }

    public void zmeBootloaderFlash(int seg) {
        this.jni_fc_zmeBootloaderFlash(this.jzway, seg, 0);
    }

    public void zmeBootloaderLoadFlash(int[] data, Object callbackArg) {
        this.jni_fc_zmeBootloaderLoadFlash(this.jzway, data, callbackArg);
    }

    public void zmeBootloaderLoadFlash(int[] data) {
        this.jni_fc_zmeBootloaderLoadFlash(this.jzway, data, 0);
    }

    public void zmeCapabilities(int[] data, Object callbackArg) {
        this.jni_fc_zmeCapabilities(this.jzway, data, callbackArg);
    }

    public void zmeCapabilities(int[] data) {
        this.jni_fc_zmeCapabilities(this.jzway, data, 0);
    }

    public void zmeLicenseSet(int[] data, Object callbackArg) {
        this.jni_fc_zmeLicenseSet(this.jzway, data, callbackArg);
    }

    public void zmeLicenseSet(int[] data) {
        this.jni_fc_zmeLicenseSet(this.jzway, data, 0);
    }

    public void applicationCommandHandlerInject(int node_id, int[] data, Object callbackArg) {
        this.jni_fc_applicationCommandHandlerInject(this.jzway, node_id, data, callbackArg);
    }

    public void applicationCommandHandlerInject(int node_id, int[] data) {
        this.jni_fc_applicationCommandHandlerInject(this.jzway, node_id, data, 0);
    }

    public void getBackgroundRssi(Object callbackArg) {
        this.jni_fc_getBackgroundRssi(this.jzway, callbackArg);
    }

    public void getBackgroundRssi() {
        this.jni_fc_getBackgroundRssi(this.jzway, 0);
    }

    public void serialApiSetupSetIma(boolean enable, Object callbackArg) {
        this.jni_fc_serialApiSetupSetIma(this.jzway, enable, callbackArg);
    }

    public void serialApiSetupSetIma(boolean enable) {
        this.jni_fc_serialApiSetupSetIma(this.jzway, enable, 0);
    }

    public void serialApiSetupSetTxPower(int power, Object callbackArg) {
        this.jni_fc_serialApiSetupSetTxPower(this.jzway, power, callbackArg);
    }

    public void serialApiSetupSetTxPower(int power) {
        this.jni_fc_serialApiSetupSetTxPower(this.jzway, power, 0);
    }

    public void clearNetworkStats(Object callbackArg) {
        this.jni_fc_clearNetworkStats(this.jzway, callbackArg);
    }

    public void clearNetworkStats() {
        this.jni_fc_clearNetworkStats(this.jzway, 0);
    }

    public void getNetworkStats(Object callbackArg) {
        this.jni_fc_getNetworkStats(this.jzway, callbackArg);
    }

    public void getNetworkStats() {
        this.jni_fc_getNetworkStats(this.jzway, 0);
    }

    public void getPriorityRoute(int node_id, Object callbackArg) {
        this.jni_fc_getPriorityRoute(this.jzway, node_id, callbackArg);
    }

    public void getPriorityRoute(int node_id) {
        this.jni_fc_getPriorityRoute(this.jzway, node_id, 0);
    }

    public void setPriorityRoute(int node_id, int repeater1, int repeater2, int repeater3, int repeater4, int route_speed, Object callbackArg) {
        this.jni_fc_setPriorityRoute(this.jzway, node_id, repeater1, repeater2, repeater3, repeater4, route_speed, callbackArg);
    }

    public void setPriorityRoute(int node_id, int repeater1, int repeater2, int repeater3, int repeater4, int route_speed) {
        this.jni_fc_setPriorityRoute(this.jzway, node_id, repeater1, repeater2, repeater3, repeater4, route_speed, 0);
    }

    public void setPromiscuousMode(boolean enable, Object callbackArg) {
        this.jni_fc_setPromiscuousMode(this.jzway, enable, callbackArg);
    }

    public void setPromiscuousMode(boolean enable) {
        this.jni_fc_setPromiscuousMode(this.jzway, enable, 0);
    }

    public void assignPriorityReturnRoute(int node_id, int dest_id, int repeater1, int repeater2, int repeater3, int repeater4, int route_speed, Object callbackArg) {
        this.jni_fc_assignPriorityReturnRoute(this.jzway, node_id, dest_id, repeater1, repeater2, repeater3, repeater4, route_speed, callbackArg);
    }

    public void assignPriorityReturnRoute(int node_id, int dest_id, int repeater1, int repeater2, int repeater3, int repeater4, int route_speed) {
        this.jni_fc_assignPriorityReturnRoute(this.jzway, node_id, dest_id, repeater1, repeater2, repeater3, repeater4, route_speed, 0);
    }

    public void assignPrioritySucReturnRoute(int node_id, int repeater1, int repeater2, int repeater3, int repeater4, int route_speed, Object callbackArg) {
        this.jni_fc_assignPrioritySucReturnRoute(this.jzway, node_id, repeater1, repeater2, repeater3, repeater4, route_speed, callbackArg);
    }

    public void assignPrioritySucReturnRoute(int node_id, int repeater1, int repeater2, int repeater3, int repeater4, int route_speed) {
        this.jni_fc_assignPrioritySucReturnRoute(this.jzway, node_id, repeater1, repeater2, repeater3, repeater4, route_speed, 0);
    }

    public void zmeSerialapiOptionsJammingDetectionSet(int ch1_threshold, int ch2_threshold, int ch3_threshold, Object callbackArg) {
        this.jni_fc_zmeSerialapiOptionsJammingDetectionSet(this.jzway, ch1_threshold, ch2_threshold, ch3_threshold, callbackArg);
    }

    public void zmeSerialapiOptionsJammingDetectionSet(int ch1_threshold, int ch2_threshold, int ch3_threshold) {
        this.jni_fc_zmeSerialapiOptionsJammingDetectionSet(this.jzway, ch1_threshold, ch2_threshold, ch3_threshold, 0);
    }

    public void zmeSerialapiOptionsAdvancedImaSet(boolean enable, Object callbackArg) {
        this.jni_fc_zmeSerialapiOptionsAdvancedImaSet(this.jzway, enable, callbackArg);
    }

    public void zmeSerialapiOptionsAdvancedImaSet(boolean enable) {
        this.jni_fc_zmeSerialapiOptionsAdvancedImaSet(this.jzway, enable, 0);
    }

    public void zmeSerialapiOptionsStaticApiSet(boolean enable, Object callbackArg) {
        this.jni_fc_zmeSerialapiOptionsStaticApiSet(this.jzway, enable, callbackArg);
    }

    public void zmeSerialapiOptionsStaticApiSet(boolean enable) {
        this.jni_fc_zmeSerialapiOptionsStaticApiSet(this.jzway, enable, 0);
    }

    public void zmeSerialapiOptionsUartSpeedSet(int speed, Object callbackArg) {
        this.jni_fc_zmeSerialapiOptionsUartSpeedSet(this.jzway, speed, callbackArg);
    }

    public void zmeSerialapiOptionsUartSpeedSet(int speed) {
        this.jni_fc_zmeSerialapiOptionsUartSpeedSet(this.jzway, speed, 0);
    }

    public void getLongRangeChannel(Object callbackArg) {
        this.jni_fc_getLongRangeChannel(this.jzway, callbackArg);
    }

    public void getLongRangeChannel() {
        this.jni_fc_getLongRangeChannel(this.jzway, 0);
    }

    public void setLongRangeChannel(int channel, Object callbackArg) {
        this.jni_fc_setLongRangeChannel(this.jzway, channel, callbackArg);
    }

    public void setLongRangeChannel(int channel) {
        this.jni_fc_setLongRangeChannel(this.jzway, channel, 0);
    }

    public void getLongRangeNodes(Object callbackArg) {
        this.jni_fc_getLongRangeNodes(this.jzway, callbackArg);
    }

    public void getLongRangeNodes() {
        this.jni_fc_getLongRangeNodes(this.jzway, 0);
    }

    static {
        System.loadLibrary("jzway");
        commandClassIdByName = new HashMap<String, Integer>();
        commandClassIdByName.put("basic", 32);
        commandClassIdByName.put("wakeup", 132);
        commandClassIdByName.put("noOperation", 0);
        commandClassIdByName.put("battery", 128);
        commandClassIdByName.put("manufacturerSpecific", 114);
        commandClassIdByName.put("proprietary", 136);
        commandClassIdByName.put("configuration", 112);
        commandClassIdByName.put("sensorBinary", 48);
        commandClassIdByName.put("association", 133);
        commandClassIdByName.put("meter", 50);
        commandClassIdByName.put("meterPulse", 53);
        commandClassIdByName.put("sensorMultilevel", 49);
        commandClassIdByName.put("sensorConfiguration", 158);
        commandClassIdByName.put("switchAll", 39);
        commandClassIdByName.put("switchBinary", 37);
        commandClassIdByName.put("switchMultilevel", 38);
        commandClassIdByName.put("multiChannelAssociation", 142);
        commandClassIdByName.put("multiChannel", 96);
        commandClassIdByName.put("nodeNaming", 119);
        commandClassIdByName.put("thermostatSetPoint", 67);
        commandClassIdByName.put("thermostatMode", 64);
        commandClassIdByName.put("thermostatFanMode", 68);
        commandClassIdByName.put("thermostatFanState", 69);
        commandClassIdByName.put("thermostatOperatingState", 66);
        commandClassIdByName.put("thermostatSetBack", 71);
        commandClassIdByName.put("alarmSensor", 156);
        commandClassIdByName.put("doorLock", 98);
        commandClassIdByName.put("doorLockLogging", 76);
        commandClassIdByName.put("userCode", 99);
        commandClassIdByName.put("time", 138);
        commandClassIdByName.put("timeParameters", 139);
        commandClassIdByName.put("clock", 129);
        commandClassIdByName.put("sceneActivation", 43);
        commandClassIdByName.put("sceneControllerConf", 45);
        commandClassIdByName.put("sceneActuatorConf", 44);
        commandClassIdByName.put("indicator", 135);
        commandClassIdByName.put("protection", 117);
        commandClassIdByName.put("scheduleEntryLock", 78);
        commandClassIdByName.put("climateControlSchedule", 70);
        commandClassIdByName.put("meterTableMonitor", 61);
        commandClassIdByName.put("alarm", 113);
        commandClassIdByName.put("powerLevel", 115);
        commandClassIdByName.put("zWavePlusInfo", 94);
        commandClassIdByName.put("firmwareUpdate", 122);
        commandClassIdByName.put("associationGroupInformation", 89);
        commandClassIdByName.put("switchColor", 51);
        commandClassIdByName.put("soundSwitch", 121);
        commandClassIdByName.put("barrierOperator", 102);
        commandClassIdByName.put("simpleAVControl", 148);
        commandClassIdByName.put("security", 152);
        commandClassIdByName.put("securityS2", 159);
        commandClassIdByName.put("entryControl", 111);
        commandClassIdByName.put("hail", 130);
        commandClassIdByName.put("cRC16", 86);
        commandClassIdByName.put("multiCmd", 143);
        commandClassIdByName.put("supervision", 108);
        commandClassIdByName.put("applicationStatus", 34);
        commandClassIdByName.put("version", 134);
        commandClassIdByName.put("deviceResetLocally", 90);
        commandClassIdByName.put("centralScene", 91);
        commandClassNameById = new HashMap<Integer, String>();
        commandClassNameById.put(32, "basic");
        commandClassNameById.put(132, "wakeup");
        commandClassNameById.put(0, "noOperation");
        commandClassNameById.put(128, "battery");
        commandClassNameById.put(114, "manufacturerSpecific");
        commandClassNameById.put(136, "proprietary");
        commandClassNameById.put(112, "configuration");
        commandClassNameById.put(48, "sensorBinary");
        commandClassNameById.put(133, "association");
        commandClassNameById.put(50, "meter");
        commandClassNameById.put(53, "meterPulse");
        commandClassNameById.put(49, "sensorMultilevel");
        commandClassNameById.put(158, "sensorConfiguration");
        commandClassNameById.put(39, "switchAll");
        commandClassNameById.put(37, "switchBinary");
        commandClassNameById.put(38, "switchMultilevel");
        commandClassNameById.put(142, "multiChannelAssociation");
        commandClassNameById.put(96, "multiChannel");
        commandClassNameById.put(119, "nodeNaming");
        commandClassNameById.put(67, "thermostatSetPoint");
        commandClassNameById.put(64, "thermostatMode");
        commandClassNameById.put(68, "thermostatFanMode");
        commandClassNameById.put(69, "thermostatFanState");
        commandClassNameById.put(66, "thermostatOperatingState");
        commandClassNameById.put(71, "thermostatSetBack");
        commandClassNameById.put(156, "alarmSensor");
        commandClassNameById.put(98, "doorLock");
        commandClassNameById.put(76, "doorLockLogging");
        commandClassNameById.put(99, "userCode");
        commandClassNameById.put(138, "time");
        commandClassNameById.put(139, "timeParameters");
        commandClassNameById.put(129, "clock");
        commandClassNameById.put(43, "sceneActivation");
        commandClassNameById.put(45, "sceneControllerConf");
        commandClassNameById.put(44, "sceneActuatorConf");
        commandClassNameById.put(135, "indicator");
        commandClassNameById.put(117, "protection");
        commandClassNameById.put(78, "scheduleEntryLock");
        commandClassNameById.put(70, "climateControlSchedule");
        commandClassNameById.put(61, "meterTableMonitor");
        commandClassNameById.put(113, "alarm");
        commandClassNameById.put(115, "powerLevel");
        commandClassNameById.put(94, "zWavePlusInfo");
        commandClassNameById.put(122, "firmwareUpdate");
        commandClassNameById.put(89, "associationGroupInformation");
        commandClassNameById.put(51, "switchColor");
        commandClassNameById.put(121, "soundSwitch");
        commandClassNameById.put(102, "barrierOperator");
        commandClassNameById.put(148, "simpleAVControl");
        commandClassNameById.put(152, "security");
        commandClassNameById.put(159, "securityS2");
        commandClassNameById.put(111, "entryControl");
        commandClassNameById.put(130, "hail");
        commandClassNameById.put(86, "cRC16");
        commandClassNameById.put(143, "multiCmd");
        commandClassNameById.put(108, "supervision");
        commandClassNameById.put(34, "applicationStatus");
        commandClassNameById.put(134, "version");
        commandClassNameById.put(90, "deviceResetLocally");
        commandClassNameById.put(91, "centralScene");
    }

    public final class Device {
        public final Integer id;
        public final Data data;
        public Map<Integer, Instance> instances;

        public Device(ZWay zway, Integer device_id) throws Exception {
            this.id = device_id;
            try {
                this.data = new Data("", device_id);
            }
            catch (Data.NotFound e) {
                throw new RuntimeException();
            }
            this.instances = new HashMap<Integer, Instance>();
        }

        public void deviceSendNOP(Integer nodeId, Object arg) {
            ZWay.this.jni_deviceSendNOP(ZWay.this.jzway, nodeId, arg);
        }

        public void deviceAwakeQueue(Integer nodeId) {
            ZWay.this.jni_deviceAwakeQueue(ZWay.this.jzway, nodeId);
        }

        public void deviceInterviewForce(Integer deviceId) {
            ZWay.this.jni_deviceInterviewForce(ZWay.this.jzway, deviceId);
        }

        public boolean deviceIsInterviewDone(Integer deviceId) {
            return ZWay.this.jni_deviceIsInterviewDone(ZWay.this.jzway, deviceId);
        }

        public void deviceDelayCommunication(Integer deviceId, Integer delay) {
            ZWay.this.jni_deviceDelayCommunication(ZWay.this.jzway, deviceId, delay);
        }

        public void deviceAssignReturnRoute(Integer deviceId, Integer nodeId) {
            ZWay.this.jni_deviceAssignReturnRoute(ZWay.this.jzway, deviceId, nodeId);
        }

        public void deviceAssignPriorityReturnRoute(Integer deviceId, Integer nodeId, Integer repeater1, Integer repeater2, Integer repeater3, Integer repeater4) {
            ZWay.this.jni_deviceAssignPriorityReturnRoute(ZWay.this.jzway, deviceId, nodeId, repeater1, repeater2, repeater3, repeater4);
        }

        public void deviceDeleteReturnRoute(Integer deviceId) {
            ZWay.this.jni_deviceDeleteReturnRoute(ZWay.this.jzway, deviceId);
        }

        public void deviceAssignSUCReturnRoute(Integer deviceId) {
            ZWay.this.jni_deviceAssignSUCReturnRoute(ZWay.this.jzway, deviceId);
        }

        public void deviceAssignPrioritySUCReturnRoute(Integer deviceId, Integer repeater1, Integer repeater2, Integer repeater3, Integer repeater4) {
            ZWay.this.jni_deviceAssignPrioritySUCReturnRoute(ZWay.this.jzway, deviceId, repeater1, repeater2, repeater3, repeater4);
        }

        public void deviceDeleteSUCReturnRoute(Integer deviceId) {
            ZWay.this.jni_deviceDeleteSUCReturnRoute(ZWay.this.jzway, deviceId);
        }

        public final class Instance {
            private final Device device;
            public final Integer id;
            public final Data data;
            public Map<Integer, CommandClass> commandClasses;
            public Map<String, CommandClass> commandClassesByName;

            public Instance(ZWay zway, Device dev, Integer instance_id) throws Exception {
                this.device = dev;
                this.id = instance_id;
                try {
                    this.data = new Data("", dev.id, instance_id);
                }
                catch (Data.NotFound e) {
                    throw new RuntimeException();
                }
                this.commandClasses = new HashMap<Integer, CommandClass>();
                this.commandClassesByName = new HashMap<String, CommandClass>();
            }

            public final class CentralScene
            extends CommandClass {
                public static final int id = 91;
                public final Data data;

                public CentralScene(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 91);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }
            }

            public final class DeviceResetLocally
            extends CommandClass {
                public static final int id = 90;
                public final Data data;

                public DeviceResetLocally(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 90);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }
            }

            public final class Version
            extends CommandClass {
                public static final int id = 134;
                public final Data data;

                public Version(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 134);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }
            }

            public final class ApplicationStatus
            extends CommandClass {
                public static final int id = 34;
                public final Data data;

                public ApplicationStatus(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 34);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }
            }

            public final class Supervision
            extends CommandClass {
                public static final int id = 108;
                public final Data data;

                public Supervision(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 108);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }
            }

            public final class MultiCmd
            extends CommandClass {
                public static final int id = 143;
                public final Data data;

                public MultiCmd(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 143);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }
            }

            public final class CRC16
            extends CommandClass {
                public static final int id = 86;
                public final Data data;

                public CRC16(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 86);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }
            }

            public final class Hail
            extends CommandClass {
                public static final int id = 130;
                public final Data data;

                public Hail(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 130);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }
            }

            public final class EntryControl
            extends CommandClass {
                public static final int id = 111;
                public final Data data;

                public EntryControl(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 111);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void configurationGet(Object callbackArg) {
                    ZWay.this.jni_cc_entryControlConfigurationGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void configurationGet() {
                    ZWay.this.jni_cc_entryControlConfigurationGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void configurationSet(int keyCacheSize, int keyCacheTimeout, Object callbackArg) {
                    ZWay.this.jni_cc_entryControlConfigurationSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, keyCacheSize, keyCacheTimeout, callbackArg);
                }

                public void configurationSet(int keyCacheSize, int keyCacheTimeout) {
                    ZWay.this.jni_cc_entryControlConfigurationSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, keyCacheSize, keyCacheTimeout, 0);
                }
            }

            public final class SecurityS2
            extends CommandClass {
                public static final int id = 159;
                public final Data data;

                public SecurityS2(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 159);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void inject(int[] data, int keyClass, Object callbackArg) {
                    ZWay.this.jni_cc_securityS2Inject(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, data, keyClass, callbackArg);
                }

                public void inject(int[] data, int keyClass) {
                    ZWay.this.jni_cc_securityS2Inject(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, data, keyClass, 0);
                }
            }

            public final class Security
            extends CommandClass {
                public static final int id = 152;
                public final Data data;

                public Security(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 152);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void inject(int[] data, Object callbackArg) {
                    ZWay.this.jni_cc_securityInject(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, data, callbackArg);
                }

                public void inject(int[] data) {
                    ZWay.this.jni_cc_securityInject(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, data, 0);
                }
            }

            public final class SimpleAVControl
            extends CommandClass {
                public static final int id = 148;
                public final Data data;

                public SimpleAVControl(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 148);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void simpleAvControlSet(int keyAttribute, int avCommand, Object callbackArg) {
                    ZWay.this.jni_cc_simpleAvControlSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, keyAttribute, avCommand, callbackArg);
                }

                public void simpleAvControlSet(int keyAttribute, int avCommand) {
                    ZWay.this.jni_cc_simpleAvControlSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, keyAttribute, avCommand, 0);
                }
            }

            public final class BarrierOperator
            extends CommandClass {
                public static final int id = 102;
                public final Data data;

                public BarrierOperator(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 102);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void get(Object callbackArg) {
                    ZWay.this.jni_cc_barrierOperatorGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void get() {
                    ZWay.this.jni_cc_barrierOperatorGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void set(int state, Object callbackArg) {
                    ZWay.this.jni_cc_barrierOperatorSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, state, callbackArg);
                }

                public void set(int state) {
                    ZWay.this.jni_cc_barrierOperatorSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, state, 0);
                }

                public void signalGet(int signalType, Object callbackArg) {
                    ZWay.this.jni_cc_barrierOperatorSignalGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, signalType, callbackArg);
                }

                public void signalGet(int signalType) {
                    ZWay.this.jni_cc_barrierOperatorSignalGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, signalType, 0);
                }

                public void signalSet(int signalType, int state, Object callbackArg) {
                    ZWay.this.jni_cc_barrierOperatorSignalSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, signalType, state, callbackArg);
                }

                public void signalSet(int signalType, int state) {
                    ZWay.this.jni_cc_barrierOperatorSignalSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, signalType, state, 0);
                }
            }

            public final class SoundSwitch
            extends CommandClass {
                public static final int id = 121;
                public final Data data;

                public SoundSwitch(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 121);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void tonePlayGet(Object callbackArg) {
                    ZWay.this.jni_cc_soundSwitchTonePlayGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void tonePlayGet() {
                    ZWay.this.jni_cc_soundSwitchTonePlayGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void tonePlaySet(int toneId, int volume, Object callbackArg) {
                    ZWay.this.jni_cc_soundSwitchTonePlaySet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, toneId, volume, callbackArg);
                }

                public void tonePlaySet(int toneId, int volume) {
                    ZWay.this.jni_cc_soundSwitchTonePlaySet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, toneId, volume, 0);
                }

                public void configurationGet(Object callbackArg) {
                    ZWay.this.jni_cc_soundSwitchConfigurationGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void configurationGet() {
                    ZWay.this.jni_cc_soundSwitchConfigurationGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void configurationSet(int toneId, int volume, Object callbackArg) {
                    ZWay.this.jni_cc_soundSwitchConfigurationSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, toneId, volume, callbackArg);
                }

                public void configurationSet(int toneId, int volume) {
                    ZWay.this.jni_cc_soundSwitchConfigurationSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, toneId, volume, 0);
                }
            }

            public final class SwitchColor
            extends CommandClass {
                public static final int id = 51;
                public final Data data;

                public SwitchColor(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 51);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void get(int capabilityId, Object callbackArg) {
                    ZWay.this.jni_cc_switchColorGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, capabilityId, callbackArg);
                }

                public void get(int capabilityId) {
                    ZWay.this.jni_cc_switchColorGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, capabilityId, 0);
                }

                public void set(int capabilityId, int state, int duration, Object callbackArg) {
                    ZWay.this.jni_cc_switchColorSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, capabilityId, state, duration, callbackArg);
                }

                public void set(int capabilityId, int state, int duration) {
                    ZWay.this.jni_cc_switchColorSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, capabilityId, state, duration, 0);
                }

                public void setMultiple(int[] capabilityIds, int[] states, int duration, Object callbackArg) {
                    ZWay.this.jni_cc_switchColorSetMultiple(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, capabilityIds, states, duration, callbackArg);
                }

                public void setMultiple(int[] capabilityIds, int[] states, int duration) {
                    ZWay.this.jni_cc_switchColorSetMultiple(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, capabilityIds, states, duration, 0);
                }

                public void startStateChange(int capabilityId, int dir, int duration, boolean ignoreStartLevel, int startLevel, Object callbackArg) {
                    ZWay.this.jni_cc_switchColorStartStateChange(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, capabilityId, dir, duration, ignoreStartLevel, startLevel, callbackArg);
                }

                public void startStateChange(int capabilityId, int dir, int duration, boolean ignoreStartLevel, int startLevel) {
                    ZWay.this.jni_cc_switchColorStartStateChange(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, capabilityId, dir, duration, ignoreStartLevel, startLevel, 0);
                }

                public void stopStateChange(int capabilityId, Object callbackArg) {
                    ZWay.this.jni_cc_switchColorStopStateChange(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, capabilityId, callbackArg);
                }

                public void stopStateChange(int capabilityId) {
                    ZWay.this.jni_cc_switchColorStopStateChange(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, capabilityId, 0);
                }
            }

            public final class AssociationGroupInformation
            extends CommandClass {
                public static final int id = 89;
                public final Data data;

                public AssociationGroupInformation(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 89);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void getInfo(int groupId, Object callbackArg) {
                    ZWay.this.jni_cc_associationGroupInformationGetInfo(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, groupId, callbackArg);
                }

                public void getInfo(int groupId) {
                    ZWay.this.jni_cc_associationGroupInformationGetInfo(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, groupId, 0);
                }

                public void getName(int groupId, Object callbackArg) {
                    ZWay.this.jni_cc_associationGroupInformationGetName(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, groupId, callbackArg);
                }

                public void getName(int groupId) {
                    ZWay.this.jni_cc_associationGroupInformationGetName(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, groupId, 0);
                }

                public void getCommands(int groupId, Object callbackArg) {
                    ZWay.this.jni_cc_associationGroupInformationGetCommands(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, groupId, callbackArg);
                }

                public void getCommands(int groupId) {
                    ZWay.this.jni_cc_associationGroupInformationGetCommands(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, groupId, 0);
                }
            }

            public final class FirmwareUpdate
            extends CommandClass {
                public static final int id = 122;
                public final Data data;

                public FirmwareUpdate(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 122);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void get(Object callbackArg) {
                    ZWay.this.jni_cc_firmwareUpdateGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void get() {
                    ZWay.this.jni_cc_firmwareUpdateGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void perform(int manufacturerId, int firmwareId, int firmwareTarget, int[] data, boolean delayActivation, Object callbackArg) {
                    ZWay.this.jni_cc_firmwareUpdatePerform(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, manufacturerId, firmwareId, firmwareTarget, data, delayActivation, callbackArg);
                }

                public void perform(int manufacturerId, int firmwareId, int firmwareTarget, int[] data, boolean delayActivation) {
                    ZWay.this.jni_cc_firmwareUpdatePerform(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, manufacturerId, firmwareId, firmwareTarget, data, delayActivation, 0);
                }

                public void activation(int manufacturerId, int firmwareId, int firmwareTarget, int[] data, Object callbackArg) {
                    ZWay.this.jni_cc_firmwareUpdateActivation(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, manufacturerId, firmwareId, firmwareTarget, data, callbackArg);
                }

                public void activation(int manufacturerId, int firmwareId, int firmwareTarget, int[] data) {
                    ZWay.this.jni_cc_firmwareUpdateActivation(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, manufacturerId, firmwareId, firmwareTarget, data, 0);
                }

                public void prepare(int manufacturerId, int firmwareId, int firmwareTarget, Object callbackArg) {
                    ZWay.this.jni_cc_firmwareUpdatePrepare(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, manufacturerId, firmwareId, firmwareTarget, callbackArg);
                }

                public void prepare(int manufacturerId, int firmwareId, int firmwareTarget) {
                    ZWay.this.jni_cc_firmwareUpdatePrepare(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, manufacturerId, firmwareId, firmwareTarget, 0);
                }
            }

            public final class ZWavePlusInfo
            extends CommandClass {
                public static final int id = 94;
                public final Data data;

                public ZWavePlusInfo(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 94);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void zwavePlusInfoGet(Object callbackArg) {
                    ZWay.this.jni_cc_zwavePlusInfoGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void zwavePlusInfoGet() {
                    ZWay.this.jni_cc_zwavePlusInfoGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }
            }

            public final class PowerLevel
            extends CommandClass {
                public static final int id = 115;
                public final Data data;

                public PowerLevel(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 115);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void get(Object callbackArg) {
                    ZWay.this.jni_cc_powerLevelGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void get() {
                    ZWay.this.jni_cc_powerLevelGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void set(int level, int timeout, Object callbackArg) {
                    ZWay.this.jni_cc_powerLevelSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, level, timeout, callbackArg);
                }

                public void set(int level, int timeout) {
                    ZWay.this.jni_cc_powerLevelSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, level, timeout, 0);
                }

                public void testNodeGet(Object callbackArg) {
                    ZWay.this.jni_cc_powerLevelTestNodeGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void testNodeGet() {
                    ZWay.this.jni_cc_powerLevelTestNodeGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void testNodeSet(int testNodeId, int level, int frameCount, Object callbackArg) {
                    ZWay.this.jni_cc_powerLevelTestNodeSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, testNodeId, level, frameCount, callbackArg);
                }

                public void testNodeSet(int testNodeId, int level, int frameCount) {
                    ZWay.this.jni_cc_powerLevelTestNodeSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, testNodeId, level, frameCount, 0);
                }
            }

            public final class Alarm
            extends CommandClass {
                public static final int id = 113;
                public final Data data;

                public Alarm(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 113);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void get(int type, int event, Object callbackArg) {
                    ZWay.this.jni_cc_alarmGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, type, event, callbackArg);
                }

                public void get(int type, int event) {
                    ZWay.this.jni_cc_alarmGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, type, event, 0);
                }

                public void set(int type, int level, Object callbackArg) {
                    ZWay.this.jni_cc_alarmSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, type, level, callbackArg);
                }

                public void set(int type, int level) {
                    ZWay.this.jni_cc_alarmSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, type, level, 0);
                }
            }

            public final class MeterTableMonitor
            extends CommandClass {
                public static final int id = 61;
                public final Data data;

                public MeterTableMonitor(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 61);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void statusDateGet(int maxResults, long startDate, long endDate, Object callbackArg) {
                    ZWay.this.jni_cc_meterTableMonitorStatusDateGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, maxResults, startDate, endDate, callbackArg);
                }

                public void statusDateGet(int maxResults, long startDate, long endDate) {
                    ZWay.this.jni_cc_meterTableMonitorStatusDateGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, maxResults, startDate, endDate, 0);
                }

                public void statusDepthGet(int maxResults, Object callbackArg) {
                    ZWay.this.jni_cc_meterTableMonitorStatusDepthGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, maxResults, callbackArg);
                }

                public void statusDepthGet(int maxResults) {
                    ZWay.this.jni_cc_meterTableMonitorStatusDepthGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, maxResults, 0);
                }

                public void currentDataGet(int setId, Object callbackArg) {
                    ZWay.this.jni_cc_meterTableMonitorCurrentDataGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, setId, callbackArg);
                }

                public void currentDataGet(int setId) {
                    ZWay.this.jni_cc_meterTableMonitorCurrentDataGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, setId, 0);
                }

                public void historicalDataGet(int setId, int maxResults, long startDate, long endDate, Object callbackArg) {
                    ZWay.this.jni_cc_meterTableMonitorHistoricalDataGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, setId, maxResults, startDate, endDate, callbackArg);
                }

                public void historicalDataGet(int setId, int maxResults, long startDate, long endDate) {
                    ZWay.this.jni_cc_meterTableMonitorHistoricalDataGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, setId, maxResults, startDate, endDate, 0);
                }
            }

            public final class ClimateControlSchedule
            extends CommandClass {
                public static final int id = 70;
                public final Data data;

                public ClimateControlSchedule(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 70);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void overrideGet(Object callbackArg) {
                    ZWay.this.jni_cc_climateControlScheduleOverrideGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void overrideGet() {
                    ZWay.this.jni_cc_climateControlScheduleOverrideGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void overrideSet(int overrideType, int overrideState, Object callbackArg) {
                    ZWay.this.jni_cc_climateControlScheduleOverrideSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, overrideType, overrideState, callbackArg);
                }

                public void overrideSet(int overrideType, int overrideState) {
                    ZWay.this.jni_cc_climateControlScheduleOverrideSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, overrideType, overrideState, 0);
                }
            }

            public final class ScheduleEntryLock
            extends CommandClass {
                public static final int id = 78;
                public final Data data;

                public ScheduleEntryLock(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 78);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void enable(int user, boolean enable, Object callbackArg) {
                    ZWay.this.jni_cc_scheduleEntryLockEnable(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, user, enable, callbackArg);
                }

                public void enable(int user, boolean enable) {
                    ZWay.this.jni_cc_scheduleEntryLockEnable(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, user, enable, 0);
                }

                public void weekdayGet(int user, int slot, Object callbackArg) {
                    ZWay.this.jni_cc_scheduleEntryLockWeekdayGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, user, slot, callbackArg);
                }

                public void weekdayGet(int user, int slot) {
                    ZWay.this.jni_cc_scheduleEntryLockWeekdayGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, user, slot, 0);
                }

                public void weekdaySet(boolean modifyErase, int user, int slot, int dayOfWeek, int startHour, int startMinute, int stopHour, int stopMinute, Object callbackArg) {
                    ZWay.this.jni_cc_scheduleEntryLockWeekdaySet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, modifyErase, user, slot, dayOfWeek, startHour, startMinute, stopHour, stopMinute, callbackArg);
                }

                public void weekdaySet(boolean modifyErase, int user, int slot, int dayOfWeek, int startHour, int startMinute, int stopHour, int stopMinute) {
                    ZWay.this.jni_cc_scheduleEntryLockWeekdaySet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, modifyErase, user, slot, dayOfWeek, startHour, startMinute, stopHour, stopMinute, 0);
                }

                public void yearGet(int user, int slot, Object callbackArg) {
                    ZWay.this.jni_cc_scheduleEntryLockYearGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, user, slot, callbackArg);
                }

                public void yearGet(int user, int slot) {
                    ZWay.this.jni_cc_scheduleEntryLockYearGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, user, slot, 0);
                }

                public void yearSet(boolean modifyErase, int user, int slot, int startYear, int startMonth, int startDay, int startHour, int startMinute, int stopYear, int stopMonth, int stopDay, int stopHour, int stopMinute, Object callbackArg) {
                    ZWay.this.jni_cc_scheduleEntryLockYearSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, modifyErase, user, slot, startYear, startMonth, startDay, startHour, startMinute, stopYear, stopMonth, stopDay, stopHour, stopMinute, callbackArg);
                }

                public void yearSet(boolean modifyErase, int user, int slot, int startYear, int startMonth, int startDay, int startHour, int startMinute, int stopYear, int stopMonth, int stopDay, int stopHour, int stopMinute) {
                    ZWay.this.jni_cc_scheduleEntryLockYearSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, modifyErase, user, slot, startYear, startMonth, startDay, startHour, startMinute, stopYear, stopMonth, stopDay, stopHour, stopMinute, 0);
                }
            }

            public final class Protection
            extends CommandClass {
                public static final int id = 117;
                public final Data data;

                public Protection(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 117);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void get(Object callbackArg) {
                    ZWay.this.jni_cc_protectionGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void get() {
                    ZWay.this.jni_cc_protectionGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void set(int state, int rfState, Object callbackArg) {
                    ZWay.this.jni_cc_protectionSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, state, rfState, callbackArg);
                }

                public void set(int state, int rfState) {
                    ZWay.this.jni_cc_protectionSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, state, rfState, 0);
                }

                public void exclusiveGet(Object callbackArg) {
                    ZWay.this.jni_cc_protectionExclusiveGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void exclusiveGet() {
                    ZWay.this.jni_cc_protectionExclusiveGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void exclusiveSet(int controlNodeId, Object callbackArg) {
                    ZWay.this.jni_cc_protectionExclusiveSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, controlNodeId, callbackArg);
                }

                public void exclusiveSet(int controlNodeId) {
                    ZWay.this.jni_cc_protectionExclusiveSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, controlNodeId, 0);
                }

                public void timeoutGet(Object callbackArg) {
                    ZWay.this.jni_cc_protectionTimeoutGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void timeoutGet() {
                    ZWay.this.jni_cc_protectionTimeoutGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void timeoutSet(int timeout, Object callbackArg) {
                    ZWay.this.jni_cc_protectionTimeoutSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, timeout, callbackArg);
                }

                public void timeoutSet(int timeout) {
                    ZWay.this.jni_cc_protectionTimeoutSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, timeout, 0);
                }
            }

            public final class Indicator
            extends CommandClass {
                public static final int id = 135;
                public final Data data;

                public Indicator(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 135);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void get(int indicator_id, Object callbackArg) {
                    ZWay.this.jni_cc_indicatorGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, indicator_id, callbackArg);
                }

                public void get(int indicator_id) {
                    ZWay.this.jni_cc_indicatorGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, indicator_id, 0);
                }

                public void set(int indicator_id, int property_id, int state, Object callbackArg) {
                    ZWay.this.jni_cc_indicatorSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, indicator_id, property_id, state, callbackArg);
                }

                public void set(int indicator_id, int property_id, int state) {
                    ZWay.this.jni_cc_indicatorSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, indicator_id, property_id, state, 0);
                }

                public void setMultiple(int indicator_id, int[] property_ids, int[] states, Object callbackArg) {
                    ZWay.this.jni_cc_indicatorSetMultiple(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, indicator_id, property_ids, states, callbackArg);
                }

                public void setMultiple(int indicator_id, int[] property_ids, int[] states) {
                    ZWay.this.jni_cc_indicatorSetMultiple(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, indicator_id, property_ids, states, 0);
                }

                public void identify(Object callbackArg) {
                    ZWay.this.jni_cc_indicatorIdentify(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void identify() {
                    ZWay.this.jni_cc_indicatorIdentify(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }
            }

            public final class SceneActuatorConf
            extends CommandClass {
                public static final int id = 44;
                public final Data data;

                public SceneActuatorConf(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 44);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void get(int scene, Object callbackArg) {
                    ZWay.this.jni_cc_sceneActuatorConfGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, scene, callbackArg);
                }

                public void get(int scene) {
                    ZWay.this.jni_cc_sceneActuatorConfGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, scene, 0);
                }

                public void set(int scene, int level, int dimming, boolean override, Object callbackArg) {
                    ZWay.this.jni_cc_sceneActuatorConfSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, scene, level, dimming, override, callbackArg);
                }

                public void set(int scene, int level, int dimming, boolean override) {
                    ZWay.this.jni_cc_sceneActuatorConfSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, scene, level, dimming, override, 0);
                }
            }

            public final class SceneControllerConf
            extends CommandClass {
                public static final int id = 45;
                public final Data data;

                public SceneControllerConf(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 45);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void get(int group, Object callbackArg) {
                    ZWay.this.jni_cc_sceneControllerConfGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, group, callbackArg);
                }

                public void get(int group) {
                    ZWay.this.jni_cc_sceneControllerConfGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, group, 0);
                }

                public void set(int group, int scene, int duration, Object callbackArg) {
                    ZWay.this.jni_cc_sceneControllerConfSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, group, scene, duration, callbackArg);
                }

                public void set(int group, int scene, int duration) {
                    ZWay.this.jni_cc_sceneControllerConfSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, group, scene, duration, 0);
                }
            }

            public final class SceneActivation
            extends CommandClass {
                public static final int id = 43;
                public final Data data;

                public SceneActivation(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 43);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void set(int sceneId, int dimmingDuration, Object callbackArg) {
                    ZWay.this.jni_cc_sceneActivationSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, sceneId, dimmingDuration, callbackArg);
                }

                public void set(int sceneId, int dimmingDuration) {
                    ZWay.this.jni_cc_sceneActivationSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, sceneId, dimmingDuration, 0);
                }
            }

            public final class Clock
            extends CommandClass {
                public static final int id = 129;
                public final Data data;

                public Clock(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 129);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void get(Object callbackArg) {
                    ZWay.this.jni_cc_clockGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void get() {
                    ZWay.this.jni_cc_clockGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void set(Object callbackArg) {
                    ZWay.this.jni_cc_clockSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void set() {
                    ZWay.this.jni_cc_clockSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }
            }

            public final class TimeParameters
            extends CommandClass {
                public static final int id = 139;
                public final Data data;

                public TimeParameters(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 139);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void get(Object callbackArg) {
                    ZWay.this.jni_cc_timeParametersGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void get() {
                    ZWay.this.jni_cc_timeParametersGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void set(Object callbackArg) {
                    ZWay.this.jni_cc_timeParametersSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void set() {
                    ZWay.this.jni_cc_timeParametersSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }
            }

            public final class Time
            extends CommandClass {
                public static final int id = 138;
                public final Data data;

                public Time(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 138);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void get(Object callbackArg) {
                    ZWay.this.jni_cc_timeTimeGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void get() {
                    ZWay.this.jni_cc_timeTimeGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void dateGet(Object callbackArg) {
                    ZWay.this.jni_cc_timeDateGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void dateGet() {
                    ZWay.this.jni_cc_timeDateGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void offsetGet(Object callbackArg) {
                    ZWay.this.jni_cc_timeOffsetGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void offsetGet() {
                    ZWay.this.jni_cc_timeOffsetGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }
            }

            public final class UserCode
            extends CommandClass {
                public static final int id = 99;
                public final Data data;

                public UserCode(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 99);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void get(int user, Object callbackArg) {
                    ZWay.this.jni_cc_userCodeGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, user, callbackArg);
                }

                public void get(int user) {
                    ZWay.this.jni_cc_userCodeGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, user, 0);
                }

                public void getAll(Object callbackArg) {
                    ZWay.this.jni_cc_userCodeGetAll(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void getAll() {
                    ZWay.this.jni_cc_userCodeGetAll(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void set(int user, String code, int status, Object callbackArg) {
                    ZWay.this.jni_cc_userCodeSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, user, code, status, callbackArg);
                }

                public void set(int user, String code, int status) {
                    ZWay.this.jni_cc_userCodeSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, user, code, status, 0);
                }

                public void setRaw(int user, int[] code, int status, Object callbackArg) {
                    ZWay.this.jni_cc_userCodeSetRaw(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, user, code, status, callbackArg);
                }

                public void setRaw(int user, int[] code, int status) {
                    ZWay.this.jni_cc_userCodeSetRaw(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, user, code, status, 0);
                }

                public void masterCodeGet(Object callbackArg) {
                    ZWay.this.jni_cc_userCodeMasterCodeGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void masterCodeGet() {
                    ZWay.this.jni_cc_userCodeMasterCodeGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void masterCodeSet(String code, Object callbackArg) {
                    ZWay.this.jni_cc_userCodeMasterCodeSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, code, callbackArg);
                }

                public void masterCodeSet(String code) {
                    ZWay.this.jni_cc_userCodeMasterCodeSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, code, 0);
                }

                public void masterCodeSetRaw(int[] code, Object callbackArg) {
                    ZWay.this.jni_cc_userCodeMasterCodeSetRaw(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, code, callbackArg);
                }

                public void masterCodeSetRaw(int[] code) {
                    ZWay.this.jni_cc_userCodeMasterCodeSetRaw(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, code, 0);
                }

                public void keypadModeGet(Object callbackArg) {
                    ZWay.this.jni_cc_userCodeKeypadModeGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void keypadModeGet() {
                    ZWay.this.jni_cc_userCodeKeypadModeGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void keypadModeSet(int mode, Object callbackArg) {
                    ZWay.this.jni_cc_userCodeKeypadModeSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, mode, callbackArg);
                }

                public void keypadModeSet(int mode) {
                    ZWay.this.jni_cc_userCodeKeypadModeSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, mode, 0);
                }

                public void checksumGet(Object callbackArg) {
                    ZWay.this.jni_cc_userCodeChecksumGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void checksumGet() {
                    ZWay.this.jni_cc_userCodeChecksumGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }
            }

            public final class DoorLockLogging
            extends CommandClass {
                public static final int id = 76;
                public final Data data;

                public DoorLockLogging(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 76);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void get(int record, Object callbackArg) {
                    ZWay.this.jni_cc_doorLockLoggingGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, record, callbackArg);
                }

                public void get(int record) {
                    ZWay.this.jni_cc_doorLockLoggingGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, record, 0);
                }
            }

            public final class DoorLock
            extends CommandClass {
                public static final int id = 98;
                public final Data data;

                public DoorLock(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 98);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void get(Object callbackArg) {
                    ZWay.this.jni_cc_doorLockGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void get() {
                    ZWay.this.jni_cc_doorLockGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void configurationGet(Object callbackArg) {
                    ZWay.this.jni_cc_doorLockConfigurationGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void configurationGet() {
                    ZWay.this.jni_cc_doorLockConfigurationGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void set(int mode, Object callbackArg) {
                    ZWay.this.jni_cc_doorLockSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, mode, callbackArg);
                }

                public void set(int mode) {
                    ZWay.this.jni_cc_doorLockSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, mode, 0);
                }

                public void configurationSet(int operationType, int outsideHandlesEnabled, int insideHandlesEnabled, int lockTimeout, int autolockTime, int holdReleaseTime, boolean twistAssist, boolean blockToBlock, Object callbackArg) {
                    ZWay.this.jni_cc_doorLockConfigurationSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, operationType, outsideHandlesEnabled, insideHandlesEnabled, lockTimeout, autolockTime, holdReleaseTime, twistAssist, blockToBlock, callbackArg);
                }

                public void configurationSet(int operationType, int outsideHandlesEnabled, int insideHandlesEnabled, int lockTimeout, int autolockTime, int holdReleaseTime, boolean twistAssist, boolean blockToBlock) {
                    ZWay.this.jni_cc_doorLockConfigurationSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, operationType, outsideHandlesEnabled, insideHandlesEnabled, lockTimeout, autolockTime, holdReleaseTime, twistAssist, blockToBlock, 0);
                }
            }

            public final class AlarmSensor
            extends CommandClass {
                public static final int id = 156;
                public final Data data;

                public AlarmSensor(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 156);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void supportedGet(Object callbackArg) {
                    ZWay.this.jni_cc_alarmSensorSupportedGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void supportedGet() {
                    ZWay.this.jni_cc_alarmSensorSupportedGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void get(int type, Object callbackArg) {
                    ZWay.this.jni_cc_alarmSensorGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, type, callbackArg);
                }

                public void get(int type) {
                    ZWay.this.jni_cc_alarmSensorGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, type, 0);
                }
            }

            public final class ThermostatSetBack
            extends CommandClass {
                public static final int id = 71;
                public final Data data;

                public ThermostatSetBack(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 71);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void thermostatSetbackGet(Object callbackArg) {
                    ZWay.this.jni_cc_thermostatSetbackGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void thermostatSetbackGet() {
                    ZWay.this.jni_cc_thermostatSetbackGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void thermostatSetbackSet(int overrideType, int state, float value, Object callbackArg) {
                    ZWay.this.jni_cc_thermostatSetbackSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, overrideType, state, value, callbackArg);
                }

                public void thermostatSetbackSet(int overrideType, int state, float value) {
                    ZWay.this.jni_cc_thermostatSetbackSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, overrideType, state, value, 0);
                }
            }

            public final class ThermostatOperatingState
            extends CommandClass {
                public static final int id = 66;
                public final Data data;

                public ThermostatOperatingState(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 66);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void get(Object callbackArg) {
                    ZWay.this.jni_cc_thermostatOperatingStateGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void get() {
                    ZWay.this.jni_cc_thermostatOperatingStateGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void loggingGet(int state, Object callbackArg) {
                    ZWay.this.jni_cc_thermostatOperatingStateLoggingGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, state, callbackArg);
                }

                public void loggingGet(int state) {
                    ZWay.this.jni_cc_thermostatOperatingStateLoggingGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, state, 0);
                }
            }

            public final class ThermostatFanState
            extends CommandClass {
                public static final int id = 69;
                public final Data data;

                public ThermostatFanState(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 69);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void get(Object callbackArg) {
                    ZWay.this.jni_cc_thermostatFanStateGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void get() {
                    ZWay.this.jni_cc_thermostatFanStateGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }
            }

            public final class ThermostatFanMode
            extends CommandClass {
                public static final int id = 68;
                public final Data data;

                public ThermostatFanMode(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 68);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void get(Object callbackArg) {
                    ZWay.this.jni_cc_thermostatFanModeGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void get() {
                    ZWay.this.jni_cc_thermostatFanModeGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void set(boolean on, int mode, Object callbackArg) {
                    ZWay.this.jni_cc_thermostatFanModeSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, on, mode, callbackArg);
                }

                public void set(boolean on, int mode) {
                    ZWay.this.jni_cc_thermostatFanModeSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, on, mode, 0);
                }
            }

            public final class ThermostatMode
            extends CommandClass {
                public static final int id = 64;
                public final Data data;

                public ThermostatMode(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 64);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void get(Object callbackArg) {
                    ZWay.this.jni_cc_thermostatModeGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void get() {
                    ZWay.this.jni_cc_thermostatModeGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void set(int mode, Object callbackArg) {
                    ZWay.this.jni_cc_thermostatModeSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, mode, callbackArg);
                }

                public void set(int mode) {
                    ZWay.this.jni_cc_thermostatModeSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, mode, 0);
                }

                public void setManufacturerSpecific(int[] manufacturerSpecifc, Object callbackArg) {
                    ZWay.this.jni_cc_thermostatModeSetManufacturerSpecific(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, manufacturerSpecifc, callbackArg);
                }

                public void setManufacturerSpecific(int[] manufacturerSpecifc) {
                    ZWay.this.jni_cc_thermostatModeSetManufacturerSpecific(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, manufacturerSpecifc, 0);
                }
            }

            public final class ThermostatSetPoint
            extends CommandClass {
                public static final int id = 67;
                public final Data data;

                public ThermostatSetPoint(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 67);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void thermostatSetpointGet(int mode, Object callbackArg) {
                    ZWay.this.jni_cc_thermostatSetpointGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, mode, callbackArg);
                }

                public void thermostatSetpointGet(int mode) {
                    ZWay.this.jni_cc_thermostatSetpointGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, mode, 0);
                }

                public void thermostatSetpointSet(int mode, float value, Object callbackArg) {
                    ZWay.this.jni_cc_thermostatSetpointSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, mode, value, callbackArg);
                }

                public void thermostatSetpointSet(int mode, float value) {
                    ZWay.this.jni_cc_thermostatSetpointSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, mode, value, 0);
                }
            }

            public final class NodeNaming
            extends CommandClass {
                public static final int id = 119;
                public final Data data;

                public NodeNaming(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 119);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void get(Object callbackArg) {
                    ZWay.this.jni_cc_nodeNamingGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void get() {
                    ZWay.this.jni_cc_nodeNamingGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void getName(Object callbackArg) {
                    ZWay.this.jni_cc_nodeNamingGetName(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void getName() {
                    ZWay.this.jni_cc_nodeNamingGetName(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void getLocation(Object callbackArg) {
                    ZWay.this.jni_cc_nodeNamingGetLocation(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void getLocation() {
                    ZWay.this.jni_cc_nodeNamingGetLocation(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void setName(String name, Object callbackArg) {
                    ZWay.this.jni_cc_nodeNamingSetName(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, name, callbackArg);
                }

                public void setName(String name) {
                    ZWay.this.jni_cc_nodeNamingSetName(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, name, 0);
                }

                public void setLocation(String location, Object callbackArg) {
                    ZWay.this.jni_cc_nodeNamingSetLocation(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, location, callbackArg);
                }

                public void setLocation(String location) {
                    ZWay.this.jni_cc_nodeNamingSetLocation(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, location, 0);
                }
            }

            public final class MultiChannel
            extends CommandClass {
                public static final int id = 96;
                public final Data data;

                public MultiChannel(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 96);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void multichannelGet(int cc_id, Object callbackArg) {
                    ZWay.this.jni_cc_multichannelGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, cc_id, callbackArg);
                }

                public void multichannelGet(int cc_id) {
                    ZWay.this.jni_cc_multichannelGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, cc_id, 0);
                }

                public void multichannelEndpointFind(int generic, int specific, Object callbackArg) {
                    ZWay.this.jni_cc_multichannelEndpointFind(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, generic, specific, callbackArg);
                }

                public void multichannelEndpointFind(int generic, int specific) {
                    ZWay.this.jni_cc_multichannelEndpointFind(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, generic, specific, 0);
                }

                public void multichannelEndpointGet(Object callbackArg) {
                    ZWay.this.jni_cc_multichannelEndpointGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void multichannelEndpointGet() {
                    ZWay.this.jni_cc_multichannelEndpointGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void multichannelCapabilitiesGet(int endpoint, Object callbackArg) {
                    ZWay.this.jni_cc_multichannelCapabilitiesGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, endpoint, callbackArg);
                }

                public void multichannelCapabilitiesGet(int endpoint) {
                    ZWay.this.jni_cc_multichannelCapabilitiesGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, endpoint, 0);
                }

                public void multichannelAggregatedMembersGet(int endpoint, Object callbackArg) {
                    ZWay.this.jni_cc_multichannelAggregatedMembersGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, endpoint, callbackArg);
                }

                public void multichannelAggregatedMembersGet(int endpoint) {
                    ZWay.this.jni_cc_multichannelAggregatedMembersGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, endpoint, 0);
                }
            }

            public final class MultiChannelAssociation
            extends CommandClass {
                public static final int id = 142;
                public final Data data;

                public MultiChannelAssociation(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 142);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void multichannelAssociationGet(int group_id, Object callbackArg) {
                    ZWay.this.jni_cc_multichannelAssociationGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, group_id, callbackArg);
                }

                public void multichannelAssociationGet(int group_id) {
                    ZWay.this.jni_cc_multichannelAssociationGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, group_id, 0);
                }

                public void multichannelAssociationSet(int group_id, int include_node, int include_instance, Object callbackArg) {
                    ZWay.this.jni_cc_multichannelAssociationSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, group_id, include_node, include_instance, callbackArg);
                }

                public void multichannelAssociationSet(int group_id, int include_node, int include_instance) {
                    ZWay.this.jni_cc_multichannelAssociationSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, group_id, include_node, include_instance, 0);
                }

                public void multichannelAssociationRemove(int group_id, int exclude_node, int exclude_instance, Object callbackArg) {
                    ZWay.this.jni_cc_multichannelAssociationRemove(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, group_id, exclude_node, exclude_instance, callbackArg);
                }

                public void multichannelAssociationRemove(int group_id, int exclude_node, int exclude_instance) {
                    ZWay.this.jni_cc_multichannelAssociationRemove(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, group_id, exclude_node, exclude_instance, 0);
                }

                public void multichannelAssociationGroupingsGet(Object callbackArg) {
                    ZWay.this.jni_cc_multichannelAssociationGroupingsGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void multichannelAssociationGroupingsGet() {
                    ZWay.this.jni_cc_multichannelAssociationGroupingsGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }
            }

            public final class SwitchMultilevel
            extends CommandClass {
                public static final int id = 38;
                public final Data data;

                public SwitchMultilevel(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 38);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void get(Object callbackArg) {
                    ZWay.this.jni_cc_switchMultilevelGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void get() {
                    ZWay.this.jni_cc_switchMultilevelGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void set(int level, int duration, Object callbackArg) {
                    ZWay.this.jni_cc_switchMultilevelSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, level, duration, callbackArg);
                }

                public void set(int level, int duration) {
                    ZWay.this.jni_cc_switchMultilevelSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, level, duration, 0);
                }

                public void startLevelChange(int dir, int duration, boolean ignoreStartLevel, int startLevel, int incdec, int step, Object callbackArg) {
                    ZWay.this.jni_cc_switchMultilevelStartLevelChange(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, dir, duration, ignoreStartLevel, startLevel, incdec, step, callbackArg);
                }

                public void startLevelChange(int dir, int duration, boolean ignoreStartLevel, int startLevel, int incdec, int step) {
                    ZWay.this.jni_cc_switchMultilevelStartLevelChange(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, dir, duration, ignoreStartLevel, startLevel, incdec, step, 0);
                }

                public void stopLevelChange(Object callbackArg) {
                    ZWay.this.jni_cc_switchMultilevelStopLevelChange(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void stopLevelChange() {
                    ZWay.this.jni_cc_switchMultilevelStopLevelChange(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }
            }

            public final class SwitchBinary
            extends CommandClass {
                public static final int id = 37;
                public final Data data;

                public SwitchBinary(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 37);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void get(Object callbackArg) {
                    ZWay.this.jni_cc_switchBinaryGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void get() {
                    ZWay.this.jni_cc_switchBinaryGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void set(boolean value, int duration, Object callbackArg) {
                    ZWay.this.jni_cc_switchBinarySet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, value, duration, callbackArg);
                }

                public void set(boolean value, int duration) {
                    ZWay.this.jni_cc_switchBinarySet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, value, duration, 0);
                }
            }

            public final class SwitchAll
            extends CommandClass {
                public static final int id = 39;
                public final Data data;

                public SwitchAll(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 39);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void get(Object callbackArg) {
                    ZWay.this.jni_cc_switchAllGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void get() {
                    ZWay.this.jni_cc_switchAllGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void set(int mode, Object callbackArg) {
                    ZWay.this.jni_cc_switchAllSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, mode, callbackArg);
                }

                public void set(int mode) {
                    ZWay.this.jni_cc_switchAllSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, mode, 0);
                }

                public void setOn(Object callbackArg) {
                    ZWay.this.jni_cc_switchAllSetOn(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void setOn() {
                    ZWay.this.jni_cc_switchAllSetOn(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void setOff(Object callbackArg) {
                    ZWay.this.jni_cc_switchAllSetOff(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void setOff() {
                    ZWay.this.jni_cc_switchAllSetOff(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }
            }

            public final class SensorConfiguration
            extends CommandClass {
                public static final int id = 158;
                public final Data data;

                public SensorConfiguration(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 158);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void get(Object callbackArg) {
                    ZWay.this.jni_cc_sensorConfigurationGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void get() {
                    ZWay.this.jni_cc_sensorConfigurationGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void set(int mode, float value, Object callbackArg) {
                    ZWay.this.jni_cc_sensorConfigurationSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, mode, value, callbackArg);
                }

                public void set(int mode, float value) {
                    ZWay.this.jni_cc_sensorConfigurationSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, mode, value, 0);
                }
            }

            public final class SensorMultilevel
            extends CommandClass {
                public static final int id = 49;
                public final Data data;

                public SensorMultilevel(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 49);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void get(int sensor_type, Object callbackArg) {
                    ZWay.this.jni_cc_sensorMultilevelGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, sensor_type, callbackArg);
                }

                public void get(int sensor_type) {
                    ZWay.this.jni_cc_sensorMultilevelGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, sensor_type, 0);
                }
            }

            public final class MeterPulse
            extends CommandClass {
                public static final int id = 53;
                public final Data data;

                public MeterPulse(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 53);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void get(Object callbackArg) {
                    ZWay.this.jni_cc_meterPulseGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void get() {
                    ZWay.this.jni_cc_meterPulseGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }
            }

            public final class Meter
            extends CommandClass {
                public static final int id = 50;
                public final Data data;

                public Meter(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 50);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void get(int scale, Object callbackArg) {
                    ZWay.this.jni_cc_meterGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, scale, callbackArg);
                }

                public void get(int scale) {
                    ZWay.this.jni_cc_meterGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, scale, 0);
                }

                public void reset(Object callbackArg) {
                    ZWay.this.jni_cc_meterReset(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void reset() {
                    ZWay.this.jni_cc_meterReset(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void supported(Object callbackArg) {
                    ZWay.this.jni_cc_meterSupported(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void supported() {
                    ZWay.this.jni_cc_meterSupported(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }
            }

            public final class Association
            extends CommandClass {
                public static final int id = 133;
                public final Data data;

                public Association(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 133);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void get(int group_id, Object callbackArg) {
                    ZWay.this.jni_cc_associationGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, group_id, callbackArg);
                }

                public void get(int group_id) {
                    ZWay.this.jni_cc_associationGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, group_id, 0);
                }

                public void set(int group_id, int include_node, Object callbackArg) {
                    ZWay.this.jni_cc_associationSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, group_id, include_node, callbackArg);
                }

                public void set(int group_id, int include_node) {
                    ZWay.this.jni_cc_associationSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, group_id, include_node, 0);
                }

                public void remove(int group_id, int exclude_node, Object callbackArg) {
                    ZWay.this.jni_cc_associationRemove(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, group_id, exclude_node, callbackArg);
                }

                public void remove(int group_id, int exclude_node) {
                    ZWay.this.jni_cc_associationRemove(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, group_id, exclude_node, 0);
                }

                public void groupingsGet(Object callbackArg) {
                    ZWay.this.jni_cc_associationGroupingsGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void groupingsGet() {
                    ZWay.this.jni_cc_associationGroupingsGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }
            }

            public final class SensorBinary
            extends CommandClass {
                public static final int id = 48;
                public final Data data;

                public SensorBinary(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 48);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void get(int sensorType, Object callbackArg) {
                    ZWay.this.jni_cc_sensorBinaryGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, sensorType, callbackArg);
                }

                public void get(int sensorType) {
                    ZWay.this.jni_cc_sensorBinaryGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, sensorType, 0);
                }
            }

            public final class Configuration
            extends CommandClass {
                public static final int id = 112;
                public final Data data;

                public Configuration(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 112);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void get(int parameter, Object callbackArg) {
                    ZWay.this.jni_cc_configurationGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, parameter, callbackArg);
                }

                public void get(int parameter) {
                    ZWay.this.jni_cc_configurationGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, parameter, 0);
                }

                public void set(int parameter, int value, int size, Object callbackArg) {
                    ZWay.this.jni_cc_configurationSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, parameter, value, size, callbackArg);
                }

                public void set(int parameter, int value, int size) {
                    ZWay.this.jni_cc_configurationSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, parameter, value, size, 0);
                }

                public void setDefault(int parameter, Object callbackArg) {
                    ZWay.this.jni_cc_configurationSetDefault(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, parameter, callbackArg);
                }

                public void setDefault(int parameter) {
                    ZWay.this.jni_cc_configurationSetDefault(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, parameter, 0);
                }

                public void defaultReset(Object callbackArg) {
                    ZWay.this.jni_cc_configurationDefaultReset(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void defaultReset() {
                    ZWay.this.jni_cc_configurationDefaultReset(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }
            }

            public final class Proprietary
            extends CommandClass {
                public static final int id = 136;
                public final Data data;

                public Proprietary(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 136);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void get(Object callbackArg) {
                    ZWay.this.jni_cc_proprietaryGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void get() {
                    ZWay.this.jni_cc_proprietaryGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void set(int[] data, Object callbackArg) {
                    ZWay.this.jni_cc_proprietarySet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, data, callbackArg);
                }

                public void set(int[] data) {
                    ZWay.this.jni_cc_proprietarySet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, data, 0);
                }
            }

            public final class ManufacturerSpecific
            extends CommandClass {
                public static final int id = 114;
                public final Data data;

                public ManufacturerSpecific(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 114);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void get(Object callbackArg) {
                    ZWay.this.jni_cc_manufacturerSpecificGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void get() {
                    ZWay.this.jni_cc_manufacturerSpecificGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void deviceIdGet(int type, Object callbackArg) {
                    ZWay.this.jni_cc_manufacturerSpecificDeviceIdGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, type, callbackArg);
                }

                public void deviceIdGet(int type) {
                    ZWay.this.jni_cc_manufacturerSpecificDeviceIdGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, type, 0);
                }
            }

            public final class Battery
            extends CommandClass {
                public static final int id = 128;
                public final Data data;

                public Battery(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 128);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void get(Object callbackArg) {
                    ZWay.this.jni_cc_batteryGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void get() {
                    ZWay.this.jni_cc_batteryGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }
            }

            public final class NoOperation
            extends CommandClass {
                public static final int id = 0;
                public final Data data;

                public NoOperation(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 0);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }
            }

            public final class Wakeup
            extends CommandClass {
                public static final int id = 132;
                public final Data data;

                public Wakeup(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 132);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void get(Object callbackArg) {
                    ZWay.this.jni_cc_wakeupGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void get() {
                    ZWay.this.jni_cc_wakeupGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void capabilitiesGet(Object callbackArg) {
                    ZWay.this.jni_cc_wakeupCapabilitiesGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void capabilitiesGet() {
                    ZWay.this.jni_cc_wakeupCapabilitiesGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void sleep(Object callbackArg) {
                    ZWay.this.jni_cc_wakeupSleep(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void sleep() {
                    ZWay.this.jni_cc_wakeupSleep(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void set(int interval, int notification_node_id, Object callbackArg) {
                    ZWay.this.jni_cc_wakeupSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, interval, notification_node_id, callbackArg);
                }

                public void set(int interval, int notification_node_id) {
                    ZWay.this.jni_cc_wakeupSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, interval, notification_node_id, 0);
                }
            }

            public final class Basic
            extends CommandClass {
                public static final int id = 32;
                public final Data data;

                public Basic(ZWay zway, Instance instance) throws Exception {
                    super(zway, instance);
                    try {
                        this.data = new Data("", ((Instance)instance).device.id, instance.id, 32);
                    }
                    catch (Data.NotFound e) {
                        throw new RuntimeException();
                    }
                }

                public void get(Object callbackArg) {
                    ZWay.this.jni_cc_basicGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, callbackArg);
                }

                public void get() {
                    ZWay.this.jni_cc_basicGet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, 0);
                }

                public void set(int value, Object callbackArg) {
                    ZWay.this.jni_cc_basicSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, value, callbackArg);
                }

                public void set(int value) {
                    ZWay.this.jni_cc_basicSet(ZWay.this.jzway, ((Instance)this.instance).device.id, this.instance.id, value, 0);
                }
            }

            public class CommandClass {
                protected final Instance instance;
                public final Data data = null;

                public CommandClass(ZWay zway, Instance inst) throws Exception {
                    this.instance = inst;
                }

                public void interview(int deviceId, int instanceId, int ccId) {
                    ZWay.this.jni_commmandInterview(ZWay.this.jzway, deviceId, instanceId, ccId);
                }
            }
        }
    }

    public final class Controller {
        public final Data data;

        public Controller() throws Exception {
            try {
                this.data = new Data("");
            }
            catch (Data.NotFound e) {
                throw new RuntimeException();
            }
        }

        public void addNodeToNetwork(boolean startStop) {
            ZWay.this.jni_addNodeToNetwork(ZWay.this.jzway, startStop);
        }

        public void removeNodeFromNetwork(boolean startStop) {
            ZWay.this.jni_removeNodeFromNetwork(ZWay.this.jzway, startStop);
        }

        public void change(boolean startStop) {
            ZWay.this.jni_controllerChange(ZWay.this.jzway, startStop);
        }

        public void getSUCNodeId() {
            ZWay.this.jni_fc_getSucNodeId(ZWay.this.jzway, 0);
        }

        public void setSUCNodeId(int nodeId) {
            ZWay.this.jni_setSUCNodeId(ZWay.this.jzway, nodeId);
        }

        public void setSISNodeId(int nodeId) {
            ZWay.this.jni_setSISNodeId(ZWay.this.jzway, nodeId);
        }

        public void disableSUCNodeId(int nodeId) {
            ZWay.this.jni_disableSUCNodeId(ZWay.this.jzway, nodeId);
        }

        public void sendNodeInformation(int nodeId) {
            ZWay.this.jni_fc_sendNodeInformation(ZWay.this.jzway, nodeId, 0);
        }

        public void setDefault() {
            ZWay.this.jni_setDefault(ZWay.this.jzway);
        }

        public void requestNetworkUpdate() {
            ZWay.this.jni_requestNetworkUpdate(ZWay.this.jzway);
        }

        public void setLearnMode(boolean startStop) {
            ZWay.this.jni_setLearnMode(ZWay.this.jzway, startStop);
        }

        public int[] backup() {
            return ZWay.this.jni_backup(ZWay.this.jzway);
        }

        public void restore(int[] data, boolean full) {
            ZWay.this.jni_restore(ZWay.this.jzway, data, full);
        }

        public void nodeProvisioningDSKAdd(int[] dsk) {
            ZWay.this.jni_nodeProvisioningDSKAdd(ZWay.this.jzway, dsk);
        }

        public void nodeProvisioningDSKRemove(int[] dsk) {
            ZWay.this.jni_nodeProvisioningDSKRemove(ZWay.this.jzway, dsk);
        }

        public void ZDDXSaveToXML() {
            ZWay.this.jni_ZDDXSaveToXML(ZWay.this.jzway);
        }
    }

    public final class Data {
        public static final int phantomUpdate = 64;
        public static final int childEvent = 128;
        public static final int updated = 1;
        public static final int invalidated = 2;
        public static final int deleted = 3;
        public static final int childCreated = 4;
        public static final int Empty = 0;
        public static final int Bool = 1;
        public static final int Int = 2;
        public static final int Float = 3;
        public static final int String = 4;
        public static final int Binary = 5;
        public static final int IntArray = 6;
        public static final int FloatArray = 7;
        public static final int StringArray = 8;
        private Object value;
        private Type valueType;
        private String valueTypeStr;
        private long dh;
        public final String name;
        public final String path;
        private long updateTime;
        private long invalidateTime;
        private Boolean isAlive;
        private Set<DataCallback> callbacks;

        public Data(String path, long dhParent) throws NotFound, Exception {
            this(this$0.jni_zdataFind(dhParent, path, this$0.jzway));
        }

        public Data(String path) throws NotFound, Exception {
            this(this$0.jni_zdataControllerFind(path, this$0.jzway));
        }

        public Data(String path, int deviceId) throws NotFound, Exception {
            this(this$0.jni_zdataDeviceFind(path, deviceId, this$0.jzway));
        }

        public Data(String path, int deviceId, int instanceId) throws NotFound, Exception {
            this(this$0.jni_zdataInstanceFind(path, deviceId, instanceId, this$0.jzway));
        }

        public Data(String path, int deviceId, int instanceId, int commandClassId) throws NotFound, Exception {
            this(this$0.jni_zdataCommandClassFind(path, deviceId, instanceId, commandClassId, this$0.jzway));
        }

        private Data(long dh) throws NotFound, Exception {
            if (dh == 0L) {
                throw new NotFound();
            }
            this.dh = dh;
            this.name = this.jni_zdataGetName(dh);
            this.path = this.jni_zdataGetPath(dh);
            this.isAlive = true;
            this.callbacks = new HashSet<DataCallback>();
            this.updateTime = this.jni_zdataGetUpdateTime(dh);
            this.invalidateTime = this.jni_zdataGetInvalidateTime(dh);
            this.jni_zdataAddCallback(dh);
            this.getValue();
        }

        public void finalize() {
            this.jni_zdataRemoveCallback(this.dh);
        }

        private void isAlive() throws NotAlive {
            if (!this.isAlive.booleanValue()) {
                throw new NotAlive(this);
            }
        }

        public void bind(DataCallback func) throws NotAlive, Exception {
            this.isAlive();
            this.callbacks.add(func);
        }

        public void unbind(DataCallback func) throws NotAlive, Exception {
            this.isAlive();
            this.callbacks.remove(func);
        }

        public long getUpdateTime() {
            return this.updateTime;
        }

        public long getInvalidateTime() {
            return this.invalidateTime;
        }

        private void dataCallback(int type) throws Exception {
            boolean isPhantom = (0x40 & type) > 0;
            boolean isChild = (0x80 & type) > 0;
            if ((type = type & 0xFFFFFFBF & 0xFFFFFF7F) == 1) {
                this.getValue();
            } else if (type == 2) {
                this.jni_zdataGetInvalidateTime(this.dh);
            } else if (type == 3) {
                this.isAlive = false;
            } else if (type != 4) {
                throw new Exception("Type of the event is an invalid integer.");
            }
            if (isPhantom) {
                this.jni_zdataGetUpdateTime(this.dh);
            }
            for (DataCallback dc : this.callbacks) {
                dc.dataCallback(this, type);
            }
        }

        private void getValue() throws Exception {
            int dataType = this.jni_zdataGetType(this.dh);
            if (dataType == 1) {
                this.valueType = Boolean.class;
                this.valueTypeStr = "Boolean";
                this.value = this.jni_zdataGetBoolean(this.dh);
            } else if (dataType == 2) {
                this.valueType = Integer.class;
                this.valueTypeStr = "Integer";
                this.value = this.jni_zdataGetInteger(this.dh);
            } else if (dataType == 3) {
                this.valueType = Float.class;
                this.valueTypeStr = "Float";
                this.value = java.lang.Float.valueOf(this.jni_zdataGetFloat(this.dh));
            } else if (dataType == 4) {
                this.valueType = String.class;
                this.valueTypeStr = "String";
                this.value = this.jni_zdataGetString(this.dh);
            } else if (dataType == 5) {
                this.valueType = Byte[].class;
                this.valueTypeStr = "Byte[]";
                int[] val = this.jni_zdataGetBinary(this.dh);
                this.value = Arrays.stream(val).boxed().toArray(Integer[]::new);
            } else if (dataType == 6) {
                this.valueType = Integer[].class;
                this.valueTypeStr = "Integer[]";
                int[] val = this.jni_zdataGetIntArray(this.dh);
                this.value = Arrays.stream(val).boxed().toArray(Integer[]::new);
            } else if (dataType == 7) {
                this.valueType = Float[].class;
                this.valueTypeStr = "Float[]";
                float[] val = this.jni_zdataGetFloatArray(this.dh);
                int len = val.length;
                Float[] newValue = new Float[len];
                for (int i = 0; i < len; ++i) {
                    newValue[i] = java.lang.Float.valueOf(val[i]);
                }
                this.value = newValue;
            } else if (dataType == 8) {
                this.valueType = String[].class;
                this.valueTypeStr = "String[]";
                this.value = this.jni_zdataGetStringArray(this.dh);
            } else if (dataType == 0) {
                this.valueType = Object.class;
                this.valueTypeStr = "Null";
                this.value = null;
            } else {
                throw new Exception("Type of the value in data holder is an invalid integer.");
            }
        }

        public Data[] getChildren() throws NotAlive, Exception {
            this.isAlive();
            long[] list = this.jni_zdataGetChildren(this.dh);
            int length = list.length;
            Data[] children = new Data[length];
            for (int i = 0; i < length; ++i) {
                try {
                    children[i] = new Data(list[i]);
                    continue;
                }
                catch (NotFound e) {
                    throw new RuntimeException();
                }
            }
            return children;
        }

        public Data get(String path) throws NotAlive, NotFound, Exception {
            this.isAlive();
            return new Data(path, this.dh);
        }

        public Type getValueType() throws NotAlive {
            this.isAlive();
            return this.valueType;
        }

        public String getValueTypeStr() throws NotAlive {
            this.isAlive();
            return this.valueTypeStr;
        }

        public void setBool(Boolean data) throws NotAlive {
            this.isAlive();
            this.jni_zdataSetBoolean(this.dh, data);
        }

        public void setInt(Integer data) throws NotAlive {
            this.isAlive();
            this.jni_zdataSetInteger(this.dh, data);
        }

        public void setFloat(Float data) throws NotAlive {
            this.isAlive();
            this.jni_zdataSetFloat(this.dh, data.floatValue());
        }

        public void setString(String data) throws NotAlive {
            this.isAlive();
            this.jni_zdataSetString(this.dh, data);
        }

        public void setByteList(Integer[] data) throws NotAlive {
            this.isAlive();
            int size = data.length;
            int[] rdata = new int[size];
            for (int i = 0; i < size; ++i) {
                rdata[i] = data[i];
            }
            this.jni_zdataSetBinary(this.dh, rdata);
        }

        public void setIntList(Integer[] data) throws NotAlive {
            this.isAlive();
            int size = data.length;
            int[] rdata = new int[size];
            for (int i = 0; i < size; ++i) {
                rdata[i] = data[i];
            }
            this.jni_zdataSetIntArray(this.dh, rdata);
        }

        public void setFloatList(Float[] data) throws NotAlive {
            this.isAlive();
            int size = data.length;
            float[] rdata = new float[size];
            for (int i = 0; i < size; ++i) {
                rdata[i] = data[i].floatValue();
            }
            this.jni_zdataSetFloatArray(this.dh, rdata);
        }

        public void setStringList(String[] data) throws NotAlive {
            this.isAlive();
            this.jni_zdataSetStringArray(this.dh, data);
        }

        public void setEmpty() throws NotAlive {
            this.isAlive();
            this.jni_zdataSetEmpty(this.dh);
        }

        public Boolean getBool() throws NotAlive {
            this.isAlive();
            if (this.valueType == Boolean.class && this.valueTypeStr.equals("Boolean")) {
                return (Boolean)this.value;
            }
            throw new ClassCastException("Illegal call: value is not Boolean");
        }

        public Integer getInt() throws NotAlive {
            this.isAlive();
            if (this.valueType == Integer.class && this.valueTypeStr.equals("Integer")) {
                return (Integer)this.value;
            }
            throw new ClassCastException("Illegal call: value is not Integer");
        }

        public Float getFloat() throws NotAlive {
            this.isAlive();
            if (this.valueType == Float.class && this.valueTypeStr.equals("Float")) {
                return (Float)this.value;
            }
            throw new ClassCastException("Illegal call: value is not Float");
        }

        public String getString() throws NotAlive {
            this.isAlive();
            if (this.valueType == String.class && this.valueTypeStr.equals("String")) {
                return (String)this.value;
            }
            throw new ClassCastException("Illegal call: value is not String");
        }

        public Integer[] getByteList() throws NotAlive {
            this.isAlive();
            if (this.valueType == Byte[].class && this.valueTypeStr.equals("Byte[]")) {
                return (Integer[])this.value;
            }
            throw new ClassCastException("Illegal call: value is not Integer[]");
        }

        public Integer[] getIntList() throws NotAlive {
            this.isAlive();
            if (this.valueType == Integer[].class && this.valueTypeStr.equals("Integer[]")) {
                return (Integer[])this.value;
            }
            throw new ClassCastException("Illegal call: value is not Integer[]");
        }

        public Float[] getFloatList() throws NotAlive {
            this.isAlive();
            if (this.valueType == Float[].class && this.valueTypeStr.equals("Float[]")) {
                return (Float[])this.value;
            }
            throw new ClassCastException("Illegal call: value is not Float[]");
        }

        public String[] getStringList() throws NotAlive {
            this.isAlive();
            if (this.valueType == String[].class && this.valueTypeStr.equals("String[]")) {
                return (String[])this.value;
            }
            throw new ClassCastException("Illegal call: value is not String[]");
        }

        private native void jni_zdataAddCallback(long var1);

        private native void jni_zdataRemoveCallback(long var1);

        private native String jni_zdataGetName(long var1);

        private native int jni_zdataGetType(long var1);

        private native boolean jni_zdataGetBoolean(long var1);

        private native int jni_zdataGetInteger(long var1);

        private native float jni_zdataGetFloat(long var1);

        private native String jni_zdataGetString(long var1);

        private native int[] jni_zdataGetBinary(long var1);

        private native int[] jni_zdataGetIntArray(long var1);

        private native float[] jni_zdataGetFloatArray(long var1);

        private native String[] jni_zdataGetStringArray(long var1);

        private native void jni_zdataSetEmpty(long var1);

        private native void jni_zdataSetBoolean(long var1, boolean var3);

        private native void jni_zdataSetInteger(long var1, int var3);

        private native void jni_zdataSetFloat(long var1, float var3);

        private native void jni_zdataSetString(long var1, String var3);

        private native void jni_zdataSetBinary(long var1, int[] var3);

        private native void jni_zdataSetIntArray(long var1, int[] var3);

        private native void jni_zdataSetFloatArray(long var1, float[] var3);

        private native void jni_zdataSetStringArray(long var1, String[] var3);

        private native long[] jni_zdataGetChildren(long var1);

        private native String jni_zdataGetPath(long var1);

        private native long jni_zdataGetUpdateTime(long var1);

        private native long jni_zdataGetInvalidateTime(long var1);

        public final class NotFound
        extends Throwable {
        }

        public final class NotAlive
        extends Throwable {
            public final Data data;

            public NotAlive(Data data) {
                this.data = data;
            }
        }
    }

    public static interface TerminateCallback {
        public void terminateCallback();
    }

    public static interface StatusCallback {
        public void statusCallback(boolean var1, Object var2);
    }

    public static interface DeviceCallback {
        public void deviceCallback(Integer var1, Integer var2, Integer var3, Integer var4);
    }

    public static interface DataCallback {
        public void dataCallback(Data var1, Integer var2);
    }
}

