/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.crs.common;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import mil.nga.crs.common.AxisDirectionType;
import mil.nga.crs.common.Identifiable;
import mil.nga.crs.common.Identifier;
import mil.nga.crs.common.Unit;
import mil.nga.crs.wkt.CRSWriter;

public class Axis
implements Identifiable {
    private static final Logger logger = Logger.getLogger(Axis.class.getName());
    private String name = null;
    private String abbreviation = null;
    private AxisDirectionType direction = null;
    private Double meridian = null;
    private Unit meridianUnit = null;
    private Double bearing = null;
    private Integer order = null;
    private Unit unit = null;
    private List<Identifier> identifiers = null;

    public Axis() {
    }

    public Axis(String name, AxisDirectionType direction) {
        this.setName(name);
        this.setDirection(direction);
    }

    public String getName() {
        return this.name;
    }

    public boolean hasName() {
        return this.getName() != null;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public boolean hasAbbreviation() {
        return this.getAbbreviation() != null;
    }

    public void setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    public AxisDirectionType getDirection() {
        return this.direction;
    }

    public void setDirection(AxisDirectionType direction) {
        this.direction = direction;
    }

    public Double getMeridian() {
        return this.meridian;
    }

    public boolean hasMeridian() {
        return this.getMeridian() != null;
    }

    public void setMeridian(Double meridian) {
        this.meridian = meridian;
    }

    public Unit getMeridianUnit() {
        return this.meridianUnit;
    }

    public void setMeridianUnit(Unit meridianUnit) {
        this.meridianUnit = meridianUnit;
    }

    public Double getBearing() {
        return this.bearing;
    }

    public boolean hasBearing() {
        return this.getBearing() != null;
    }

    public void setBearing(Double bearing) {
        this.bearing = bearing;
    }

    public Integer getOrder() {
        return this.order;
    }

    public boolean hasOrder() {
        return this.getOrder() != null;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public boolean hasUnit() {
        return this.getUnit() != null;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return this.identifiers;
    }

    @Override
    public boolean hasIdentifiers() {
        return this.identifiers != null && !this.identifiers.isEmpty();
    }

    @Override
    public int numIdentifiers() {
        return this.identifiers != null ? this.identifiers.size() : 0;
    }

    @Override
    public Identifier getIdentifier(int index) {
        return this.identifiers.get(index);
    }

    @Override
    public void setIdentifiers(List<Identifier> identifiers) {
        this.identifiers = identifiers;
    }

    @Override
    public void addIdentifier(Identifier identifier) {
        if (this.identifiers == null) {
            this.identifiers = new ArrayList<Identifier>();
        }
        this.identifiers.add(identifier);
    }

    @Override
    public void addIdentifiers(List<Identifier> identifiers) {
        if (this.identifiers == null) {
            this.identifiers = new ArrayList<Identifier>();
        }
        this.identifiers.addAll(identifiers);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.abbreviation == null ? 0 : this.abbreviation.hashCode());
        result = 31 * result + (this.bearing == null ? 0 : this.bearing.hashCode());
        result = 31 * result + (this.direction == null ? 0 : this.direction.hashCode());
        result = 31 * result + (this.identifiers == null ? 0 : this.identifiers.hashCode());
        result = 31 * result + (this.meridian == null ? 0 : this.meridian.hashCode());
        result = 31 * result + (this.meridianUnit == null ? 0 : this.meridianUnit.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.order == null ? 0 : this.order.hashCode());
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Axis other = (Axis)obj;
        if (this.abbreviation == null ? other.abbreviation != null : !this.abbreviation.equals(other.abbreviation)) {
            return false;
        }
        if (this.bearing == null ? other.bearing != null : !this.bearing.equals(other.bearing)) {
            return false;
        }
        if (this.direction != other.direction) {
            return false;
        }
        if (this.identifiers == null ? other.identifiers != null : !this.identifiers.equals(other.identifiers)) {
            return false;
        }
        if (this.meridian == null ? other.meridian != null : !this.meridian.equals(other.meridian)) {
            return false;
        }
        if (this.meridianUnit == null ? other.meridianUnit != null : !this.meridianUnit.equals(other.meridianUnit)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.order == null ? other.order != null : !this.order.equals(other.order)) {
            return false;
        }
        return !(this.unit == null ? other.unit != null : !this.unit.equals(other.unit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String value = null;
        try (CRSWriter writer = new CRSWriter();){
            writer.write(this);
            value = writer.toString();
        }
        return value;
    }
}

