/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.crs.common;

import mil.nga.crs.CRSException;

public class DateTime {
    public static final String HYPHEN = "-";
    public static final String TIME_DESIGNATOR = "T";
    public static final String COLON = ":";
    public static final String PERIOD = ".";
    public static final String UTC = "Z";
    public static final String PLUS_SIGN = "+";
    public static final String MINUS_SIGN = "-";
    private int year;
    private Integer month = null;
    private Integer day = null;
    private Integer hour = null;
    private Integer minute = null;
    private Integer second = null;
    private Double fraction = null;
    private Integer timeZoneHour = null;
    private Integer timeZoneMinute = null;

    public static DateTime parse(String text) {
        DateTime dateTime = null;
        if (text != null && text.length() >= 4) {
            String[] dateParts;
            int numDateParts;
            String[] dateTimeParts = text.split(TIME_DESIGNATOR);
            String date = null;
            int numDateTimeParts = dateTimeParts.length;
            if (numDateTimeParts == 1 || numDateTimeParts == 2) {
                date = dateTimeParts[0];
            }
            if (date != null && (numDateParts = (dateParts = date.split("-")).length) >= 1 && numDateParts <= 3) {
                dateTime = new DateTime();
                dateTime.setYear(Integer.parseInt(dateParts[0]));
                if (numDateParts > 1) {
                    int datePartTwo = Integer.parseInt(dateParts[1]);
                    if (numDateParts == 2) {
                        if (dateParts[1].length() == 2) {
                            dateTime.setMonth(datePartTwo);
                        } else {
                            dateTime.setDay(datePartTwo);
                        }
                    } else {
                        dateTime.setMonth(datePartTwo);
                        dateTime.setDay(Integer.parseInt(dateParts[2]));
                    }
                }
            }
            if (dateTime != null && numDateTimeParts == 2) {
                String timeWithZone = dateTimeParts[1];
                int zoneIndex = timeWithZone.indexOf(UTC);
                if (zoneIndex == -1 && (zoneIndex = timeWithZone.indexOf(PLUS_SIGN)) == -1) {
                    zoneIndex = timeWithZone.indexOf("-");
                }
                if (zoneIndex != -1) {
                    String time;
                    String[] timeParts;
                    int numTimeParts;
                    String timeZone = timeWithZone.substring(zoneIndex);
                    if (!timeZone.equals(UTC)) {
                        String[] timeZoneParts = timeZone.split(COLON);
                        dateTime.setTimeZoneHour(Integer.parseInt(timeZoneParts[0]));
                        if (timeZoneParts.length == 2) {
                            dateTime.setTimeZoneMinute(Integer.parseInt(timeZoneParts[1]));
                        }
                    }
                    if ((numTimeParts = (timeParts = (time = timeWithZone.substring(0, zoneIndex)).split(COLON)).length) >= 1 && numTimeParts <= 3) {
                        dateTime.setHour(Integer.parseInt(timeParts[0]));
                        if (numTimeParts > 1) {
                            dateTime.setMinute(Integer.parseInt(timeParts[1]));
                            if (numTimeParts > 2) {
                                String seconds = timeParts[2];
                                int decimalIndex = seconds.indexOf(PERIOD);
                                if (decimalIndex > -1) {
                                    String fraction = "0." + seconds.substring(decimalIndex + 1);
                                    dateTime.setFraction(Double.parseDouble(fraction));
                                    seconds = seconds.substring(0, decimalIndex);
                                }
                                dateTime.setSecond(Integer.parseInt(seconds));
                            }
                        }
                    }
                }
                if (!dateTime.hasHour()) {
                    dateTime = null;
                }
            }
        }
        if (dateTime == null) {
            throw new CRSException("Invalid Date and Time value: " + text);
        }
        return dateTime;
    }

    public static DateTime tryParse(String text) {
        DateTime dateTime = null;
        try {
            dateTime = DateTime.parse(text);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dateTime;
    }

    public DateTime() {
    }

    public DateTime(int year) {
        this.setYear(year);
    }

    public boolean isOrdinal() {
        return this.day != null && this.month == null;
    }

    public boolean hasTime() {
        return this.hasHour();
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public Integer getMonth() {
        return this.month;
    }

    public boolean hasMonth() {
        return this.getMonth() != null;
    }

    public void setMonth(Integer month) {
        this.month = month;
    }

    public Integer getDay() {
        return this.day;
    }

    public boolean hasDay() {
        return this.getDay() != null;
    }

    public void setDay(Integer day) {
        this.day = day;
    }

    public Integer getHour() {
        return this.hour;
    }

    public boolean hasHour() {
        return this.getHour() != null;
    }

    public void setHour(Integer hour) {
        this.hour = hour;
    }

    public Integer getMinute() {
        return this.minute;
    }

    public boolean hasMinute() {
        return this.getMinute() != null;
    }

    public void setMinute(Integer minute) {
        this.minute = minute;
    }

    public Integer getSecond() {
        return this.second;
    }

    public boolean hasSecond() {
        return this.getSecond() != null;
    }

    public void setSecond(Integer second) {
        this.second = second;
    }

    public Double getFraction() {
        return this.fraction;
    }

    public boolean hasFraction() {
        return this.getFraction() != null;
    }

    public void setFraction(Double fraction) {
        if (fraction != null && (fraction < 0.0 || fraction >= 1.0)) {
            throw new CRSException("Invalid fraction value: " + fraction);
        }
        this.fraction = fraction;
    }

    public Integer getTimeZoneHour() {
        return this.timeZoneHour;
    }

    public boolean hasTimeZoneHour() {
        return this.getTimeZoneHour() != null;
    }

    public void setTimeZoneHour(Integer timeZoneHour) {
        this.timeZoneHour = timeZoneHour;
    }

    public Integer getTimeZoneMinute() {
        return this.timeZoneMinute;
    }

    public boolean hasTimeZoneMinute() {
        return this.getTimeZoneMinute() != null;
    }

    public void setTimeZoneMinute(Integer timeZoneMinute) {
        this.timeZoneMinute = timeZoneMinute;
    }

    public boolean isTimeZoneUTC() {
        return !this.hasTimeZoneHour();
    }

    public void setTimeZoneUTC() {
        this.setTimeZoneHour(null);
        this.setTimeZoneMinute(null);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.day == null ? 0 : this.day.hashCode());
        result = 31 * result + (this.fraction == null ? 0 : this.fraction.hashCode());
        result = 31 * result + (this.hour == null ? 0 : this.hour.hashCode());
        result = 31 * result + (this.minute == null ? 0 : this.minute.hashCode());
        result = 31 * result + (this.month == null ? 0 : this.month.hashCode());
        result = 31 * result + (this.second == null ? 0 : this.second.hashCode());
        result = 31 * result + (this.timeZoneHour == null ? 0 : this.timeZoneHour.hashCode());
        result = 31 * result + (this.timeZoneMinute == null ? 0 : this.timeZoneMinute.hashCode());
        result = 31 * result + this.year;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateTime other = (DateTime)obj;
        if (this.day == null ? other.day != null : !this.day.equals(other.day)) {
            return false;
        }
        if (this.fraction == null ? other.fraction != null : !this.fraction.equals(other.fraction)) {
            return false;
        }
        if (this.hour == null ? other.hour != null : !this.hour.equals(other.hour)) {
            return false;
        }
        if (this.minute == null ? other.minute != null : !this.minute.equals(other.minute)) {
            return false;
        }
        if (this.month == null ? other.month != null : !this.month.equals(other.month)) {
            return false;
        }
        if (this.second == null ? other.second != null : !this.second.equals(other.second)) {
            return false;
        }
        if (this.timeZoneHour == null ? other.timeZoneHour != null : !this.timeZoneHour.equals(other.timeZoneHour)) {
            return false;
        }
        if (this.timeZoneMinute == null ? other.timeZoneMinute != null : !this.timeZoneMinute.equals(other.timeZoneMinute)) {
            return false;
        }
        return this.year == other.year;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append(String.format("%04d", this.getYear()));
        if (this.hasMonth()) {
            text.append("-");
            text.append(String.format("%02d", this.getMonth()));
        }
        if (this.hasDay()) {
            text.append("-");
            if (this.isOrdinal()) {
                text.append(String.format("%03d", this.getDay()));
            } else {
                text.append(String.format("%02d", this.getDay()));
            }
        }
        if (this.hasHour()) {
            text.append(TIME_DESIGNATOR);
            text.append(String.format("%02d", this.getHour()));
            if (this.hasMinute()) {
                text.append(COLON);
                text.append(String.format("%02d", this.getMinute()));
                if (this.hasSecond()) {
                    String fraction;
                    int periodIndex;
                    text.append(COLON);
                    text.append(String.format("%02d", this.getSecond()));
                    if (this.hasFraction() && (periodIndex = (fraction = this.getFraction().toString()).indexOf(PERIOD)) >= 0 && periodIndex + 1 < fraction.length()) {
                        text.append(PERIOD);
                        text.append(fraction.substring(periodIndex + 1));
                    }
                }
            }
            if (this.isTimeZoneUTC()) {
                text.append(UTC);
            } else {
                int timeZoneHour = this.getTimeZoneHour();
                if (timeZoneHour >= 0) {
                    text.append(PLUS_SIGN);
                } else {
                    text.append("-");
                    timeZoneHour *= -1;
                }
                text.append(String.format("%02d", timeZoneHour));
                if (this.hasTimeZoneMinute()) {
                    text.append(COLON);
                    text.append(String.format("%02d", this.getTimeZoneMinute()));
                }
            }
        }
        return text.toString();
    }
}

