/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.crs.common;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import mil.nga.crs.common.Identifiable;
import mil.nga.crs.common.Identifier;
import mil.nga.crs.wkt.CRSWriter;

public class Dynamic
implements Identifiable {
    private static final Logger logger = Logger.getLogger(Dynamic.class.getName());
    private double referenceEpoch;
    private String deformationModelName = null;
    private List<Identifier> identifiers;

    public Dynamic() {
    }

    public Dynamic(double referenceEpoch) {
        this.setReferenceEpoch(referenceEpoch);
    }

    public double getReferenceEpoch() {
        return this.referenceEpoch;
    }

    public void setReferenceEpoch(double referenceEpoch) {
        this.referenceEpoch = referenceEpoch;
    }

    public String getDeformationModelName() {
        return this.deformationModelName;
    }

    public boolean hasDeformationModelName() {
        return this.getDeformationModelName() != null;
    }

    public void setDeformationModelName(String deformationModelName) {
        this.deformationModelName = deformationModelName;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return this.identifiers;
    }

    @Override
    public boolean hasIdentifiers() {
        return this.identifiers != null && !this.identifiers.isEmpty();
    }

    @Override
    public int numIdentifiers() {
        return this.identifiers != null ? this.identifiers.size() : 0;
    }

    @Override
    public Identifier getIdentifier(int index) {
        return this.identifiers.get(index);
    }

    @Override
    public void setIdentifiers(List<Identifier> identifiers) {
        this.identifiers = identifiers;
    }

    @Override
    public void addIdentifier(Identifier identifier) {
        if (this.identifiers == null) {
            this.identifiers = new ArrayList<Identifier>();
        }
        this.identifiers.add(identifier);
    }

    @Override
    public void addIdentifiers(List<Identifier> identifiers) {
        if (this.identifiers == null) {
            this.identifiers = new ArrayList<Identifier>();
        }
        this.identifiers.addAll(identifiers);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.deformationModelName == null ? 0 : this.deformationModelName.hashCode());
        result = 31 * result + (this.identifiers == null ? 0 : this.identifiers.hashCode());
        long temp = Double.doubleToLongBits(this.referenceEpoch);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Dynamic other = (Dynamic)obj;
        if (this.deformationModelName == null ? other.deformationModelName != null : !this.deformationModelName.equals(other.deformationModelName)) {
            return false;
        }
        if (this.identifiers == null ? other.identifiers != null : !this.identifiers.equals(other.identifiers)) {
            return false;
        }
        return Double.doubleToLongBits(this.referenceEpoch) == Double.doubleToLongBits(other.referenceEpoch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String value = null;
        try (CRSWriter writer = new CRSWriter();){
            writer.write(this);
            value = writer.toString();
        }
        return value;
    }
}

