/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.crs.common;

import mil.nga.crs.CRSException;
import mil.nga.crs.common.Unit;
import mil.nga.crs.common.UnitType;

public class Units {
    public static final String MICROMETRE = "metre";
    public static final String MILLIMETRE = "millimetre";
    public static final String METRE = "metre";
    public static final String KILOMETRE = "kilometre";
    public static final String GERMAN_LEGAL_METRE = "German legal metre";
    public static final String US_SURVEY_FOOT = "US survey foot";
    public static final String MICRORADIAN = "microradian";
    public static final String MILLIRADIAN = "milliradian";
    public static final String RADIAN = "radian";
    public static final String ARC_SECOND = "arc-second";
    public static final String ARC_MINUTE = "arc-minute";
    public static final String DEGREE = "degree";
    public static final String GRAD = "grad";
    public static final String UNITY = "unity";
    public static final String BIN = "bin";
    public static final String PARTS_PER_MILLION = "parts per million";
    public static final String PASCAL = "pascal";
    public static final String HECTOPASCAL = "hectopascal";
    public static final String MICROSECOND = "microsecond";
    public static final String MILLISECOND = "millisecond";
    public static final String SECOND = "second";
    public static final String MINUTE = "minute";
    public static final String HOUR = "hour";
    public static final String DAY = "day";
    public static final String YEAR = "year";
    public static final String CALENDAR_SECOND = "calendar second";
    public static final String CALENDAR_MONTH = "calendar month";

    public static Unit getMicrometre() {
        return new Unit(UnitType.LENGTHUNIT, "metre", 1.0E-6);
    }

    public static Unit getMillimetre() {
        return new Unit(UnitType.LENGTHUNIT, MILLIMETRE, 0.001);
    }

    public static Unit getMetre() {
        return new Unit(UnitType.LENGTHUNIT, "metre", 1.0);
    }

    public static Unit getKilometre() {
        return new Unit(UnitType.LENGTHUNIT, KILOMETRE, 1000.0);
    }

    public static Unit getGermanLegalMetre() {
        return new Unit(UnitType.LENGTHUNIT, GERMAN_LEGAL_METRE, 1.0000135965);
    }

    public static Unit getUSSurveyFoot() {
        return new Unit(UnitType.LENGTHUNIT, US_SURVEY_FOOT, 0.304800609601219);
    }

    public static Unit getMicroradian() {
        return new Unit(UnitType.ANGLEUNIT, MICRORADIAN, 1.0E-6);
    }

    public static Unit getMilliradian() {
        return new Unit(UnitType.ANGLEUNIT, MILLIRADIAN, 0.001);
    }

    public static Unit getRadian() {
        return new Unit(UnitType.ANGLEUNIT, RADIAN, 1.0);
    }

    public static Unit getArcSecond() {
        return new Unit(UnitType.ANGLEUNIT, ARC_SECOND, 4.84813681109536E-6);
    }

    public static Unit getArcMinute() {
        return new Unit(UnitType.ANGLEUNIT, ARC_MINUTE, 2.908882086657216E-4);
    }

    public static Unit getDegree() {
        return new Unit(UnitType.ANGLEUNIT, DEGREE, Math.PI / 180);
    }

    public static Unit getGrad() {
        return new Unit(UnitType.ANGLEUNIT, GRAD, 0.015707963267949);
    }

    public static Unit getUnity() {
        return new Unit(UnitType.SCALEUNIT, UNITY, 1.0);
    }

    public static Unit getBin() {
        return new Unit(UnitType.SCALEUNIT, BIN, 1.0);
    }

    public static Unit getPartsPerMillion() {
        return new Unit(UnitType.SCALEUNIT, PARTS_PER_MILLION, 1.0E-6);
    }

    public static Unit getPascal() {
        return new Unit(UnitType.PARAMETRICUNIT, PASCAL, 1.0);
    }

    public static Unit getHectopascal() {
        return new Unit(UnitType.PARAMETRICUNIT, HECTOPASCAL, 100.0);
    }

    public static Unit getMicrosecond() {
        return new Unit(UnitType.TIMEUNIT, MICROSECOND, 1.0E-6);
    }

    public static Unit getMillisecond() {
        return new Unit(UnitType.TIMEUNIT, MILLISECOND, 0.001);
    }

    public static Unit getSecond() {
        return new Unit(UnitType.TIMEUNIT, SECOND, 1.0);
    }

    public static Unit getMinute() {
        return new Unit(UnitType.TIMEUNIT, MINUTE, 60.0);
    }

    public static Unit getHour() {
        return new Unit(UnitType.TIMEUNIT, HOUR, 3600.0);
    }

    public static Unit getDay() {
        return new Unit(UnitType.TIMEUNIT, DAY, 86400.0);
    }

    public static Unit getYear() {
        return new Unit(UnitType.TIMEUNIT, YEAR, 3.15576E7);
    }

    public static Unit getCalendarSecond() {
        return new Unit(UnitType.TIMEUNIT, CALENDAR_SECOND);
    }

    public static Unit getCalendarMonth() {
        return new Unit(UnitType.TIMEUNIT, CALENDAR_MONTH);
    }

    public static Unit getDefaultUnit(UnitType type) {
        Unit defaultUnit = null;
        switch (type) {
            case LENGTHUNIT: {
                defaultUnit = Units.getMetre();
                break;
            }
            case ANGLEUNIT: {
                defaultUnit = Units.getDegree();
                break;
            }
            case SCALEUNIT: {
                defaultUnit = Units.getUnity();
                break;
            }
        }
        return defaultUnit;
    }

    public static boolean canConvert(Unit unit1, Unit unit2) {
        return unit1 != null && unit2 != null && unit1.getType() == unit2.getType() && unit1.hasConversionFactor() && unit2.hasConversionFactor();
    }

    public static double convert(double value, Unit from, Unit to) {
        if (from.getType() != to.getType()) {
            throw new CRSException("Can't convert value '" + value + "' from unit type " + from.getType().name() + " to unit type " + to.getType().name());
        }
        if (!from.hasConversionFactor()) {
            throw new CRSException("Can't convert value '" + value + "' from unit type " + from.getType().name() + " without a conversion factor.");
        }
        if (!to.hasConversionFactor()) {
            throw new CRSException("Can't convert value '" + value + "' to unit type " + to.getType().name() + " without a conversion factor.");
        }
        return value * (from.getConversionFactor() / to.getConversionFactor());
    }
}

