/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.crs.geo;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import mil.nga.crs.common.Identifiable;
import mil.nga.crs.common.Identifier;
import mil.nga.crs.common.Unit;
import mil.nga.crs.geo.EllipsoidType;
import mil.nga.crs.wkt.CRSWriter;

public class Ellipsoid
implements Identifiable {
    private static final Logger logger = Logger.getLogger(Ellipsoid.class.getName());
    private String name = null;
    private double semiMajorAxis;
    private double inverseFlattening;
    private Unit unit = null;
    private List<Identifier> identifiers = null;

    public Ellipsoid() {
    }

    public Ellipsoid(String name, double semiMajorAxis, double inverseFlattening) {
        this.setName(name);
        this.setSemiMajorAxis(semiMajorAxis);
        this.setInverseFlattening(inverseFlattening);
    }

    public EllipsoidType getType() {
        return EllipsoidType.OBLATE;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getSemiMajorAxis() {
        return this.semiMajorAxis;
    }

    public void setSemiMajorAxis(double semiMajorAxis) {
        this.semiMajorAxis = semiMajorAxis;
    }

    public double getInverseFlattening() {
        return this.inverseFlattening;
    }

    public void setInverseFlattening(double inverseFlattening) {
        this.inverseFlattening = inverseFlattening;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public boolean hasUnit() {
        return this.getUnit() != null;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return this.identifiers;
    }

    @Override
    public boolean hasIdentifiers() {
        return this.identifiers != null && !this.identifiers.isEmpty();
    }

    @Override
    public int numIdentifiers() {
        return this.identifiers != null ? this.identifiers.size() : 0;
    }

    @Override
    public Identifier getIdentifier(int index) {
        return this.identifiers.get(index);
    }

    @Override
    public void setIdentifiers(List<Identifier> identifiers) {
        this.identifiers = identifiers;
    }

    @Override
    public void addIdentifier(Identifier identifier) {
        if (this.identifiers == null) {
            this.identifiers = new ArrayList<Identifier>();
        }
        this.identifiers.add(identifier);
    }

    @Override
    public void addIdentifiers(List<Identifier> identifiers) {
        if (this.identifiers == null) {
            this.identifiers = new ArrayList<Identifier>();
        }
        this.identifiers.addAll(identifiers);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.identifiers == null ? 0 : this.identifiers.hashCode());
        long temp = Double.doubleToLongBits(this.inverseFlattening);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        temp = Double.doubleToLongBits(this.semiMajorAxis);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Ellipsoid other = (Ellipsoid)obj;
        if (this.identifiers == null ? other.identifiers != null : !this.identifiers.equals(other.identifiers)) {
            return false;
        }
        if (Double.doubleToLongBits(this.inverseFlattening) != Double.doubleToLongBits(other.inverseFlattening)) {
            return false;
        }
        if (this.unit == null ? other.unit != null : !this.unit.equals(other.unit)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return Double.doubleToLongBits(this.semiMajorAxis) == Double.doubleToLongBits(other.semiMajorAxis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String value = null;
        try (CRSWriter writer = new CRSWriter();){
            writer.write(this);
            value = writer.toString();
        }
        return value;
    }
}

