/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.crs.geo;

import java.util.List;
import java.util.logging.Logger;
import mil.nga.crs.common.DatumEnsemble;
import mil.nga.crs.common.DatumEnsembleMember;
import mil.nga.crs.geo.Ellipsoid;
import mil.nga.crs.geo.GeoDatum;
import mil.nga.crs.geo.PrimeMeridian;
import mil.nga.crs.wkt.CRSWriter;

public class GeoDatumEnsemble
extends DatumEnsemble
implements GeoDatum {
    private static final Logger logger = Logger.getLogger(GeoDatumEnsemble.class.getName());
    private Ellipsoid ellipsoid = null;
    private PrimeMeridian primeMeridian = null;

    public GeoDatumEnsemble() {
    }

    public GeoDatumEnsemble(String name, DatumEnsembleMember member, Ellipsoid ellipsoid, double accuracy, PrimeMeridian primeMeridian) {
        super(name, member, accuracy);
        this.setEllipsoid(ellipsoid);
        this.setPrimeMeridian(primeMeridian);
    }

    public GeoDatumEnsemble(String name, List<DatumEnsembleMember> members, Ellipsoid ellipsoid, double accuracy, PrimeMeridian primeMeridian) {
        super(name, members, accuracy);
        this.setEllipsoid(ellipsoid);
        this.setPrimeMeridian(primeMeridian);
    }

    @Override
    public Ellipsoid getEllipsoid() {
        return this.ellipsoid;
    }

    @Override
    public void setEllipsoid(Ellipsoid ellipsoid) {
        this.ellipsoid = ellipsoid;
    }

    @Override
    public PrimeMeridian getPrimeMeridian() {
        return this.primeMeridian;
    }

    @Override
    public boolean hasPrimeMeridian() {
        return this.getPrimeMeridian() != null;
    }

    @Override
    public void setPrimeMeridian(PrimeMeridian primeMeridian) {
        this.primeMeridian = primeMeridian;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.ellipsoid == null ? 0 : this.ellipsoid.hashCode());
        result = 31 * result + (this.primeMeridian == null ? 0 : this.primeMeridian.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeoDatumEnsemble other = (GeoDatumEnsemble)obj;
        if (this.ellipsoid == null ? other.ellipsoid != null : !this.ellipsoid.equals(other.ellipsoid)) {
            return false;
        }
        return !(this.primeMeridian == null ? other.primeMeridian != null : !this.primeMeridian.equals(other.primeMeridian));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        String value = null;
        try (CRSWriter writer = new CRSWriter();){
            writer.write(this);
            value = writer.toString();
        }
        return value;
    }
}

