/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.crs.operation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mil.nga.crs.CRSException;
import mil.nga.crs.operation.OperationParameters;
import mil.nga.crs.operation.OperationType;

public enum OperationMethods {
    ALBERS_EQUAL_AREA(9822, "Albers Equal Area", OperationType.MAP_PROJECTION, "Albers", 8821, 8822, 8823, 8824, 8826, 8827),
    AMERICAN_POLYCONIC(9818, "American Polyconic", OperationType.MAP_PROJECTION, "Polyconic", 8801, 8802, 8806, 8807),
    CASSINI_SOLDNER(9806, "Cassini-Soldner", OperationType.MAP_PROJECTION, "Cassini", 8801, 8802, 8806, 8807),
    COORDINATE_FRAME_ROTATION(1032, "Coordinate Frame rotation (geocentric domain)", OperationType.COORDINATE, new String[]{"Coordinate Frame rotation", "Bursa-Wolf", "Helmert"}, 8605, 8606, 8607, 8608, 8609, 8610, 8611),
    EQUIDISTANT_CYLINDRICAL(9823, "Equidistant Cylindrical (Spherical)", OperationType.MAP_PROJECTION, "Equidistant Cylindrical", 8801, 8802, 8806, 8807),
    GEOCENTRIC_TRANSLATIONS(1031, "Geocentric translations (geocentric domain)", OperationType.COORDINATE, "Geocentric translations", 8605, 8606, 8607),
    HOTINE_OBLIQUE_MERCATOR_A(9812, "Hotine Oblique Mercator (variant A)", OperationType.MAP_PROJECTION, new String[]{"Rectified skew orthomorphic", "Hotine Oblique Mercator"}, 8811, 8812, 8813, 8814, 8815, 8806, 8807),
    HOTINE_OBLIQUE_MERCATOR_B(9815, "Hotine Oblique Mercator (variant B)", OperationType.MAP_PROJECTION, new String[]{"Rectified skew orthomorphic", "Oblique Mercator"}, 8811, 8812, 8813, 8814, 8815, 8816, 8817),
    KROVAK(9819, "Krovak", OperationType.MAP_PROJECTION, 8811, 8833, 1036, 8818, 8819, 8806, 8807),
    LAMBERT_AZIMUTHAL_EQUAL_AREA(9820, "Lambert Azimuthal Equal Area", OperationType.MAP_PROJECTION, new String[]{"Lambert Equal Area", "LAEA"}, 8801, 8802, 8806, 8807),
    LAMBERT_CONIC_CONFORMAL_1SP(9801, "Lambert Conic Conformal (1SP)", OperationType.MAP_PROJECTION, new String[]{"Lambert Conic Conformal", "LCC", "Lambert Conformal Conic 1SP"}, 8801, 8802, 8805, 8806, 8807),
    LAMBERT_CONIC_CONFORMAL_2SP(9802, "Lambert Conic Conformal (2SP)", OperationType.MAP_PROJECTION, new String[]{"Lambert Conic Conformal", "LCC", "Lambert Conformal Conic 2SP"}, 8821, 8822, 8823, 8824, 8826, 8827),
    LAMBERT_CYLINDRICAL_EQUAL_AREA(9834, "Lambert Cylindrical Equal Area (Spherical)", OperationType.MAP_PROJECTION, "Lambert Cylindrical Equal Area", 8823, 8802, 8806, 8807),
    LONGITUDE_ROTATION(9601, "Longitude rotation", OperationType.COORDINATE, 8602),
    MERCATOR_A(9804, "Mercator (variant A)", OperationType.MAP_PROJECTION, "Mercator", 8801, 8802, 8805, 8806, 8807),
    MERCATOR_B(9805, "Mercator (variant B)", OperationType.MAP_PROJECTION, "Mercator", 8823, 8802, 8806, 8807),
    MOLODENSKY_BADEKAS(1034, "Molodensky-Badekas (geocentric domain)", OperationType.COORDINATE, "Molodensky-Badekas", 8605, 8606, 8607, 8608, 8609, 8610, 8611, 8617, 8618, 8667),
    NADCON(9613, "NADCON", OperationType.COORDINATE, 8657, 8658),
    NADCON5(1075, "NADCON5 (3D)", OperationType.COORDINATE, "NADCON5", 8657, 8658, 1058),
    NEW_ZEALAND_MAP_GRID(9811, "New Zealand Map Grid", OperationType.MAP_PROJECTION, 8801, 8802, 8806, 8807),
    NTV2(9615, "NTv2", OperationType.COORDINATE, 8656),
    OBLIQUE_STEREOGRAPHIC(9809, "Oblique stereographic", OperationType.MAP_PROJECTION, "Double stereographic", 8801, 8802, 8805, 8806, 8807),
    POLAR_STEREOGRAPHIC_A(9810, "Polar Stereographic (variant A)", OperationType.MAP_PROJECTION, "Polar Stereographic", 8801, 8802, 8805, 8806, 8807),
    POLAR_STEREOGRAPHIC_B(9829, "Polar Stereographic (variant B)", OperationType.MAP_PROJECTION, 8832, 8833, 8806, 8807),
    POLAR_STEREOGRAPHIC_C(9830, "Polar Stereographic (variant C)", OperationType.MAP_PROJECTION, 8832, 8833, 8826, 8827),
    POPULAR_VISUALISATION_PSEUDO_MERCATOR(1024, "Popular Visualisation Pseudo Mercator", OperationType.MAP_PROJECTION, "Mercator_1SP", 8801, 8802, 8806, 8807),
    POSITION_VECTOR_TRANSFORMATION(1033, "Position Vector transformation (geocentric domain)", OperationType.COORDINATE, new String[]{"Position Vector transformation", "Position Vector 7-param. transformation", "Bursa-Wolf", "Helmert"}, 8605, 8606, 8607, 8608, 8609, 8610, 8611),
    TRANSVERSE_MERCATOR(9807, "Transverse Mercator", OperationType.MAP_PROJECTION, new String[]{"Gauss-Boaga", "Gauss-Kr\u00fcger", "TM"}, 8801, 8802, 8805, 8806, 8807),
    TRANSVERSE_MERCATOR_SOUTH_ORIENTATED(9808, "Transverse Mercator (South Orientated)", OperationType.MAP_PROJECTION, "Gauss-Conform", 8801, 8802, 8805, 8806, 8807),
    VERTICAL_OFFSET(9616, "Vertical Offset", OperationType.COORDINATE, 8603);

    private static final Map<String, Set<OperationMethods>> aliasMethods;
    private static final Map<Integer, OperationMethods> codeMethods;
    private final String name;
    private final OperationType operationType;
    private final Set<String> aliases = new LinkedHashSet<String>();
    private final int code;
    private final List<Integer> parameterCodes = new ArrayList<Integer>();

    private OperationMethods(int code, String name, OperationType operationType, int ... parameterCodes) {
        this(code, name, operationType, new String[0], parameterCodes);
    }

    private OperationMethods(int code, String name, OperationType operationType, String alias, int ... parameterCodes) {
        this(code, name, operationType, new String[]{alias}, parameterCodes);
    }

    private OperationMethods(int code, String name, OperationType operationType, String[] aliases, int ... parameterCodes) {
        this.code = code;
        this.name = name;
        this.operationType = operationType;
        this.addAlias(name);
        for (String alias : aliases) {
            this.addAlias(alias);
        }
        for (int parameterCode : parameterCodes) {
            this.parameterCodes.add(parameterCode);
        }
    }

    private void addAlias(String alias) {
        this.aliases.add(alias);
        String underscore = alias.replaceAll(" ", "_");
        this.aliases.add(underscore);
        this.aliases.add(underscore.replace("(", "").replace(")", ""));
    }

    public String getName() {
        return this.name;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public Set<String> getAliases() {
        return Collections.unmodifiableSet(this.aliases);
    }

    public int getCode() {
        return this.code;
    }

    public List<Integer> getParameterCodes() {
        return Collections.unmodifiableList(this.parameterCodes);
    }

    public int numParameters() {
        return this.parameterCodes.size();
    }

    public int getParameterCode(int index) {
        return this.parameterCodes.get(index);
    }

    public OperationParameters getParameter(int index) {
        return OperationParameters.getParameter(this.getParameterCode(index));
    }

    public List<OperationParameters> getParameters() {
        ArrayList<OperationParameters> parameters = new ArrayList<OperationParameters>();
        for (int i = 0; i < this.numParameters(); ++i) {
            parameters.add(this.getParameter(i));
        }
        return parameters;
    }

    public static OperationMethods getMethod(String name) {
        OperationMethods method = null;
        Set<OperationMethods> methods = OperationMethods.getMethods(name);
        if (methods != null && !methods.isEmpty()) {
            method = methods.iterator().next();
        }
        return method;
    }

    public static Set<OperationMethods> getMethods(String name) {
        Set<OperationMethods> methods = null;
        if (name != null) {
            methods = aliasMethods.get(name.toLowerCase());
        }
        return methods;
    }

    public static OperationMethods getMethod(int code) {
        return codeMethods.get(code);
    }

    static {
        aliasMethods = new HashMap<String, Set<OperationMethods>>();
        codeMethods = new HashMap<Integer, OperationMethods>();
        for (OperationMethods method : OperationMethods.values()) {
            for (String alias : method.aliases) {
                String aliasLowerCase = alias.toLowerCase();
                Set<OperationMethods> methodSet = aliasMethods.get(aliasLowerCase);
                if (methodSet == null) {
                    methodSet = new HashSet<OperationMethods>();
                    aliasMethods.put(aliasLowerCase, methodSet);
                }
                methodSet.add(method);
            }
            int code = method.getCode();
            if (codeMethods.containsKey(code)) {
                throw new CRSException("Duplicate configured Operation Method code: " + code);
            }
            codeMethods.put(code, method);
        }
    }
}

