package mil.nga.crs.geo;

import java.util.List;

import mil.nga.crs.common.DatumEnsemble;
import mil.nga.crs.common.DatumEnsembleMember;

/**
 * Geodetic and Geographic Datum Ensemble
 * 
 * @author osbornb
 */
public class GeoDatumEnsemble extends DatumEnsemble implements GeoDatum {

	/**
	 * Ellipsoid
	 */
	private Ellipsoid ellipsoid = null;

	/**
	 * Prime Meridian
	 */
	private PrimeMeridian primeMeridian = null;

	/**
	 * Constructor
	 */
	public GeoDatumEnsemble() {

	}

	/**
	 * Constructor
	 * 
	 * @param name
	 *            name
	 * @param member
	 *            member
	 * @param ellipsoid
	 *            ellipsoid
	 * @param accuracy
	 *            accuracy
	 * @param primeMeridian
	 *            prime meridian
	 */
	public GeoDatumEnsemble(String name, DatumEnsembleMember member,
			Ellipsoid ellipsoid, double accuracy, PrimeMeridian primeMeridian) {
		super(name, member, accuracy);
		setEllipsoid(ellipsoid);
		setPrimeMeridian(primeMeridian);
	}

	/**
	 * Constructor
	 * 
	 * @param name
	 *            name
	 * @param members
	 *            members
	 * @param ellipsoid
	 *            ellipsoid
	 * @param accuracy
	 *            accuracy
	 * @param primeMeridian
	 *            prime meridian
	 */
	public GeoDatumEnsemble(String name, List<DatumEnsembleMember> members,
			Ellipsoid ellipsoid, double accuracy, PrimeMeridian primeMeridian) {
		super(name, members, accuracy);
		setEllipsoid(ellipsoid);
		setPrimeMeridian(primeMeridian);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Ellipsoid getEllipsoid() {
		return ellipsoid;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setEllipsoid(Ellipsoid ellipsoid) {
		this.ellipsoid = ellipsoid;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public PrimeMeridian getPrimeMeridian() {
		return primeMeridian;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean hasPrimeMeridian() {
		return getPrimeMeridian() != null;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setPrimeMeridian(PrimeMeridian primeMeridian) {
		this.primeMeridian = primeMeridian;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result
				+ ((ellipsoid == null) ? 0 : ellipsoid.hashCode());
		result = prime * result
				+ ((primeMeridian == null) ? 0 : primeMeridian.hashCode());
		return result;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		GeoDatumEnsemble other = (GeoDatumEnsemble) obj;
		if (ellipsoid == null) {
			if (other.ellipsoid != null)
				return false;
		} else if (!ellipsoid.equals(other.ellipsoid))
			return false;
		if (primeMeridian == null) {
			if (other.primeMeridian != null)
				return false;
		} else if (!primeMeridian.equals(other.primeMeridian))
			return false;
		return true;
	}

}
