/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.crs.geo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mil.nga.crs.geo.Ellipsoids;

public enum GeoDatums {
    WGS84("WGS84", 0.0, 0.0, 0.0, Ellipsoids.WGS84, "WGS84", "World Geodetic System 1984 ensemble", "WGS 1984", "WGS 84", "World Geodetic System 1984"),
    GGRS87("GGRS87", -199.87, 74.79, 246.62, Ellipsoids.GRS80, "Greek Geodetic Reference System 1987"),
    NAD83("NAD83", 0.0, 0.0, 0.0, Ellipsoids.GRS80, "North American Datum 1983"),
    NAD27("NAD27", Ellipsoids.CLARKE_1866, "North American Datum 1927"),
    POTSDAM("potsdam", 598.1, 73.7, 418.2, 0.202, 0.045, -2.455, 6.7, Ellipsoids.BESSEL, "Potsdam Rauenberg 1950 DHDN", "Deutsches Hauptdreiecksnetz"),
    CARTHAGE("carthage", -263.0, 6.0, 431.0, Ellipsoids.CLARKE_1880, "Carthage 1934 Tunisia", "Carthage"),
    HERMANNSKOGEL("hermannskogel", 577.326, 90.129, 463.919, 5.137, 1.474, 5.297, 2.4232, Ellipsoids.BESSEL, "Hermannskogel", "Militar-Geographische Institut", "Militar Geographische Institute"),
    IRE65("ire65", 482.53, -130.596, 564.557, -1.042, -0.214, -0.631, 8.15, Ellipsoids.MOD_AIRY, "Ireland 1965", "TM65"),
    NZGD49("nzgd49", 59.47, -5.04, 187.44, 0.47, -0.1, 1.024, -4.5993, Ellipsoids.INTERNATIONAL, "New Zealand Geodetic Datum 1949"),
    OSGB36("OSGB36", 446.448, -125.157, 542.06, 0.15, 0.247, 0.842, -20.489, Ellipsoids.AIRY, "Airy 1830", "OSGB 1936", "Ordnance Survey of Great Britain 1936");

    private final String code;
    private final List<String> names;
    private final double[] transform;
    private final Ellipsoids ellipsoid;
    private static final Map<String, GeoDatums> nameTypes;

    private GeoDatums(String code, Ellipsoids ellipsoid, String ... names) {
        this(code, null, ellipsoid, names);
    }

    private GeoDatums(String code, double xTranslation, double yTranslation, double zTranslation, Ellipsoids ellipsoid, String ... names) {
        this(code, new double[]{xTranslation, yTranslation, zTranslation}, ellipsoid, names);
    }

    private GeoDatums(String code, double xTranslation, double yTranslation, double zTranslation, double xRotation, double yRotation, double zRotation, double scaleDifference, Ellipsoids ellipsoid, String ... names) {
        this(code, new double[]{xTranslation, yTranslation, zTranslation, xRotation, yRotation, zRotation, scaleDifference}, ellipsoid, names);
    }

    private GeoDatums(String code, double[] transform, Ellipsoids ellipsoid, String ... names) {
        this.code = code;
        this.transform = transform;
        this.ellipsoid = ellipsoid;
        ArrayList<String> tempNames = new ArrayList<String>();
        for (String name : names) {
            String underscore;
            if (!tempNames.contains(name)) {
                tempNames.add(name);
            }
            if (tempNames.contains(underscore = name.replaceAll(" ", "_"))) continue;
            tempNames.add(underscore);
        }
        this.names = tempNames;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.names.get(0);
    }

    public List<String> getNames() {
        return this.names;
    }

    public double[] getTransform() {
        return this.transform;
    }

    public Ellipsoids getEllipsoid() {
        return this.ellipsoid;
    }

    public static GeoDatums fromName(String name) {
        return nameTypes.get(name.toLowerCase());
    }

    static {
        nameTypes = new HashMap<String, GeoDatums>();
        for (GeoDatums type : GeoDatums.values()) {
            nameTypes.put(type.getCode().toLowerCase(), type);
            for (String name : type.getNames()) {
                String lowercaseName = name.toLowerCase();
                nameTypes.put(lowercaseName, type);
            }
        }
    }
}

