/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.crs.geo;

import java.util.HashMap;
import java.util.Map;

public enum PrimeMeridians {
    GREENWICH("greenwich", 0.0),
    LISBON("lisbon", true, 9.0, 7.0, 54.862),
    PARIS("paris", false, 2.0, 20.0, 14.025),
    BOGOTA("bogota", true, 74.0, 4.0, 51.3),
    MADRID("madrid", true, 3.0, 41.0, 16.58),
    ROME("rome", false, 12.0, 27.0, 8.4),
    BERN("bern", false, 7.0, 26.0, 22.5),
    JAKARTA("jakarta", false, 106.0, 48.0, 27.79),
    FERRO("ferro", true, 17.0, 40.0, 0.0),
    BRUSSELS("brussels", false, 4.0, 22.0, 4.71),
    STOCKHOLM("stockholm", false, 18.0, 3.0, 29.8),
    ATHENS("athens", false, 23.0, 42.0, 58.815),
    OSLO("oslo", false, 10.0, 43.0, 22.5);

    private static final Map<String, PrimeMeridians> nameTypes;
    private final String name;
    private final double offsetFromGreenwich;

    private PrimeMeridians(String name, boolean west, double degree, double minute, double second) {
        this(name, PrimeMeridians.getLongitude(west, degree, minute, second));
    }

    private PrimeMeridians(String name, double offsetFromGreenwich) {
        this.name = name;
        this.offsetFromGreenwich = offsetFromGreenwich;
    }

    public String getName() {
        return this.name;
    }

    public double getOffsetFromGreenwich() {
        return this.offsetFromGreenwich;
    }

    public static PrimeMeridians fromName(String name) {
        return nameTypes.get(name.toLowerCase());
    }

    private static double getLongitude(boolean west, double degree, double minute, double second) {
        double longitude = west ? PrimeMeridians.getWestLongitude(degree, minute, second) : PrimeMeridians.getEastLongitude(degree, minute, second);
        return longitude;
    }

    private static double getEastLongitude(double degree, double minute, double second) {
        return ((second / 60.0 + minute) / 60.0 + degree) * (Math.PI / 180);
    }

    private static double getWestLongitude(double degree, double minute, double second) {
        return PrimeMeridians.getEastLongitude(-degree, -minute, -second);
    }

    static {
        nameTypes = new HashMap<String, PrimeMeridians>();
        for (PrimeMeridians type : PrimeMeridians.values()) {
            nameTypes.put(type.getName().toLowerCase(), type);
        }
    }
}

