/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.crs.util.proj;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import mil.nga.crs.CRS;
import mil.nga.crs.CRSException;
import mil.nga.crs.CompoundCoordinateReferenceSystem;
import mil.nga.crs.SimpleCoordinateReferenceSystem;
import mil.nga.crs.common.Axis;
import mil.nga.crs.common.CoordinateSystem;
import mil.nga.crs.common.Unit;
import mil.nga.crs.common.UnitType;
import mil.nga.crs.common.Units;
import mil.nga.crs.geo.Ellipsoid;
import mil.nga.crs.geo.Ellipsoids;
import mil.nga.crs.geo.GeoCoordinateReferenceSystem;
import mil.nga.crs.geo.GeoDatum;
import mil.nga.crs.geo.GeoDatums;
import mil.nga.crs.geo.PrimeMeridian;
import mil.nga.crs.geo.PrimeMeridians;
import mil.nga.crs.geo.TriaxialEllipsoid;
import mil.nga.crs.operation.OperationMethod;
import mil.nga.crs.operation.OperationMethods;
import mil.nga.crs.operation.OperationParameter;
import mil.nga.crs.projected.MapProjection;
import mil.nga.crs.projected.ProjectedCoordinateReferenceSystem;
import mil.nga.crs.util.proj.ProjParams;
import mil.nga.crs.wkt.CRSKeyword;
import mil.nga.crs.wkt.CRSReader;

public class ProjParser {
    public static ProjParams params(String wkt) throws IOException {
        CRS crs = CRSReader.read(wkt);
        ProjParams params = null;
        if (crs != null) {
            params = ProjParser.params(crs);
        }
        return params;
    }

    public static String paramsText(String wkt) throws IOException {
        return ProjParser.paramsText(ProjParser.params(wkt));
    }

    public static ProjParams params(CRS crs) {
        ProjParams params = null;
        switch (crs.getType()) {
            case GEODETIC: 
            case GEOGRAPHIC: {
                params = ProjParser.params((GeoCoordinateReferenceSystem)crs);
                break;
            }
            case PROJECTED: {
                params = ProjParser.params((ProjectedCoordinateReferenceSystem)crs);
                break;
            }
            case COMPOUND: {
                params = ProjParser.params((CompoundCoordinateReferenceSystem)crs);
                break;
            }
        }
        return params;
    }

    public static String paramsText(CRS crs) {
        return ProjParser.paramsText(ProjParser.params(crs));
    }

    public static ProjParams params(GeoCoordinateReferenceSystem geo) {
        ProjParams params = new ProjParams();
        GeoDatum geoDatum = geo.getGeoDatum();
        ProjParser.updateDatum(params, geoDatum);
        ProjParser.updateDatumTransform(params, geo);
        ProjParser.updateProj(params, geo.getCoordinateSystem());
        ProjParser.updatePrimeMeridian(params, geoDatum);
        params.setNoDefs(true);
        return params;
    }

    public static String paramsText(GeoCoordinateReferenceSystem geo) {
        return ProjParser.paramsText(ProjParser.params(geo));
    }

    public static ProjParams params(ProjectedCoordinateReferenceSystem projected) {
        ProjParams params = new ProjParams();
        CoordinateSystem coordinateSystem = projected.getCoordinateSystem();
        MapProjection mapProjection = projected.getMapProjection();
        GeoDatum geoDatum = projected.getGeoDatum();
        ProjParser.updateDatum(params, geoDatum, mapProjection);
        ProjParser.updateDatumTransform(params, projected.getBase());
        ProjParser.updateDatumTransform(params, mapProjection.getMethod());
        ProjParser.updateProj(params, coordinateSystem, mapProjection);
        ProjParser.updateUnits(params, coordinateSystem);
        ProjParser.updatePrimeMeridian(params, geoDatum);
        ProjParser.updateParams(params, mapProjection, coordinateSystem.getUnit());
        params.setNoDefs(true);
        return params;
    }

    public static String paramsText(ProjectedCoordinateReferenceSystem projected) {
        return ProjParser.paramsText(ProjParser.params(projected));
    }

    public static ProjParams params(CompoundCoordinateReferenceSystem compound) {
        SimpleCoordinateReferenceSystem simpleCrs;
        ProjParams params = new ProjParams();
        Iterator<SimpleCoordinateReferenceSystem> iterator = compound.getCoordinateReferenceSystems().iterator();
        while (iterator.hasNext() && (params = ProjParser.params(simpleCrs = iterator.next())) == null) {
        }
        return params;
    }

    public static String paramsText(CompoundCoordinateReferenceSystem compound) {
        return ProjParser.paramsText(ProjParser.params(compound));
    }

    private static void updateDatum(ProjParams params, GeoDatum geoDatum) {
        GeoDatums commonGeoDatum = GeoDatums.fromName(geoDatum.getName());
        if (commonGeoDatum != null) {
            params.setDatum(commonGeoDatum.getCode());
        } else {
            ProjParser.updateEllipsoid(params, geoDatum.getEllipsoid());
        }
    }

    private static void updateDatum(ProjParams params, GeoDatum geoDatum, MapProjection mapProjection) {
        GeoDatums commonGeoDatum = GeoDatums.fromName(geoDatum.getName());
        if (commonGeoDatum != null) {
            ProjParser.updateDatum(params, geoDatum, commonGeoDatum, mapProjection);
        } else {
            ProjParser.updateEllipsoid(params, geoDatum.getEllipsoid());
        }
    }

    private static void updateDatum(ProjParams params, GeoDatum geoDatum, GeoDatums commonGeoDatum, MapProjection mapProjection) {
        OperationMethod method = mapProjection.getMethod();
        if (commonGeoDatum == GeoDatums.WGS84 && method.hasMethod() && method.getMethod() == OperationMethods.POPULAR_VISUALISATION_PSEUDO_MERCATOR && mapProjection.getName().toLowerCase().contains("pseudo")) {
            ProjParser.updateSphericalEllipsoid(params, geoDatum.getEllipsoid().getSemiMajorAxisText());
        } else {
            params.setDatum(commonGeoDatum.getCode());
        }
    }

    private static void updateEllipsoid(ProjParams params, Ellipsoid ellipsoid) {
        Ellipsoids commonEllipsoid = null;
        if (ellipsoid.getInverseFlattening() != 0.0) {
            commonEllipsoid = Ellipsoids.fromName(ellipsoid.getName());
        }
        if (commonEllipsoid != null) {
            params.setEllps(commonEllipsoid.getShortName());
        } else {
            params.setA(ProjParser.convert(ellipsoid.getSemiMajorAxis(), ellipsoid.getSemiMajorAxisText(), ellipsoid.getUnit(), Units.METRE));
            switch (ellipsoid.getType()) {
                case OBLATE: {
                    params.setB(ProjParser.convert(ellipsoid.getPoleRadius(), ellipsoid.getPoleRadiusText(), ellipsoid.getUnit(), Units.METRE));
                    break;
                }
                case TRIAXIAL: {
                    TriaxialEllipsoid triaxial = (TriaxialEllipsoid)ellipsoid;
                    params.setB(ProjParser.convert(triaxial.getSemiMinorAxis(), triaxial.getSemiMinorAxisText(), ellipsoid.getUnit(), Units.METRE));
                    break;
                }
                default: {
                    throw new CRSException("Unsupported Ellipsoid Type: " + (Object)((Object)ellipsoid.getType()));
                }
            }
        }
    }

    private static void updateSphericalEllipsoid(ProjParams params, String radius) {
        params.setA(radius);
        params.setB(radius);
    }

    private static void updateDatumTransform(ProjParams params, CRS crs) {
        Object toWGS84 = crs.getExtra(CRSKeyword.TOWGS84.name());
        if (toWGS84 != null) {
            ProjParser.updateDatumTransform(params, (String[])toWGS84);
        }
    }

    private static void updateDatumTransform(ProjParams params, String[] toWGS84) {
        if (toWGS84.length >= 3) {
            params.setXTranslation(toWGS84[0]);
            params.setYTranslation(toWGS84[1]);
            params.setZTranslation(toWGS84[2]);
            if (toWGS84.length >= 7) {
                params.setXRotation(toWGS84[3]);
                params.setYRotation(toWGS84[4]);
                params.setZRotation(toWGS84[5]);
                params.setScaleDifference(toWGS84[6]);
            }
        }
    }

    private static void updateDatumTransform(ProjParams params, OperationMethod method) {
        if (method.hasParameters()) {
            for (OperationParameter parameter : method.getParameters()) {
                if (!parameter.hasParameter()) continue;
                switch (parameter.getParameter()) {
                    case X_AXIS_TRANSLATION: {
                        params.setXTranslation(ProjParser.value(parameter, Units.METRE));
                        break;
                    }
                    case Y_AXIS_TRANSLATION: {
                        params.setYTranslation(ProjParser.value(parameter, Units.METRE));
                        break;
                    }
                    case Z_AXIS_TRANSLATION: {
                        params.setZTranslation(ProjParser.value(parameter, Units.METRE));
                        break;
                    }
                    case X_AXIS_ROTATION: {
                        params.setXRotation(ProjParser.value(parameter, Units.ARC_SECOND));
                        break;
                    }
                    case Y_AXIS_ROTATION: {
                        params.setYRotation(ProjParser.value(parameter, Units.ARC_SECOND));
                        break;
                    }
                    case Z_AXIS_ROTATION: {
                        params.setZRotation(ProjParser.value(parameter, Units.ARC_SECOND));
                        break;
                    }
                    case SCALE_DIFFERENCE: {
                        params.setScaleDifference(ProjParser.value(parameter, Units.PARTS_PER_MILLION));
                        break;
                    }
                }
            }
        }
    }

    private static void updatePrimeMeridian(ProjParams params, GeoDatum geoDatum) {
        if (geoDatum.hasPrimeMeridian()) {
            PrimeMeridian primeMeridian = geoDatum.getPrimeMeridian();
            PrimeMeridians commonPrimeMeridian = PrimeMeridians.fromName(primeMeridian.getName());
            if (commonPrimeMeridian != null) {
                if (commonPrimeMeridian != PrimeMeridians.GREENWICH) {
                    params.setPm(commonPrimeMeridian.getName());
                }
            } else {
                params.setPm(ProjParser.convert(primeMeridian.getLongitude(), primeMeridian.getLongitudeText(), primeMeridian.getLongitudeUnit(), Units.DEGREE));
            }
        }
    }

    private static void updateProj(ProjParams params, CoordinateSystem coordinateSystem) {
        Unit unit = coordinateSystem.getAxisUnit();
        if (unit != null && (unit.getType() == UnitType.ANGLEUNIT || unit.getType() == UnitType.UNIT && unit.getName().toLowerCase().startsWith("deg"))) {
            params.setProj("longlat");
        } else {
            params.setProj("merc");
        }
    }

    private static void updateProj(ProjParams params, CoordinateSystem coordinateSystem, MapProjection mapProjection) {
        OperationMethod method = mapProjection.getMethod();
        if (method.hasMethod()) {
            switch (method.getMethod()) {
                case ALBERS_EQUAL_AREA: {
                    params.setProj("aea");
                    break;
                }
                case AMERICAN_POLYCONIC: {
                    params.setProj("poly");
                    break;
                }
                case CASSINI_SOLDNER: {
                    params.setProj("cass");
                    break;
                }
                case EQUIDISTANT_CYLINDRICAL: {
                    params.setProj("eqc");
                    break;
                }
                case HOTINE_OBLIQUE_MERCATOR_A: {
                    params.setNoUoff(true);
                    params.setProj("omerc");
                    break;
                }
                case HOTINE_OBLIQUE_MERCATOR_B: {
                    if (mapProjection.getName().toLowerCase().contains("swiss oblique mercator") || method.getName().toLowerCase().contains("hotine_oblique_mercator_azimuth_center")) {
                        params.setProj("somerc");
                        break;
                    }
                    params.setProj("omerc");
                    break;
                }
                case KROVAK: {
                    params.setProj("krovak");
                    break;
                }
                case LAMBERT_AZIMUTHAL_EQUAL_AREA: {
                    params.setProj("laea");
                    break;
                }
                case LAMBERT_CONIC_CONFORMAL_1SP: 
                case LAMBERT_CONIC_CONFORMAL_2SP: {
                    params.setProj("lcc");
                    break;
                }
                case LAMBERT_CYLINDRICAL_EQUAL_AREA: {
                    params.setProj("cea");
                    break;
                }
                case MERCATOR_A: 
                case MERCATOR_B: {
                    params.setProj("merc");
                    break;
                }
                case NEW_ZEALAND_MAP_GRID: {
                    params.setProj("nzmg");
                    break;
                }
                case OBLIQUE_STEREOGRAPHIC: {
                    params.setProj("sterea");
                    break;
                }
                case POLAR_STEREOGRAPHIC_A: 
                case POLAR_STEREOGRAPHIC_B: 
                case POLAR_STEREOGRAPHIC_C: {
                    params.setProj("stere");
                    break;
                }
                case POPULAR_VISUALISATION_PSEUDO_MERCATOR: {
                    params.setProj("merc");
                    break;
                }
                case TRANSVERSE_MERCATOR: 
                case TRANSVERSE_MERCATOR_SOUTH_ORIENTATED: {
                    if (mapProjection.getName().toLowerCase().contains("utm zone")) {
                        params.setProj("utm");
                        break;
                    }
                    params.setProj("tmerc");
                    break;
                }
            }
            if (params.getProj() != null) {
                ProjParser.updateAxis(params, coordinateSystem);
            }
        }
        if (params.getProj() == null) {
            ProjParser.updateProj(params, coordinateSystem);
        }
    }

    private static void updateUnits(ProjParams params, CoordinateSystem coordinateSystem) {
        Unit unit;
        if (coordinateSystem.hasUnit() && ((unit = coordinateSystem.getUnit()).getType() == UnitType.LENGTHUNIT || unit.getType() == UnitType.UNIT)) {
            Units type = Units.fromUnit(unit);
            if (type != null) {
                switch (type) {
                    case MICROMETRE: 
                    case MILLIMETRE: 
                    case METRE: 
                    case KILOMETRE: {
                        params.setUnits("m");
                        break;
                    }
                    case US_SURVEY_FOOT: {
                        params.setUnits("us-ft");
                        break;
                    }
                    case FOOT: {
                        params.setUnits("ft");
                        break;
                    }
                }
            }
            if (params.getUnits() == null && unit.hasConversionFactor() && unit.getConversionFactor() != 1.0) {
                params.setToMeter(unit.getConversionFactorText());
            }
        }
    }

    private static void updateAxis(ProjParams params, CoordinateSystem coordinateSystem) {
        String axisOrder = ProjParser.convertAxes(coordinateSystem.getAxes());
        params.setAxis(axisOrder);
    }

    private static void updateParams(ProjParams params, MapProjection mapProjection, Unit unit) {
        String name = mapProjection.getName();
        int index = name.toLowerCase().indexOf("utm zone");
        if (index > -1) {
            String utm = name.substring(index + "utm zone".length()).trim();
            String[] parts = utm.split("\\s+");
            boolean south = false;
            if (parts.length > 0 && ((south = (utm = parts[0].toLowerCase()).endsWith("s")) || utm.endsWith("n"))) {
                utm = utm.substring(0, utm.length() - 1);
            }
            Scanner scanner = new Scanner(utm);
            boolean isZone = scanner.hasNextInt();
            scanner.close();
            if (isZone) {
                params.setZone(utm);
                if (south) {
                    params.setSouth(true);
                }
            } else {
                ProjParser.updateParams(params, mapProjection.getMethod(), unit);
            }
        } else {
            ProjParser.updateParams(params, mapProjection.getMethod(), unit);
        }
    }

    private static void updateParams(ProjParams params, OperationMethod method, Unit unit) {
        if (method.hasParameters()) {
            for (OperationParameter parameter : method.getParameters()) {
                ProjParser.updateParams(params, method, unit, parameter);
            }
        }
    }

    private static void updateParams(ProjParams params, OperationMethod method, Unit unit, OperationParameter parameter) {
        if (parameter.hasParameter()) {
            block0 : switch (parameter.getParameter()) {
                case FALSE_EASTING: 
                case EASTING_AT_PROJECTION_CENTRE: 
                case EASTING_AT_FALSE_ORIGIN: {
                    params.setX0(ProjParser.value(parameter, unit, Units.METRE));
                    break;
                }
                case FALSE_NORTHING: 
                case NORTHING_AT_PROJECTION_CENTRE: 
                case NORTHING_AT_FALSE_ORIGIN: {
                    params.setY0(ProjParser.value(parameter, unit, Units.METRE));
                    break;
                }
                case SCALE_FACTOR_AT_NATURAL_ORIGIN: 
                case SCALE_FACTOR_ON_INITIAL_LINE: 
                case SCALE_FACTOR_ON_PSEUDO_STANDARD_PARALLEL: {
                    params.setK0(ProjParser.value(parameter, Units.UNITY));
                    break;
                }
                case LATITUDE_OF_1ST_STANDARD_PARALLEL: {
                    if (method.hasMethod()) {
                        switch (method.getMethod()) {
                            case LAMBERT_CYLINDRICAL_EQUAL_AREA: {
                                params.setLatTs(ProjParser.value(parameter, Units.DEGREE));
                                break block0;
                            }
                        }
                        params.setLat1(ProjParser.value(parameter, Units.DEGREE));
                        break;
                    }
                    params.setLat1(ProjParser.value(parameter, Units.DEGREE));
                    break;
                }
                case LATITUDE_OF_2ND_STANDARD_PARALLEL: {
                    params.setLat2(ProjParser.value(parameter, Units.DEGREE));
                    break;
                }
                case LATITUDE_OF_PROJECTION_CENTRE: 
                case LATITUDE_OF_NATURAL_ORIGIN: 
                case LATITUDE_OF_FALSE_ORIGIN: {
                    if (method.hasMethod()) {
                        switch (method.getMethod()) {
                            case POLAR_STEREOGRAPHIC_A: 
                            case POLAR_STEREOGRAPHIC_B: 
                            case POLAR_STEREOGRAPHIC_C: {
                                params.setLatTs(ProjParser.value(parameter, Units.DEGREE));
                                if (Double.valueOf(params.getLatTs()) >= 0.0) {
                                    params.setLat0("90");
                                    break block0;
                                }
                                params.setLat0("-90");
                                break block0;
                            }
                            case EQUIDISTANT_CYLINDRICAL: {
                                params.setLatTs(ProjParser.value(parameter, Units.DEGREE));
                                params.setLat0("0");
                                break block0;
                            }
                            case LAMBERT_CYLINDRICAL_EQUAL_AREA: 
                            case MERCATOR_A: 
                            case MERCATOR_B: 
                            case POPULAR_VISUALISATION_PSEUDO_MERCATOR: {
                                params.setLatTs(ProjParser.value(parameter, Units.DEGREE));
                                break block0;
                            }
                            case LAMBERT_CONIC_CONFORMAL_1SP: 
                            case LAMBERT_CONIC_CONFORMAL_2SP: {
                                params.setLat0(ProjParser.value(parameter, Units.DEGREE));
                                if (params.getLat1() != null) break block0;
                                params.setLat1(params.getLat0());
                                break block0;
                            }
                        }
                        params.setLat0(ProjParser.value(parameter, Units.DEGREE));
                        break;
                    }
                    params.setLat0(ProjParser.value(parameter, Units.DEGREE));
                    break;
                }
                case LONGITUDE_OF_PROJECTION_CENTRE: 
                case LONGITUDE_OF_NATURAL_ORIGIN: 
                case LONGITUDE_OF_FALSE_ORIGIN: 
                case LONGITUDE_OF_ORIGIN: {
                    if (method.hasMethod()) {
                        switch (method.getMethod()) {
                            case HOTINE_OBLIQUE_MERCATOR_A: {
                                params.setLonc(ProjParser.value(parameter, Units.DEGREE));
                                break block0;
                            }
                            case HOTINE_OBLIQUE_MERCATOR_B: {
                                if (params.getProj() != null && params.getProj().equals("somerc")) {
                                    params.setLon0(ProjParser.value(parameter, Units.DEGREE));
                                    break block0;
                                }
                                params.setLonc(ProjParser.value(parameter, Units.DEGREE));
                                break block0;
                            }
                        }
                        params.setLon0(ProjParser.value(parameter, Units.DEGREE));
                        break;
                    }
                    params.setLon0(ProjParser.value(parameter, Units.DEGREE));
                    break;
                }
                case AZIMUTH_OF_INITIAL_LINE: 
                case CO_LATITUDE_OF_CONE_AXIS: {
                    if (method.hasMethod()) {
                        switch (method.getMethod()) {
                            case HOTINE_OBLIQUE_MERCATOR_B: {
                                if (params.getProj() != null && params.getProj().equals("somerc")) break block0;
                                params.setAlpha(ProjParser.value(parameter, Units.DEGREE));
                                break block0;
                            }
                        }
                        params.setAlpha(ProjParser.value(parameter, Units.DEGREE));
                        break;
                    }
                    params.setAlpha(ProjParser.value(parameter, Units.DEGREE));
                    break;
                }
                case ANGLE_FROM_RECTIFIED_TO_SKEW_GRID: {
                    if (method.hasMethod()) {
                        switch (method.getMethod()) {
                            case HOTINE_OBLIQUE_MERCATOR_B: {
                                if (params.getProj() != null && params.getProj().equals("somerc")) break block0;
                                params.setGamma(ProjParser.value(parameter, Units.DEGREE));
                                break block0;
                            }
                        }
                        params.setGamma(ProjParser.value(parameter, Units.DEGREE));
                        break;
                    }
                    params.setGamma(ProjParser.value(parameter, Units.DEGREE));
                    break;
                }
            }
        }
    }

    private static String convertAxes(List<Axis> axes) {
        String axisValue = null;
        int axesCount = axes.size();
        if (axesCount == 2 || axesCount == 3) {
            StringBuilder axisString = new StringBuilder();
            for (Axis axis : axes) {
                switch (axis.getDirection()) {
                    case EAST: {
                        axisString.append("e");
                        break;
                    }
                    case WEST: {
                        axisString.append("w");
                        break;
                    }
                    case NORTH: {
                        axisString.append("n");
                        break;
                    }
                    case SOUTH: {
                        axisString.append("s");
                        break;
                    }
                    case UP: {
                        axisString.append("u");
                        break;
                    }
                    case DOWN: {
                        axisString.append("d");
                        break;
                    }
                    default: {
                        axisString = null;
                    }
                }
                if (axisString != null) continue;
                break;
            }
            if (axisString != null) {
                if (axesCount == 2) {
                    axisString.append("u");
                }
                axisValue = axisString.toString();
            }
        }
        return axisValue;
    }

    private static String value(OperationParameter parameter, Unit unit, Units inUnit) {
        return ProjParser.value(parameter, unit, inUnit.createUnit());
    }

    private static String value(OperationParameter parameter, Unit unit, Unit inUnit) {
        Unit parameterUnit = parameter.getUnit();
        if (parameterUnit == null) {
            parameterUnit = unit;
        }
        return ProjParser.convert(parameter.getValue(), parameter.getValueText(), parameterUnit, inUnit);
    }

    private static String value(OperationParameter parameter, Units unit) {
        return ProjParser.value(parameter, unit.createUnit());
    }

    private static String value(OperationParameter parameter, Unit unit) {
        return ProjParser.convert(parameter.getValue(), parameter.getValueText(), parameter.getUnit(), unit);
    }

    private static String convert(double value, String textValue, Unit fromUnit, Units toUnit) {
        return ProjParser.convert(value, textValue, fromUnit, toUnit.createUnit());
    }

    private static String convert(double value, String textValue, Unit fromUnit, Unit toUnit) {
        if (fromUnit == null) {
            fromUnit = Units.createDefaultUnit(toUnit.getType());
        }
        if (value != 0.0 && Units.canConvert(fromUnit, toUnit) && !fromUnit.equalsName(toUnit)) {
            value = Units.convert(value, fromUnit, toUnit);
            textValue = String.valueOf(value);
        }
        return textValue;
    }

    private static String paramsText(ProjParams params) {
        String text = null;
        if (params != null) {
            text = params.toString();
        }
        return text;
    }
}

