/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.crs.wkt;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.crs.CRS;
import mil.nga.crs.CRSException;
import mil.nga.crs.CRSType;
import mil.nga.crs.CompoundCoordinateReferenceSystem;
import mil.nga.crs.CoordinateReferenceSystem;
import mil.nga.crs.SimpleCoordinateReferenceSystem;
import mil.nga.crs.bound.AbridgedCoordinateTransformation;
import mil.nga.crs.bound.BoundCoordinateReferenceSystem;
import mil.nga.crs.common.Axis;
import mil.nga.crs.common.AxisDirectionType;
import mil.nga.crs.common.CoordinateSystem;
import mil.nga.crs.common.CoordinateSystemType;
import mil.nga.crs.common.DatumEnsemble;
import mil.nga.crs.common.DatumEnsembleMember;
import mil.nga.crs.common.Dynamic;
import mil.nga.crs.common.Extent;
import mil.nga.crs.common.GeographicBoundingBox;
import mil.nga.crs.common.Identifier;
import mil.nga.crs.common.ReferenceFrame;
import mil.nga.crs.common.ScopeExtentIdentifierRemark;
import mil.nga.crs.common.TemporalExtent;
import mil.nga.crs.common.Unit;
import mil.nga.crs.common.UnitType;
import mil.nga.crs.common.Units;
import mil.nga.crs.common.Usage;
import mil.nga.crs.common.VerticalExtent;
import mil.nga.crs.derived.DerivedCoordinateReferenceSystem;
import mil.nga.crs.derived.DerivingConversion;
import mil.nga.crs.engineering.EngineeringCoordinateReferenceSystem;
import mil.nga.crs.engineering.EngineeringDatum;
import mil.nga.crs.geo.Ellipsoid;
import mil.nga.crs.geo.GeoCoordinateReferenceSystem;
import mil.nga.crs.geo.GeoDatumEnsemble;
import mil.nga.crs.geo.GeoReferenceFrame;
import mil.nga.crs.geo.PrimeMeridian;
import mil.nga.crs.geo.TriaxialEllipsoid;
import mil.nga.crs.metadata.CoordinateMetadata;
import mil.nga.crs.operation.CommonOperation;
import mil.nga.crs.operation.ConcatenatedOperation;
import mil.nga.crs.operation.CoordinateOperation;
import mil.nga.crs.operation.OperationMethod;
import mil.nga.crs.operation.OperationMethods;
import mil.nga.crs.operation.OperationParameter;
import mil.nga.crs.operation.OperationParameters;
import mil.nga.crs.operation.PointMotionOperation;
import mil.nga.crs.parametric.ParametricCoordinateReferenceSystem;
import mil.nga.crs.parametric.ParametricDatum;
import mil.nga.crs.projected.MapProjection;
import mil.nga.crs.projected.ProjectedCoordinateReferenceSystem;
import mil.nga.crs.temporal.TemporalCoordinateReferenceSystem;
import mil.nga.crs.temporal.TemporalDatum;
import mil.nga.crs.vertical.VerticalCoordinateReferenceSystem;
import mil.nga.crs.vertical.VerticalDatumEnsemble;
import mil.nga.crs.vertical.VerticalReferenceFrame;
import mil.nga.crs.wkt.CRSKeyword;
import mil.nga.crs.wkt.TextReader;
import mil.nga.crs.wkt.WKTUtils;

public class CRSReader
implements Closeable {
    private static final Logger logger = Logger.getLogger(CRSReader.class.getName());
    private static final String AXIS_NAME_ABBREV_PATTERN = "((.+ )|^)\\([a-zA-Z]+\\)$";
    private TextReader reader;
    private boolean strict = false;

    public static CRS read(String text) throws IOException {
        return CRSReader.read(text, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CRS read(String text, boolean strict) throws IOException {
        CRS crs = null;
        try (CRSReader reader = new CRSReader(text, strict);){
            crs = reader.read();
            reader.readEnd();
        }
        return crs;
    }

    public static CRS read(String text, CRSType ... expected) throws IOException {
        return CRSReader.read(text, false, expected);
    }

    public static CRS read(String text, boolean strict, CRSType ... expected) throws IOException {
        CRS crs = CRSReader.read(text, strict);
        HashSet<CRSType> expectedSet = new HashSet<CRSType>(Arrays.asList(expected));
        if (!expectedSet.contains((Object)crs.getType())) {
            throw new CRSException("Unexpected Coordinate Reference System Type: " + (Object)((Object)crs.getType()) + ", Expected: " + expectedSet);
        }
        return crs;
    }

    public static CoordinateReferenceSystem readCoordinateReferenceSystem(String text) throws IOException {
        return CRSReader.readCoordinateReferenceSystem(text, false);
    }

    public static CoordinateReferenceSystem readCoordinateReferenceSystem(String text, boolean strict) throws IOException {
        return (CoordinateReferenceSystem)CRSReader.read(text, strict, CRSType.GEODETIC, CRSType.GEOGRAPHIC, CRSType.PROJECTED, CRSType.VERTICAL, CRSType.ENGINEERING, CRSType.PARAMETRIC, CRSType.TEMPORAL, CRSType.DERIVED, CRSType.COMPOUND, CRSType.BOUND);
    }

    public static SimpleCoordinateReferenceSystem readSimpleCoordinateReferenceSystem(String text) throws IOException {
        return CRSReader.readSimpleCoordinateReferenceSystem(text, false);
    }

    public static SimpleCoordinateReferenceSystem readSimpleCoordinateReferenceSystem(String text, boolean strict) throws IOException {
        return (SimpleCoordinateReferenceSystem)CRSReader.read(text, strict, CRSType.GEODETIC, CRSType.GEOGRAPHIC, CRSType.PROJECTED, CRSType.VERTICAL, CRSType.ENGINEERING, CRSType.PARAMETRIC, CRSType.TEMPORAL, CRSType.DERIVED);
    }

    public static GeoCoordinateReferenceSystem readGeo(String text) throws IOException {
        return (GeoCoordinateReferenceSystem)CRSReader.read(text, CRSType.GEODETIC, CRSType.GEOGRAPHIC);
    }

    public static GeoCoordinateReferenceSystem readGeodetic(String text) throws IOException {
        return (GeoCoordinateReferenceSystem)CRSReader.read(text, CRSType.GEODETIC);
    }

    public static GeoCoordinateReferenceSystem readGeographic(String text) throws IOException {
        return (GeoCoordinateReferenceSystem)CRSReader.read(text, CRSType.GEOGRAPHIC);
    }

    public static ProjectedCoordinateReferenceSystem readProjected(String text) throws IOException {
        ProjectedCoordinateReferenceSystem crs = null;
        try (CRSReader reader = new CRSReader(text);){
            crs = reader.readProjected();
            reader.readEnd();
        }
        return crs;
    }

    public static ProjectedCoordinateReferenceSystem readProjectedGeodetic(String text) throws IOException {
        ProjectedCoordinateReferenceSystem crs = null;
        try (CRSReader reader = new CRSReader(text);){
            crs = reader.readProjectedGeodetic();
            reader.readEnd();
        }
        return crs;
    }

    public static ProjectedCoordinateReferenceSystem readProjectedGeographic(String text) throws IOException {
        ProjectedCoordinateReferenceSystem crs = null;
        try (CRSReader reader = new CRSReader(text);){
            crs = reader.readProjectedGeographic();
            reader.readEnd();
        }
        return crs;
    }

    public static VerticalCoordinateReferenceSystem readVertical(String text) throws IOException {
        return (VerticalCoordinateReferenceSystem)CRSReader.read(text, CRSType.VERTICAL);
    }

    public static EngineeringCoordinateReferenceSystem readEngineering(String text) throws IOException {
        return (EngineeringCoordinateReferenceSystem)CRSReader.read(text, CRSType.ENGINEERING);
    }

    public static ParametricCoordinateReferenceSystem readParametric(String text) throws IOException {
        return (ParametricCoordinateReferenceSystem)CRSReader.read(text, CRSType.PARAMETRIC);
    }

    public static TemporalCoordinateReferenceSystem readTemporal(String text) throws IOException {
        return (TemporalCoordinateReferenceSystem)CRSReader.read(text, CRSType.TEMPORAL);
    }

    public static DerivedCoordinateReferenceSystem readDerived(String text) throws IOException {
        return (DerivedCoordinateReferenceSystem)CRSReader.read(text, CRSType.DERIVED);
    }

    public static CompoundCoordinateReferenceSystem readCompound(String text) throws IOException {
        CompoundCoordinateReferenceSystem crs = null;
        try (CRSReader reader = new CRSReader(text);){
            crs = reader.readCompound();
            reader.readEnd();
        }
        return crs;
    }

    public static CoordinateMetadata readCoordinateMetadata(String text) throws IOException {
        CoordinateMetadata metadata = null;
        try (CRSReader reader = new CRSReader(text);){
            metadata = reader.readCoordinateMetadata();
            reader.readEnd();
        }
        return metadata;
    }

    public static CoordinateOperation readCoordinateOperation(String text) throws IOException {
        CoordinateOperation operation = null;
        try (CRSReader reader = new CRSReader(text);){
            operation = reader.readCoordinateOperation();
            reader.readEnd();
        }
        return operation;
    }

    public static PointMotionOperation readPointMotionOperation(String text) throws IOException {
        PointMotionOperation operation = null;
        try (CRSReader reader = new CRSReader(text);){
            operation = reader.readPointMotionOperation();
            reader.readEnd();
        }
        return operation;
    }

    public static ConcatenatedOperation readConcatenatedOperation(String text) throws IOException {
        ConcatenatedOperation operation = null;
        try (CRSReader reader = new CRSReader(text);){
            operation = reader.readConcatenatedOperation();
            reader.readEnd();
        }
        return operation;
    }

    public static BoundCoordinateReferenceSystem readBound(String text) throws IOException {
        BoundCoordinateReferenceSystem crs = null;
        try (CRSReader reader = new CRSReader(text);){
            crs = reader.readBound();
            reader.readEnd();
        }
        return crs;
    }

    public static GeoCoordinateReferenceSystem readGeoCompat(String text) throws IOException {
        GeoCoordinateReferenceSystem crs = null;
        try (CRSReader reader = new CRSReader(text);){
            crs = reader.readGeoCompat();
            reader.readEnd();
        }
        return crs;
    }

    public static GeoCoordinateReferenceSystem readGeodeticCompat(String text) throws IOException {
        GeoCoordinateReferenceSystem crs = null;
        try (CRSReader reader = new CRSReader(text);){
            crs = reader.readGeodeticCompat();
            reader.readEnd();
        }
        return crs;
    }

    public static GeoCoordinateReferenceSystem readGeographicCompat(String text) throws IOException {
        GeoCoordinateReferenceSystem crs = null;
        try (CRSReader reader = new CRSReader(text);){
            crs = reader.readGeographicCompat();
            reader.readEnd();
        }
        return crs;
    }

    public static ProjectedCoordinateReferenceSystem readProjectedCompat(String text) throws IOException {
        ProjectedCoordinateReferenceSystem crs = null;
        try (CRSReader reader = new CRSReader(text);){
            crs = reader.readProjectedCompat();
            reader.readEnd();
        }
        return crs;
    }

    public static ProjectedCoordinateReferenceSystem readProjectedGeodeticCompat(String text) throws IOException {
        ProjectedCoordinateReferenceSystem crs = null;
        try (CRSReader reader = new CRSReader(text);){
            crs = reader.readProjectedGeodeticCompat();
            reader.readEnd();
        }
        return crs;
    }

    public static ProjectedCoordinateReferenceSystem readProjectedGeographicCompat(String text) throws IOException {
        ProjectedCoordinateReferenceSystem crs = null;
        try (CRSReader reader = new CRSReader(text);){
            crs = reader.readProjectedGeographicCompat();
            reader.readEnd();
        }
        return crs;
    }

    public CRSReader(String text) {
        this(new TextReader(text));
    }

    public CRSReader(TextReader reader) {
        this(reader, false);
    }

    public CRSReader(String text, boolean strict) {
        this(new TextReader(text), strict);
    }

    public CRSReader(TextReader reader, boolean strict) {
        this.reader = reader;
        this.strict = strict;
    }

    public TextReader getTextReader() {
        return this.reader;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void reset() throws IOException {
        this.reader.reset();
    }

    @Override
    public void close() {
        this.reader.close();
    }

    public CRS read() throws IOException {
        CRS crs = null;
        CRSKeyword keyword = this.peekKeyword();
        switch (keyword) {
            case GEODCRS: 
            case GEOGCRS: {
                crs = this.readGeo();
                break;
            }
            case GEOCCS: 
            case GEOGCS: {
                crs = this.readGeoCompat();
                break;
            }
            case PROJCRS: {
                crs = this.readProjected();
                break;
            }
            case PROJCS: {
                crs = this.readProjectedCompat();
                break;
            }
            case VERTCRS: {
                crs = this.readVertical();
                break;
            }
            case VERT_CS: {
                crs = this.readVerticalCompat();
                break;
            }
            case ENGCRS: {
                crs = this.readEngineering();
                break;
            }
            case LOCAL_CS: {
                crs = this.readEngineeringCompat();
                break;
            }
            case PARAMETRICCRS: {
                crs = this.readParametric();
                break;
            }
            case TIMECRS: {
                crs = this.readTemporal();
                break;
            }
            case DERIVEDPROJCRS: {
                crs = this.readDerivedProjected();
                break;
            }
            case COMPOUNDCRS: {
                crs = this.readCompound();
                break;
            }
            case COORDINATEMETADATA: {
                crs = this.readCoordinateMetadata();
                break;
            }
            case COORDINATEOPERATION: {
                crs = this.readCoordinateOperation();
                break;
            }
            case POINTMOTIONOPERATION: {
                crs = this.readPointMotionOperation();
                break;
            }
            case CONCATENATEDOPERATION: {
                crs = this.readConcatenatedOperation();
                break;
            }
            case BOUNDCRS: {
                crs = this.readBound();
                break;
            }
            default: {
                throw new CRSException("Unsupported WKT CRS keyword: " + (Object)((Object)keyword));
            }
        }
        return crs;
    }

    public CoordinateReferenceSystem readCoordinateReferenceSystem() throws IOException {
        CRS crs = this.read();
        if (!(crs instanceof CoordinateReferenceSystem)) {
            throw new CRSException("Unexpected Coordinate Reference System Type: " + (Object)((Object)crs.getType()));
        }
        return (CoordinateReferenceSystem)crs;
    }

    public SimpleCoordinateReferenceSystem readSimpleCoordinateReferenceSystem() throws IOException {
        CRS crs = this.read();
        if (!(crs instanceof SimpleCoordinateReferenceSystem)) {
            throw new CRSException("Unexpected Simple Coordinate Reference System Type: " + (Object)((Object)crs.getType()));
        }
        return (SimpleCoordinateReferenceSystem)crs;
    }

    public CRSKeyword readKeyword() throws IOException {
        return CRSKeyword.getRequiredType(this.reader.readToken());
    }

    public Set<CRSKeyword> readKeywords() throws IOException {
        return CRSKeyword.getRequiredTypes(this.reader.readToken());
    }

    public CRSKeyword readKeyword(CRSKeyword ... keywords) throws IOException {
        return this.readKeyword(true, keywords);
    }

    public CRSKeyword readToKeyword(CRSKeyword ... keywords) throws IOException {
        CRSKeyword keyword = this.readKeyword(false, keywords);
        if (keyword != null) {
            this.reader.pushToken(keyword.name());
        }
        return keyword;
    }

    public CRSKeyword readKeyword(boolean required, CRSKeyword ... keywords) throws IOException {
        CRSKeyword keyword = null;
        HashSet<CRSKeyword> keywordSet = new HashSet<CRSKeyword>(Arrays.asList(keywords));
        int delimiterCount = 0;
        String previousToken = null;
        String token = this.reader.readToken();
        StringBuilder ignored = null;
        while (token != null) {
            Set<CRSKeyword> tokenKeywords;
            if (!required) {
                if (WKTUtils.isLeftDelimiter(token)) {
                    ++delimiterCount;
                } else if (WKTUtils.isRightDelimiter(token) && --delimiterCount < 0) {
                    this.reader.pushToken(token);
                    break;
                }
            }
            if ((tokenKeywords = CRSKeyword.getTypes(token)) != null) {
                for (CRSKeyword kw : tokenKeywords) {
                    if (!keywordSet.contains((Object)kw)) continue;
                    keyword = kw;
                    break;
                }
                if (keyword != null) break;
            }
            if (previousToken != null) {
                if (ignored == null) {
                    ignored = new StringBuilder();
                }
                ignored.append(previousToken);
            }
            previousToken = token;
            token = this.reader.readToken();
        }
        if (required && keyword == null) {
            throw new CRSException("Expected keyword not found: " + this.keywordNames(keywordSet));
        }
        if (!(previousToken == null || keyword != null && previousToken.equals(","))) {
            if (ignored == null) {
                ignored = new StringBuilder();
            }
            ignored.append(previousToken);
        }
        if (ignored != null) {
            StringBuilder log = new StringBuilder();
            if (this.strict) {
                log.append("Unexpected");
            } else {
                log.append("Ignored");
            }
            if (keyword != null) {
                log.append(" before ");
                log.append(keyword.getKeywords());
            }
            log.append(": \"");
            log.append((CharSequence)ignored);
            log.append("\"");
            if (this.strict) {
                throw new CRSException(log.toString());
            }
            logger.log(Level.WARNING, log.toString());
        }
        return keyword;
    }

    public CRSKeyword peekKeyword() throws IOException {
        return CRSKeyword.getRequiredType(this.reader.peekToken());
    }

    public Set<CRSKeyword> peekKeywords() throws IOException {
        return CRSKeyword.getRequiredTypes(this.reader.peekToken());
    }

    public CRSKeyword peekOptionalKeyword() throws IOException {
        return CRSKeyword.getType(this.reader.peekToken());
    }

    public Set<CRSKeyword> peekOptionalKeywords() throws IOException {
        return CRSKeyword.getTypes(this.reader.peekToken());
    }

    public CRSKeyword peekOptionalKeyword(int num) throws IOException {
        return CRSKeyword.getType(this.reader.peekToken(num));
    }

    public Set<CRSKeyword> peekOptionalKeywords(int num) throws IOException {
        return CRSKeyword.getTypes(this.reader.peekToken(num));
    }

    public void readLeftDelimiter() throws IOException {
        String token = this.reader.readExpectedToken();
        if (!WKTUtils.isLeftDelimiter(token)) {
            throw new CRSException("Invalid left delimiter token, expected '[' or '('. found: '" + token + "'");
        }
    }

    public boolean peekLeftDelimiter() throws IOException {
        boolean leftDelimiter = false;
        String token = this.reader.peekToken();
        if (token != null) {
            leftDelimiter = WKTUtils.isLeftDelimiter(token);
        }
        return leftDelimiter;
    }

    public void readRightDelimiter() throws IOException {
        this.readKeyword(false, new CRSKeyword[0]);
        String token = this.reader.readExpectedToken();
        if (!WKTUtils.isRightDelimiter(token)) {
            throw new CRSException("Invalid right delimiter token, expected ']' or ')'. found: '" + token + "'");
        }
    }

    public boolean peekRightDelimiter() throws IOException {
        boolean rightDelimiter = false;
        String token = this.reader.peekToken();
        if (token != null) {
            rightDelimiter = WKTUtils.isRightDelimiter(token);
        }
        return rightDelimiter;
    }

    public void readSeparator() throws IOException {
        String token = this.reader.peekToken();
        if (token.equals(",")) {
            this.reader.readExpectedToken();
        } else {
            if (this.strict) {
                throw new CRSException("Invalid separator token, expected ','. found: '" + token + "'");
            }
            logger.log(Level.WARNING, "Missing expected separator before token: '" + token + "'");
        }
    }

    public boolean peekSeparator() throws IOException {
        boolean separator = false;
        String token = this.reader.peekToken();
        if (token != null) {
            separator = token.equals(",");
        }
        return separator;
    }

    public void readEnd() throws IOException {
        String token = this.reader.readToken();
        if (token != null) {
            StringBuilder ignored = new StringBuilder();
            do {
                ignored.append(token);
            } while ((token = this.reader.readToken()) != null);
            StringBuilder log = new StringBuilder();
            if (this.strict) {
                log.append("Unexpected");
            } else {
                log.append("Ignored");
            }
            log.append(" end: \"");
            log.append((CharSequence)ignored);
            log.append("\"");
            if (this.strict) {
                throw new CRSException(log.toString());
            }
            logger.log(Level.WARNING, log.toString());
        }
    }

    public String readKeywordDelimitedToken(CRSKeyword keyword) throws IOException {
        this.readKeyword(keyword);
        this.readLeftDelimiter();
        String token = this.reader.readExpectedToken();
        this.readRightDelimiter();
        return token;
    }

    private CRSKeyword validateKeyword(Set<CRSKeyword> keywords, CRSKeyword ... expected) {
        CRSKeyword keyword = null;
        HashSet<CRSKeyword> expectedSet = new HashSet<CRSKeyword>(Arrays.asList(expected));
        for (CRSKeyword kw : keywords) {
            if (!expectedSet.contains((Object)kw)) continue;
            keyword = kw;
            break;
        }
        if (keyword == null) {
            throw new CRSException("Unexpected keyword. found: " + this.keywordNames(keywords) + ", expected: " + this.keywordNames(expectedSet));
        }
        return keyword;
    }

    private Set<String> keywordNames(Set<CRSKeyword> keywords) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (CRSKeyword keyword : keywords) {
            names.addAll(keyword.getKeywords());
        }
        return names;
    }

    private boolean isKeywordNext(CRSKeyword ... keywords) throws IOException {
        int num;
        Set<CRSKeyword> nextKeywords;
        boolean next = false;
        boolean separator = this.peekSeparator();
        if (!(!separator && this.strict || (nextKeywords = this.peekOptionalKeywords(num = separator ? 2 : 1)) == null || nextKeywords.isEmpty())) {
            CRSKeyword keyword;
            CRSKeyword[] cRSKeywordArray = keywords;
            int n = cRSKeywordArray.length;
            for (int i = 0; i < n && !(next = nextKeywords.contains((Object)(keyword = cRSKeywordArray[i]))); ++i) {
            }
        }
        return next;
    }

    private boolean isNonKeywordNext() throws IOException {
        boolean next = false;
        if (this.peekSeparator()) {
            Set<CRSKeyword> nextKeywords = this.peekOptionalKeywords(2);
            next = nextKeywords == null || nextKeywords.isEmpty();
        }
        return next;
    }

    private boolean isUnitNext() throws IOException {
        return this.isKeywordNext(CRSKeyword.ANGLEUNIT, CRSKeyword.LENGTHUNIT, CRSKeyword.PARAMETRICUNIT, CRSKeyword.SCALEUNIT, CRSKeyword.TIMEUNIT);
    }

    private boolean isSpatialUnitNext() throws IOException {
        return this.isKeywordNext(CRSKeyword.ANGLEUNIT, CRSKeyword.LENGTHUNIT, CRSKeyword.PARAMETRICUNIT, CRSKeyword.SCALEUNIT);
    }

    private boolean isTimeUnitNext() throws IOException {
        return this.isKeywordNext(CRSKeyword.TIMEUNIT);
    }

    public CoordinateReferenceSystem readGeo() throws IOException {
        GeoCoordinateReferenceSystem baseCrs = new GeoCoordinateReferenceSystem();
        SimpleCoordinateReferenceSystem crs = baseCrs;
        DerivedCoordinateReferenceSystem derivedCrs = null;
        CRSKeyword keyword = this.readKeyword(CRSKeyword.GEODCRS, CRSKeyword.GEOGCRS);
        crs.setType(WKTUtils.getCoordinateReferenceSystemType(keyword));
        this.readLeftDelimiter();
        String name = this.reader.readExpectedToken();
        if (this.isKeywordNext(CRSKeyword.BASEGEODCRS, CRSKeyword.BASEGEOGCRS)) {
            switch (keyword) {
                case GEODCRS: {
                    this.readKeyword(CRSKeyword.BASEGEODCRS);
                    break;
                }
                case GEOGCRS: {
                    this.readKeyword(CRSKeyword.BASEGEOGCRS);
                    break;
                }
                default: {
                    throw new CRSException("Unsupported Coordinate Reference System Type: " + (Object)((Object)keyword));
                }
            }
            derivedCrs = new DerivedCoordinateReferenceSystem();
            derivedCrs.setBase(baseCrs);
            crs = derivedCrs;
            this.readLeftDelimiter();
            baseCrs.setName(this.reader.readExpectedToken());
        }
        crs.setName(name);
        boolean isDynamic = this.isKeywordNext(CRSKeyword.DYNAMIC);
        if (isDynamic) {
            this.readSeparator();
            baseCrs.setDynamic(this.readDynamic());
        }
        if (isDynamic || this.isKeywordNext(CRSKeyword.DATUM)) {
            this.readSeparator();
            GeoReferenceFrame referenceFrame = this.readGeoReferenceFrame(crs);
            referenceFrame.setType(baseCrs.getType());
            baseCrs.setReferenceFrame(referenceFrame);
        } else if (this.isKeywordNext(CRSKeyword.ENSEMBLE)) {
            this.readSeparator();
            baseCrs.setDatumEnsemble(this.readGeoDatumEnsemble());
        } else {
            this.readSeparator();
            this.readKeyword(CRSKeyword.DATUM, CRSKeyword.ENSEMBLE);
        }
        if (derivedCrs != null) {
            keyword = this.readToKeyword(CRSKeyword.ID);
            if (keyword == CRSKeyword.ID) {
                baseCrs.setIdentifiers(this.readIdentifiers());
            }
            this.readRightDelimiter();
            this.readSeparator();
            derivedCrs.setConversion(this.readDerivingConversion());
        }
        this.readSeparator();
        crs.setCoordinateSystem(this.readCoordinateSystem());
        this.readScopeExtentIdentifierRemark(crs);
        this.readRightDelimiter();
        return crs;
    }

    public ProjectedCoordinateReferenceSystem readProjected() throws IOException {
        CRSType expectedType = null;
        return this.readProjected(expectedType);
    }

    public ProjectedCoordinateReferenceSystem readProjectedGeodetic() throws IOException {
        return this.readProjected(CRSType.GEODETIC);
    }

    public ProjectedCoordinateReferenceSystem readProjectedGeographic() throws IOException {
        return this.readProjected(CRSType.GEOGRAPHIC);
    }

    public ProjectedCoordinateReferenceSystem readProjected(CRSType expectedBaseType) throws IOException {
        ProjectedCoordinateReferenceSystem crs = new ProjectedCoordinateReferenceSystem();
        this.readKeyword(CRSKeyword.PROJCRS);
        this.readLeftDelimiter();
        crs.setName(this.reader.readExpectedToken());
        this.readSeparator();
        CRSKeyword type = this.readKeyword(CRSKeyword.BASEGEODCRS, CRSKeyword.BASEGEOGCRS);
        CRSType crsType = WKTUtils.getCoordinateReferenceSystemType(type);
        if (expectedBaseType != null && crsType != expectedBaseType) {
            throw new CRSException("Unexpected Base Coordinate Reference System Type. expected: " + (Object)((Object)expectedBaseType) + ", found: " + (Object)((Object)crsType));
        }
        crs.setBaseType(crsType);
        this.readLeftDelimiter();
        crs.setBaseName(this.reader.readExpectedToken());
        boolean isDynamic = this.isKeywordNext(CRSKeyword.DYNAMIC);
        if (isDynamic) {
            this.readSeparator();
            crs.setDynamic(this.readDynamic());
        }
        if (isDynamic || this.isKeywordNext(CRSKeyword.DATUM)) {
            this.readSeparator();
            GeoReferenceFrame referenceFrame = this.readGeoReferenceFrame(crs);
            referenceFrame.setType(crsType);
            crs.setReferenceFrame(referenceFrame);
        } else if (this.isKeywordNext(CRSKeyword.ENSEMBLE)) {
            this.readSeparator();
            crs.setDatumEnsemble(this.readGeoDatumEnsemble());
        } else {
            this.readSeparator();
            this.readKeyword(CRSKeyword.DATUM, CRSKeyword.ENSEMBLE);
        }
        CRSKeyword keyword = this.readToKeyword(CRSKeyword.ANGLEUNIT, CRSKeyword.ID);
        if (keyword == CRSKeyword.ANGLEUNIT) {
            crs.setUnit(this.readAngleUnit());
            keyword = this.readToKeyword(CRSKeyword.ID);
        }
        if (keyword == CRSKeyword.ID) {
            crs.setBaseIdentifiers(this.readIdentifiers());
        }
        this.readRightDelimiter();
        this.readSeparator();
        crs.setMapProjection(this.readMapProjection());
        this.readSeparator();
        crs.setCoordinateSystem(this.readCoordinateSystem());
        this.readScopeExtentIdentifierRemark(crs);
        this.readRightDelimiter();
        return crs;
    }

    public CoordinateReferenceSystem readVertical() throws IOException {
        CRSKeyword keyword;
        VerticalCoordinateReferenceSystem baseCrs = new VerticalCoordinateReferenceSystem();
        SimpleCoordinateReferenceSystem crs = baseCrs;
        DerivedCoordinateReferenceSystem derivedCrs = null;
        this.readKeyword(CRSKeyword.VERTCRS);
        this.readLeftDelimiter();
        String name = this.reader.readExpectedToken();
        if (this.isKeywordNext(CRSKeyword.BASEVERTCRS)) {
            this.readKeyword(CRSKeyword.BASEVERTCRS);
            derivedCrs = new DerivedCoordinateReferenceSystem();
            derivedCrs.setBase(baseCrs);
            crs = derivedCrs;
            this.readLeftDelimiter();
            baseCrs.setName(this.reader.readExpectedToken());
        }
        crs.setName(name);
        boolean isDynamic = this.isKeywordNext(CRSKeyword.DYNAMIC);
        if (isDynamic) {
            this.readSeparator();
            baseCrs.setDynamic(this.readDynamic());
        }
        if (isDynamic || this.isKeywordNext(CRSKeyword.VDATUM)) {
            this.readSeparator();
            baseCrs.setReferenceFrame(this.readVerticalReferenceFrame(crs));
        } else if (this.isKeywordNext(CRSKeyword.ENSEMBLE)) {
            this.readSeparator();
            baseCrs.setDatumEnsemble(this.readVerticalDatumEnsemble());
        } else {
            this.readSeparator();
            this.readKeyword(CRSKeyword.VDATUM, CRSKeyword.ENSEMBLE);
        }
        if (derivedCrs != null) {
            keyword = this.readToKeyword(CRSKeyword.ID);
            if (keyword == CRSKeyword.ID) {
                baseCrs.setIdentifiers(this.readIdentifiers());
            }
            this.readRightDelimiter();
            this.readSeparator();
            derivedCrs.setConversion(this.readDerivingConversion());
        }
        this.readSeparator();
        crs.setCoordinateSystem(this.readCoordinateSystem());
        if (derivedCrs == null && this.isKeywordNext(CRSKeyword.GEOIDMODEL)) {
            this.readSeparator();
            this.readKeyword(CRSKeyword.GEOIDMODEL);
            this.readLeftDelimiter();
            baseCrs.setGeoidModelName(this.reader.readExpectedToken());
            keyword = this.readToKeyword(CRSKeyword.ID);
            if (keyword == CRSKeyword.ID) {
                baseCrs.setGeoidModelIdentifier(this.readIdentifier());
            }
            this.readRightDelimiter();
        }
        this.readScopeExtentIdentifierRemark(crs);
        this.readRightDelimiter();
        return crs;
    }

    public CoordinateReferenceSystem readEngineering() throws IOException {
        EngineeringCoordinateReferenceSystem baseCrs;
        SimpleCoordinateReferenceSystem crs = baseCrs = new EngineeringCoordinateReferenceSystem();
        DerivedCoordinateReferenceSystem derivedCrs = null;
        this.readKeyword(CRSKeyword.ENGCRS);
        this.readLeftDelimiter();
        String name = this.reader.readExpectedToken();
        if (this.isKeywordNext(CRSKeyword.BASEENGCRS)) {
            this.readKeyword(CRSKeyword.BASEENGCRS);
            derivedCrs = new DerivedCoordinateReferenceSystem();
            derivedCrs.setBase(baseCrs);
            crs = derivedCrs;
            this.readLeftDelimiter();
            baseCrs.setName(this.reader.readExpectedToken());
        }
        crs.setName(name);
        this.readSeparator();
        baseCrs.setDatum(this.readEngineeringDatum(crs));
        if (derivedCrs != null) {
            CRSKeyword keyword = this.readToKeyword(CRSKeyword.ID);
            if (keyword == CRSKeyword.ID) {
                baseCrs.setIdentifiers(this.readIdentifiers());
            }
            this.readRightDelimiter();
            this.readSeparator();
            derivedCrs.setConversion(this.readDerivingConversion());
        }
        this.readSeparator();
        crs.setCoordinateSystem(this.readCoordinateSystem());
        this.readScopeExtentIdentifierRemark(crs);
        this.readRightDelimiter();
        return crs;
    }

    public CoordinateReferenceSystem readParametric() throws IOException {
        ParametricCoordinateReferenceSystem baseCrs;
        SimpleCoordinateReferenceSystem crs = baseCrs = new ParametricCoordinateReferenceSystem();
        DerivedCoordinateReferenceSystem derivedCrs = null;
        this.readKeyword(CRSKeyword.PARAMETRICCRS);
        this.readLeftDelimiter();
        String name = this.reader.readExpectedToken();
        if (this.isKeywordNext(CRSKeyword.BASEPARAMCRS)) {
            this.readKeyword(CRSKeyword.BASEPARAMCRS);
            derivedCrs = new DerivedCoordinateReferenceSystem();
            derivedCrs.setBase(baseCrs);
            crs = derivedCrs;
            this.readLeftDelimiter();
            baseCrs.setName(this.reader.readExpectedToken());
        }
        crs.setName(name);
        this.readSeparator();
        baseCrs.setDatum(this.readParametricDatum(crs));
        if (derivedCrs != null) {
            CRSKeyword keyword = this.readToKeyword(CRSKeyword.ID);
            if (keyword == CRSKeyword.ID) {
                baseCrs.setIdentifiers(this.readIdentifiers());
            }
            this.readRightDelimiter();
            this.readSeparator();
            derivedCrs.setConversion(this.readDerivingConversion());
        }
        this.readSeparator();
        crs.setCoordinateSystem(this.readCoordinateSystem());
        this.readScopeExtentIdentifierRemark(crs);
        this.readRightDelimiter();
        return crs;
    }

    public CoordinateReferenceSystem readTemporal() throws IOException {
        TemporalCoordinateReferenceSystem baseCrs;
        SimpleCoordinateReferenceSystem crs = baseCrs = new TemporalCoordinateReferenceSystem();
        DerivedCoordinateReferenceSystem derivedCrs = null;
        this.readKeyword(CRSKeyword.TIMECRS);
        this.readLeftDelimiter();
        String name = this.reader.readExpectedToken();
        if (this.isKeywordNext(CRSKeyword.BASETIMECRS)) {
            this.readKeyword(CRSKeyword.BASETIMECRS);
            derivedCrs = new DerivedCoordinateReferenceSystem();
            derivedCrs.setBase(baseCrs);
            crs = derivedCrs;
            this.readLeftDelimiter();
            baseCrs.setName(this.reader.readExpectedToken());
        }
        crs.setName(name);
        this.readSeparator();
        baseCrs.setDatum(this.readTemporalDatum());
        if (derivedCrs != null) {
            CRSKeyword keyword = this.readToKeyword(CRSKeyword.ID);
            if (keyword == CRSKeyword.ID) {
                baseCrs.setIdentifiers(this.readIdentifiers());
            }
            this.readRightDelimiter();
            this.readSeparator();
            derivedCrs.setConversion(this.readDerivingConversion());
        }
        this.readSeparator();
        crs.setCoordinateSystem(this.readCoordinateSystem());
        this.readScopeExtentIdentifierRemark(crs);
        this.readRightDelimiter();
        return crs;
    }

    public DerivedCoordinateReferenceSystem readDerivedProjected() throws IOException {
        DerivedCoordinateReferenceSystem crs = new DerivedCoordinateReferenceSystem();
        ProjectedCoordinateReferenceSystem projectedCrs = new ProjectedCoordinateReferenceSystem();
        crs.setBase(projectedCrs);
        this.readKeyword(CRSKeyword.DERIVEDPROJCRS);
        this.readLeftDelimiter();
        crs.setName(this.reader.readExpectedToken());
        this.readSeparator();
        this.readKeyword(CRSKeyword.BASEPROJCRS);
        this.readLeftDelimiter();
        projectedCrs.setName(this.reader.readExpectedToken());
        this.readSeparator();
        CRSKeyword keyword = this.readKeyword(CRSKeyword.BASEGEODCRS, CRSKeyword.BASEGEOGCRS);
        projectedCrs.setBaseType(WKTUtils.getCoordinateReferenceSystemType(keyword));
        this.readLeftDelimiter();
        projectedCrs.setBaseName(this.reader.readExpectedToken());
        boolean isDynamic = this.isKeywordNext(CRSKeyword.DYNAMIC);
        if (isDynamic) {
            this.readSeparator();
            projectedCrs.setDynamic(this.readDynamic());
        }
        if (isDynamic || this.isKeywordNext(CRSKeyword.DATUM)) {
            this.readSeparator();
            GeoReferenceFrame referenceFrame = this.readGeoReferenceFrame(crs);
            referenceFrame.setType(projectedCrs.getBaseType());
            projectedCrs.setReferenceFrame(referenceFrame);
        } else if (this.isKeywordNext(CRSKeyword.ENSEMBLE)) {
            this.readSeparator();
            projectedCrs.setDatumEnsemble(this.readGeoDatumEnsemble());
        } else {
            this.readSeparator();
            this.readKeyword(CRSKeyword.DATUM, CRSKeyword.ENSEMBLE);
        }
        keyword = this.readToKeyword(CRSKeyword.ID);
        if (keyword == CRSKeyword.ID) {
            projectedCrs.setBaseIdentifiers(this.readIdentifiers());
        }
        this.readRightDelimiter();
        this.readSeparator();
        projectedCrs.setMapProjection(this.readMapProjection());
        keyword = this.readToKeyword(CRSKeyword.ID);
        if (keyword == CRSKeyword.ID) {
            projectedCrs.setIdentifiers(this.readIdentifiers());
        }
        this.readRightDelimiter();
        this.readSeparator();
        crs.setConversion(this.readDerivingConversion());
        this.readSeparator();
        crs.setCoordinateSystem(this.readCoordinateSystem());
        this.readScopeExtentIdentifierRemark(crs);
        this.readRightDelimiter();
        return crs;
    }

    public CompoundCoordinateReferenceSystem readCompound() throws IOException {
        CompoundCoordinateReferenceSystem crs = new CompoundCoordinateReferenceSystem();
        this.readKeyword(CRSKeyword.COMPOUNDCRS);
        this.readLeftDelimiter();
        crs.setName(this.reader.readExpectedToken());
        while (this.isKeywordNext(CRSKeyword.GEODCRS, CRSKeyword.GEOGCRS, CRSKeyword.GEOCCS, CRSKeyword.GEOGCS, CRSKeyword.PROJCRS, CRSKeyword.PROJCS, CRSKeyword.VERTCRS, CRSKeyword.VERT_CS, CRSKeyword.ENGCRS, CRSKeyword.LOCAL_CS, CRSKeyword.PARAMETRICCRS, CRSKeyword.TIMECRS, CRSKeyword.DERIVEDPROJCRS)) {
            this.readSeparator();
            crs.addCoordinateReferenceSystem(this.readSimpleCoordinateReferenceSystem());
        }
        this.readScopeExtentIdentifierRemark(crs);
        this.readRightDelimiter();
        if (crs.numCoordinateReferenceSystems() < 2) {
            String message = "Compound Coordinate Reference System requires at least two Coordinate Reference Systems";
            if (this.strict) {
                throw new CRSException(message);
            }
            logger.log(Level.WARNING, message);
        }
        return crs;
    }

    public CoordinateMetadata readCoordinateMetadata() throws IOException {
        CoordinateMetadata metadata = new CoordinateMetadata();
        this.readKeyword(CRSKeyword.COORDINATEMETADATA);
        this.readLeftDelimiter();
        metadata.setCoordinateReferenceSystem(this.readCoordinateReferenceSystem());
        if (this.isKeywordNext(CRSKeyword.EPOCH)) {
            this.readSeparator();
            this.readKeyword(CRSKeyword.EPOCH);
            this.readLeftDelimiter();
            metadata.setEpoch(this.reader.readExpectedToken());
            this.validateUnsignedDouble(metadata.getEpoch());
            this.readRightDelimiter();
        }
        this.readRightDelimiter();
        return metadata;
    }

    public CoordinateOperation readCoordinateOperation() throws IOException {
        CoordinateOperation operation = new CoordinateOperation();
        this.readKeyword(CRSKeyword.COORDINATEOPERATION);
        this.readLeftDelimiter();
        operation.setName(this.reader.readExpectedToken());
        if (this.isKeywordNext(CRSKeyword.VERSION)) {
            this.readSeparator();
            operation.setVersion(this.readVersion());
        }
        this.readSeparator();
        operation.setSource(this.readSource());
        this.readSeparator();
        operation.setTarget(this.readTarget());
        this.readSeparator();
        OperationMethod method = this.readMethod();
        operation.setMethod(method);
        if (this.isKeywordNext(CRSKeyword.PARAMETER, CRSKeyword.PARAMETERFILE)) {
            this.readSeparator();
            method.setParameters(this.readCoordinateOperationParameters());
        }
        if (this.isKeywordNext(CRSKeyword.INTERPOLATIONCRS)) {
            this.readSeparator();
            operation.setInterpolation(this.readInterpolation());
        }
        if (this.isKeywordNext(CRSKeyword.OPERATIONACCURACY)) {
            this.readSeparator();
            operation.setAccuracy(this.readAccuracyText());
        }
        this.readScopeExtentIdentifierRemark(operation);
        this.readRightDelimiter();
        return operation;
    }

    public PointMotionOperation readPointMotionOperation() throws IOException {
        PointMotionOperation operation = new PointMotionOperation();
        this.readKeyword(CRSKeyword.POINTMOTIONOPERATION);
        this.readLeftDelimiter();
        operation.setName(this.reader.readExpectedToken());
        if (this.isKeywordNext(CRSKeyword.VERSION)) {
            this.readSeparator();
            operation.setVersion(this.readVersion());
        }
        this.readSeparator();
        operation.setSource(this.readSource());
        this.readSeparator();
        OperationMethod method = this.readMethod();
        operation.setMethod(method);
        if (this.isKeywordNext(CRSKeyword.PARAMETER, CRSKeyword.PARAMETERFILE)) {
            this.readSeparator();
            method.setParameters(this.readPointMotionOperationParameters());
        }
        if (this.isKeywordNext(CRSKeyword.OPERATIONACCURACY)) {
            this.readSeparator();
            operation.setAccuracy(this.readAccuracyText());
        }
        this.readScopeExtentIdentifierRemark(operation);
        this.readRightDelimiter();
        return operation;
    }

    public ConcatenatedOperation readConcatenatedOperation() throws IOException {
        ConcatenatedOperation operation = new ConcatenatedOperation();
        this.readKeyword(CRSKeyword.CONCATENATEDOPERATION);
        this.readLeftDelimiter();
        operation.setName(this.reader.readExpectedToken());
        if (this.isKeywordNext(CRSKeyword.VERSION)) {
            this.readSeparator();
            operation.setVersion(this.readVersion());
        }
        this.readSeparator();
        operation.setSource(this.readSource());
        this.readSeparator();
        operation.setTarget(this.readTarget());
        do {
            this.readSeparator();
            this.readKeyword(CRSKeyword.STEP);
            this.readLeftDelimiter();
            CRSKeyword keyword = this.readToKeyword(CRSKeyword.COORDINATEOPERATION, CRSKeyword.POINTMOTIONOPERATION, CRSKeyword.CONVERSION, CRSKeyword.DERIVINGCONVERSION);
            CommonOperation concatenable = null;
            switch (keyword) {
                case COORDINATEOPERATION: {
                    concatenable = this.readCoordinateOperation();
                    break;
                }
                case POINTMOTIONOPERATION: {
                    concatenable = this.readPointMotionOperation();
                    break;
                }
                case CONVERSION: {
                    concatenable = this.readMapProjection();
                    break;
                }
                case DERIVINGCONVERSION: {
                    concatenable = this.readDerivingConversion();
                    break;
                }
                default: {
                    throw new CRSException("Unsupported concatenable operation type: " + (Object)((Object)keyword));
                }
            }
            operation.addOperation(concatenable);
            this.readRightDelimiter();
        } while (this.isKeywordNext(CRSKeyword.STEP));
        if (this.isKeywordNext(CRSKeyword.OPERATIONACCURACY)) {
            this.readSeparator();
            operation.setAccuracy(this.readAccuracyText());
        }
        this.readScopeExtentIdentifierRemark(operation);
        this.readRightDelimiter();
        return operation;
    }

    public BoundCoordinateReferenceSystem readBound() throws IOException {
        BoundCoordinateReferenceSystem crs = new BoundCoordinateReferenceSystem();
        this.readKeyword(CRSKeyword.BOUNDCRS);
        this.readLeftDelimiter();
        crs.setSource(this.readSource());
        this.readSeparator();
        crs.setTarget(this.readTarget());
        this.readSeparator();
        crs.setTransformation(this.readAbridgedCoordinateTransformation());
        this.readScopeExtentIdentifierRemark(crs);
        this.readRightDelimiter();
        return crs;
    }

    public void readScopeExtentIdentifierRemark(ScopeExtentIdentifierRemark object) throws IOException {
        CRSKeyword keyword = this.readToKeyword(CRSKeyword.USAGE, CRSKeyword.ID, CRSKeyword.REMARK);
        if (keyword == CRSKeyword.USAGE) {
            object.setUsages(this.readUsages());
            keyword = this.readToKeyword(CRSKeyword.ID, CRSKeyword.REMARK);
        }
        if (keyword == CRSKeyword.ID) {
            object.setIdentifiers(this.readIdentifiers());
            keyword = this.readToKeyword(CRSKeyword.REMARK);
        }
        if (keyword == CRSKeyword.REMARK) {
            object.setRemark(this.readRemark());
        }
    }

    public GeoReferenceFrame readGeoReferenceFrame() throws IOException {
        return this.readGeoReferenceFrame(null);
    }

    public GeoReferenceFrame readGeoReferenceFrame(SimpleCoordinateReferenceSystem crs) throws IOException {
        ReferenceFrame referenceFrame = this.readReferenceFrame(crs);
        if (!(referenceFrame instanceof GeoReferenceFrame)) {
            throw new CRSException("Reference frame was not an expected Geo Reference Frame");
        }
        return (GeoReferenceFrame)referenceFrame;
    }

    public VerticalReferenceFrame readVerticalReferenceFrame() throws IOException {
        return this.readVerticalReferenceFrame(null);
    }

    public VerticalReferenceFrame readVerticalReferenceFrame(SimpleCoordinateReferenceSystem crs) throws IOException {
        ReferenceFrame referenceFrame = this.readReferenceFrame(crs);
        if (!(referenceFrame instanceof VerticalReferenceFrame)) {
            throw new CRSException("Reference frame was not an expected Vertical Reference Frame");
        }
        return (VerticalReferenceFrame)referenceFrame;
    }

    public EngineeringDatum readEngineeringDatum() throws IOException {
        return this.readEngineeringDatum(null);
    }

    public EngineeringDatum readEngineeringDatum(SimpleCoordinateReferenceSystem crs) throws IOException {
        ReferenceFrame referenceFrame = this.readReferenceFrame(crs);
        if (!(referenceFrame instanceof EngineeringDatum)) {
            throw new CRSException("Reference frame was not an expected Engineering Datum");
        }
        return (EngineeringDatum)referenceFrame;
    }

    public ParametricDatum readParametricDatum() throws IOException {
        return this.readParametricDatum(null);
    }

    public ParametricDatum readParametricDatum(SimpleCoordinateReferenceSystem crs) throws IOException {
        ReferenceFrame referenceFrame = this.readReferenceFrame(crs);
        if (!(referenceFrame instanceof ParametricDatum)) {
            throw new CRSException("Reference frame was not an expected Parametric Datum");
        }
        return (ParametricDatum)referenceFrame;
    }

    public ReferenceFrame readReferenceFrame() throws IOException {
        return this.readReferenceFrame(null);
    }

    public ReferenceFrame readReferenceFrame(SimpleCoordinateReferenceSystem crs) throws IOException {
        String[] toWGS84;
        CRSKeyword keyword;
        ReferenceFrame referenceFrame = null;
        GeoReferenceFrame geoReferenceFrame = null;
        CRSKeyword type = this.readKeyword(CRSKeyword.DATUM, CRSKeyword.VDATUM, CRSKeyword.EDATUM, CRSKeyword.PDATUM);
        switch (type) {
            case DATUM: {
                geoReferenceFrame = new GeoReferenceFrame();
                referenceFrame = geoReferenceFrame;
                break;
            }
            case VDATUM: {
                referenceFrame = new VerticalReferenceFrame();
                break;
            }
            case EDATUM: {
                referenceFrame = new EngineeringDatum();
                break;
            }
            case PDATUM: {
                referenceFrame = new ParametricDatum();
                break;
            }
            default: {
                throw new CRSException("Unexpected Reference Frame type: " + (Object)((Object)type));
            }
        }
        this.readLeftDelimiter();
        referenceFrame.setName(this.reader.readExpectedToken());
        if (geoReferenceFrame != null) {
            this.readSeparator();
            geoReferenceFrame.setEllipsoid(this.readEllipsoid());
        }
        if ((keyword = this.readToKeyword(CRSKeyword.TOWGS84, CRSKeyword.ANCHOR, CRSKeyword.ID)) == CRSKeyword.TOWGS84) {
            toWGS84 = this.readToWGS84Compat();
            if (crs != null) {
                crs.addExtra(CRSKeyword.TOWGS84.name(), toWGS84);
            }
            keyword = this.readToKeyword(CRSKeyword.ANCHOR, CRSKeyword.ID);
        }
        if (keyword == CRSKeyword.ANCHOR) {
            referenceFrame.setAnchor(this.readKeywordDelimitedToken(CRSKeyword.ANCHOR));
            keyword = this.readToKeyword(CRSKeyword.ID, CRSKeyword.TOWGS84);
        }
        if (keyword == CRSKeyword.ID) {
            referenceFrame.setIdentifiers(this.readIdentifiers());
            keyword = this.readToKeyword(CRSKeyword.TOWGS84);
        }
        if (keyword == CRSKeyword.TOWGS84) {
            toWGS84 = this.readToWGS84Compat();
            if (crs != null) {
                crs.addExtra(CRSKeyword.TOWGS84.name(), toWGS84);
            }
        }
        this.readRightDelimiter();
        if (geoReferenceFrame != null && this.isKeywordNext(CRSKeyword.PRIMEM)) {
            this.readSeparator();
            geoReferenceFrame.setPrimeMeridian(this.readPrimeMeridian());
        }
        return referenceFrame;
    }

    public GeoDatumEnsemble readGeoDatumEnsemble() throws IOException {
        DatumEnsemble datumEnsemble = this.readDatumEnsemble();
        if (!(datumEnsemble instanceof GeoDatumEnsemble)) {
            throw new CRSException("Datum ensemble was not an expected Geo Datum Ensemble");
        }
        return (GeoDatumEnsemble)datumEnsemble;
    }

    public VerticalDatumEnsemble readVerticalDatumEnsemble() throws IOException {
        DatumEnsemble datumEnsemble = this.readDatumEnsemble();
        if (!(datumEnsemble instanceof VerticalDatumEnsemble)) {
            throw new CRSException("Datum ensemble was not an expected Vertical Datum Ensemble");
        }
        return (VerticalDatumEnsemble)datumEnsemble;
    }

    public DatumEnsemble readDatumEnsemble() throws IOException {
        this.readKeyword(CRSKeyword.ENSEMBLE);
        this.readLeftDelimiter();
        String name = this.reader.readExpectedToken();
        ArrayList<DatumEnsembleMember> members = new ArrayList<DatumEnsembleMember>();
        do {
            this.readSeparator();
            members.add(this.readDatumEnsembleMember());
        } while (this.isKeywordNext(CRSKeyword.MEMBER));
        DatumEnsemble datumEnsemble = null;
        GeoDatumEnsemble geoDatumEnsemble = null;
        if (this.isKeywordNext(CRSKeyword.ELLIPSOID)) {
            geoDatumEnsemble = new GeoDatumEnsemble();
            datumEnsemble = geoDatumEnsemble;
        } else {
            datumEnsemble = new VerticalDatumEnsemble();
        }
        datumEnsemble.setName(name);
        datumEnsemble.setMembers(members);
        if (geoDatumEnsemble != null) {
            this.readSeparator();
            geoDatumEnsemble.setEllipsoid(this.readEllipsoid());
        }
        this.readSeparator();
        this.readKeyword(CRSKeyword.ENSEMBLEACCURACY);
        this.readLeftDelimiter();
        datumEnsemble.setAccuracy(this.reader.readExpectedToken());
        this.readRightDelimiter();
        CRSKeyword keyword = this.readToKeyword(CRSKeyword.ID);
        if (keyword == CRSKeyword.ID) {
            datumEnsemble.setIdentifiers(this.readIdentifiers());
        }
        this.readRightDelimiter();
        if (geoDatumEnsemble != null && this.isKeywordNext(CRSKeyword.PRIMEM)) {
            this.readSeparator();
            geoDatumEnsemble.setPrimeMeridian(this.readPrimeMeridian());
        }
        return datumEnsemble;
    }

    public DatumEnsembleMember readDatumEnsembleMember() throws IOException {
        DatumEnsembleMember member = new DatumEnsembleMember();
        this.readKeyword(CRSKeyword.MEMBER);
        this.readLeftDelimiter();
        member.setName(this.reader.readExpectedToken());
        CRSKeyword keyword = this.readToKeyword(CRSKeyword.ID);
        if (keyword == CRSKeyword.ID) {
            member.setIdentifiers(this.readIdentifiers());
        }
        this.readRightDelimiter();
        return member;
    }

    public Dynamic readDynamic() throws IOException {
        Dynamic dynamic = new Dynamic();
        this.readKeyword(CRSKeyword.DYNAMIC);
        this.readLeftDelimiter();
        this.readKeyword(CRSKeyword.FRAMEEPOCH);
        this.readLeftDelimiter();
        dynamic.setReferenceEpoch(this.reader.readExpectedToken());
        this.validateUnsignedDouble(dynamic.getReferenceEpoch());
        this.readRightDelimiter();
        CRSKeyword keyword = this.readToKeyword(CRSKeyword.MODEL);
        if (keyword == CRSKeyword.MODEL) {
            this.readKeyword(CRSKeyword.MODEL);
            this.readLeftDelimiter();
            dynamic.setDeformationModelName(this.reader.readExpectedToken());
            keyword = this.readToKeyword(CRSKeyword.ID);
            if (keyword == CRSKeyword.ID) {
                dynamic.setIdentifiers(this.readIdentifiers());
            }
            this.readRightDelimiter();
        }
        this.readRightDelimiter();
        return dynamic;
    }

    public PrimeMeridian readPrimeMeridian() throws IOException {
        PrimeMeridian primeMeridian = new PrimeMeridian();
        this.readKeyword(CRSKeyword.PRIMEM);
        this.readLeftDelimiter();
        primeMeridian.setName(this.reader.readExpectedToken());
        this.readSeparator();
        primeMeridian.setLongitude(this.reader.readExpectedToken());
        CRSKeyword keyword = this.readToKeyword(CRSKeyword.ANGLEUNIT, CRSKeyword.ID);
        if (keyword == CRSKeyword.ANGLEUNIT) {
            primeMeridian.setLongitudeUnit(this.readAngleUnit());
            keyword = this.readToKeyword(CRSKeyword.ID);
        }
        if (keyword == CRSKeyword.ID) {
            primeMeridian.setIdentifiers(this.readIdentifiers());
        }
        this.readRightDelimiter();
        return primeMeridian;
    }

    public Ellipsoid readEllipsoid() throws IOException {
        Ellipsoid ellipsoid = null;
        TriaxialEllipsoid triaxial = null;
        CRSKeyword keyword = this.readKeyword(CRSKeyword.ELLIPSOID, CRSKeyword.TRIAXIAL);
        if (keyword == CRSKeyword.TRIAXIAL) {
            triaxial = new TriaxialEllipsoid();
            ellipsoid = triaxial;
        } else {
            ellipsoid = new Ellipsoid();
        }
        this.readLeftDelimiter();
        ellipsoid.setName(this.reader.readExpectedToken());
        this.readSeparator();
        ellipsoid.setSemiMajorAxis(this.reader.readExpectedToken());
        this.validateUnsignedDouble(ellipsoid.getSemiMajorAxis());
        if (triaxial != null) {
            this.readSeparator();
            triaxial.setSemiMedianAxis(this.reader.readExpectedToken());
            this.validateUnsignedDouble(triaxial.getSemiMedianAxis());
            this.readSeparator();
            triaxial.setSemiMinorAxis(this.reader.readExpectedToken());
            this.validateUnsignedDouble(triaxial.getSemiMinorAxis());
        } else {
            this.readSeparator();
            ellipsoid.setInverseFlattening(this.reader.readExpectedToken());
            this.validateUnsignedDouble(ellipsoid.getInverseFlattening());
        }
        keyword = this.readToKeyword(CRSKeyword.LENGTHUNIT, CRSKeyword.ID);
        if (keyword == CRSKeyword.LENGTHUNIT) {
            ellipsoid.setUnit(this.readLengthUnit());
            keyword = this.readToKeyword(CRSKeyword.ID);
        }
        if (keyword == CRSKeyword.ID) {
            ellipsoid.setIdentifiers(this.readIdentifiers());
        }
        this.readRightDelimiter();
        return ellipsoid;
    }

    public Unit readUnit() throws IOException {
        return this.readUnit(UnitType.UNIT);
    }

    public Unit readAngleUnit() throws IOException {
        return this.readUnit(UnitType.ANGLEUNIT);
    }

    public Unit readLengthUnit() throws IOException {
        return this.readUnit(UnitType.LENGTHUNIT);
    }

    public Unit readParametricUnit() throws IOException {
        return this.readUnit(UnitType.PARAMETRICUNIT);
    }

    public Unit readScaleUnit() throws IOException {
        return this.readUnit(UnitType.SCALEUNIT);
    }

    public Unit readTimeUnit() throws IOException {
        return this.readUnit(UnitType.TIMEUNIT);
    }

    public Unit readUnit(UnitType type) throws IOException {
        CRSKeyword keyword;
        Unit unit = new Unit();
        Set<CRSKeyword> keywords = this.readKeywords();
        if (type != UnitType.UNIT) {
            CRSKeyword crsType = CRSKeyword.getType(type.name());
            this.validateKeyword(keywords, crsType);
        } else if (keywords.size() == 1) {
            type = WKTUtils.getUnitType(keywords.iterator().next());
        } else if (keywords.isEmpty()) {
            throw new CRSException("Unexpected unit keyword. found: " + this.keywordNames(keywords));
        }
        unit.setType(type);
        this.readLeftDelimiter();
        unit.setName(this.reader.readExpectedToken());
        if (type != UnitType.TIMEUNIT || this.isNonKeywordNext()) {
            this.readSeparator();
            unit.setConversionFactor(this.reader.readExpectedToken());
            this.validateUnsignedDouble(unit.getConversionFactor());
        }
        if ((keyword = this.readToKeyword(CRSKeyword.ID)) == CRSKeyword.ID) {
            unit.setIdentifiers(this.readIdentifiers());
        }
        this.readRightDelimiter();
        return unit;
    }

    public List<Identifier> readIdentifiers() throws IOException {
        ArrayList<Identifier> identifiers = new ArrayList<Identifier>();
        do {
            if (!identifiers.isEmpty()) {
                this.readSeparator();
            }
            identifiers.add(this.readIdentifier());
        } while (this.isKeywordNext(CRSKeyword.ID));
        return identifiers;
    }

    public Identifier readIdentifier() throws IOException {
        CRSKeyword keyword;
        Identifier identifier = new Identifier();
        this.readKeyword(CRSKeyword.ID);
        this.readLeftDelimiter();
        identifier.setName(this.reader.readExpectedToken());
        this.readSeparator();
        identifier.setUniqueIdentifier(this.reader.readExpectedToken());
        if (this.isNonKeywordNext()) {
            this.readSeparator();
            identifier.setVersion(this.reader.readExpectedToken());
        }
        if ((keyword = this.readToKeyword(CRSKeyword.CITATION, CRSKeyword.URI)) == CRSKeyword.CITATION) {
            identifier.setCitation(this.readKeywordDelimitedToken(CRSKeyword.CITATION));
            keyword = this.readToKeyword(CRSKeyword.URI);
        }
        if (keyword == CRSKeyword.URI) {
            identifier.setUri(this.readKeywordDelimitedToken(CRSKeyword.URI));
        }
        this.readRightDelimiter();
        return identifier;
    }

    public CoordinateSystem readCoordinateSystem() throws IOException {
        CoordinateSystem coordinateSystem = new CoordinateSystem();
        this.readKeyword(CRSKeyword.CS);
        this.readLeftDelimiter();
        String csTypeName = this.reader.readToken();
        CoordinateSystemType csType = CoordinateSystemType.getType(csTypeName);
        if (csType == null) {
            throw new CRSException("Unexpected coordinate system type. found: " + csTypeName);
        }
        coordinateSystem.setType(csType);
        this.readSeparator();
        coordinateSystem.setDimension(this.reader.readUnsignedInteger());
        CRSKeyword keyword = this.readToKeyword(CRSKeyword.ID);
        if (keyword == CRSKeyword.ID) {
            coordinateSystem.setIdentifiers(this.readIdentifiers());
        }
        this.readRightDelimiter();
        this.readSeparator();
        coordinateSystem.setAxes(this.readAxes(csType));
        if (WKTUtils.isSpatial(csType) && this.isUnitNext()) {
            this.readSeparator();
            coordinateSystem.setUnit(this.readUnit());
        }
        return coordinateSystem;
    }

    public List<Axis> readAxes() throws IOException {
        return this.readAxes(null);
    }

    public List<Axis> readAxes(CoordinateSystemType type) throws IOException {
        boolean isTemporalCountMeasure = type != null && WKTUtils.isTemporalCountMeasure(type);
        ArrayList<Axis> axes = new ArrayList<Axis>();
        do {
            if (!axes.isEmpty()) {
                this.readSeparator();
            }
            axes.add(this.readAxis(type));
        } while (!isTemporalCountMeasure && this.isKeywordNext(CRSKeyword.AXIS));
        return axes;
    }

    public Axis readAxis() throws IOException {
        return this.readAxis(null);
    }

    public Axis readAxis(CoordinateSystemType type) throws IOException {
        Axis axis = new Axis();
        this.readKeyword(CRSKeyword.AXIS);
        this.readLeftDelimiter();
        String nameAbbrev = this.reader.readExpectedToken();
        if (nameAbbrev.matches(AXIS_NAME_ABBREV_PATTERN)) {
            int abbrevIndex = nameAbbrev.lastIndexOf("(");
            axis.setAbbreviation(nameAbbrev.substring(abbrevIndex + 1, nameAbbrev.length() - 1));
            if (abbrevIndex > 0) {
                axis.setName(nameAbbrev.substring(0, abbrevIndex - 1));
            }
        } else {
            axis.setName(nameAbbrev);
        }
        this.readSeparator();
        String axisDirectionTypeName = this.reader.readToken();
        AxisDirectionType axisDirectionType = AxisDirectionType.getType(axisDirectionTypeName);
        if (axisDirectionType == null) {
            if (axisDirectionTypeName.equalsIgnoreCase("other")) {
                axisDirectionType = AxisDirectionType.UNSPECIFIED;
            } else {
                throw new CRSException("Unexpected axis direction type. found: " + axisDirectionTypeName);
            }
        }
        axis.setDirection(axisDirectionType);
        if (type != null) {
            CRSKeyword keyword;
            switch (axisDirectionType) {
                case NORTH: 
                case SOUTH: {
                    if (!this.isKeywordNext(CRSKeyword.MERIDIAN)) break;
                    this.readSeparator();
                    this.readKeyword(CRSKeyword.MERIDIAN);
                    this.readLeftDelimiter();
                    axis.setMeridian(this.reader.readExpectedToken());
                    this.readSeparator();
                    axis.setMeridianUnit(this.readAngleUnit());
                    this.readRightDelimiter();
                    break;
                }
                case CLOCKWISE: 
                case COUNTER_CLOCKWISE: {
                    this.readSeparator();
                    this.readKeyword(CRSKeyword.BEARING);
                    this.readLeftDelimiter();
                    axis.setBearing(this.reader.readExpectedToken());
                    this.readRightDelimiter();
                    break;
                }
            }
            if (this.isKeywordNext(CRSKeyword.ORDER)) {
                this.readSeparator();
                this.readKeyword(CRSKeyword.ORDER);
                this.readLeftDelimiter();
                axis.setOrder(this.reader.readUnsignedInteger());
                this.readRightDelimiter();
            }
            if (WKTUtils.isSpatial(type)) {
                if (this.isSpatialUnitNext()) {
                    this.readSeparator();
                    axis.setUnit(this.readUnit());
                }
            } else if (WKTUtils.isTemporalCountMeasure(type) && this.isTimeUnitNext()) {
                this.readSeparator();
                axis.setUnit(this.readTimeUnit());
            }
            if ((keyword = this.readToKeyword(CRSKeyword.ID)) == CRSKeyword.ID) {
                axis.setIdentifiers(this.readIdentifiers());
            }
        }
        this.readRightDelimiter();
        return axis;
    }

    public String readRemark() throws IOException {
        return this.readKeywordDelimitedToken(CRSKeyword.REMARK);
    }

    public List<Usage> readUsages() throws IOException {
        ArrayList<Usage> usages = new ArrayList<Usage>();
        do {
            if (!usages.isEmpty()) {
                this.readSeparator();
            }
            usages.add(this.readUsage());
        } while (this.isKeywordNext(CRSKeyword.USAGE));
        return usages;
    }

    public Usage readUsage() throws IOException {
        Usage usage = new Usage();
        this.readKeyword(CRSKeyword.USAGE);
        this.readLeftDelimiter();
        usage.setScope(this.readScope());
        usage.setExtent(this.readExtent());
        this.readRightDelimiter();
        return usage;
    }

    public String readScope() throws IOException {
        return this.readKeywordDelimitedToken(CRSKeyword.SCOPE);
    }

    public Extent readExtent() throws IOException {
        Extent extent = new Extent();
        CRSKeyword keyword = this.readToKeyword(CRSKeyword.AREA, CRSKeyword.BBOX, CRSKeyword.VERTICALEXTENT, CRSKeyword.TIMEEXTENT);
        if (keyword == null) {
            throw new CRSException("Missing extent type of [" + (Object)((Object)CRSKeyword.AREA) + ", " + (Object)((Object)CRSKeyword.BBOX) + ", " + (Object)((Object)CRSKeyword.VERTICALEXTENT) + ", " + (Object)((Object)CRSKeyword.TIMEEXTENT) + "]");
        }
        if (keyword == CRSKeyword.AREA) {
            extent.setAreaDescription(this.readAreaDescription());
            keyword = this.readToKeyword(CRSKeyword.BBOX, CRSKeyword.VERTICALEXTENT, CRSKeyword.TIMEEXTENT);
        }
        if (keyword == CRSKeyword.BBOX) {
            extent.setGeographicBoundingBox(this.readGeographicBoundingBox());
            keyword = this.readToKeyword(CRSKeyword.VERTICALEXTENT, CRSKeyword.TIMEEXTENT);
        }
        if (keyword == CRSKeyword.VERTICALEXTENT) {
            extent.setVerticalExtent(this.readVerticalExtent());
            keyword = this.readToKeyword(CRSKeyword.TIMEEXTENT);
        }
        if (keyword == CRSKeyword.TIMEEXTENT) {
            extent.setTemporalExtent(this.readTemporalExtent());
        }
        return extent;
    }

    public String readAreaDescription() throws IOException {
        return this.readKeywordDelimitedToken(CRSKeyword.AREA);
    }

    public GeographicBoundingBox readGeographicBoundingBox() throws IOException {
        GeographicBoundingBox boundingBox = new GeographicBoundingBox();
        this.readKeyword(CRSKeyword.BBOX);
        this.readLeftDelimiter();
        boundingBox.setLowerLeftLatitude(this.reader.readExpectedToken());
        this.readSeparator();
        boundingBox.setLowerLeftLongitude(this.reader.readExpectedToken());
        this.readSeparator();
        boundingBox.setUpperRightLatitude(this.reader.readExpectedToken());
        this.readSeparator();
        boundingBox.setUpperRightLongitude(this.reader.readExpectedToken());
        this.readRightDelimiter();
        return boundingBox;
    }

    public VerticalExtent readVerticalExtent() throws IOException {
        VerticalExtent verticalExtent = new VerticalExtent();
        this.readKeyword(CRSKeyword.VERTICALEXTENT);
        this.readLeftDelimiter();
        verticalExtent.setMinimumHeight(this.reader.readExpectedToken());
        this.readSeparator();
        verticalExtent.setMaximumHeight(this.reader.readExpectedToken());
        CRSKeyword keyword = this.readToKeyword(CRSKeyword.LENGTHUNIT);
        if (keyword == CRSKeyword.LENGTHUNIT) {
            verticalExtent.setUnit(this.readLengthUnit());
        }
        this.readRightDelimiter();
        return verticalExtent;
    }

    public TemporalExtent readTemporalExtent() throws IOException {
        TemporalExtent temporalExtent = new TemporalExtent();
        this.readKeyword(CRSKeyword.TIMEEXTENT);
        this.readLeftDelimiter();
        temporalExtent.setStart(this.reader.readExpectedToken());
        this.readSeparator();
        temporalExtent.setEnd(this.reader.readExpectedToken());
        this.readRightDelimiter();
        return temporalExtent;
    }

    public MapProjection readMapProjection() throws IOException {
        MapProjection mapProjection = new MapProjection();
        this.readKeyword(CRSKeyword.CONVERSION);
        this.readLeftDelimiter();
        mapProjection.setName(this.reader.readExpectedToken());
        this.readSeparator();
        OperationMethod method = this.readMethod();
        mapProjection.setMethod(method);
        CRSKeyword keyword = this.readToKeyword(CRSKeyword.PARAMETER, CRSKeyword.ID);
        if (keyword == CRSKeyword.PARAMETER) {
            method.setParameters(this.readProjectedParameters());
            keyword = this.readToKeyword(CRSKeyword.ID);
        }
        if (keyword == CRSKeyword.ID) {
            mapProjection.setIdentifiers(this.readIdentifiers());
        }
        this.readRightDelimiter();
        return mapProjection;
    }

    public OperationMethod readMethod() throws IOException {
        OperationMethod method = new OperationMethod();
        this.readKeyword(CRSKeyword.METHOD);
        this.readLeftDelimiter();
        method.setName(this.reader.readExpectedToken());
        CRSKeyword keyword = this.readToKeyword(CRSKeyword.ID);
        if (keyword == CRSKeyword.ID) {
            method.setIdentifiers(this.readIdentifiers());
        }
        this.readRightDelimiter();
        return method;
    }

    public List<OperationParameter> readProjectedParameters() throws IOException {
        return this.readParameters(CRSType.PROJECTED);
    }

    public List<OperationParameter> readParameters(CRSType type) throws IOException {
        ArrayList<OperationParameter> parameters = new ArrayList<OperationParameter>();
        do {
            if (!parameters.isEmpty()) {
                this.readSeparator();
            }
            parameters.add(this.readParameter(type));
        } while (this.isKeywordNext(CRSKeyword.PARAMETER));
        return parameters;
    }

    public OperationParameter readParameter(CRSType type) throws IOException {
        OperationParameter parameter = new OperationParameter();
        this.readKeyword(CRSKeyword.PARAMETER);
        this.readLeftDelimiter();
        parameter.setName(this.reader.readExpectedToken());
        this.readSeparator();
        parameter.setValue(this.reader.readExpectedToken());
        CRSKeyword[] keywords = null;
        switch (type) {
            case PROJECTED: {
                keywords = new CRSKeyword[]{CRSKeyword.LENGTHUNIT, CRSKeyword.ANGLEUNIT, CRSKeyword.SCALEUNIT, CRSKeyword.ID};
                break;
            }
            case DERIVED: 
            case COORDINATE_OPERATION: 
            case POINT_MOTION_OPERATION: {
                keywords = new CRSKeyword[]{CRSKeyword.LENGTHUNIT, CRSKeyword.ANGLEUNIT, CRSKeyword.SCALEUNIT, CRSKeyword.TIMEUNIT, CRSKeyword.PARAMETRICUNIT, CRSKeyword.ID};
                break;
            }
            case BOUND: {
                keywords = new CRSKeyword[]{CRSKeyword.ID};
                break;
            }
            default: {
                throw new CRSException("Unsupported CRS Type: " + (Object)((Object)type));
            }
        }
        CRSKeyword keyword = this.readToKeyword(keywords);
        if (keyword != null && keyword != CRSKeyword.ID) {
            parameter.setUnit(this.readUnit());
            keyword = this.readToKeyword(CRSKeyword.ID);
        }
        if (keyword == CRSKeyword.ID) {
            parameter.setIdentifiers(this.readIdentifiers());
        }
        this.readRightDelimiter();
        return parameter;
    }

    public TemporalDatum readTemporalDatum() throws IOException {
        TemporalDatum temporalDatum = new TemporalDatum();
        this.readKeyword(CRSKeyword.TDATUM);
        this.readLeftDelimiter();
        temporalDatum.setName(this.reader.readExpectedToken());
        CRSKeyword keyword = this.readToKeyword(CRSKeyword.CALENDAR, CRSKeyword.TIMEORIGIN, CRSKeyword.ID);
        if (keyword == CRSKeyword.CALENDAR) {
            temporalDatum.setCalendar(this.readKeywordDelimitedToken(CRSKeyword.CALENDAR));
            keyword = this.readToKeyword(CRSKeyword.TIMEORIGIN, CRSKeyword.ID);
        }
        if (keyword == CRSKeyword.TIMEORIGIN) {
            temporalDatum.setOrigin(this.readKeywordDelimitedToken(CRSKeyword.TIMEORIGIN));
            keyword = this.readToKeyword(CRSKeyword.ID);
        }
        if (keyword == CRSKeyword.ID) {
            temporalDatum.setIdentifiers(this.readIdentifiers());
        }
        this.readRightDelimiter();
        return temporalDatum;
    }

    public DerivingConversion readDerivingConversion() throws IOException {
        DerivingConversion derivingConversion = new DerivingConversion();
        this.readKeyword(CRSKeyword.DERIVINGCONVERSION);
        this.readLeftDelimiter();
        derivingConversion.setName(this.reader.readExpectedToken());
        this.readSeparator();
        OperationMethod method = this.readMethod();
        derivingConversion.setMethod(method);
        CRSKeyword keyword = this.readToKeyword(CRSKeyword.PARAMETER, CRSKeyword.PARAMETERFILE, CRSKeyword.ID);
        if (keyword == CRSKeyword.PARAMETER || keyword == CRSKeyword.PARAMETERFILE) {
            method.setParameters(this.readDerivedParameters());
            keyword = this.readToKeyword(CRSKeyword.ID);
        }
        if (keyword == CRSKeyword.ID) {
            derivingConversion.setIdentifiers(this.readIdentifiers());
        }
        this.readRightDelimiter();
        return derivingConversion;
    }

    public List<OperationParameter> readDerivedParameters() throws IOException {
        return this.readParametersAndFiles(CRSType.DERIVED);
    }

    public List<OperationParameter> readParametersAndFiles(CRSType type) throws IOException {
        ArrayList<OperationParameter> parameters = new ArrayList<OperationParameter>();
        do {
            if (!parameters.isEmpty()) {
                this.readSeparator();
            }
            if (this.peekKeyword() == CRSKeyword.PARAMETERFILE) {
                parameters.add(this.readParameterFile());
                continue;
            }
            parameters.add(this.readParameter(type));
        } while (this.isKeywordNext(CRSKeyword.PARAMETER, CRSKeyword.PARAMETERFILE));
        return parameters;
    }

    public OperationParameter readParameterFile() throws IOException {
        OperationParameter parameterFile = new OperationParameter();
        this.readKeyword(CRSKeyword.PARAMETERFILE);
        this.readLeftDelimiter();
        parameterFile.setName(this.reader.readExpectedToken());
        this.readSeparator();
        parameterFile.setFileName(this.reader.readExpectedToken());
        CRSKeyword keyword = this.readToKeyword(CRSKeyword.ID);
        if (keyword == CRSKeyword.ID) {
            parameterFile.setIdentifiers(this.readIdentifiers());
        }
        this.readRightDelimiter();
        return parameterFile;
    }

    public List<OperationParameter> readCoordinateOperationParameters() throws IOException {
        return this.readParametersAndFiles(CRSType.COORDINATE_OPERATION);
    }

    public String readVersion() throws IOException {
        this.readKeyword(CRSKeyword.VERSION);
        this.readLeftDelimiter();
        String version = this.reader.readExpectedToken();
        this.readRightDelimiter();
        return version;
    }

    public CoordinateReferenceSystem readSource() throws IOException {
        return this.readCoordinateReferenceSystem(CRSKeyword.SOURCECRS);
    }

    public CoordinateReferenceSystem readTarget() throws IOException {
        return this.readCoordinateReferenceSystem(CRSKeyword.TARGETCRS);
    }

    public CoordinateReferenceSystem readInterpolation() throws IOException {
        return this.readCoordinateReferenceSystem(CRSKeyword.INTERPOLATIONCRS);
    }

    public CoordinateReferenceSystem readCoordinateReferenceSystem(CRSKeyword keyword) throws IOException {
        this.readKeyword(keyword);
        this.readLeftDelimiter();
        CoordinateReferenceSystem crs = this.readCoordinateReferenceSystem();
        this.readRightDelimiter();
        return crs;
    }

    public double readAccuracy() throws IOException {
        this.readKeyword(CRSKeyword.OPERATIONACCURACY);
        this.readLeftDelimiter();
        double accuracy = this.reader.readNumber();
        this.readRightDelimiter();
        return accuracy;
    }

    public String readAccuracyText() throws IOException {
        this.readKeyword(CRSKeyword.OPERATIONACCURACY);
        this.readLeftDelimiter();
        String accuracy = this.reader.readExpectedToken();
        this.readRightDelimiter();
        return accuracy;
    }

    public List<OperationParameter> readPointMotionOperationParameters() throws IOException {
        return this.readParametersAndFiles(CRSType.POINT_MOTION_OPERATION);
    }

    public AbridgedCoordinateTransformation readAbridgedCoordinateTransformation() throws IOException {
        AbridgedCoordinateTransformation transformation = new AbridgedCoordinateTransformation();
        this.readKeyword(CRSKeyword.ABRIDGEDTRANSFORMATION);
        this.readLeftDelimiter();
        transformation.setName(this.reader.readExpectedToken());
        if (this.isKeywordNext(CRSKeyword.VERSION)) {
            this.readSeparator();
            transformation.setVersion(this.readVersion());
        }
        this.readSeparator();
        OperationMethod method = this.readMethod();
        transformation.setMethod(method);
        if (this.isKeywordNext(CRSKeyword.PARAMETER, CRSKeyword.PARAMETERFILE)) {
            this.readSeparator();
            method.setParameters(this.readBoundParameters());
        }
        this.readScopeExtentIdentifierRemark(transformation);
        this.readRightDelimiter();
        return transformation;
    }

    public List<OperationParameter> readBoundParameters() throws IOException {
        return this.readParametersAndFiles(CRSType.BOUND);
    }

    public GeoCoordinateReferenceSystem readGeoCompat() throws IOException {
        CRSType expectedType = null;
        return this.readGeoCompat(expectedType);
    }

    public GeoCoordinateReferenceSystem readGeodeticCompat() throws IOException {
        return this.readGeoCompat(CRSType.GEODETIC);
    }

    public GeoCoordinateReferenceSystem readGeographicCompat() throws IOException {
        return this.readGeoCompat(CRSType.GEOGRAPHIC);
    }

    public GeoCoordinateReferenceSystem readGeoCompat(CRSType expectedType) throws IOException {
        GeoCoordinateReferenceSystem crs = new GeoCoordinateReferenceSystem();
        CRSKeyword type = this.readKeyword(CRSKeyword.GEOCCS, CRSKeyword.GEOGCS, CRSKeyword.GEODCRS, CRSKeyword.GEOGCRS);
        CRSType crsType = WKTUtils.getCoordinateReferenceSystemType(type);
        if (expectedType != null && crsType != expectedType) {
            throw new CRSException("Unexpected Coordinate Reference System Type. expected: " + (Object)((Object)expectedType) + ", found: " + (Object)((Object)crsType));
        }
        crs.setType(crsType);
        this.readLeftDelimiter();
        crs.setName(this.reader.readExpectedToken());
        this.readSeparator();
        GeoReferenceFrame referenceFrame = this.readGeoReferenceFrame(crs);
        referenceFrame.setType(crsType);
        crs.setReferenceFrame(referenceFrame);
        crs.setCoordinateSystem(this.readCoordinateSystemCompat(crsType, crs.getReferenceFrame()));
        CRSKeyword keyword = this.readToKeyword(CRSKeyword.EXTENSION, CRSKeyword.ID);
        if (keyword == CRSKeyword.EXTENSION) {
            crs.addExtras(this.readExtensionsCompat());
            keyword = this.readToKeyword(CRSKeyword.ID);
        }
        if (keyword == CRSKeyword.ID) {
            crs.setIdentifiers(this.readIdentifiers());
        }
        this.readRightDelimiter();
        return crs;
    }

    public ProjectedCoordinateReferenceSystem readProjectedCompat() throws IOException {
        CRSType expectedType = null;
        return this.readProjectedCompat(expectedType);
    }

    public ProjectedCoordinateReferenceSystem readProjectedGeodeticCompat() throws IOException {
        return this.readProjectedCompat(CRSType.GEODETIC);
    }

    public ProjectedCoordinateReferenceSystem readProjectedGeographicCompat() throws IOException {
        return this.readProjectedCompat(CRSType.GEOGRAPHIC);
    }

    public ProjectedCoordinateReferenceSystem readProjectedCompat(CRSType expectedBaseType) throws IOException {
        CRSKeyword keyword;
        OperationMethod method;
        ProjectedCoordinateReferenceSystem crs = new ProjectedCoordinateReferenceSystem();
        this.readKeyword(CRSKeyword.PROJCS);
        this.readLeftDelimiter();
        crs.setName(this.reader.readExpectedToken());
        this.readSeparator();
        GeoCoordinateReferenceSystem base = this.readGeoCompat(expectedBaseType);
        crs.setBase(base);
        Unit unit = null;
        if (this.isUnitNext()) {
            this.readSeparator();
            unit = this.readUnit();
        }
        this.readSeparator();
        MapProjection mapProjection = this.readMapProjectionCompat();
        String mapProjectionName = crs.getName();
        if (!(mapProjectionName.toLowerCase().contains(mapProjection.getName().toLowerCase()) || (method = mapProjection.getMethod()).hasMethod() && method.getMethod() == OperationMethods.getMethod(mapProjectionName))) {
            mapProjectionName = mapProjectionName + " / " + mapProjection.getName();
        }
        mapProjection.setName(mapProjectionName);
        Object toWGS84 = base.getExtra(CRSKeyword.TOWGS84.name());
        if (toWGS84 != null) {
            CRSReader.addTransformParameters((String[])toWGS84, mapProjection);
        }
        crs.setMapProjection(mapProjection);
        crs.setCoordinateSystem(this.readCoordinateSystemCompat(CRSType.PROJECTED, crs.getReferenceFrame()));
        if (unit != null && !crs.getCoordinateSystem().hasUnit()) {
            crs.getCoordinateSystem().setUnit(unit);
        }
        if ((keyword = this.readToKeyword(CRSKeyword.EXTENSION, CRSKeyword.ID)) == CRSKeyword.EXTENSION) {
            crs.addExtras(this.readExtensionsCompat());
            keyword = this.readToKeyword(CRSKeyword.ID);
        }
        if (keyword == CRSKeyword.ID) {
            crs.setIdentifiers(this.readIdentifiers());
        } else if (mapProjection.hasIdentifiers()) {
            crs.setIdentifiers(mapProjection.getIdentifiers());
            mapProjection.setIdentifiers(null);
        }
        this.readRightDelimiter();
        return crs;
    }

    public static void addTransformParameters(String[] transform, MapProjection mapProjection) {
        boolean param3 = false;
        boolean param7 = false;
        if (transform != null) {
            for (int i = 0; i < transform.length; ++i) {
                if (Double.valueOf(transform[i]) == 0.0) continue;
                param3 = true;
                if (i < 3) continue;
                param7 = true;
                break;
            }
            if (param3) {
                boolean bl = param3 = transform.length >= 3;
                if (param7) {
                    boolean bl2 = param7 = transform.length >= 7;
                }
            }
        }
        if (param3) {
            OperationMethod method = mapProjection.getMethod();
            method.addParameter(new OperationParameter(OperationParameters.X_AXIS_TRANSLATION, transform[0], Units.METRE.createUnit()));
            method.addParameter(new OperationParameter(OperationParameters.Y_AXIS_TRANSLATION, transform[1], Units.METRE.createUnit()));
            method.addParameter(new OperationParameter(OperationParameters.Z_AXIS_TRANSLATION, transform[2], Units.METRE.createUnit()));
            if (param7) {
                method.addParameter(new OperationParameter(OperationParameters.X_AXIS_ROTATION, transform[3], Units.ARC_SECOND.createUnit()));
                method.addParameter(new OperationParameter(OperationParameters.Y_AXIS_ROTATION, transform[4], Units.ARC_SECOND.createUnit()));
                method.addParameter(new OperationParameter(OperationParameters.Z_AXIS_ROTATION, transform[5], Units.ARC_SECOND.createUnit()));
                method.addParameter(new OperationParameter(OperationParameters.SCALE_DIFFERENCE, transform[6], Units.PARTS_PER_MILLION.createUnit()));
            }
        }
    }

    public VerticalCoordinateReferenceSystem readVerticalCompat() throws IOException {
        VerticalCoordinateReferenceSystem crs = new VerticalCoordinateReferenceSystem();
        this.readKeyword(CRSKeyword.VERT_CS);
        this.readLeftDelimiter();
        crs.setName(this.reader.readExpectedToken());
        this.readSeparator();
        crs.setReferenceFrame(this.readVerticalDatumCompat(crs));
        crs.setCoordinateSystem(this.readCoordinateSystemCompat(CRSType.VERTICAL, crs.getReferenceFrame()));
        CRSKeyword keyword = this.readToKeyword(CRSKeyword.EXTENSION, CRSKeyword.ID);
        if (keyword == CRSKeyword.EXTENSION) {
            crs.addExtras(this.readExtensionsCompat());
            keyword = this.readToKeyword(CRSKeyword.ID);
        }
        if (keyword == CRSKeyword.ID) {
            crs.setIdentifiers(this.readIdentifiers());
        }
        this.readRightDelimiter();
        return crs;
    }

    public EngineeringCoordinateReferenceSystem readEngineeringCompat() throws IOException {
        EngineeringCoordinateReferenceSystem crs = new EngineeringCoordinateReferenceSystem();
        this.readKeyword(CRSKeyword.LOCAL_CS);
        this.readLeftDelimiter();
        crs.setName(this.reader.readExpectedToken());
        this.readSeparator();
        crs.setDatum(this.readEngineeringDatumCompat(crs));
        crs.setCoordinateSystem(this.readCoordinateSystemCompat(CRSType.ENGINEERING, crs.getDatum()));
        CRSKeyword keyword = this.readToKeyword(CRSKeyword.EXTENSION, CRSKeyword.ID);
        if (keyword == CRSKeyword.EXTENSION) {
            crs.addExtras(this.readExtensionsCompat());
            keyword = this.readToKeyword(CRSKeyword.ID);
        }
        if (keyword == CRSKeyword.ID) {
            crs.setIdentifiers(this.readIdentifiers());
        }
        this.readRightDelimiter();
        return crs;
    }

    public MapProjection readMapProjectionCompat() throws IOException {
        MapProjection mapProjection = new MapProjection();
        OperationMethod method = this.readMethod();
        mapProjection.setName(method.getName());
        mapProjection.setMethod(method);
        CRSKeyword keyword = this.readToKeyword(CRSKeyword.PARAMETER, CRSKeyword.ID);
        if (keyword == CRSKeyword.PARAMETER) {
            method.setParameters(this.readProjectedParameters());
        }
        if (this.isKeywordNext(CRSKeyword.ID)) {
            this.readSeparator();
            mapProjection.setIdentifiers(this.readIdentifiers());
        }
        return mapProjection;
    }

    public CoordinateSystem readCoordinateSystemCompat(CRSType type, ReferenceFrame datum) throws IOException {
        CoordinateSystem coordinateSystem = new CoordinateSystem();
        switch (datum.getType()) {
            case GEODETIC: 
            case GEOGRAPHIC: {
                coordinateSystem.setType(CoordinateSystemType.ELLIPSOIDAL);
                break;
            }
            case VERTICAL: {
                coordinateSystem.setType(CoordinateSystemType.VERTICAL);
                break;
            }
            case ENGINEERING: {
                coordinateSystem.setType(CoordinateSystemType.CARTESIAN);
                break;
            }
            default: {
                throw new CRSException("Unexpected Reference Frame Type. expected: " + (Object)((Object)datum.getType()));
            }
        }
        if (this.isUnitNext()) {
            this.readSeparator();
            coordinateSystem.setUnit(this.readUnit());
        }
        if (this.isKeywordNext(CRSKeyword.AXIS)) {
            this.readSeparator();
            coordinateSystem.setAxes(this.readAxes());
        } else {
            switch (type) {
                case GEOGRAPHIC: {
                    coordinateSystem.addAxis(new Axis("Lon", AxisDirectionType.EAST));
                    coordinateSystem.addAxis(new Axis("Lat", AxisDirectionType.NORTH));
                    break;
                }
                case PROJECTED: {
                    coordinateSystem.addAxis(new Axis("X", AxisDirectionType.EAST));
                    coordinateSystem.addAxis(new Axis("Y", AxisDirectionType.NORTH));
                    break;
                }
                case GEODETIC: {
                    coordinateSystem.addAxis(new Axis("X", AxisDirectionType.UNSPECIFIED));
                    coordinateSystem.addAxis(new Axis("Y", AxisDirectionType.EAST));
                    coordinateSystem.addAxis(new Axis("Z", AxisDirectionType.NORTH));
                    break;
                }
                default: {
                    throw new CRSException("Unexpected Coordinate Reference System Type: " + (Object)((Object)type));
                }
            }
        }
        coordinateSystem.setDimension(coordinateSystem.numAxes());
        if (this.isUnitNext()) {
            this.readSeparator();
            coordinateSystem.setUnit(this.readUnit());
        }
        return coordinateSystem;
    }

    public VerticalReferenceFrame readVerticalDatumCompat() throws IOException {
        return this.readVerticalDatumCompat(null);
    }

    public VerticalReferenceFrame readVerticalDatumCompat(SimpleCoordinateReferenceSystem crs) throws IOException {
        ReferenceFrame referenceFrame = this.readDatumCompat(crs);
        if (!(referenceFrame instanceof VerticalReferenceFrame)) {
            throw new CRSException("Datum was not an expected Vertical Reference Frame");
        }
        return (VerticalReferenceFrame)referenceFrame;
    }

    public EngineeringDatum readEngineeringDatumCompat() throws IOException {
        return this.readEngineeringDatumCompat(null);
    }

    public EngineeringDatum readEngineeringDatumCompat(SimpleCoordinateReferenceSystem crs) throws IOException {
        ReferenceFrame referenceFrame = this.readDatumCompat(crs);
        if (!(referenceFrame instanceof EngineeringDatum)) {
            throw new CRSException("Datum was not an expected Engineering Datum");
        }
        return (EngineeringDatum)referenceFrame;
    }

    public ReferenceFrame readDatumCompat() throws IOException {
        return this.readDatumCompat(null);
    }

    public ReferenceFrame readDatumCompat(SimpleCoordinateReferenceSystem crs) throws IOException {
        CRSKeyword keyword;
        ReferenceFrame referenceFrame = null;
        CRSKeyword type = this.readKeyword(CRSKeyword.VDATUM, CRSKeyword.EDATUM);
        switch (type) {
            case VDATUM: {
                referenceFrame = new VerticalReferenceFrame();
                break;
            }
            case EDATUM: {
                referenceFrame = new EngineeringDatum();
                break;
            }
            default: {
                throw new CRSException("Unexpected Datum type: " + (Object)((Object)type));
            }
        }
        this.readLeftDelimiter();
        referenceFrame.setName(this.reader.readExpectedToken());
        this.readSeparator();
        double datumType = this.reader.readNumber();
        if (crs != null) {
            crs.addExtra("datumType", Double.toString(datumType));
        }
        if ((keyword = this.readToKeyword(CRSKeyword.ID, CRSKeyword.EXTENSION)) == CRSKeyword.ID) {
            referenceFrame.setIdentifiers(this.readIdentifiers());
            keyword = this.readToKeyword(CRSKeyword.EXTENSION);
        }
        if (keyword == CRSKeyword.EXTENSION) {
            Map<String, Object> extensions = this.readExtensionsCompat();
            if (crs != null) {
                crs.addExtras(extensions);
            }
        }
        this.readRightDelimiter();
        return referenceFrame;
    }

    public String[] readToWGS84Compat() throws IOException {
        String[] value = new String[7];
        this.readKeyword(CRSKeyword.TOWGS84);
        this.readLeftDelimiter();
        for (int i = 0; i < value.length; ++i) {
            if (i > 0) {
                this.readSeparator();
            }
            value[i] = this.reader.readExpectedToken();
        }
        this.readRightDelimiter();
        return value;
    }

    public Map<String, Object> readExtensionsCompat() throws IOException {
        LinkedHashMap<String, Object> extensions = new LinkedHashMap<String, Object>();
        do {
            if (!extensions.isEmpty()) {
                this.readSeparator();
            }
            this.readKeyword(CRSKeyword.EXTENSION);
            this.readLeftDelimiter();
            String key = this.reader.readExpectedToken();
            this.readSeparator();
            String value = this.reader.readExpectedToken();
            extensions.put(key, value);
            this.readRightDelimiter();
        } while (this.isKeywordNext(CRSKeyword.EXTENSION));
        return extensions;
    }

    private void validateUnsignedDouble(Double value) {
        if (value == null || value < 0.0) {
            throw new CRSException("Invalid unsigned number. found: " + value);
        }
    }
}

