/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.crs.wkt;

import java.io.IOException;
import mil.nga.crs.CRSException;
import mil.nga.crs.CRSType;
import mil.nga.crs.common.CoordinateSystemType;
import mil.nga.crs.common.UnitType;
import mil.nga.crs.wkt.CRSKeyword;
import mil.nga.crs.wkt.TextReader;

public class WKTUtils {
    public static boolean isLeftDelimiter(String text) {
        return text.equals("[") || text.equals("(");
    }

    public static boolean isRightDelimiter(String text) {
        return text.equals("]") || text.equals(")");
    }

    public static boolean isSpatial(CoordinateSystemType type) {
        boolean value = false;
        switch (type) {
            case AFFINE: 
            case CARTESIAN: 
            case CYLINDRICAL: 
            case ELLIPSOIDAL: 
            case LINEAR: 
            case PARAMETRIC: 
            case POLAR: 
            case SPHERICAL: 
            case VERTICAL: {
                value = true;
                break;
            }
        }
        return value;
    }

    public static boolean isTemporalCountMeasure(CoordinateSystemType type) {
        boolean value = false;
        switch (type) {
            case TEMPORAL_COUNT: 
            case TEMPORAL_MEASURE: {
                value = true;
                break;
            }
        }
        return value;
    }

    public static boolean isOrdinalDateTime(CoordinateSystemType type) {
        boolean value = false;
        switch (type) {
            case ORDINAL: 
            case TEMPORAL_DATE_TIME: {
                value = true;
                break;
            }
        }
        return value;
    }

    public static UnitType getUnitType(CRSKeyword keyword) {
        UnitType unitType = null;
        try {
            unitType = UnitType.valueOf(keyword.name());
        }
        catch (Exception e) {
            throw new CRSException("No unit type found. keyword: " + (Object)((Object)keyword), e);
        }
        return unitType;
    }

    public static CRSType getCoordinateReferenceSystemType(CRSKeyword keyword) {
        CRSType crsType = null;
        switch (keyword) {
            case GEODCRS: 
            case BASEGEODCRS: 
            case GEOCCS: {
                crsType = CRSType.GEODETIC;
                break;
            }
            case GEOGCRS: 
            case BASEGEOGCRS: 
            case GEOGCS: {
                crsType = CRSType.GEOGRAPHIC;
                break;
            }
            default: {
                throw new CRSException("No coordinate reference system type found. keyword: " + (Object)((Object)keyword));
            }
        }
        return crsType;
    }

    public static String pretty(String wkt) throws IOException {
        return WKTUtils.pretty(wkt, "    ");
    }

    public static String prettyTabIndent(String wkt) throws IOException {
        return WKTUtils.pretty(wkt, "\t");
    }

    public static String prettyNoIndent(String wkt) throws IOException {
        return WKTUtils.pretty(wkt, "");
    }

    public static String pretty(String wkt, String indent) throws IOException {
        return WKTUtils.pretty(wkt, "\n", indent);
    }

    public static String pretty(String wkt, String newline, String indent) throws IOException {
        StringBuilder pretty = new StringBuilder();
        int depth = 0;
        TextReader reader = new TextReader(wkt, true);
        String previousToken = reader.readToken();
        String token = reader.readToken();
        while (previousToken != null) {
            if (token != null && (token.equals("[") || token.equals("("))) {
                ++depth;
                if (pretty.length() > 0) {
                    pretty.append(newline);
                }
                for (int i = 1; i < depth; ++i) {
                    pretty.append(indent);
                }
            }
            pretty.append(previousToken);
            if (previousToken.equals("]") || previousToken.equals(")")) {
                --depth;
            }
            previousToken = token;
            token = reader.readToken();
        }
        reader.close();
        return pretty.toString();
    }
}

