package mil.nga.crs.wkt;

/**
 * Well-Known Text constants
 * 
 * @author osbornb
 */
public class WKTConstants {

	/**
	 * Separator
	 */
	public static final String SEPARATOR = ",";

	/**
	 * Left Delimiter
	 */
	public static final String LEFT_DELIMITER = "[";

	/**
	 * Backwards Compatible Left Delimiter
	 */
	public static final String LEFT_DELIMITER_COMPAT = "(";

	/**
	 * Right Delimiter
	 */
	public static final String RIGHT_DELIMITER = "]";

	/**
	 * Backwards Compatible Right Delimiter
	 */
	public static final String RIGHT_DELIMITER_COMPAT = ")";

	/**
	 * Axis Abbreviation Left Delimiter
	 */
	public static final String AXIS_ABBREV_LEFT_DELIMITER = "(";

	/**
	 * Axis Abbreviation Right Delimiter
	 */
	public static final String AXIS_ABBREV_RIGHT_DELIMITER = ")";

	/**
	 * Backwards Compatible Other Axis Direction
	 */
	public static final String AXIS_DIRECTION_OTHER = "other";

	/**
	 * Backwards Compatible Default Axis Name for geographic longitude
	 */
	public static final String AXIS_NAME_LON = "Lon";

	/**
	 * Backwards Compatible Default Axis Name for geographic latitude
	 */
	public static final String AXIS_NAME_LAT = "Lat";

	/**
	 * Backwards Compatible Default Axis Name for projected and geodetic x
	 */
	public static final String AXIS_NAME_X = "X";

	/**
	 * Backwards Compatible Default Axis Name for projected and geodetic x
	 */
	public static final String AXIS_NAME_Y = "Y";

	/**
	 * Backwards Compatible Default Axis Name for projected and geodetic x
	 */
	public static final String AXIS_NAME_Z = "Z";

	/**
	 * Backwards Compatible Datum Type extra value key name
	 */
	public static final String DATUM_TYPE = "datumType";

}
