package mil.nga.crs.util.proj;

/**
 * Projection constants
 * 
 * @author osbornb
 * @since 1.1.0
 */
public class ProjConstants {

	/**
	 * proj param
	 */
	public static final String PARAM_PROJ = "proj";

	/**
	 * zone param
	 */
	public static final String PARAM_ZONE = "zone";

	/**
	 * south param
	 */
	public static final String PARAM_SOUTH = "south";

	/**
	 * lat_1 param
	 */
	public static final String PARAM_LAT_1 = "lat_1";

	/**
	 * lat_2 param
	 */
	public static final String PARAM_LAT_2 = "lat_2";

	/**
	 * lat_0 param
	 */
	public static final String PARAM_LAT_0 = "lat_0";

	/**
	 * lat_ts param
	 */
	public static final String PARAM_LAT_TS = "lat_ts";

	/**
	 * lon_0 param
	 */
	public static final String PARAM_LON_0 = "lon_0";

	/**
	 * lonc param
	 */
	public static final String PARAM_LONC = "lonc";

	/**
	 * alpha param
	 */
	public static final String PARAM_ALPHA = "alpha";

	/**
	 * k_0 param
	 */
	public static final String PARAM_K_0 = "k_0";

	/**
	 * x_0 param
	 */
	public static final String PARAM_X_0 = "x_0";

	/**
	 * y_0 param
	 */
	public static final String PARAM_Y_0 = "y_0";

	/**
	 * axis param
	 */
	public static final String PARAM_AXIS = "axis";

	/**
	 * datum param
	 */
	public static final String PARAM_DATUM = "datum";

	/**
	 * no_uoff param
	 */
	public static final String PARAM_NO_UOFF = "no_uoff";

	/**
	 * gamma param
	 */
	public static final String PARAM_GAMMA = "gamma";

	/**
	 * a param
	 */
	public static final String PARAM_A = "a";

	/**
	 * b param
	 */
	public static final String PARAM_B = "b";

	/**
	 * ellps param
	 */
	public static final String PARAM_ELLPS = "ellps";

	/**
	 * towgs84 param
	 */
	public static final String PARAM_TOWGS84 = "towgs84";

	/**
	 * pm param
	 */
	public static final String PARAM_PM = "pm";

	/**
	 * units param
	 */
	public static final String PARAM_UNITS = "units";

	/**
	 * to_meter param
	 */
	public static final String PARAM_TO_METER = "to_meter";

	/**
	 * nadgrids param
	 */
	public static final String PARAM_NADGRIDS = "nadgrids";

	/**
	 * wktext param
	 */
	public static final String PARAM_WKTEXT = "wktext";

	/**
	 * no_defs param
	 */
	public static final String PARAM_NO_DEFS = "no_defs";

	/**
	 * Albers Equal Area projection name
	 */
	public static final String NAME_AEA = "aea";

	/**
	 * Cassini Soldner projection name
	 */
	public static final String NAME_CASS = "cass";

	/**
	 * Lambert Cylindrical Equal Area projection name
	 */
	public static final String NAME_CEA = "cea";

	/**
	 * Equidistant Cylindrical projection name
	 */
	public static final String NAME_EQC = "eqc";

	/**
	 * Krovak projection name
	 */
	public static final String NAME_KROVAK = "krovak";

	/**
	 * Lambert Azimuthal Equal Area projection name
	 */
	public static final String NAME_LAEA = "laea";

	/**
	 * Lambert Conic Conformal projection name
	 */
	public static final String NAME_LCC = "lcc";

	/**
	 * Longitude Latitude projection name
	 */
	public static final String NAME_LONGLAT = "longlat";

	/**
	 * Mercator projection name
	 */
	public static final String NAME_MERC = "merc";

	/**
	 * New Zealand Map Grid projection name
	 */
	public static final String NAME_NZMG = "nzmg";

	/**
	 * Hotine Oblique Mercator projection name
	 */
	public static final String NAME_OMERC = "omerc";

	/**
	 * American Polyconic projection name
	 */
	public static final String NAME_POLY = "poly";

	/**
	 * Swiss Hotine Oblique Mercator projection name
	 */
	public static final String NAME_SOMERC = "somerc";

	/**
	 * Polar Stereographic projection name
	 */
	public static final String NAME_STERE = "stere";

	/**
	 * Oblique Stereographic projection name
	 */
	public static final String NAME_STEREA = "sterea";

	/**
	 * Transverse Mercator projection name
	 */
	public static final String NAME_TMERC = "tmerc";

	/**
	 * UTM Zone projection name
	 */
	public static final String NAME_UTM = "utm";

	/**
	 * east axis
	 */
	public static final String AXIS_EAST = "e";

	/**
	 * west axis
	 */
	public static final String AXIS_WEST = "w";

	/**
	 * north axis
	 */
	public static final String AXIS_NORTH = "n";

	/**
	 * south axis
	 */
	public static final String AXIS_SOUTH = "s";

	/**
	 * up axis
	 */
	public static final String AXIS_UP = "u";

	/**
	 * down axis
	 */
	public static final String AXIS_DOWN = "d";

	/**
	 * Axis West South Up
	 */
	public static final String AXIS_WEST_SOUTH_UP = AXIS_WEST + AXIS_SOUTH
			+ AXIS_UP;

	/**
	 * metre units
	 */
	public static final String UNITS_METRE = "m";

	/**
	 * US survey foot units
	 */
	public static final String UNITS_US_SURVEY_FOOT = "us-ft";

	/**
	 * foot units
	 */
	public static final String UNITS_FOOT = "ft";

	/**
	 * degree units
	 */
	public static final String UNITS_DEGREE = "deg";

	/**
	 * Pseudo Mercator name identifier
	 */
	public static final String PSEUDO_MERCATOR = "pseudo";

	/**
	 * Swiss Oblique Mercator name
	 */
	public static final String SWISS_OBLIQUE_MERCATOR = "swiss oblique mercator";

	/**
	 * Swiis Oblique Mercator backward compatible name
	 */
	public static final String SWISS_OBLIQUE_MERCATOR_COMPAT = "hotine_oblique_mercator_azimuth_center";

	/**
	 * UTM Zone name
	 */
	public static final String UTM_ZONE = "utm zone";

}
