/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.crs.wkt;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import mil.nga.crs.CRSException;

public enum CRSKeyword {
    ABRIDGEDTRANSFORMATION(new String[0]),
    ANCHOR(new String[0]),
    ANGLEUNIT("UNIT"),
    AREA(new String[0]),
    AXIS(new String[0]),
    BASEENGCRS(new String[0]),
    BASEGEODCRS(new String[0]),
    BASEGEOGCRS(new String[0]),
    BASEPARAMCRS(new String[0]),
    BASEPROJCRS(new String[0]),
    BASETIMECRS(new String[0]),
    BASEVERTCRS(new String[0]),
    BBOX(new String[0]),
    BEARING(new String[0]),
    BOUNDCRS(new String[0]),
    CALENDAR(new String[0]),
    CITATION(new String[0]),
    CONVERSION(new String[0]),
    COMPOUNDCRS("COMPD_CS"),
    CONCATENATEDOPERATION(new String[0]),
    COORDINATEMETADATA(new String[0]),
    COORDINATEOPERATION(new String[0]),
    CS(new String[0]),
    DATUM("GEODETICDATUM", "TRF"),
    DERIVEDPROJCRS("DERIVEDPROJECTEDCRS"),
    DERIVINGCONVERSION(new String[0]),
    DYNAMIC(new String[0]),
    EDATUM("ENGINEERINGDATUM", "LOCAL_DATUM"),
    ELLIPSOID("SPHEROID"),
    ENGCRS("ENGINEERINGCRS"),
    ENSEMBLE(new String[0]),
    ENSEMBLEACCURACY(new String[0]),
    EPOCH("COORDEPOCH"),
    EXTENSION(new String[0]),
    FRAMEEPOCH(new String[0]),
    GEOCCS(new String[0]),
    GEODCRS("GEODETICCRS"),
    GEOGCS(new String[0]),
    GEOGCRS("GEOGRAPHICCRS"),
    GEOIDMODEL(new String[0]),
    ID("AUTHORITY"),
    INTERPOLATIONCRS(new String[0]),
    LENGTHUNIT("UNIT"),
    LOCAL_CS(new String[0]),
    MEMBER(new String[0]),
    MERIDIAN(new String[0]),
    METHOD("PROJECTION"),
    MODEL("VELOCITYGRID"),
    OPERATIONACCURACY(new String[0]),
    ORDER(new String[0]),
    PARAMETER(new String[0]),
    PARAMETERFILE(new String[0]),
    PARAMETRICCRS(new String[0]),
    PARAMETRICUNIT(new String[0]),
    PDATUM("PARAMETRICDATUM"),
    POINTMOTIONOPERATION(new String[0]),
    PRIMEM("PRIMEMERIDIAN"),
    PROJCRS("PROJECTEDCRS"),
    PROJCS(new String[0]),
    REMARK(new String[0]),
    SCALEUNIT("UNIT"),
    SCOPE(new String[0]),
    SOURCECRS(new String[0]),
    STEP(new String[0]),
    TARGETCRS(new String[0]),
    TDATUM("TIMEDATUM"),
    TIMECRS(new String[0]),
    TIMEEXTENT(new String[0]),
    TIMEORIGIN(new String[0]),
    TIMEUNIT("TEMPORALQUANTITY"),
    TOWGS84("ABRIDGEDTRANSFORMATION"),
    TRIAXIAL(new String[0]),
    USAGE(new String[0]),
    URI(new String[0]),
    VDATUM("VRF", "VERTICALDATUM", "VERT_DATUM"),
    VERSION(new String[0]),
    VERT_CS(new String[0]),
    VERTCRS("VERTICALCRS"),
    VERTICALEXTENT(new String[0]);

    private static final Map<String, Set<CRSKeyword>> keywordTypes;
    private final Set<String> keywords = new LinkedHashSet<String>();

    private CRSKeyword(String ... additionalKeywords) {
        this.keywords.add(this.name());
        this.keywords.addAll(Arrays.asList(additionalKeywords));
    }

    public Set<String> getKeywords() {
        return Collections.unmodifiableSet(this.keywords);
    }

    public static CRSKeyword getType(String keyword) {
        CRSKeyword type = null;
        Set<CRSKeyword> types = CRSKeyword.getTypes(keyword);
        if (types != null && !types.isEmpty()) {
            type = types.iterator().next();
        }
        return type;
    }

    public static CRSKeyword getRequiredType(String keyword) {
        CRSKeyword type = CRSKeyword.getType(keyword);
        if (type == null) {
            throw new CRSException("No Coordinate Reference System Keyword for value: " + keyword);
        }
        return type;
    }

    public static Set<CRSKeyword> getTypes(String keyword) {
        Set<CRSKeyword> types = null;
        if (keyword != null) {
            types = keywordTypes.get(keyword.toUpperCase());
        }
        return types;
    }

    public static Set<CRSKeyword> getRequiredTypes(String keyword) {
        Set<CRSKeyword> types = CRSKeyword.getTypes(keyword);
        if (types == null || types.isEmpty()) {
            throw new CRSException("No Coordinate Reference System Keywords for value: " + keyword);
        }
        return types;
    }

    static {
        keywordTypes = new HashMap<String, Set<CRSKeyword>>();
        for (CRSKeyword type : CRSKeyword.values()) {
            for (String keyword : type.keywords) {
                String keywordUpperCase = keyword.toUpperCase();
                Set<CRSKeyword> keywordSet = keywordTypes.get(keywordUpperCase);
                if (keywordSet == null) {
                    keywordSet = new HashSet<CRSKeyword>();
                    keywordTypes.put(keywordUpperCase, keywordSet);
                }
                keywordSet.add(type);
            }
        }
    }
}

