/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.proj.Projection;

public class VanDerGrintenProjection
extends Projection {
    private static final double TOL = 1.0E-10;
    private static final double THIRD = 0.3333333333333333;
    private static final double TWO_THRD = 0.6666666666666666;
    private static final double C2_27 = 0.07407407407407407;
    private static final double PI4_3 = 4.188790204786391;
    private static final double PISQ = Math.PI * Math.PI;
    private static final double TPISQ = 19.739208802178716;
    private static final double HPISQ = 4.934802200544679;

    @Override
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate out) {
        double p2 = Math.abs(lpphi / 1.5707963267948966);
        if (p2 - 1.0E-10 > 1.0) {
            throw new ProjectionException("F");
        }
        if (p2 > 1.0) {
            p2 = 1.0;
        }
        if (Math.abs(lpphi) <= 1.0E-10) {
            out.x = lplam;
            out.y = 0.0;
        } else if (Math.abs(lplam) <= 1.0E-10 || Math.abs(p2 - 1.0) < 1.0E-10) {
            out.x = 0.0;
            out.y = Math.PI * Math.tan(0.5 * Math.asin(p2));
            if (lpphi < 0.0) {
                out.y = -out.y;
            }
        } else {
            double al = 0.5 * Math.abs(Math.PI / lplam - lplam / Math.PI);
            double al2 = al * al;
            double g = Math.sqrt(1.0 - p2 * p2);
            g /= p2 + g - 1.0;
            double g2 = g * g;
            p2 = g * (2.0 / p2 - 1.0);
            p2 *= p2;
            out.x = g - p2;
            g = p2 + al2;
            out.x = Math.PI * (al * out.x + Math.sqrt(al2 * out.x * out.x - g * (g2 - p2))) / g;
            if (lplam < 0.0) {
                out.x = -out.x;
            }
            out.y = Math.abs(out.x / Math.PI);
            out.y = 1.0 - out.y * (out.y + 2.0 * al);
            if (out.y < -1.0E-10) {
                throw new ProjectionException("F");
            }
            out.y = out.y < 0.0 ? 0.0 : Math.sqrt(out.y) * (lpphi < 0.0 ? -Math.PI : Math.PI);
        }
        return out;
    }

    @Override
    public ProjCoordinate projectInverse(double xyx, double xyy, ProjCoordinate out) {
        double d;
        double d2;
        double x2 = xyx * xyx;
        double ay = Math.abs(xyy);
        if (d2 < 1.0E-10) {
            out.y = 0.0;
            double t = x2 * x2 + 19.739208802178716 * (x2 + 4.934802200544679);
            out.x = Math.abs(xyx) <= 1.0E-10 ? 0.0 : 0.5 * (x2 - Math.PI * Math.PI + Math.sqrt(t)) / xyx;
            return out;
        }
        double y2 = xyy * xyy;
        double r = x2 + y2;
        double r2 = r * r;
        double c1 = -Math.PI * ay * (r + Math.PI * Math.PI);
        double c3 = r2 + Math.PI * 2 * (ay * r + Math.PI * (y2 + Math.PI * (ay + 1.5707963267948966)));
        double c2 = c1 + Math.PI * Math.PI * (r - 3.0 * y2);
        double c0 = Math.PI * ay;
        double al = c1 / c3 - 0.3333333333333333 * (c2 /= c3) * c2;
        double m = 2.0 * Math.sqrt(-0.3333333333333333 * al);
        double d3 = 0.07407407407407407 * c2 * c2 * c2 + (c0 * c0 - 0.3333333333333333 * c2 * c1) / c3;
        d3 = 3.0 * d3 / (al * m);
        double t = Math.abs(d3);
        if (d - 1.0E-10 <= 1.0) {
            d3 = t > 1.0 ? (d3 > 0.0 ? 0.0 : Math.PI) : Math.acos(d3);
            out.y = Math.PI * (m * Math.cos(d3 * 0.3333333333333333 + 4.188790204786391) - 0.3333333333333333 * c2);
            if (xyy < 0.0) {
                out.y = -out.y;
            }
        } else {
            throw new ProjectionException("I");
        }
        t = r2 + 19.739208802178716 * (x2 - y2 + 4.934802200544679);
        out.x = Math.abs(xyx) <= 1.0E-10 ? 0.0 : 0.5 * (r - Math.PI * Math.PI + (t <= 0.0 ? 0.0 : Math.sqrt(t))) / xyx;
        return out;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "van der Grinten (I)";
    }
}

