/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.factory;

import com.j256.ormlite.dao.BaseDaoImpl;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.core.contents.Contents;
import mil.nga.geopackage.core.contents.ContentsDao;
import mil.nga.geopackage.core.contents.ContentsDataType;
import mil.nga.geopackage.core.srs.SpatialReferenceSystem;
import mil.nga.geopackage.core.srs.SpatialReferenceSystemDao;
import mil.nga.geopackage.core.srs.SpatialReferenceSystemSfSql;
import mil.nga.geopackage.core.srs.SpatialReferenceSystemSfSqlDao;
import mil.nga.geopackage.core.srs.SpatialReferenceSystemSqlMm;
import mil.nga.geopackage.core.srs.SpatialReferenceSystemSqlMmDao;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.db.GeoPackageTableCreator;
import mil.nga.geopackage.extension.Extensions;
import mil.nga.geopackage.extension.ExtensionsDao;
import mil.nga.geopackage.extension.index.GeometryIndex;
import mil.nga.geopackage.extension.index.GeometryIndexDao;
import mil.nga.geopackage.extension.index.TableIndex;
import mil.nga.geopackage.extension.index.TableIndexDao;
import mil.nga.geopackage.features.columns.GeometryColumns;
import mil.nga.geopackage.features.columns.GeometryColumnsDao;
import mil.nga.geopackage.features.columns.GeometryColumnsSfSql;
import mil.nga.geopackage.features.columns.GeometryColumnsSfSqlDao;
import mil.nga.geopackage.features.columns.GeometryColumnsSqlMm;
import mil.nga.geopackage.features.columns.GeometryColumnsSqlMmDao;
import mil.nga.geopackage.features.user.FeatureColumn;
import mil.nga.geopackage.features.user.FeatureTable;
import mil.nga.geopackage.metadata.Metadata;
import mil.nga.geopackage.metadata.MetadataDao;
import mil.nga.geopackage.metadata.reference.MetadataReference;
import mil.nga.geopackage.metadata.reference.MetadataReferenceDao;
import mil.nga.geopackage.schema.columns.DataColumns;
import mil.nga.geopackage.schema.columns.DataColumnsDao;
import mil.nga.geopackage.schema.constraints.DataColumnConstraints;
import mil.nga.geopackage.schema.constraints.DataColumnConstraintsDao;
import mil.nga.geopackage.tiles.matrix.TileMatrix;
import mil.nga.geopackage.tiles.matrix.TileMatrixDao;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSet;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSetDao;
import mil.nga.geopackage.tiles.user.TileColumn;
import mil.nga.geopackage.tiles.user.TileTable;

public abstract class GeoPackageCoreImpl
implements GeoPackageCore {
    private final String name;
    private final String path;
    private final GeoPackageCoreConnection database;
    private final GeoPackageTableCreator tableCreator;
    private final boolean writable;

    protected GeoPackageCoreImpl(String name, String path, GeoPackageCoreConnection database, GeoPackageTableCreator tableCreator, boolean writable) {
        this.name = name;
        this.path = path;
        this.database = database;
        this.tableCreator = tableCreator;
        this.writable = writable;
    }

    @Override
    public void close() {
        this.database.close();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public GeoPackageCoreConnection getDatabase() {
        return this.database;
    }

    @Override
    public boolean isWritable() {
        return this.writable;
    }

    @Override
    public List<String> getFeatureTables() {
        GeometryColumnsDao geometryColumnsDao = this.getGeometryColumnsDao();
        List<String> tableNames = null;
        try {
            if (geometryColumnsDao.isTableExists()) {
                tableNames = geometryColumnsDao.getFeatureTables();
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to retrieve feature tables", e);
        }
        if (tableNames == null) {
            tableNames = new ArrayList<String>();
        }
        return tableNames;
    }

    @Override
    public List<String> getTileTables() {
        TileMatrixSetDao tileMatrixSetDao = this.getTileMatrixSetDao();
        List<String> tableNames = null;
        try {
            if (tileMatrixSetDao.isTableExists()) {
                tableNames = tileMatrixSetDao.getTileTables();
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to retrieve tile tables", e);
        }
        if (tableNames == null) {
            tableNames = new ArrayList<String>();
        }
        return tableNames;
    }

    @Override
    public SpatialReferenceSystemDao getSpatialReferenceSystemDao() {
        return (SpatialReferenceSystemDao)((Object)this.createDao(SpatialReferenceSystem.class));
    }

    @Override
    public SpatialReferenceSystemSqlMmDao getSpatialReferenceSystemSqlMmDao() {
        SpatialReferenceSystemSqlMmDao dao = (SpatialReferenceSystemSqlMmDao)((Object)this.createDao(SpatialReferenceSystemSqlMm.class));
        this.verifyTableExists(dao);
        return dao;
    }

    @Override
    public SpatialReferenceSystemSfSqlDao getSpatialReferenceSystemSfSqlDao() {
        SpatialReferenceSystemSfSqlDao dao = (SpatialReferenceSystemSfSqlDao)((Object)this.createDao(SpatialReferenceSystemSfSql.class));
        this.verifyTableExists(dao);
        return dao;
    }

    @Override
    public ContentsDao getContentsDao() {
        ContentsDao dao = (ContentsDao)((Object)this.createDao(Contents.class));
        dao.setDatabase(this.database);
        return dao;
    }

    @Override
    public GeometryColumnsDao getGeometryColumnsDao() {
        return (GeometryColumnsDao)((Object)this.createDao(GeometryColumns.class));
    }

    @Override
    public GeometryColumnsSqlMmDao getGeometryColumnsSqlMmDao() {
        GeometryColumnsSqlMmDao dao = (GeometryColumnsSqlMmDao)((Object)this.createDao(GeometryColumnsSqlMm.class));
        this.verifyTableExists(dao);
        return dao;
    }

    @Override
    public GeometryColumnsSfSqlDao getGeometryColumnsSfSqlDao() {
        GeometryColumnsSfSqlDao dao = (GeometryColumnsSfSqlDao)((Object)this.createDao(GeometryColumnsSfSql.class));
        this.verifyTableExists(dao);
        return dao;
    }

    @Override
    public boolean createGeometryColumnsTable() {
        this.verifyWritable();
        boolean created = false;
        GeometryColumnsDao dao = this.getGeometryColumnsDao();
        try {
            if (!dao.isTableExists()) {
                created = this.tableCreator.createGeometryColumns() > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if " + GeometryColumns.class.getSimpleName() + " table exists and create it", e);
        }
        return created;
    }

    @Override
    public void createFeatureTable(FeatureTable table) {
        this.verifyWritable();
        this.tableCreator.createTable(table);
    }

    @Override
    public GeometryColumns createFeatureTableWithMetadata(GeometryColumns geometryColumns, BoundingBox boundingBox, long srsId) {
        SpatialReferenceSystem srs = this.getSrs(srsId);
        this.createGeometryColumnsTable();
        ArrayList<FeatureColumn> columns = new ArrayList<FeatureColumn>();
        columns.add(FeatureColumn.createPrimaryKeyColumn(0, "id"));
        columns.add(FeatureColumn.createGeometryColumn(1, geometryColumns.getColumnName(), geometryColumns.getGeometryType(), false, null));
        FeatureTable table = new FeatureTable(geometryColumns.getTableName(), (List<FeatureColumn>)columns);
        this.createFeatureTable(table);
        try {
            Contents contents = new Contents();
            contents.setTableName(geometryColumns.getTableName());
            contents.setDataType(ContentsDataType.FEATURES);
            contents.setIdentifier(geometryColumns.getTableName());
            contents.setLastChange(new Date());
            contents.setMinX(boundingBox.getMinLongitude());
            contents.setMinY(boundingBox.getMinLatitude());
            contents.setMaxX(boundingBox.getMaxLongitude());
            contents.setMaxY(boundingBox.getMaxLatitude());
            contents.setSrs(srs);
            this.getContentsDao().create(contents);
            geometryColumns.setContents(contents);
            geometryColumns.setSrs(contents.getSrs());
            this.getGeometryColumnsDao().create(geometryColumns);
        }
        catch (RuntimeException e) {
            this.deleteTableQuietly(geometryColumns.getTableName());
            throw e;
        }
        catch (SQLException e) {
            this.deleteTableQuietly(geometryColumns.getTableName());
            throw new GeoPackageException("Failed to create table and metadata: " + geometryColumns.getTableName(), e);
        }
        return geometryColumns;
    }

    @Override
    public TileMatrixSetDao getTileMatrixSetDao() {
        return (TileMatrixSetDao)((Object)this.createDao(TileMatrixSet.class));
    }

    @Override
    public boolean createTileMatrixSetTable() {
        this.verifyWritable();
        boolean created = false;
        TileMatrixSetDao dao = this.getTileMatrixSetDao();
        try {
            if (!dao.isTableExists()) {
                created = this.tableCreator.createTileMatrixSet() > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if " + TileMatrixSet.class.getSimpleName() + " table exists and create it", e);
        }
        return created;
    }

    @Override
    public TileMatrixDao getTileMatrixDao() {
        return (TileMatrixDao)((Object)this.createDao(TileMatrix.class));
    }

    @Override
    public boolean createTileMatrixTable() {
        this.verifyWritable();
        boolean created = false;
        TileMatrixDao dao = this.getTileMatrixDao();
        try {
            if (!dao.isTableExists()) {
                created = this.tableCreator.createTileMatrix() > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if " + TileMatrix.class.getSimpleName() + " table exists and create it", e);
        }
        return created;
    }

    @Override
    public void createTileTable(TileTable table) {
        this.verifyWritable();
        this.tableCreator.createTable(table);
    }

    @Override
    public TileMatrixSet createTileTableWithMetadata(String tableName, BoundingBox contentsBoundingBox, long contentsSrsId, BoundingBox tileMatrixSetBoundingBox, long tileMatrixSetSrsId) {
        TileMatrixSet tileMatrixSet = null;
        SpatialReferenceSystem contentsSrs = this.getSrs(contentsSrsId);
        SpatialReferenceSystem tileMatrixSetSrs = this.getSrs(tileMatrixSetSrsId);
        this.createTileMatrixSetTable();
        this.createTileMatrixTable();
        List<TileColumn> columns = TileTable.createRequiredColumns();
        TileTable table = new TileTable(tableName, columns);
        this.createTileTable(table);
        try {
            Contents contents = new Contents();
            contents.setTableName(tableName);
            contents.setDataType(ContentsDataType.TILES);
            contents.setIdentifier(tableName);
            contents.setLastChange(new Date());
            contents.setMinX(contentsBoundingBox.getMinLongitude());
            contents.setMinY(contentsBoundingBox.getMinLatitude());
            contents.setMaxX(contentsBoundingBox.getMaxLongitude());
            contents.setMaxY(contentsBoundingBox.getMaxLatitude());
            contents.setSrs(contentsSrs);
            this.getContentsDao().create(contents);
            tileMatrixSet = new TileMatrixSet();
            tileMatrixSet.setContents(contents);
            tileMatrixSet.setSrs(tileMatrixSetSrs);
            tileMatrixSet.setMinX(tileMatrixSetBoundingBox.getMinLongitude());
            tileMatrixSet.setMinY(tileMatrixSetBoundingBox.getMinLatitude());
            tileMatrixSet.setMaxX(tileMatrixSetBoundingBox.getMaxLongitude());
            tileMatrixSet.setMaxY(tileMatrixSetBoundingBox.getMaxLatitude());
            this.getTileMatrixSetDao().create(tileMatrixSet);
        }
        catch (RuntimeException e) {
            this.deleteTableQuietly(tableName);
            throw e;
        }
        catch (SQLException e) {
            this.deleteTableQuietly(tableName);
            throw new GeoPackageException("Failed to create table and metadata: " + tableName, e);
        }
        return tileMatrixSet;
    }

    private SpatialReferenceSystem getSrs(long srsId) {
        SpatialReferenceSystem srs;
        try {
            srs = (SpatialReferenceSystem)this.getSpatialReferenceSystemDao().queryForId(srsId);
        }
        catch (SQLException e1) {
            throw new GeoPackageException("Failed to retrieve Spatial Reference System. SRS ID: " + srsId);
        }
        if (srs == null) {
            throw new GeoPackageException("Spatial Reference System could not be found. SRS ID: " + srsId);
        }
        return srs;
    }

    @Override
    public DataColumnsDao getDataColumnsDao() {
        return (DataColumnsDao)((Object)this.createDao(DataColumns.class));
    }

    @Override
    public boolean createDataColumnsTable() {
        this.verifyWritable();
        boolean created = false;
        DataColumnsDao dao = this.getDataColumnsDao();
        try {
            if (!dao.isTableExists()) {
                created = this.tableCreator.createDataColumns() > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if " + DataColumns.class.getSimpleName() + " table exists and create it", e);
        }
        return created;
    }

    @Override
    public DataColumnConstraintsDao getDataColumnConstraintsDao() {
        return (DataColumnConstraintsDao)((Object)this.createDao(DataColumnConstraints.class));
    }

    @Override
    public boolean createDataColumnConstraintsTable() {
        this.verifyWritable();
        boolean created = false;
        DataColumnConstraintsDao dao = this.getDataColumnConstraintsDao();
        try {
            if (!dao.isTableExists()) {
                created = this.tableCreator.createDataColumnConstraints() > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if " + DataColumnConstraints.class.getSimpleName() + " table exists and create it", e);
        }
        return created;
    }

    @Override
    public MetadataDao getMetadataDao() {
        return (MetadataDao)((Object)this.createDao(Metadata.class));
    }

    @Override
    public boolean createMetadataTable() {
        this.verifyWritable();
        boolean created = false;
        MetadataDao dao = this.getMetadataDao();
        try {
            if (!dao.isTableExists()) {
                created = this.tableCreator.createMetadata() > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if " + Metadata.class.getSimpleName() + " table exists and create it", e);
        }
        return created;
    }

    @Override
    public MetadataReferenceDao getMetadataReferenceDao() {
        return (MetadataReferenceDao)((Object)this.createDao(MetadataReference.class));
    }

    @Override
    public boolean createMetadataReferenceTable() {
        this.verifyWritable();
        boolean created = false;
        MetadataReferenceDao dao = this.getMetadataReferenceDao();
        try {
            if (!dao.isTableExists()) {
                created = this.tableCreator.createMetadataReference() > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if " + MetadataReference.class.getSimpleName() + " table exists and create it", e);
        }
        return created;
    }

    @Override
    public ExtensionsDao getExtensionsDao() {
        return (ExtensionsDao)((Object)this.createDao(Extensions.class));
    }

    @Override
    public boolean createExtensionsTable() {
        this.verifyWritable();
        boolean created = false;
        ExtensionsDao dao = this.getExtensionsDao();
        try {
            if (!dao.isTableExists()) {
                created = this.tableCreator.createExtensions() > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if " + Extensions.class.getSimpleName() + " table exists and create it", e);
        }
        return created;
    }

    @Override
    public void deleteTable(String table) {
        this.verifyWritable();
        ContentsDao contentsDao = this.getContentsDao();
        contentsDao.deleteTable(table);
    }

    @Override
    public void deleteTableQuietly(String tableName) {
        this.verifyWritable();
        try {
            this.deleteTable(tableName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void dropSQLiteTriggers(GeometryColumns geometryColumns) {
        if (this.writable) {
            this.database.execSQL("DROP TRIGGER IF EXISTS rtree_" + geometryColumns.getTableName() + "_" + geometryColumns.getColumnName() + "_insert");
            this.database.execSQL("DROP TRIGGER IF EXISTS rtree_" + geometryColumns.getTableName() + "_" + geometryColumns.getColumnName() + "_update1");
            this.database.execSQL("DROP TRIGGER IF EXISTS rtree_" + geometryColumns.getTableName() + "_" + geometryColumns.getColumnName() + "_update2");
            this.database.execSQL("DROP TRIGGER IF EXISTS rtree_" + geometryColumns.getTableName() + "_" + geometryColumns.getColumnName() + "_update3");
            this.database.execSQL("DROP TRIGGER IF EXISTS rtree_" + geometryColumns.getTableName() + "_" + geometryColumns.getColumnName() + "_update4");
            this.database.execSQL("DROP TRIGGER IF EXISTS rtree_" + geometryColumns.getTableName() + "_" + geometryColumns.getColumnName() + "_delete");
        }
    }

    @Override
    public <T, S extends BaseDaoImpl<T, ?>> S createDao(Class<T> type) {
        BaseDaoImpl dao;
        try {
            dao = (BaseDaoImpl)DaoManager.createDao((ConnectionSource)this.database.getConnectionSource(), type);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to create " + type.getSimpleName() + " dao", e);
        }
        return (S)dao;
    }

    private void verifyTableExists(BaseDaoImpl<?, ?> dao) {
        try {
            if (!dao.isTableExists()) {
                throw new GeoPackageException("Table or view does not exist for: " + dao.getDataClass().getSimpleName());
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to detect if table or view exists for dao: " + dao.getDataClass().getSimpleName(), e);
        }
    }

    @Override
    public void verifyWritable() {
        if (!this.writable) {
            throw new GeoPackageException("GeoPackage file is not writable. Name: " + this.name + (this.path != null ? ", Path: " + this.path : ""));
        }
    }

    @Override
    public TableIndexDao getTableIndexDao() {
        return (TableIndexDao)((Object)this.createDao(TableIndex.class));
    }

    @Override
    public boolean createTableIndexTable() {
        this.verifyWritable();
        boolean created = false;
        TableIndexDao dao = this.getTableIndexDao();
        try {
            if (!dao.isTableExists()) {
                created = this.tableCreator.createTableIndex() > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if " + TableIndex.class.getSimpleName() + " table exists and create it", e);
        }
        return created;
    }

    @Override
    public GeometryIndexDao getGeometryIndexDao() {
        return (GeometryIndexDao)((Object)this.createDao(GeometryIndex.class));
    }

    @Override
    public boolean createGeometryIndexTable() {
        this.verifyWritable();
        boolean created = false;
        GeometryIndexDao dao = this.getGeometryIndexDao();
        try {
            if (!dao.isTableExists()) {
                created = this.tableCreator.createGeometryIndex() > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if " + GeometryIndex.class.getSimpleName() + " table exists and create it", e);
        }
        return created;
    }
}

