/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.tiles;

import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.projection.Projection;
import mil.nga.geopackage.projection.ProjectionConstants;
import mil.nga.geopackage.projection.ProjectionFactory;
import mil.nga.geopackage.projection.ProjectionTransform;
import mil.nga.geopackage.tiles.TileGrid;
import mil.nga.geopackage.tiles.matrix.TileMatrix;
import mil.nga.wkb.geom.Point;

public class TileBoundingBoxUtils {
    private static Projection webMercator = ProjectionFactory.getProjection(3857L);

    public static BoundingBox overlap(BoundingBox boundingBox, BoundingBox boundingBox2) {
        double minLongitude = Math.max(boundingBox.getMinLongitude(), boundingBox2.getMinLongitude());
        double maxLongitude = Math.min(boundingBox.getMaxLongitude(), boundingBox2.getMaxLongitude());
        double minLatitude = Math.max(boundingBox.getMinLatitude(), boundingBox2.getMinLatitude());
        double maxLatitude = Math.min(boundingBox.getMaxLatitude(), boundingBox2.getMaxLatitude());
        BoundingBox overlap = null;
        if (minLongitude < maxLongitude && minLatitude < maxLatitude) {
            overlap = new BoundingBox(minLongitude, maxLongitude, minLatitude, maxLatitude);
        }
        return overlap;
    }

    public static BoundingBox union(BoundingBox boundingBox, BoundingBox boundingBox2) {
        double minLongitude = Math.min(boundingBox.getMinLongitude(), boundingBox2.getMinLongitude());
        double maxLongitude = Math.max(boundingBox.getMaxLongitude(), boundingBox2.getMaxLongitude());
        double minLatitude = Math.min(boundingBox.getMinLatitude(), boundingBox2.getMinLatitude());
        double maxLatitude = Math.max(boundingBox.getMaxLatitude(), boundingBox2.getMaxLatitude());
        BoundingBox union = null;
        if (minLongitude < maxLongitude && minLatitude < maxLatitude) {
            union = new BoundingBox(minLongitude, maxLongitude, minLatitude, maxLatitude);
        }
        return union;
    }

    public static float getXPixel(long width, BoundingBox boundingBox, double longitude) {
        double boxWidth = boundingBox.getMaxLongitude() - boundingBox.getMinLongitude();
        double offset = longitude - boundingBox.getMinLongitude();
        double percentage = offset / boxWidth;
        float pixel = (float)(percentage * (double)width);
        return pixel;
    }

    public static double getLongitudeFromPixel(long width, BoundingBox boundingBox, float pixel) {
        double boxWidth = boundingBox.getMaxLongitude() - boundingBox.getMinLongitude();
        double percentage = pixel / (float)width;
        double offset = percentage * boxWidth;
        double longitude = offset + boundingBox.getMinLongitude();
        return longitude;
    }

    public static float getYPixel(long height, BoundingBox boundingBox, double latitude) {
        double boxHeight = boundingBox.getMaxLatitude() - boundingBox.getMinLatitude();
        double offset = boundingBox.getMaxLatitude() - latitude;
        double percentage = offset / boxHeight;
        float pixel = (float)(percentage * (double)height);
        return pixel;
    }

    public static double getLatitudeFromPixel(long height, BoundingBox boundingBox, float pixel) {
        double boxHeight = boundingBox.getMaxLatitude() - boundingBox.getMinLatitude();
        double percentage = pixel / (float)height;
        double offset = percentage * boxHeight;
        double latitude = boundingBox.getMaxLatitude() - offset;
        return latitude;
    }

    public static BoundingBox getBoundingBox(int x, int y, int zoom) {
        int tilesPerSide = TileBoundingBoxUtils.tilesPerSide(zoom);
        double tileWidthDegrees = TileBoundingBoxUtils.tileWidthDegrees(tilesPerSide);
        double tileHeightDegrees = TileBoundingBoxUtils.tileHeightDegrees(tilesPerSide);
        double minLon = -180.0 + (double)x * tileWidthDegrees;
        double maxLon = minLon + tileWidthDegrees;
        double maxLat = 90.0 - (double)y * tileHeightDegrees;
        double minLat = maxLat - tileHeightDegrees;
        BoundingBox box = new BoundingBox(minLon, maxLon, minLat, maxLat);
        return box;
    }

    public static BoundingBox getWebMercatorBoundingBox(long x, long y, int zoom) {
        int tilesPerSide = TileBoundingBoxUtils.tilesPerSide(zoom);
        double tileSize = TileBoundingBoxUtils.tileSize(tilesPerSide);
        double minLon = -1.0 * ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH + (double)x * tileSize;
        double maxLon = -1.0 * ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH + (double)(x + 1L) * tileSize;
        double minLat = ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH - (double)(y + 1L) * tileSize;
        double maxLat = ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH - (double)y * tileSize;
        BoundingBox box = new BoundingBox(minLon, maxLon, minLat, maxLat);
        return box;
    }

    public static BoundingBox getWebMercatorBoundingBox(TileGrid tileGrid, int zoom) {
        int tilesPerSide = TileBoundingBoxUtils.tilesPerSide(zoom);
        double tileSize = TileBoundingBoxUtils.tileSize(tilesPerSide);
        double minLon = -1.0 * ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH + (double)tileGrid.getMinX() * tileSize;
        double maxLon = -1.0 * ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH + (double)(tileGrid.getMaxX() + 1L) * tileSize;
        double minLat = ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH - (double)(tileGrid.getMaxY() + 1L) * tileSize;
        double maxLat = ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH - (double)tileGrid.getMinY() * tileSize;
        BoundingBox box = new BoundingBox(minLon, maxLon, minLat, maxLat);
        return box;
    }

    public static BoundingBox getProjectedBoundingBox(Long projectionEpsg, int x, int y, int zoom) {
        BoundingBox boundingBox = TileBoundingBoxUtils.getWebMercatorBoundingBox(x, y, zoom);
        if (projectionEpsg != null) {
            ProjectionTransform transform = webMercator.getTransformation(projectionEpsg);
            boundingBox = transform.transform(boundingBox);
        }
        return boundingBox;
    }

    public static BoundingBox getProjectedBoundingBox(Projection projection, long x, long y, int zoom) {
        BoundingBox boundingBox = TileBoundingBoxUtils.getWebMercatorBoundingBox(x, y, zoom);
        if (projection != null) {
            ProjectionTransform transform = webMercator.getTransformation(projection);
            boundingBox = transform.transform(boundingBox);
        }
        return boundingBox;
    }

    public static BoundingBox getProjectedBoundingBox(Long projectionEpsg, TileGrid tileGrid, int zoom) {
        BoundingBox boundingBox = TileBoundingBoxUtils.getWebMercatorBoundingBox(tileGrid, zoom);
        if (projectionEpsg != null) {
            ProjectionTransform transform = webMercator.getTransformation(projectionEpsg);
            boundingBox = transform.transform(boundingBox);
        }
        return boundingBox;
    }

    public static BoundingBox getProjectedBoundingBox(Projection projection, TileGrid tileGrid, int zoom) {
        BoundingBox boundingBox = TileBoundingBoxUtils.getWebMercatorBoundingBox(tileGrid, zoom);
        if (projection != null) {
            ProjectionTransform transform = webMercator.getTransformation(projection);
            boundingBox = transform.transform(boundingBox);
        }
        return boundingBox;
    }

    public static TileGrid getTileGridFromWGS84(Point point, int zoom) {
        Projection projection = ProjectionFactory.getProjection(4326L);
        return TileBoundingBoxUtils.getTileGrid(point, zoom, projection);
    }

    public static TileGrid getTileGrid(Point point, int zoom, Projection projection) {
        ProjectionTransform toWebMercator = projection.getTransformation(3857L);
        Point webMercatorPoint = toWebMercator.transform(point);
        BoundingBox boundingBox = new BoundingBox(webMercatorPoint.getX(), webMercatorPoint.getX(), webMercatorPoint.getY(), webMercatorPoint.getY());
        return TileBoundingBoxUtils.getTileGrid(boundingBox, zoom);
    }

    public static TileGrid getTileGrid(BoundingBox webMercatorBoundingBox, int zoom) {
        int tilesPerSide = TileBoundingBoxUtils.tilesPerSide(zoom);
        double tileSize = TileBoundingBoxUtils.tileSize(tilesPerSide);
        int minX = (int)((webMercatorBoundingBox.getMinLongitude() + ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH) / tileSize);
        double tempMaxX = (webMercatorBoundingBox.getMaxLongitude() + ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH) / tileSize;
        int maxX = (int)(tempMaxX - ProjectionConstants.WEB_MERCATOR_PRECISION);
        maxX = Math.min(maxX, tilesPerSide - 1);
        int minY = (int)((webMercatorBoundingBox.getMaxLatitude() - ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH) * -1.0 / tileSize);
        double tempMaxY = (webMercatorBoundingBox.getMinLatitude() - ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH) * -1.0 / tileSize;
        int maxY = (int)(tempMaxY - ProjectionConstants.WEB_MERCATOR_PRECISION);
        maxY = Math.min(maxY, tilesPerSide - 1);
        TileGrid grid = new TileGrid(minX, maxX, minY, maxY);
        return grid;
    }

    public static BoundingBox toWebMercator(BoundingBox boundingBox) {
        double minLatitude = Math.max(boundingBox.getMinLatitude(), -85.05112877980659);
        double maxLatitude = Math.min(boundingBox.getMaxLatitude(), 85.0511287798066);
        Point lowerLeftPoint = new Point(false, false, boundingBox.getMinLongitude(), minLatitude);
        Point upperRightPoint = new Point(false, false, boundingBox.getMaxLongitude(), maxLatitude);
        ProjectionTransform toWebMercator = ProjectionFactory.getProjection(4326L).getTransformation(3857L);
        lowerLeftPoint = toWebMercator.transform(lowerLeftPoint);
        upperRightPoint = toWebMercator.transform(upperRightPoint);
        BoundingBox mercatorBox = new BoundingBox(lowerLeftPoint.getX(), upperRightPoint.getX(), lowerLeftPoint.getY(), upperRightPoint.getY());
        return mercatorBox;
    }

    public static double tileSize(int tilesPerSide) {
        return 2.0 * ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH / (double)tilesPerSide;
    }

    public static double tileWidthDegrees(int tilesPerSide) {
        return 360.0 / (double)tilesPerSide;
    }

    public static double tileHeightDegrees(int tilesPerSide) {
        return 180.0 / (double)tilesPerSide;
    }

    public static int tilesPerSide(int zoom) {
        return (int)Math.pow(2.0, zoom);
    }

    public static int getYAsOppositeTileFormat(int zoom, int y) {
        int tilesPerSide = TileBoundingBoxUtils.tilesPerSide(zoom);
        int oppositeY = tilesPerSide - y - 1;
        return oppositeY;
    }

    public static int zoomFromTilesPerSide(int tilesPerSide) {
        return (int)(Math.log(tilesPerSide) / Math.log(2.0));
    }

    public static TileGrid getTileGrid(BoundingBox webMercatorTotalBox, long matrixWidth, long matrixHeight, BoundingBox webMercatorBoundingBox) {
        long minColumn = TileBoundingBoxUtils.getTileColumn(webMercatorTotalBox, matrixWidth, webMercatorBoundingBox.getMinLongitude());
        long maxColumn = TileBoundingBoxUtils.getTileColumn(webMercatorTotalBox, matrixWidth, webMercatorBoundingBox.getMaxLongitude());
        if (minColumn < matrixWidth && maxColumn >= 0L) {
            if (minColumn < 0L) {
                minColumn = 0L;
            }
            if (maxColumn >= matrixWidth) {
                maxColumn = matrixWidth - 1L;
            }
        }
        long maxRow = TileBoundingBoxUtils.getTileRow(webMercatorTotalBox, matrixHeight, webMercatorBoundingBox.getMinLatitude());
        long minRow = TileBoundingBoxUtils.getTileRow(webMercatorTotalBox, matrixHeight, webMercatorBoundingBox.getMaxLatitude());
        if (minRow < matrixHeight && maxRow >= 0L) {
            if (minRow < 0L) {
                minRow = 0L;
            }
            if (maxRow >= matrixHeight) {
                maxRow = matrixHeight - 1L;
            }
        }
        TileGrid tileGrid = new TileGrid(minColumn, maxColumn, minRow, maxRow);
        return tileGrid;
    }

    public static long getTileColumn(BoundingBox webMercatorTotalBox, long matrixWidth, double longitude) {
        long tileId;
        double minX = webMercatorTotalBox.getMinLongitude();
        double maxX = webMercatorTotalBox.getMaxLongitude();
        if (longitude < minX) {
            tileId = -1L;
        } else if (longitude >= maxX) {
            tileId = matrixWidth;
        } else {
            double matrixWidthMeters = webMercatorTotalBox.getMaxLongitude() - webMercatorTotalBox.getMinLongitude();
            double tileWidth = matrixWidthMeters / (double)matrixWidth;
            tileId = (long)((longitude - minX) / tileWidth);
        }
        return tileId;
    }

    public static long getTileRow(BoundingBox webMercatorTotalBox, long matrixHeight, double latitude) {
        long tileId;
        double minY = webMercatorTotalBox.getMinLatitude();
        double maxY = webMercatorTotalBox.getMaxLatitude();
        if (latitude <= minY) {
            tileId = matrixHeight;
        } else if (latitude > maxY) {
            tileId = -1L;
        } else {
            double matrixHeightMeters = webMercatorTotalBox.getMaxLatitude() - webMercatorTotalBox.getMinLatitude();
            double tileHeight = matrixHeightMeters / (double)matrixHeight;
            tileId = (long)((maxY - latitude) / tileHeight);
        }
        return tileId;
    }

    public static BoundingBox getWebMercatorBoundingBox(BoundingBox webMercatorTotalBox, TileMatrix tileMatrix, long tileColumn, long tileRow) {
        return TileBoundingBoxUtils.getWebMercatorBoundingBox(webMercatorTotalBox, tileMatrix.getMatrixWidth(), tileMatrix.getMatrixHeight(), tileColumn, tileRow);
    }

    public static BoundingBox getWebMercatorBoundingBox(BoundingBox webMercatorTotalBox, long tileMatrixWidth, long tileMatrixHeight, long tileColumn, long tileRow) {
        double matrixMinX = webMercatorTotalBox.getMinLongitude();
        double matrixMaxX = webMercatorTotalBox.getMaxLongitude();
        double matrixWidth = matrixMaxX - matrixMinX;
        double tileWidth = matrixWidth / (double)tileMatrixWidth;
        double minLon = matrixMinX + tileWidth * (double)tileColumn;
        double maxLon = minLon + tileWidth;
        double matrixMinY = webMercatorTotalBox.getMinLatitude();
        double matrixMaxY = webMercatorTotalBox.getMaxLatitude();
        double matrixHeight = matrixMaxY - matrixMinY;
        double tileHeight = matrixHeight / (double)tileMatrixHeight;
        double maxLat = matrixMaxY - tileHeight * (double)tileRow;
        double minLat = maxLat - tileHeight;
        BoundingBox boundingBox = new BoundingBox(minLon, maxLon, minLat, maxLat);
        return boundingBox;
    }

    public static int getZoomLevel(BoundingBox webMercatorBoundingBox) {
        double worldLength = ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH * 2.0;
        int widthTiles = (int)(worldLength / (webMercatorBoundingBox.getMaxLongitude() - webMercatorBoundingBox.getMinLongitude()));
        int heightTiles = (int)(worldLength / (webMercatorBoundingBox.getMaxLatitude() - webMercatorBoundingBox.getMinLatitude()));
        int tilesPerSide = Math.min(widthTiles, heightTiles);
        tilesPerSide = Math.max(tilesPerSide, 1);
        int zoom = TileBoundingBoxUtils.zoomFromTilesPerSide(tilesPerSide);
        return zoom;
    }

    public static double getPixelXSize(BoundingBox webMercatorBoundingBox, long matrixWidth, int tileWidth) {
        double pixelXSize = (webMercatorBoundingBox.getMaxLongitude() - webMercatorBoundingBox.getMinLongitude()) / (double)matrixWidth / (double)tileWidth;
        return pixelXSize;
    }

    public static double getPixelYSize(BoundingBox webMercatorBoundingBox, long matrixHeight, int tileHeight) {
        double pixelYSize = (webMercatorBoundingBox.getMaxLatitude() - webMercatorBoundingBox.getMinLatitude()) / (double)matrixHeight / (double)tileHeight;
        return pixelYSize;
    }
}

