/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension;

import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.TableUtils;
import java.sql.SQLException;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.extension.ExtensionsDao;
import mil.nga.geopackage.extension.index.FeatureTableCoreIndex;
import mil.nga.geopackage.extension.index.GeometryIndex;
import mil.nga.geopackage.extension.index.TableIndex;
import mil.nga.geopackage.extension.index.TableIndexDao;

public class NGAExtensions {
    public static void deleteTableExtensions(GeoPackageCore geoPackage, String table) {
        ExtensionsDao extensionsDao = geoPackage.getExtensionsDao();
        TableIndexDao tableIndexDao = geoPackage.getTableIndexDao();
        try {
            tableIndexDao.deleteByIdCascade(table);
            extensionsDao.deleteByExtension(FeatureTableCoreIndex.EXTENSION_NAME, table);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Table Index. GeoPackage: " + geoPackage.getName() + ", Table: " + table, e);
        }
    }

    public static void deleteExtensions(GeoPackageCore geoPackage) {
        NGAExtensions.deleteExtensions(geoPackage, false);
    }

    public static void deleteExtensions(GeoPackageCore geoPackage, boolean ignoreErrors) {
        ConnectionSource connectionSource = geoPackage.getDatabase().getConnectionSource();
        ExtensionsDao extensionsDao = geoPackage.getExtensionsDao();
        try {
            TableUtils.dropTable((ConnectionSource)connectionSource, GeometryIndex.class, (boolean)ignoreErrors);
            TableUtils.dropTable((ConnectionSource)connectionSource, TableIndex.class, (boolean)ignoreErrors);
            extensionsDao.deleteByExtension(FeatureTableCoreIndex.EXTENSION_NAME);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Table Index Tables. GeoPackage: " + geoPackage.getName(), e);
        }
    }
}

