/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.index;

import com.j256.ormlite.dao.CloseableIterator;
import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.PreparedDelete;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.Where;
import java.sql.SQLException;
import java.util.Date;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.core.contents.Contents;
import mil.nga.geopackage.core.contents.ContentsDao;
import mil.nga.geopackage.extension.ExtensionScopeType;
import mil.nga.geopackage.extension.Extensions;
import mil.nga.geopackage.extension.ExtensionsDao;
import mil.nga.geopackage.extension.index.GeometryIndex;
import mil.nga.geopackage.extension.index.GeometryIndexDao;
import mil.nga.geopackage.extension.index.GeometryIndexKey;
import mil.nga.geopackage.extension.index.TableIndex;
import mil.nga.geopackage.extension.index.TableIndexDao;
import mil.nga.geopackage.geom.GeoPackageGeometryData;
import mil.nga.geopackage.io.GeoPackageProgress;
import mil.nga.geopackage.property.GeoPackageProperties;
import mil.nga.wkb.geom.Geometry;
import mil.nga.wkb.geom.GeometryEnvelope;
import mil.nga.wkb.util.GeometryEnvelopeBuilder;

public abstract class FeatureTableCoreIndex {
    public static final String EXTENSION_AUTHOR = "nga";
    public static final String EXTENSION_NAME_NO_AUTHOR = "geometry_index";
    public static final String EXTENSION_NAME = Extensions.buildExtensionName("nga", "geometry_index");
    public static final String EXTENSION_DEFINITION = GeoPackageProperties.getProperty("geopackage.extensions", "geometry_index");
    private final GeoPackageCore geoPackage;
    private final String tableName;
    private final String columnName;
    private final ExtensionsDao extensionsDao;
    private final TableIndexDao tableIndexDao;
    private final GeometryIndexDao geometryIndexDao;
    protected GeoPackageProgress progress;

    protected FeatureTableCoreIndex(GeoPackageCore geoPackage, String tableName, String columnName) {
        this.geoPackage = geoPackage;
        this.tableName = tableName;
        this.columnName = columnName;
        this.extensionsDao = geoPackage.getExtensionsDao();
        this.tableIndexDao = geoPackage.getTableIndexDao();
        this.geometryIndexDao = geoPackage.getGeometryIndexDao();
    }

    public GeoPackageCore getGeoPackage() {
        return this.geoPackage;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setProgress(GeoPackageProgress progress) {
        this.progress = progress;
    }

    public int index() {
        return this.index(false);
    }

    public int index(boolean force) {
        int count = 0;
        if (force || !this.isIndexed()) {
            this.getOrCreateExtension();
            TableIndex tableIndex = this.getOrCreateTableIndex();
            this.createOrClearGeometryIndices();
            count = this.indexTable(tableIndex);
        }
        return count;
    }

    protected abstract int indexTable(TableIndex var1);

    protected boolean index(TableIndex tableIndex, long geomId, GeoPackageGeometryData geomData) {
        boolean indexed = false;
        if (geomData != null) {
            Geometry geometry;
            GeometryEnvelope envelope = geomData.getEnvelope();
            if (envelope == null && (geometry = geomData.getGeometry()) != null) {
                envelope = GeometryEnvelopeBuilder.buildEnvelope((Geometry)geometry);
            }
            if (envelope != null) {
                GeometryIndex geometryIndex = this.geometryIndexDao.populate(tableIndex, geomId, envelope);
                try {
                    this.geometryIndexDao.createOrUpdate(geometryIndex);
                    indexed = true;
                }
                catch (SQLException e) {
                    throw new GeoPackageException("Failed to create or update Geometry Index. GeoPackage: " + this.geoPackage.getName() + ", Table Name: " + this.tableName + ", Geom Id: " + geomId, e);
                }
            }
        }
        return indexed;
    }

    protected void updateLastIndexed() {
        TableIndex tableIndex = new TableIndex();
        tableIndex.setTableName(this.tableName);
        tableIndex.setLastIndexed(new Date());
        try {
            this.tableIndexDao.createOrUpdate(tableIndex);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to update last indexed date. GeoPackage: " + this.geoPackage.getName() + ", Table Name: " + this.tableName, e);
        }
    }

    public boolean deleteIndex() {
        boolean deleted = false;
        ExtensionsDao extensionsDao = this.geoPackage.getExtensionsDao();
        TableIndexDao tableIndexDao = this.geoPackage.getTableIndexDao();
        try {
            deleted = tableIndexDao.deleteByIdCascade(this.tableName) > 0;
            deleted = extensionsDao.deleteByExtension(EXTENSION_NAME, this.tableName) > 0 || deleted;
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Table Index. GeoPackage: " + this.geoPackage.getName() + ", Table: " + this.tableName, e);
        }
        return deleted;
    }

    public int deleteIndex(long geomId) {
        int deleted = 0;
        GeometryIndexKey key = new GeometryIndexKey(this.tableName, geomId);
        try {
            deleted = this.geometryIndexDao.deleteById(key);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete index, GeoPackage: " + this.geoPackage.getName() + ", Table Name: " + this.tableName + ", Geometry Id: " + geomId, e);
        }
        return deleted;
    }

    public boolean isIndexed() {
        boolean indexed = false;
        Extensions extension = this.getExtension();
        if (extension != null) {
            ContentsDao contentsDao = this.geoPackage.getContentsDao();
            try {
                Contents contents = (Contents)contentsDao.queryForId(this.tableName);
                if (contents != null) {
                    Date lastChange = contents.getLastChange();
                    TableIndexDao tableIndexDao = this.geoPackage.getTableIndexDao();
                    TableIndex tableIndex = (TableIndex)tableIndexDao.queryForId(this.tableName);
                    if (tableIndex != null) {
                        Date lastIndexed = tableIndex.getLastIndexed();
                        indexed = lastIndexed != null && lastIndexed.getTime() >= lastChange.getTime();
                    }
                }
            }
            catch (SQLException e) {
                throw new GeoPackageException("Failed to check if table is indexed, GeoPackage: " + this.geoPackage.getName() + ", Table Name: " + this.tableName, e);
            }
        }
        return indexed;
    }

    private TableIndex getOrCreateTableIndex() {
        TableIndex tableIndex = this.getTableIndex();
        if (tableIndex == null) {
            try {
                if (!this.tableIndexDao.isTableExists()) {
                    this.geoPackage.createTableIndexTable();
                }
                tableIndex = new TableIndex();
                tableIndex.setTableName(this.tableName);
                tableIndex.setLastIndexed(null);
                this.tableIndexDao.create(tableIndex);
            }
            catch (SQLException e) {
                throw new GeoPackageException("Failed to create Table Index for GeoPackage: " + this.geoPackage.getName() + ", Table Name: " + this.tableName + ", Column Name: " + this.columnName, e);
            }
        }
        return tableIndex;
    }

    public TableIndex getTableIndex() {
        TableIndex tableIndex = null;
        try {
            if (this.tableIndexDao.isTableExists()) {
                tableIndex = (TableIndex)this.tableIndexDao.queryForId(this.tableName);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to query for Table Index for GeoPackage: " + this.geoPackage.getName() + ", Table Name: " + this.tableName + ", Column Name: " + this.columnName, e);
        }
        return tableIndex;
    }

    public Date getLastIndexed() {
        Date lastIndexed = null;
        TableIndex tableIndex = this.getTableIndex();
        if (tableIndex != null) {
            lastIndexed = tableIndex.getLastIndexed();
        }
        return lastIndexed;
    }

    private void createOrClearGeometryIndices() {
        if (!this.createGeometryIndexTable()) {
            this.clearGeometryIndices();
        }
    }

    private int clearGeometryIndices() {
        int deleted = 0;
        DeleteBuilder db = this.geometryIndexDao.deleteBuilder();
        try {
            db.where().eq("table_name", (Object)this.tableName);
            PreparedDelete deleteQuery = db.prepare();
            deleted = this.geometryIndexDao.delete(deleteQuery);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to clear Geometry Index rows for GeoPackage: " + this.geoPackage.getName() + ", Table Name: " + this.tableName + ", Column Name: " + this.columnName, e);
        }
        return deleted;
    }

    private boolean createGeometryIndexTable() {
        boolean created = false;
        try {
            if (!this.geometryIndexDao.isTableExists()) {
                created = this.geoPackage.createGeometryIndexTable();
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to create Geometry Index table for GeoPackage: " + this.geoPackage.getName() + ", Table Name: " + this.tableName + ", Column Name: " + this.columnName, e);
        }
        return created;
    }

    private Extensions getOrCreateExtension() {
        Extensions extension = this.getExtension();
        if (extension == null) {
            try {
                if (!this.extensionsDao.isTableExists()) {
                    this.geoPackage.createExtensionsTable();
                }
                extension = new Extensions();
                extension.setTableName(this.tableName);
                extension.setColumnName(this.columnName);
                extension.setExtensionName(EXTENSION_AUTHOR, EXTENSION_NAME_NO_AUTHOR);
                extension.setDefinition(EXTENSION_DEFINITION);
                extension.setScope(ExtensionScopeType.READ_WRITE);
                this.extensionsDao.create(extension);
            }
            catch (SQLException e) {
                throw new GeoPackageException("Failed to create '" + EXTENSION_NAME + "' extension for GeoPackage: " + this.geoPackage.getName() + ", Table Name: " + this.tableName + ", Column Name: " + this.columnName, e);
            }
        }
        return extension;
    }

    public Extensions getExtension() {
        Extensions extension = null;
        try {
            if (this.extensionsDao.isTableExists()) {
                extension = this.extensionsDao.queryByExtension(EXTENSION_NAME, this.tableName, this.columnName);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to query for '" + EXTENSION_NAME + "' extension for GeoPackage: " + this.geoPackage.getName() + ", Table Name: " + this.tableName + ", Column Name: " + this.columnName, e);
        }
        return extension;
    }

    public CloseableIterator<GeometryIndex> query() {
        CloseableIterator geometryIndices = null;
        QueryBuilder<GeometryIndex, GeometryIndexKey> qb = this.queryBuilder();
        try {
            geometryIndices = qb.iterator();
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to query for all Geometry Indices. GeoPackage: " + this.geoPackage.getName() + ", Table Name: " + this.tableName + ", Column Name: " + this.columnName, e);
        }
        return geometryIndices;
    }

    public long count() {
        long count = 0L;
        QueryBuilder<GeometryIndex, GeometryIndexKey> qb = this.queryBuilder();
        try {
            count = qb.countOf();
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to query for Geometry Index count. GeoPackage: " + this.geoPackage.getName() + ", Table Name: " + this.tableName + ", Column Name: " + this.columnName, e);
        }
        return count;
    }

    public QueryBuilder<GeometryIndex, GeometryIndexKey> queryBuilder() {
        QueryBuilder qb = this.geometryIndexDao.queryBuilder();
        try {
            qb.where().eq("table_name", (Object)this.tableName);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to build query for all Geometry Indices. GeoPackage: " + this.geoPackage.getName() + ", Table Name: " + this.tableName + ", Column Name: " + this.columnName, e);
        }
        return qb;
    }

    public CloseableIterator<GeometryIndex> query(BoundingBox boundingBox) {
        GeometryEnvelope envelope = boundingBox.buildEnvelope();
        CloseableIterator<GeometryIndex> geometryIndices = this.query(envelope);
        return geometryIndices;
    }

    public long count(BoundingBox boundingBox) {
        GeometryEnvelope envelope = boundingBox.buildEnvelope();
        long count = this.count(envelope);
        return count;
    }

    public CloseableIterator<GeometryIndex> query(GeometryEnvelope envelope) {
        CloseableIterator geometryIndices = null;
        QueryBuilder<GeometryIndex, GeometryIndexKey> qb = this.queryBuilder(envelope);
        try {
            geometryIndices = qb.iterator();
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to query for Geometry Indices. GeoPackage: " + this.geoPackage.getName() + ", Table Name: " + this.tableName + ", Column Name: " + this.columnName, e);
        }
        return geometryIndices;
    }

    public long count(GeometryEnvelope envelope) {
        long count = 0L;
        QueryBuilder<GeometryIndex, GeometryIndexKey> qb = this.queryBuilder(envelope);
        try {
            count = qb.countOf();
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to query for Geometry Index count. GeoPackage: " + this.geoPackage.getName() + ", Table Name: " + this.tableName + ", Column Name: " + this.columnName, e);
        }
        return count;
    }

    public QueryBuilder<GeometryIndex, GeometryIndexKey> queryBuilder(GeometryEnvelope envelope) {
        QueryBuilder qb = this.geometryIndexDao.queryBuilder();
        try {
            Where where = qb.where();
            where.eq("table_name", (Object)this.tableName).and().le("min_x", (Object)envelope.getMaxX()).and().ge("max_x", (Object)envelope.getMinX()).and().le("min_y", (Object)envelope.getMaxY()).and().ge("max_y", (Object)envelope.getMinY());
            if (envelope.hasZ()) {
                where.and().le("min_z", (Object)envelope.getMaxZ()).and().ge("max_z", (Object)envelope.getMinZ());
            }
            if (envelope.hasM()) {
                where.and().le("min_m", (Object)envelope.getMaxM()).and().ge("max_m", (Object)envelope.getMinM());
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to build query for Geometry Indices. GeoPackage: " + this.geoPackage.getName() + ", Table Name: " + this.tableName + ", Column Name: " + this.columnName, e);
        }
        return qb;
    }
}

