/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.core.contents;

import com.j256.ormlite.dao.BaseDaoImpl;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.core.contents.Contents;
import mil.nga.geopackage.core.contents.ContentsDataType;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.features.columns.GeometryColumns;
import mil.nga.geopackage.features.columns.GeometryColumnsDao;
import mil.nga.geopackage.tiles.matrix.TileMatrix;
import mil.nga.geopackage.tiles.matrix.TileMatrixDao;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSet;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSetDao;

public class ContentsDao
extends BaseDaoImpl<Contents, String> {
    private GeoPackageCoreConnection db;
    private GeometryColumnsDao geometryColumnsDao;
    private TileMatrixSetDao tileMatrixSetDao;
    private TileMatrixDao tileMatrixDao;

    public ContentsDao(ConnectionSource connectionSource, Class<Contents> dataClass) throws SQLException {
        super(connectionSource, dataClass);
    }

    public void setDatabase(GeoPackageCoreConnection db) {
        this.db = db;
    }

    public int create(Contents contents) throws SQLException {
        this.verifyCreate(contents);
        return super.create((Object)contents);
    }

    public Contents createIfNotExists(Contents contents) throws SQLException {
        this.verifyCreate(contents);
        return (Contents)super.createIfNotExists((Object)contents);
    }

    public Dao.CreateOrUpdateStatus createOrUpdate(Contents contents) throws SQLException {
        this.verifyCreate(contents);
        return super.createOrUpdate((Object)contents);
    }

    public int deleteCascade(Contents contents) throws SQLException {
        int count = 0;
        if (contents != null) {
            TileMatrixSet tileMatrixSet;
            TileMatrixSetDao tileMatrixSetDao;
            ForeignCollection<TileMatrix> tileMatrixCollection;
            TileMatrixDao tileMatrixDao;
            GeometryColumns geometryColumns;
            GeometryColumnsDao geometryColumnsDao = this.getGeometryColumnsDao();
            if (geometryColumnsDao.isTableExists() && (geometryColumns = contents.getGeometryColumns()) != null) {
                geometryColumnsDao.delete(geometryColumns);
            }
            if ((tileMatrixDao = this.getTileMatrixDao()).isTableExists() && !(tileMatrixCollection = contents.getTileMatrix()).isEmpty()) {
                tileMatrixDao.delete((Collection)tileMatrixCollection);
            }
            if ((tileMatrixSetDao = this.getTileMatrixSetDao()).isTableExists() && (tileMatrixSet = contents.getTileMatrixSet()) != null) {
                tileMatrixSetDao.delete(tileMatrixSet);
            }
            count = this.delete(contents);
        }
        return count;
    }

    public int deleteCascade(Contents contents, boolean userTable) throws SQLException {
        int count = this.deleteCascade(contents);
        if (userTable) {
            this.db.execSQL("DROP TABLE IF EXISTS " + contents.getTableName());
        }
        return count;
    }

    public int deleteCascade(Collection<Contents> contentsCollection) throws SQLException {
        return this.deleteCascade(contentsCollection, false);
    }

    public int deleteCascade(Collection<Contents> contentsCollection, boolean userTable) throws SQLException {
        int count = 0;
        if (contentsCollection != null) {
            for (Contents contents : contentsCollection) {
                count += this.deleteCascade(contents, userTable);
            }
        }
        return count;
    }

    public int deleteCascade(PreparedQuery<Contents> preparedDelete) throws SQLException {
        return this.deleteCascade(preparedDelete, false);
    }

    public int deleteCascade(PreparedQuery<Contents> preparedDelete, boolean userTable) throws SQLException {
        int count = 0;
        if (preparedDelete != null) {
            List contentsList = this.query(preparedDelete);
            count = this.deleteCascade(contentsList, userTable);
        }
        return count;
    }

    public int deleteByIdCascade(String id) throws SQLException {
        return this.deleteByIdCascade(id, false);
    }

    public int deleteByIdCascade(String id, boolean userTable) throws SQLException {
        int count = 0;
        if (id != null) {
            Contents contents = (Contents)this.queryForId(id);
            if (contents != null) {
                count = this.deleteCascade(contents, userTable);
            } else if (userTable) {
                this.db.execSQL("DROP TABLE IF EXISTS " + id);
            }
        }
        return count;
    }

    public int deleteIdsCascade(Collection<String> idCollection) throws SQLException {
        return this.deleteIdsCascade(idCollection, false);
    }

    public int deleteIdsCascade(Collection<String> idCollection, boolean userTable) throws SQLException {
        int count = 0;
        if (idCollection != null) {
            for (String id : idCollection) {
                count += this.deleteByIdCascade(id, userTable);
            }
        }
        return count;
    }

    public void deleteTable(String table) {
        try {
            this.deleteByIdCascade(table, true);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete table: " + table, e);
        }
    }

    private void verifyCreate(Contents contents) throws SQLException {
        ContentsDataType dataType = contents.getDataType();
        if (dataType != null) {
            switch (dataType) {
                case FEATURES: {
                    GeometryColumnsDao geometryColumnsDao = this.getGeometryColumnsDao();
                    if (geometryColumnsDao.isTableExists()) break;
                    throw new GeoPackageException("A data type of " + dataType.getName() + " requires the " + GeometryColumns.class.getSimpleName() + " table to first be created using the GeoPackage.");
                }
                case TILES: {
                    TileMatrixSetDao tileMatrixSetDao = this.getTileMatrixSetDao();
                    if (!tileMatrixSetDao.isTableExists()) {
                        throw new GeoPackageException("A data type of " + dataType.getName() + " requires the " + TileMatrixSet.class.getSimpleName() + " table to first be created using the GeoPackage.");
                    }
                    TileMatrixDao tileMatrixDao = this.getTileMatrixDao();
                    if (tileMatrixDao.isTableExists()) break;
                    throw new GeoPackageException("A data type of " + dataType.getName() + " requires the " + TileMatrix.class.getSimpleName() + " table to first be created using the GeoPackage.");
                }
                default: {
                    throw new GeoPackageException("Unsupported data type: " + (Object)((Object)dataType));
                }
            }
        }
        if (!this.db.tableExists(contents.getTableName())) {
            throw new GeoPackageException("No table exists for Content Table Name: " + contents.getTableName() + ". Table must first be created.");
        }
    }

    private GeometryColumnsDao getGeometryColumnsDao() throws SQLException {
        if (this.geometryColumnsDao == null) {
            this.geometryColumnsDao = (GeometryColumnsDao)DaoManager.createDao((ConnectionSource)this.connectionSource, GeometryColumns.class);
        }
        return this.geometryColumnsDao;
    }

    private TileMatrixSetDao getTileMatrixSetDao() throws SQLException {
        if (this.tileMatrixSetDao == null) {
            this.tileMatrixSetDao = (TileMatrixSetDao)DaoManager.createDao((ConnectionSource)this.connectionSource, TileMatrixSet.class);
        }
        return this.tileMatrixSetDao;
    }

    private TileMatrixDao getTileMatrixDao() throws SQLException {
        if (this.tileMatrixDao == null) {
            this.tileMatrixDao = (TileMatrixDao)DaoManager.createDao((ConnectionSource)this.connectionSource, TileMatrix.class);
        }
        return this.tileMatrixDao;
    }
}

