/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension;

import com.j256.ormlite.dao.BaseDaoImpl;
import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.PreparedUpdate;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.UpdateBuilder;
import com.j256.ormlite.stmt.Where;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.List;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.extension.Extensions;

public class ExtensionsDao
extends BaseDaoImpl<Extensions, Void> {
    public ExtensionsDao(ConnectionSource connectionSource, Class<Extensions> dataClass) throws SQLException {
        super(connectionSource, dataClass);
    }

    public int update(Extensions extensions) throws SQLException {
        UpdateBuilder ub = this.updateBuilder();
        ub.updateColumnValue("definition", (Object)extensions.getDefinition());
        ub.updateColumnValue("scope", (Object)extensions.getScope().getValue());
        this.setUniqueWhere((Where<Extensions, Void>)ub.where(), extensions.getExtensionName(), true, extensions.getTableName(), true, extensions.getColumnName());
        PreparedUpdate update = ub.prepare();
        int updated = this.update(update);
        return updated;
    }

    public int delete(Extensions extensions) throws SQLException {
        DeleteBuilder db = this.deleteBuilder();
        this.setUniqueWhere((Where<Extensions, Void>)db.where(), extensions.getExtensionName(), true, extensions.getTableName(), true, extensions.getColumnName());
        int deleted = db.delete();
        return deleted;
    }

    public int deleteByExtension(String extensionName) throws SQLException {
        DeleteBuilder db = this.deleteBuilder();
        db.where().eq("extension_name", (Object)extensionName);
        int deleted = db.delete();
        return deleted;
    }

    public int deleteByExtension(String extensionName, String tableName) throws SQLException {
        DeleteBuilder db = this.deleteBuilder();
        this.setUniqueWhere((Where<Extensions, Void>)db.where(), extensionName, true, tableName, false, null);
        int deleted = db.delete();
        return deleted;
    }

    public int deleteByExtension(String extensionName, String tableName, String columnName) throws SQLException {
        DeleteBuilder db = this.deleteBuilder();
        this.setUniqueWhere((Where<Extensions, Void>)db.where(), extensionName, true, tableName, true, columnName);
        int deleted = db.delete();
        return deleted;
    }

    public List<Extensions> queryByExtension(String extensionName) throws SQLException {
        QueryBuilder qb = this.queryBuilder();
        this.setUniqueWhere((Where<Extensions, Void>)qb.where(), extensionName, false, null, false, null);
        List extensions = qb.query();
        return extensions;
    }

    public List<Extensions> queryByExtension(String extensionName, String tableName) throws SQLException {
        QueryBuilder qb = this.queryBuilder();
        this.setUniqueWhere((Where<Extensions, Void>)qb.where(), extensionName, true, tableName, false, null);
        List extensions = qb.query();
        return extensions;
    }

    public Extensions queryByExtension(String extensionName, String tableName, String columnName) throws SQLException {
        QueryBuilder qb = this.queryBuilder();
        this.setUniqueWhere((Where<Extensions, Void>)qb.where(), extensionName, true, tableName, true, columnName);
        List extensions = qb.query();
        Extensions extension = null;
        if (extensions.size() > 1) {
            throw new GeoPackageException("More than one " + Extensions.class.getSimpleName() + " existed for unique combination of Extension Name: " + extensionName + ", Table Name: " + tableName + ", Column Name: " + columnName);
        }
        if (extensions.size() == 1) {
            extension = (Extensions)extensions.get(0);
        }
        return extension;
    }

    private void setUniqueWhere(Where<Extensions, Void> where, String extensionName, boolean queryTableName, String tableName, boolean queryColumnName, String columnName) throws SQLException {
        where.eq("extension_name", (Object)extensionName);
        if (queryTableName) {
            if (tableName == null) {
                where.and().isNull("table_name");
            } else {
                where.and().eq("table_name", (Object)tableName);
            }
        }
        if (queryColumnName) {
            if (columnName == null) {
                where.and().isNull("column_name");
            } else {
                where.and().eq("column_name", (Object)columnName);
            }
        }
    }
}

