/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension;

import mil.nga.geopackage.GeoPackageException;
import mil.nga.wkb.geom.GeometryType;

public class GeometryExtensions {
    public static boolean isExtension(GeometryType geometryType) {
        return geometryType.getCode() > GeometryType.GEOMETRYCOLLECTION.getCode();
    }

    public static boolean isGeoPackageExtension(GeometryType geometryType) {
        return geometryType.getCode() >= GeometryType.CIRCULARSTRING.getCode() && geometryType.getCode() <= GeometryType.SURFACE.getCode();
    }

    public static String getExtensionName(GeometryType geometryType) {
        if (!GeometryExtensions.isExtension(geometryType)) {
            throw new GeoPackageException(GeometryType.class.getSimpleName() + " is not an extension: " + geometryType.getName());
        }
        if (!GeometryExtensions.isGeoPackageExtension(geometryType)) {
            throw new GeoPackageException(GeometryType.class.getSimpleName() + " is not a GeoPackage extension, User-Defined requires an author: " + geometryType.getName());
        }
        String extensionName = "gpkg_geom_" + geometryType.getName();
        return extensionName;
    }

    public static String getExtensionName(String author, GeometryType geometryType) {
        if (!GeometryExtensions.isExtension(geometryType)) {
            throw new GeoPackageException(GeometryType.class.getSimpleName() + " is not an extension: " + geometryType.getName());
        }
        String extensionName = (GeometryExtensions.isGeoPackageExtension(geometryType) ? "gpkg" : author) + "_" + "geom" + "_" + geometryType.getName();
        return extensionName;
    }
}

