/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.link;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.extension.ExtensionScopeType;
import mil.nga.geopackage.extension.Extensions;
import mil.nga.geopackage.extension.ExtensionsDao;
import mil.nga.geopackage.extension.link.FeatureTileLink;
import mil.nga.geopackage.extension.link.FeatureTileLinkDao;
import mil.nga.geopackage.extension.link.FeatureTileLinkKey;
import mil.nga.geopackage.property.GeoPackageProperties;

public abstract class FeatureTileTableCoreLinker {
    public static final String EXTENSION_AUTHOR = "nga";
    public static final String EXTENSION_NAME_NO_AUTHOR = "feature_tile_link";
    public static final String EXTENSION_NAME = Extensions.buildExtensionName("nga", "feature_tile_link");
    public static final String EXTENSION_DEFINITION = GeoPackageProperties.getProperty("geopackage.extensions", "feature_tile_link");
    private final GeoPackageCore geoPackage;
    private final ExtensionsDao extensionsDao;
    private final FeatureTileLinkDao featureTileLinkDao;

    protected FeatureTileTableCoreLinker(GeoPackageCore geoPackage) {
        this.geoPackage = geoPackage;
        this.extensionsDao = geoPackage.getExtensionsDao();
        this.featureTileLinkDao = geoPackage.getFeatureTileLinkDao();
    }

    public GeoPackageCore getGeoPackage() {
        return this.geoPackage;
    }

    public FeatureTileLinkDao getDao() {
        return this.featureTileLinkDao;
    }

    public void link(String featureTable, String tileTable) {
        if (!this.isLinked(featureTable, tileTable)) {
            this.getOrCreateExtension();
            try {
                if (!this.featureTileLinkDao.isTableExists()) {
                    this.geoPackage.createFeatureTileLinkTable();
                }
                FeatureTileLink link = new FeatureTileLink();
                link.setFeatureTableName(featureTable);
                link.setTileTableName(tileTable);
                this.featureTileLinkDao.create(link);
            }
            catch (SQLException e) {
                throw new GeoPackageException("Failed to create feature tile link for GeoPackage: " + this.geoPackage.getName() + ", Feature Table: " + featureTable + ", Tile Table: " + tileTable, e);
            }
        }
    }

    public boolean isLinked(String featureTable, String tileTable) {
        FeatureTileLink link = this.getLink(featureTable, tileTable);
        return link != null;
    }

    public FeatureTileLink getLink(String featureTable, String tileTable) {
        FeatureTileLink link = null;
        if (this.featureTileLinksActive()) {
            FeatureTileLinkKey id = new FeatureTileLinkKey(featureTable, tileTable);
            try {
                link = this.featureTileLinkDao.queryForId(id);
            }
            catch (SQLException e) {
                throw new GeoPackageException("Failed to get feature tile link for GeoPackage: " + this.geoPackage.getName() + ", Feature Table: " + featureTable + ", Tile Table: " + tileTable, e);
            }
        }
        return link;
    }

    public List<FeatureTileLink> queryForFeatureTable(String featureTable) {
        List<Object> links = null;
        links = this.featureTileLinksActive() ? this.featureTileLinkDao.queryForFeatureTableName(featureTable) : new ArrayList();
        return links;
    }

    public List<FeatureTileLink> queryForTileTable(String tileTable) {
        List<Object> links = null;
        links = this.featureTileLinksActive() ? this.featureTileLinkDao.queryForTileTableName(tileTable) : new ArrayList();
        return links;
    }

    public boolean deleteLink(String featureTable, String tileTable) {
        boolean deleted = false;
        try {
            if (this.featureTileLinkDao.isTableExists()) {
                FeatureTileLinkKey id = new FeatureTileLinkKey(featureTable, tileTable);
                deleted = this.featureTileLinkDao.deleteById(id) > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete feature tile link for GeoPackage: " + this.geoPackage.getName() + ", Feature Table: " + featureTable + ", Tile Table: " + tileTable, e);
        }
        return deleted;
    }

    public int deleteLinks(String table) {
        int deleted = 0;
        try {
            if (this.featureTileLinkDao.isTableExists()) {
                deleted = this.featureTileLinkDao.deleteByTableName(table);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete feature tile links for GeoPackage: " + this.geoPackage.getName() + ", Table: " + table, e);
        }
        return deleted;
    }

    private Extensions getOrCreateExtension() {
        Extensions extension = this.getExtension();
        if (extension == null) {
            try {
                if (!this.extensionsDao.isTableExists()) {
                    this.geoPackage.createExtensionsTable();
                }
                extension = new Extensions();
                extension.setTableName(null);
                extension.setColumnName(null);
                extension.setExtensionName(EXTENSION_AUTHOR, EXTENSION_NAME_NO_AUTHOR);
                extension.setDefinition(EXTENSION_DEFINITION);
                extension.setScope(ExtensionScopeType.READ_WRITE);
                this.extensionsDao.create(extension);
            }
            catch (SQLException e) {
                throw new GeoPackageException("Failed to create '" + EXTENSION_NAME + "' extension for GeoPackage: " + this.geoPackage.getName(), e);
            }
        }
        return extension;
    }

    public Extensions getExtension() {
        Extensions extension = null;
        try {
            if (this.extensionsDao.isTableExists()) {
                extension = this.extensionsDao.queryByExtension(EXTENSION_NAME, null, null);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to query for '" + EXTENSION_NAME + "' extension for GeoPackage: " + this.geoPackage.getName(), e);
        }
        return extension;
    }

    private boolean featureTileLinksActive() {
        boolean active = false;
        if (this.getExtension() != null) {
            try {
                active = this.featureTileLinkDao.isTableExists();
            }
            catch (SQLException e) {
                throw new GeoPackageException("Failed to check if the feature tile link table exists for GeoPackage: " + this.geoPackage.getName(), e);
            }
        }
        return active;
    }

    public List<String> getTileTablesForFeatureTable(String featureTable) {
        ArrayList<String> tileTables = new ArrayList<String>();
        List<FeatureTileLink> links = this.queryForFeatureTable(featureTable);
        for (FeatureTileLink link : links) {
            tileTables.add(link.getTileTableName());
        }
        return tileTables;
    }

    public List<String> getFeatureTablesForTileTable(String tileTable) {
        ArrayList<String> featureTables = new ArrayList<String>();
        List<FeatureTileLink> links = this.queryForTileTable(tileTable);
        for (FeatureTileLink link : links) {
            featureTables.add(link.getFeatureTableName());
        }
        return featureTables;
    }
}

