/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import mil.nga.geopackage.io.GeoPackageProgress;

public class GeoPackageIOUtils {
    public static String getFileExtension(File file) {
        String fileName = file.getName();
        String extension = null;
        int extensionIndex = fileName.lastIndexOf(".");
        if (extensionIndex > -1) {
            extension = fileName.substring(extensionIndex + 1);
        }
        return extension;
    }

    public static String getFileNameWithoutExtension(File file) {
        String name = file.getName();
        int extensionIndex = name.lastIndexOf(".");
        if (extensionIndex > -1) {
            name = name.substring(0, extensionIndex);
        }
        return name;
    }

    public static void copyFile(File copyFrom, File copyTo) throws IOException {
        FileInputStream from = new FileInputStream(copyFrom);
        FileOutputStream to = new FileOutputStream(copyTo);
        GeoPackageIOUtils.copyStream((InputStream)from, to);
    }

    public static void copyStream(InputStream copyFrom, File copyTo) throws IOException {
        GeoPackageIOUtils.copyStream(copyFrom, copyTo, null);
    }

    public static void copyStream(InputStream copyFrom, File copyTo, GeoPackageProgress progress) throws IOException {
        FileOutputStream to = new FileOutputStream(copyTo);
        GeoPackageIOUtils.copyStream(copyFrom, to, progress);
        if (progress != null && !progress.isActive() && progress.cleanupOnCancel()) {
            copyTo.delete();
        }
    }

    public static byte[] fileBytes(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        return GeoPackageIOUtils.streamBytes(fis);
    }

    public static byte[] streamBytes(InputStream stream) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        GeoPackageIOUtils.copyStream(stream, bytes);
        return bytes.toByteArray();
    }

    public static void copyStream(InputStream copyFrom, OutputStream copyTo) throws IOException {
        GeoPackageIOUtils.copyStream(copyFrom, copyTo, null);
    }

    public static void copyStream(InputStream copyFrom, OutputStream copyTo, GeoPackageProgress progress) throws IOException {
        int length;
        byte[] buffer = new byte[1024];
        while ((progress == null || progress.isActive()) && (length = copyFrom.read(buffer)) > 0) {
            copyTo.write(buffer, 0, length);
            if (progress == null) continue;
            progress.addProgress(length);
        }
        copyTo.flush();
        copyTo.close();
        copyFrom.close();
    }

    public static String formatBytes(long bytes) {
        double value = bytes;
        String unit = "B";
        if (bytes >= 1024L) {
            int exponent = (int)(Math.log(bytes) / Math.log(1024.0));
            exponent = Math.min(exponent, 4);
            switch (exponent) {
                case 1: {
                    unit = "KB";
                    break;
                }
                case 2: {
                    unit = "MB";
                    break;
                }
                case 3: {
                    unit = "GB";
                    break;
                }
                case 4: {
                    unit = "TB";
                }
            }
            value = (double)bytes / Math.pow(1024.0, exponent);
        }
        DecimalFormat df = new DecimalFormat("#.##");
        return df.format(value) + " " + unit;
    }
}

