/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.projection;

import java.util.HashMap;
import java.util.Map;
import mil.nga.geopackage.projection.Projection;
import mil.nga.geopackage.projection.ProjectionRetriever;
import org.osgeo.proj4j.CRSFactory;
import org.osgeo.proj4j.CoordinateReferenceSystem;

public class ProjectionFactory {
    private static Map<Long, Projection> projections = new HashMap<Long, Projection>();
    private static final CRSFactory csFactory = new CRSFactory();

    public static Projection getProjection(long epsg) {
        Projection projection = projections.get(epsg);
        if (projection == null) {
            String parameters = ProjectionRetriever.getProjection(epsg);
            CoordinateReferenceSystem crs = csFactory.createFromParameters(String.valueOf(epsg), parameters);
            projection = new Projection(epsg, crs);
            projections.put(epsg, projection);
        }
        return projection;
    }
}

