/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.schema.constraints;

import com.j256.ormlite.dao.BaseDaoImpl;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.stmt.PreparedUpdate;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.UpdateBuilder;
import com.j256.ormlite.stmt.Where;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.schema.columns.DataColumns;
import mil.nga.geopackage.schema.columns.DataColumnsDao;
import mil.nga.geopackage.schema.constraints.DataColumnConstraintType;
import mil.nga.geopackage.schema.constraints.DataColumnConstraints;

public class DataColumnConstraintsDao
extends BaseDaoImpl<DataColumnConstraints, Void> {
    private DataColumnsDao dataColumnsDao;

    public DataColumnConstraintsDao(ConnectionSource connectionSource, Class<DataColumnConstraints> dataClass) throws SQLException {
        super(connectionSource, dataClass);
    }

    public int deleteCascade(DataColumnConstraints constraints) throws SQLException {
        int count = 0;
        if (constraints != null) {
            DataColumnsDao dao;
            List<DataColumns> dataColumnsCollection;
            DataColumnConstraints remainingConstraint;
            List<DataColumnConstraints> remainingConstraints = this.queryByConstraintName(constraints.getConstraintName());
            if (remainingConstraints.size() == 1 && (remainingConstraint = remainingConstraints.get(0)).getConstraintName().equals(constraints.getConstraintName()) && remainingConstraint.getConstraintType().equals((Object)constraints.getConstraintType()) && (remainingConstraint.getValue() == null ? constraints.getValue() == null : remainingConstraint.getValue().equals(constraints.getValue())) && !(dataColumnsCollection = (dao = this.getDataColumnsDao()).queryByConstraintName(constraints.getConstraintName())).isEmpty()) {
                dao.delete(dataColumnsCollection);
            }
            count = this.delete(constraints);
        }
        return count;
    }

    public int deleteCascade(Collection<DataColumnConstraints> constraintsCollection) throws SQLException {
        int count = 0;
        if (constraintsCollection != null) {
            for (DataColumnConstraints constraints : constraintsCollection) {
                count += this.deleteCascade(constraints);
            }
        }
        return count;
    }

    public int deleteCascade(PreparedQuery<DataColumnConstraints> preparedDelete) throws SQLException {
        int count = 0;
        if (preparedDelete != null) {
            List constraintsList = this.query(preparedDelete);
            count = this.deleteCascade(constraintsList);
        }
        return count;
    }

    private DataColumnsDao getDataColumnsDao() throws SQLException {
        if (this.dataColumnsDao == null) {
            this.dataColumnsDao = (DataColumnsDao)DaoManager.createDao((ConnectionSource)this.connectionSource, DataColumns.class);
        }
        return this.dataColumnsDao;
    }

    public int update(DataColumnConstraints dataColumnConstraints) throws SQLException {
        UpdateBuilder ub = this.updateBuilder();
        ub.updateColumnValue("min", (Object)dataColumnConstraints.getMin());
        ub.updateColumnValue("minIsInclusive", (Object)dataColumnConstraints.getMinIsInclusive());
        ub.updateColumnValue("max", (Object)dataColumnConstraints.getMax());
        ub.updateColumnValue("maxIsInclusive", (Object)dataColumnConstraints.getMaxIsInclusive());
        ub.updateColumnValue("description", (Object)dataColumnConstraints.getDescription());
        this.setUniqueWhere((Where<DataColumnConstraints, Void>)ub.where(), dataColumnConstraints.getConstraintName(), dataColumnConstraints.getConstraintType(), dataColumnConstraints.getValue());
        PreparedUpdate update = ub.prepare();
        int updated = this.update(update);
        return updated;
    }

    public int delete(DataColumnConstraints dataColumnConstraints) throws SQLException {
        DeleteBuilder db = this.deleteBuilder();
        this.setUniqueWhere((Where<DataColumnConstraints, Void>)db.where(), dataColumnConstraints.getConstraintName(), dataColumnConstraints.getConstraintType(), dataColumnConstraints.getValue());
        int deleted = db.delete();
        return deleted;
    }

    public List<DataColumnConstraints> queryByConstraintName(String constraintName) throws SQLException {
        return this.queryForEq("constraint_name", constraintName);
    }

    public DataColumnConstraints queryByUnique(String constraintName, DataColumnConstraintType constraintType, String value) throws SQLException {
        DataColumnConstraints constraint = null;
        QueryBuilder qb = this.queryBuilder();
        this.setUniqueWhere((Where<DataColumnConstraints, Void>)qb.where(), constraintName, constraintType, value);
        List constraints = qb.query();
        if (!constraints.isEmpty()) {
            if (constraints.size() > 1) {
                throw new GeoPackageException("More than one " + DataColumnConstraints.class.getSimpleName() + " was found for unique constraint. Name: " + constraintName + ", Type: " + (Object)((Object)constraintType) + ", Value: " + value);
            }
            constraint = (DataColumnConstraints)constraints.get(0);
        }
        return constraint;
    }

    private void setUniqueWhere(Where<DataColumnConstraints, Void> where, String constraintName, DataColumnConstraintType constraintType, String value) throws SQLException {
        where.eq("constraint_name", (Object)constraintName).and().eq("constraint_type", (Object)constraintType.getValue());
        if (value == null) {
            where.and().isNull("value");
        } else {
            where.and().eq("value", (Object)value);
        }
    }
}

