/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.tiles.user;

import java.util.ArrayList;
import java.util.List;
import mil.nga.geopackage.db.GeoPackageDataType;
import mil.nga.geopackage.tiles.user.TileColumn;
import mil.nga.geopackage.user.UserTable;
import mil.nga.geopackage.user.UserUniqueConstraint;

public class TileTable
extends UserTable<TileColumn> {
    public static final String COLUMN_ID = "id";
    public static final String COLUMN_ZOOM_LEVEL = "zoom_level";
    public static final String COLUMN_TILE_COLUMN = "tile_column";
    public static final String COLUMN_TILE_ROW = "tile_row";
    public static final String COLUMN_TILE_DATA = "tile_data";
    private final int zoomLevelIndex;
    private final int tileColumnIndex;
    private final int tileRowIndex;
    private final int tileDataIndex;

    public TileTable(String tableName, List<TileColumn> columns) {
        super(tableName, columns);
        Integer zoomLevel = null;
        Integer tileColumn = null;
        Integer tileRow = null;
        Integer tileData = null;
        UserUniqueConstraint<TileColumn> uniqueConstraint = new UserUniqueConstraint<TileColumn>();
        for (TileColumn column : columns) {
            String columnName = column.getName();
            int columnIndex = column.getIndex();
            if (columnName.equals(COLUMN_ZOOM_LEVEL)) {
                this.duplicateCheck(columnIndex, zoomLevel, COLUMN_ZOOM_LEVEL);
                this.typeCheck(GeoPackageDataType.INTEGER, column);
                zoomLevel = columnIndex;
                uniqueConstraint.add(column);
                continue;
            }
            if (columnName.equals(COLUMN_TILE_COLUMN)) {
                this.duplicateCheck(columnIndex, tileColumn, COLUMN_TILE_COLUMN);
                this.typeCheck(GeoPackageDataType.INTEGER, column);
                tileColumn = columnIndex;
                uniqueConstraint.add(column);
                continue;
            }
            if (columnName.equals(COLUMN_TILE_ROW)) {
                this.duplicateCheck(columnIndex, tileRow, COLUMN_TILE_ROW);
                this.typeCheck(GeoPackageDataType.INTEGER, column);
                tileRow = columnIndex;
                uniqueConstraint.add(column);
                continue;
            }
            if (!columnName.equals(COLUMN_TILE_DATA)) continue;
            this.duplicateCheck(columnIndex, tileData, COLUMN_TILE_DATA);
            this.typeCheck(GeoPackageDataType.BLOB, column);
            tileData = columnIndex;
        }
        this.missingCheck(zoomLevel, COLUMN_ZOOM_LEVEL);
        this.zoomLevelIndex = zoomLevel;
        this.missingCheck(tileColumn, COLUMN_TILE_COLUMN);
        this.tileColumnIndex = tileColumn;
        this.missingCheck(tileRow, COLUMN_TILE_ROW);
        this.tileRowIndex = tileRow;
        this.missingCheck(tileData, COLUMN_TILE_DATA);
        this.tileDataIndex = tileData;
        this.addUniqueConstraint(uniqueConstraint);
    }

    public int getZoomLevelColumnIndex() {
        return this.zoomLevelIndex;
    }

    public TileColumn getZoomLevelColumn() {
        return (TileColumn)this.getColumn(this.zoomLevelIndex);
    }

    public int getTileColumnColumnIndex() {
        return this.tileColumnIndex;
    }

    public TileColumn getTileColumnColumn() {
        return (TileColumn)this.getColumn(this.tileColumnIndex);
    }

    public int getTileRowColumnIndex() {
        return this.tileRowIndex;
    }

    public TileColumn getTileRowColumn() {
        return (TileColumn)this.getColumn(this.tileRowIndex);
    }

    public int getTileDataColumnIndex() {
        return this.tileDataIndex;
    }

    public TileColumn getTileDataColumn() {
        return (TileColumn)this.getColumn(this.tileDataIndex);
    }

    public static List<TileColumn> createRequiredColumns() {
        return TileTable.createRequiredColumns(0);
    }

    public static List<TileColumn> createRequiredColumns(int startingIndex) {
        ArrayList<TileColumn> columns = new ArrayList<TileColumn>();
        columns.add(TileColumn.createIdColumn(startingIndex++));
        columns.add(TileColumn.createZoomLevelColumn(startingIndex++));
        columns.add(TileColumn.createTileColumnColumn(startingIndex++));
        columns.add(TileColumn.createTileRowColumn(startingIndex++));
        columns.add(TileColumn.createTileDataColumn(startingIndex++));
        return columns;
    }
}

