/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage;

import mil.nga.wkb.geom.GeometryEnvelope;

public class BoundingBox {
    private double minLongitude;
    private double maxLongitude;
    private double minLatitude;
    private double maxLatitude;

    public BoundingBox() {
        this(-180.0, 180.0, -90.0, 90.0);
    }

    public BoundingBox(double minLongitude, double maxLongitude, double minLatitude, double maxLatitude) {
        this.minLongitude = minLongitude;
        this.maxLongitude = maxLongitude;
        this.minLatitude = minLatitude;
        this.maxLatitude = maxLatitude;
    }

    public BoundingBox(BoundingBox boundingBox) {
        this(boundingBox.getMinLongitude(), boundingBox.getMaxLongitude(), boundingBox.getMinLatitude(), boundingBox.getMaxLatitude());
    }

    public double getMinLongitude() {
        return this.minLongitude;
    }

    public void setMinLongitude(double minLongitude) {
        this.minLongitude = minLongitude;
    }

    public double getMaxLongitude() {
        return this.maxLongitude;
    }

    public void setMaxLongitude(double maxLongitude) {
        this.maxLongitude = maxLongitude;
    }

    public double getMinLatitude() {
        return this.minLatitude;
    }

    public void setMinLatitude(double minLatitude) {
        this.minLatitude = minLatitude;
    }

    public double getMaxLatitude() {
        return this.maxLatitude;
    }

    public void setMaxLatitude(double maxLatitude) {
        this.maxLatitude = maxLatitude;
    }

    public GeometryEnvelope buildEnvelope() {
        GeometryEnvelope envelope = new GeometryEnvelope();
        envelope.setMinX(this.minLongitude);
        envelope.setMaxX(this.maxLongitude);
        envelope.setMinY(this.minLatitude);
        envelope.setMaxY(this.maxLatitude);
        return envelope;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.maxLatitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxLongitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minLatitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minLongitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BoundingBox other = (BoundingBox)obj;
        if (Double.doubleToLongBits(this.maxLatitude) != Double.doubleToLongBits(other.maxLatitude)) {
            return false;
        }
        if (Double.doubleToLongBits(this.maxLongitude) != Double.doubleToLongBits(other.maxLongitude)) {
            return false;
        }
        if (Double.doubleToLongBits(this.minLatitude) != Double.doubleToLongBits(other.minLatitude)) {
            return false;
        }
        return Double.doubleToLongBits(this.minLongitude) == Double.doubleToLongBits(other.minLongitude);
    }
}

