/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.index;

import com.j256.ormlite.dao.BaseDaoImpl;
import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.PreparedDelete;
import com.j256.ormlite.stmt.PreparedUpdate;
import com.j256.ormlite.stmt.UpdateBuilder;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.extension.index.GeometryIndex;
import mil.nga.geopackage.extension.index.GeometryIndexKey;
import mil.nga.geopackage.extension.index.TableIndex;
import mil.nga.wkb.geom.GeometryEnvelope;

public class GeometryIndexDao
extends BaseDaoImpl<GeometryIndex, GeometryIndexKey> {
    public GeometryIndexDao(ConnectionSource connectionSource, Class<GeometryIndex> dataClass) throws SQLException {
        super(connectionSource, dataClass);
    }

    public GeometryIndex queryForId(GeometryIndexKey key) throws SQLException {
        GeometryIndex geometryIndex = null;
        if (key != null) {
            HashMap<String, Object> fieldValues = new HashMap<String, Object>();
            fieldValues.put("table_name", key.getTableName());
            fieldValues.put("geom_id", key.getGeomId());
            List results = this.queryForFieldValues(fieldValues);
            if (!results.isEmpty()) {
                if (results.size() > 1) {
                    throw new SQLException("More than one " + GeometryIndex.class.getSimpleName() + " returned for key. Table Name: " + key.getTableName() + ", Geom Id: " + key.getGeomId());
                }
                geometryIndex = (GeometryIndex)results.get(0);
            }
        }
        return geometryIndex;
    }

    public GeometryIndexKey extractId(GeometryIndex data) throws SQLException {
        return data.getId();
    }

    public boolean idExists(GeometryIndexKey id) throws SQLException {
        return this.queryForId(id) != null;
    }

    public GeometryIndex queryForSameId(GeometryIndex data) throws SQLException {
        return this.queryForId(data.getId());
    }

    public int updateId(GeometryIndex data, GeometryIndexKey newId) throws SQLException {
        int count = 0;
        GeometryIndex readData = this.queryForId(data.getId());
        if (readData != null && newId != null) {
            readData.setId(newId);
            count = this.update(readData);
        }
        return count;
    }

    public int delete(GeometryIndex data) throws SQLException {
        DeleteBuilder db = this.deleteBuilder();
        db.where().eq("table_name", (Object)data.getTableName()).and().eq("geom_id", (Object)data.getGeomId());
        PreparedDelete deleteQuery = db.prepare();
        int deleted = this.delete(deleteQuery);
        return deleted;
    }

    public int deleteById(GeometryIndexKey id) throws SQLException {
        GeometryIndex deleteData;
        int count = 0;
        if (id != null && (deleteData = this.queryForId(id)) != null) {
            count = this.delete(deleteData);
        }
        return count;
    }

    public int deleteIds(Collection<GeometryIndexKey> idCollection) throws SQLException {
        int count = 0;
        if (idCollection != null) {
            for (GeometryIndexKey id : idCollection) {
                count += this.deleteById(id);
            }
        }
        return count;
    }

    public int update(GeometryIndex geometryIndex) throws SQLException {
        UpdateBuilder ub = this.updateBuilder();
        ub.updateColumnValue("min_x", (Object)geometryIndex.getMinX());
        ub.updateColumnValue("max_x", (Object)geometryIndex.getMaxX());
        ub.updateColumnValue("min_y", (Object)geometryIndex.getMinY());
        ub.updateColumnValue("max_y", (Object)geometryIndex.getMaxY());
        ub.updateColumnValue("min_z", (Object)geometryIndex.getMinZ());
        ub.updateColumnValue("max_z", (Object)geometryIndex.getMaxZ());
        ub.updateColumnValue("min_m", (Object)geometryIndex.getMinM());
        ub.updateColumnValue("max_m", (Object)geometryIndex.getMaxM());
        ub.where().eq("table_name", (Object)geometryIndex.getTableName()).and().eq("geom_id", (Object)geometryIndex.getGeomId());
        PreparedUpdate update = ub.prepare();
        int updated = this.update(update);
        return updated;
    }

    public List<GeometryIndex> queryForTableName(String tableName) {
        List results = null;
        try {
            results = this.queryForEq("table_name", tableName);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to query for Geometry Index objects by Table Name: " + tableName);
        }
        return results;
    }

    public GeometryIndex populate(TableIndex tableIndex, long geomId, GeometryEnvelope envelope) {
        GeometryIndex geometryIndex = new GeometryIndex();
        geometryIndex.setTableIndex(tableIndex);
        geometryIndex.setGeomId(geomId);
        geometryIndex.setMinX(envelope.getMinX());
        geometryIndex.setMaxX(envelope.getMaxX());
        geometryIndex.setMinY(envelope.getMinY());
        geometryIndex.setMaxY(envelope.getMaxY());
        if (envelope.hasZ()) {
            geometryIndex.setMinZ(envelope.getMinZ());
            geometryIndex.setMaxZ(envelope.getMaxZ());
        }
        if (envelope.hasM()) {
            geometryIndex.setMinM(envelope.getMinM());
            geometryIndex.setMaxM(envelope.getMaxM());
        }
        return geometryIndex;
    }

    public int deleteAll() throws SQLException {
        int count = 0;
        if (this.isTableExists()) {
            DeleteBuilder db = this.deleteBuilder();
            PreparedDelete deleteQuery = db.prepare();
            count = this.delete(deleteQuery);
        }
        return count;
    }
}

