/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.projection;

import mil.nga.geopackage.projection.ProjectionFactory;
import mil.nga.geopackage.projection.ProjectionTransform;
import org.osgeo.proj4j.CoordinateReferenceSystem;

public class Projection {
    private final long epsg;
    private final CoordinateReferenceSystem crs;

    Projection(long epsg, CoordinateReferenceSystem crs) {
        this.epsg = epsg;
        this.crs = crs;
    }

    public long getEpsg() {
        return this.epsg;
    }

    public CoordinateReferenceSystem getCrs() {
        return this.crs;
    }

    public ProjectionTransform getTransformation(long epsg) {
        Projection projectionTo = ProjectionFactory.getProjection(epsg);
        return this.getTransformation(projectionTo);
    }

    public ProjectionTransform getTransformation(Projection projection) {
        return new ProjectionTransform(this, projection);
    }

    public double toMeters(double value) {
        return value / this.crs.getProjection().getFromMetres();
    }
}

