/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.user;

import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.GeoPackageDataType;
import mil.nga.geopackage.user.UserCoreResult;

public class UserCoreResultUtils {
    public static final int FIELD_TYPE_INTEGER = 1;
    public static final int FIELD_TYPE_FLOAT = 2;
    public static final int FIELD_TYPE_STRING = 3;
    public static final int FIELD_TYPE_BLOB = 4;
    public static final int FIELD_TYPE_NULL = 0;

    public static Object getValue(UserCoreResult<?, ?, ?> result, int index, GeoPackageDataType dataType) {
        Object value = null;
        int type = result.getType(index);
        switch (type) {
            case 1: {
                value = UserCoreResultUtils.getIntegerValue(result, index, dataType);
                break;
            }
            case 2: {
                value = UserCoreResultUtils.getFloatValue(result, index, dataType);
                break;
            }
            case 3: {
                value = result.getString(index);
                break;
            }
            case 4: {
                value = result.getBlob(index);
                break;
            }
        }
        return value;
    }

    public static Object getIntegerValue(UserCoreResult<?, ?, ?> result, int index, GeoPackageDataType dataType) {
        Comparable<Short> value = null;
        switch (dataType) {
            case BOOLEAN: {
                short booleanValue = result.getShort(index);
                value = booleanValue == 0 ? Boolean.FALSE : Boolean.TRUE;
                break;
            }
            case TINYINT: {
                value = (byte)result.getShort(index);
                break;
            }
            case SMALLINT: {
                value = result.getShort(index);
                break;
            }
            case MEDIUMINT: {
                value = result.getInt(index);
                break;
            }
            case INT: 
            case INTEGER: {
                value = result.getLong(index);
                break;
            }
            default: {
                throw new GeoPackageException("Data Type " + (Object)((Object)dataType) + " is not an integer type");
            }
        }
        if (result.wasNull()) {
            value = null;
        }
        return value;
    }

    public static Object getFloatValue(UserCoreResult<?, ?, ?> result, int index, GeoPackageDataType dataType) {
        Number value = null;
        switch (dataType) {
            case FLOAT: {
                value = Float.valueOf(result.getFloat(index));
                break;
            }
            case INT: 
            case INTEGER: 
            case DOUBLE: 
            case REAL: {
                value = result.getDouble(index);
                break;
            }
            default: {
                throw new GeoPackageException("Data Type " + (Object)((Object)dataType) + " is not a float type");
            }
        }
        if (result.wasNull()) {
            value = null;
        }
        return value;
    }
}

