/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.core.srs;

import com.j256.ormlite.dao.BaseDaoImpl;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.core.contents.Contents;
import mil.nga.geopackage.core.contents.ContentsDao;
import mil.nga.geopackage.core.srs.SpatialReferenceSystem;
import mil.nga.geopackage.extension.CrsWktExtension;
import mil.nga.geopackage.features.columns.GeometryColumns;
import mil.nga.geopackage.features.columns.GeometryColumnsDao;
import mil.nga.geopackage.property.GeoPackageProperties;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSet;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSetDao;

public class SpatialReferenceSystemDao
extends BaseDaoImpl<SpatialReferenceSystem, Long> {
    private ContentsDao contentsDao;
    private GeometryColumnsDao geometryColumnsDao;
    private TileMatrixSetDao tileMatrixSetDao;
    private CrsWktExtension crsWktExtension;

    public SpatialReferenceSystemDao(ConnectionSource connectionSource, Class<SpatialReferenceSystem> dataClass) throws SQLException {
        super(connectionSource, dataClass);
    }

    public void setCrsWktExtension(CrsWktExtension crsWktExtension) {
        this.crsWktExtension = crsWktExtension;
    }

    public boolean hasDefinition_12_163() {
        return this.crsWktExtension != null && this.crsWktExtension.has();
    }

    public SpatialReferenceSystem createWgs84() throws SQLException {
        SpatialReferenceSystem srs = new SpatialReferenceSystem();
        srs.setSrsName(GeoPackageProperties.getProperty("geopackage.srs.wgs84", "srs_name"));
        srs.setSrsId(GeoPackageProperties.getIntegerProperty("geopackage.srs.wgs84", "srs_id"));
        srs.setOrganization(GeoPackageProperties.getProperty("geopackage.srs.wgs84", "organization"));
        srs.setOrganizationCoordsysId(GeoPackageProperties.getIntegerProperty("geopackage.srs.wgs84", "organization_coordsys_id"));
        srs.setDefinition(GeoPackageProperties.getProperty("geopackage.srs.wgs84", "definition"));
        srs.setDescription(GeoPackageProperties.getProperty("geopackage.srs.wgs84", "description"));
        this.create(srs);
        if (this.hasDefinition_12_163()) {
            srs.setDefinition_12_163(GeoPackageProperties.getProperty("geopackage.srs.wgs84", "definition_12_163"));
            this.crsWktExtension.updateDefinition(srs.getSrsId(), srs.getDefinition_12_163());
        }
        return srs;
    }

    public SpatialReferenceSystem createUndefinedCartesian() throws SQLException {
        SpatialReferenceSystem srs = new SpatialReferenceSystem();
        srs.setSrsName(GeoPackageProperties.getProperty("geopackage.srs.undefined_cartesian", "srs_name"));
        srs.setSrsId(GeoPackageProperties.getIntegerProperty("geopackage.srs.undefined_cartesian", "srs_id"));
        srs.setOrganization(GeoPackageProperties.getProperty("geopackage.srs.undefined_cartesian", "organization"));
        srs.setOrganizationCoordsysId(GeoPackageProperties.getIntegerProperty("geopackage.srs.undefined_cartesian", "organization_coordsys_id"));
        srs.setDefinition(GeoPackageProperties.getProperty("geopackage.srs.undefined_cartesian", "definition"));
        srs.setDescription(GeoPackageProperties.getProperty("geopackage.srs.undefined_cartesian", "description"));
        this.create(srs);
        if (this.hasDefinition_12_163()) {
            srs.setDefinition_12_163(GeoPackageProperties.getProperty("geopackage.srs.undefined_cartesian", "definition_12_163"));
            this.crsWktExtension.updateDefinition(srs.getSrsId(), srs.getDefinition_12_163());
        }
        return srs;
    }

    public SpatialReferenceSystem createUndefinedGeographic() throws SQLException {
        SpatialReferenceSystem srs = new SpatialReferenceSystem();
        srs.setSrsName(GeoPackageProperties.getProperty("geopackage.srs.undefined_geographic", "srs_name"));
        srs.setSrsId(GeoPackageProperties.getIntegerProperty("geopackage.srs.undefined_geographic", "srs_id"));
        srs.setOrganization(GeoPackageProperties.getProperty("geopackage.srs.undefined_geographic", "organization"));
        srs.setOrganizationCoordsysId(GeoPackageProperties.getIntegerProperty("geopackage.srs.undefined_geographic", "organization_coordsys_id"));
        srs.setDefinition(GeoPackageProperties.getProperty("geopackage.srs.undefined_geographic", "definition"));
        srs.setDescription(GeoPackageProperties.getProperty("geopackage.srs.undefined_geographic", "description"));
        this.create(srs);
        if (this.hasDefinition_12_163()) {
            srs.setDefinition_12_163(GeoPackageProperties.getProperty("geopackage.srs.undefined_geographic", "definition_12_163"));
            this.crsWktExtension.updateDefinition(srs.getSrsId(), srs.getDefinition_12_163());
        }
        return srs;
    }

    public SpatialReferenceSystem createWebMercator() throws SQLException {
        SpatialReferenceSystem srs = new SpatialReferenceSystem();
        srs.setSrsName(GeoPackageProperties.getProperty("geopackage.srs.web_mercator", "srs_name"));
        srs.setSrsId(GeoPackageProperties.getIntegerProperty("geopackage.srs.web_mercator", "srs_id"));
        srs.setOrganization(GeoPackageProperties.getProperty("geopackage.srs.web_mercator", "organization"));
        srs.setOrganizationCoordsysId(GeoPackageProperties.getIntegerProperty("geopackage.srs.web_mercator", "organization_coordsys_id"));
        srs.setDefinition(GeoPackageProperties.getProperty("geopackage.srs.web_mercator", "definition"));
        srs.setDescription(GeoPackageProperties.getProperty("geopackage.srs.web_mercator", "description"));
        this.create(srs);
        if (this.hasDefinition_12_163()) {
            srs.setDefinition_12_163(GeoPackageProperties.getProperty("geopackage.srs.web_mercator", "definition_12_163"));
            this.crsWktExtension.updateDefinition(srs.getSrsId(), srs.getDefinition_12_163());
        }
        return srs;
    }

    public String getDefinition_12_163(long srsId) {
        String definition = null;
        if (this.hasDefinition_12_163()) {
            definition = this.crsWktExtension.getDefinition(srsId);
        }
        return definition;
    }

    public void setDefinition_12_163(SpatialReferenceSystem srs) {
        String definition;
        if (srs != null && (definition = this.getDefinition_12_163(srs.getSrsId())) != null) {
            srs.setDefinition_12_163(definition);
        }
    }

    public void setDefinition_12_163(Collection<SpatialReferenceSystem> srsList) {
        for (SpatialReferenceSystem srs : srsList) {
            this.setDefinition_12_163(srs);
        }
    }

    public void updateDefinition_12_163(long srsId, String definition) {
        if (this.hasDefinition_12_163()) {
            this.crsWktExtension.updateDefinition(srsId, definition);
        }
    }

    public void updateDefinition_12_163(SpatialReferenceSystem srs) {
        String definition;
        if (srs != null && (definition = srs.getDefinition_12_163()) != null) {
            this.updateDefinition_12_163(srs.getSrsId(), definition);
        }
    }

    public SpatialReferenceSystem queryForId(Long id) throws SQLException {
        SpatialReferenceSystem srs = (SpatialReferenceSystem)super.queryForId((Object)id);
        this.setDefinition_12_163(srs);
        return srs;
    }

    public SpatialReferenceSystem queryForFirst(PreparedQuery<SpatialReferenceSystem> preparedQuery) throws SQLException {
        SpatialReferenceSystem srs = (SpatialReferenceSystem)super.queryForFirst(preparedQuery);
        this.setDefinition_12_163(srs);
        return srs;
    }

    public List<SpatialReferenceSystem> queryForAll() throws SQLException {
        List srsList = super.queryForAll();
        this.setDefinition_12_163(srsList);
        return srsList;
    }

    public List<SpatialReferenceSystem> queryForEq(String fieldName, Object value) throws SQLException {
        List srsList = super.queryForEq(fieldName, value);
        this.setDefinition_12_163(srsList);
        return srsList;
    }

    public List<SpatialReferenceSystem> query(PreparedQuery<SpatialReferenceSystem> preparedQuery) throws SQLException {
        List srsList = super.query(preparedQuery);
        this.setDefinition_12_163(srsList);
        return srsList;
    }

    public List<SpatialReferenceSystem> queryForMatching(SpatialReferenceSystem matchObj) throws SQLException {
        List srsList = super.queryForMatching((Object)matchObj);
        this.setDefinition_12_163(srsList);
        return srsList;
    }

    public List<SpatialReferenceSystem> queryForMatchingArgs(SpatialReferenceSystem matchObj) throws SQLException {
        List srsList = super.queryForMatchingArgs((Object)matchObj);
        this.setDefinition_12_163(srsList);
        return srsList;
    }

    public List<SpatialReferenceSystem> queryForFieldValues(Map<String, Object> fieldValues) throws SQLException {
        List srsList = super.queryForFieldValues(fieldValues);
        this.setDefinition_12_163(srsList);
        return srsList;
    }

    public List<SpatialReferenceSystem> queryForFieldValuesArgs(Map<String, Object> fieldValues) throws SQLException {
        List srsList = super.queryForFieldValuesArgs(fieldValues);
        this.setDefinition_12_163(srsList);
        return srsList;
    }

    public SpatialReferenceSystem queryForSameId(SpatialReferenceSystem data) throws SQLException {
        SpatialReferenceSystem srs = (SpatialReferenceSystem)super.queryForSameId((Object)data);
        this.setDefinition_12_163(srs);
        return srs;
    }

    public int create(SpatialReferenceSystem srs) throws SQLException {
        int result = super.create((Object)srs);
        this.updateDefinition_12_163(srs);
        return result;
    }

    public SpatialReferenceSystem createIfNotExists(SpatialReferenceSystem data) throws SQLException {
        SpatialReferenceSystem srs = (SpatialReferenceSystem)super.createIfNotExists((Object)data);
        this.updateDefinition_12_163(srs);
        return srs;
    }

    public Dao.CreateOrUpdateStatus createOrUpdate(SpatialReferenceSystem data) throws SQLException {
        Dao.CreateOrUpdateStatus status = super.createOrUpdate((Object)data);
        this.updateDefinition_12_163(data);
        return status;
    }

    public int update(SpatialReferenceSystem data) throws SQLException {
        int result = super.update((Object)data);
        this.updateDefinition_12_163(data);
        return result;
    }

    public SpatialReferenceSystem getOrCreate(long srsId) throws SQLException {
        SpatialReferenceSystem srs;
        block7: {
            block6: {
                srs = this.queryForId(srsId);
                if (srs != null) break block6;
                switch ((int)srsId) {
                    case 4326: {
                        srs = this.createWgs84();
                        break block7;
                    }
                    case -1: {
                        srs = this.createUndefinedCartesian();
                        break block7;
                    }
                    case 0: {
                        srs = this.createUndefinedGeographic();
                        break block7;
                    }
                    case 3857: {
                        srs = this.createWebMercator();
                        break block7;
                    }
                    default: {
                        throw new GeoPackageException("Spatial Reference System not supported for metadata creation: " + srsId);
                    }
                }
            }
            this.setDefinition_12_163(srs);
        }
        return srs;
    }

    public int deleteCascade(SpatialReferenceSystem srs) throws SQLException {
        int count = 0;
        if (srs != null) {
            ForeignCollection<TileMatrixSet> tileMatrixSetCollection;
            TileMatrixSetDao tileMatrixSetDao;
            ForeignCollection<GeometryColumns> geometryColumnsCollection;
            GeometryColumnsDao geometryColumnsDao;
            ForeignCollection<Contents> contentsCollection = srs.getContents();
            if (!contentsCollection.isEmpty()) {
                ContentsDao dao = this.getContentsDao();
                dao.deleteCascade((Collection<Contents>)contentsCollection);
            }
            if ((geometryColumnsDao = this.getGeometryColumnsDao()).isTableExists() && !(geometryColumnsCollection = srs.getGeometryColumns()).isEmpty()) {
                geometryColumnsDao.delete((Collection)geometryColumnsCollection);
            }
            if ((tileMatrixSetDao = this.getTileMatrixSetDao()).isTableExists() && !(tileMatrixSetCollection = srs.getTileMatrixSet()).isEmpty()) {
                tileMatrixSetDao.delete((Collection)tileMatrixSetCollection);
            }
            count = this.delete(srs);
        }
        return count;
    }

    public int deleteCascade(Collection<SpatialReferenceSystem> srsCollection) throws SQLException {
        int count = 0;
        if (srsCollection != null) {
            for (SpatialReferenceSystem srs : srsCollection) {
                count += this.deleteCascade(srs);
            }
        }
        return count;
    }

    public int deleteCascade(PreparedQuery<SpatialReferenceSystem> preparedDelete) throws SQLException {
        int count = 0;
        if (preparedDelete != null) {
            List<SpatialReferenceSystem> srsList = this.query(preparedDelete);
            count = this.deleteCascade(srsList);
        }
        return count;
    }

    public int deleteByIdCascade(Long id) throws SQLException {
        SpatialReferenceSystem srs;
        int count = 0;
        if (id != null && (srs = this.queryForId(id)) != null) {
            count = this.deleteCascade(srs);
        }
        return count;
    }

    public int deleteIdsCascade(Collection<Long> idCollection) throws SQLException {
        int count = 0;
        if (idCollection != null) {
            for (Long id : idCollection) {
                count += this.deleteByIdCascade(id);
            }
        }
        return count;
    }

    private ContentsDao getContentsDao() throws SQLException {
        if (this.contentsDao == null) {
            this.contentsDao = (ContentsDao)DaoManager.createDao((ConnectionSource)this.connectionSource, Contents.class);
        }
        return this.contentsDao;
    }

    private GeometryColumnsDao getGeometryColumnsDao() throws SQLException {
        if (this.geometryColumnsDao == null) {
            this.geometryColumnsDao = (GeometryColumnsDao)DaoManager.createDao((ConnectionSource)this.connectionSource, GeometryColumns.class);
        }
        return this.geometryColumnsDao;
    }

    private TileMatrixSetDao getTileMatrixSetDao() throws SQLException {
        if (this.tileMatrixSetDao == null) {
            this.tileMatrixSetDao = (TileMatrixSetDao)DaoManager.createDao((ConnectionSource)this.connectionSource, TileMatrixSet.class);
        }
        return this.tileMatrixSetDao;
    }
}

