/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension;

import java.sql.SQLException;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.extension.ExtensionScopeType;
import mil.nga.geopackage.extension.Extensions;
import mil.nga.geopackage.extension.ExtensionsDao;

public abstract class BaseExtension {
    protected final GeoPackageCore geoPackage;
    protected final ExtensionsDao extensionsDao;

    protected BaseExtension(GeoPackageCore geoPackage) {
        this.geoPackage = geoPackage;
        this.extensionsDao = geoPackage.getExtensionsDao();
    }

    public GeoPackageCore getGeoPackage() {
        return this.geoPackage;
    }

    public ExtensionsDao getExtensionsDao() {
        return this.extensionsDao;
    }

    protected Extensions getOrCreate(String extensionName, String tableName, String columnName, String description, ExtensionScopeType scopeType) {
        Extensions extension = this.get(extensionName, tableName, columnName);
        if (extension == null) {
            try {
                if (!this.extensionsDao.isTableExists()) {
                    this.geoPackage.createExtensionsTable();
                }
                extension = new Extensions();
                extension.setTableName(tableName);
                extension.setColumnName(columnName);
                extension.setExtensionName(extensionName);
                extension.setDefinition(description);
                extension.setScope(scopeType);
                this.extensionsDao.create(extension);
            }
            catch (SQLException e) {
                throw new GeoPackageException("Failed to create '" + extensionName + "' extension for GeoPackage: " + this.geoPackage.getName() + ", Table Name: " + tableName + ", Column Name: " + columnName, e);
            }
        }
        return extension;
    }

    protected Extensions get(String extensionName, String tableName, String columnName) {
        Extensions extension = null;
        try {
            if (this.extensionsDao.isTableExists()) {
                extension = this.extensionsDao.queryByExtension(extensionName, tableName, columnName);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to query for '" + extensionName + "' extension for GeoPackage: " + this.geoPackage.getName() + ", Table Name: " + tableName + ", Column Name: " + columnName, e);
        }
        return extension;
    }

    protected boolean has(String extensionName, String tableName, String columnName) {
        Extensions extension = this.get(extensionName, tableName, columnName);
        return extension != null;
    }
}

