/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.tiles.user;

import java.util.Arrays;
import java.util.List;
import mil.nga.geopackage.tiles.matrix.TileMatrix;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSet;

public class TileDaoUtils {
    public static void adjustTileMatrixLengths(TileMatrixSet tileMatrixSet, List<TileMatrix> tileMatrices) {
        double tileMatrixWidth = tileMatrixSet.getMaxX() - tileMatrixSet.getMinX();
        double tileMatrixHeight = tileMatrixSet.getMaxY() - tileMatrixSet.getMinY();
        for (TileMatrix tileMatrix : tileMatrices) {
            int tempMatrixWidth = (int)(tileMatrixWidth / (tileMatrix.getPixelXSize() * (double)tileMatrix.getTileWidth()));
            int tempMatrixHeight = (int)(tileMatrixHeight / (tileMatrix.getPixelYSize() * (double)tileMatrix.getTileHeight()));
            if ((long)tempMatrixWidth > tileMatrix.getMatrixWidth()) {
                tileMatrix.setMatrixWidth(tempMatrixWidth);
            }
            if ((long)tempMatrixHeight <= tileMatrix.getMatrixHeight()) continue;
            tileMatrix.setMatrixHeight(tempMatrixHeight);
        }
    }

    public static Long getZoomLevel(double[] widths, double[] heights, List<TileMatrix> tileMatrices, double length) {
        int index;
        int heightIndex;
        Long zoomLevel = null;
        int widthIndex = Arrays.binarySearch(widths, length);
        if (widthIndex < 0) {
            widthIndex = (widthIndex + 1) * -1;
        }
        if ((heightIndex = Arrays.binarySearch(heights, length)) < 0) {
            heightIndex = (heightIndex + 1) * -1;
        }
        if (widthIndex == 0) {
            if (length < TileDaoUtils.getMinLength(widths)) {
                widthIndex = -1;
            }
        } else if (widthIndex == widths.length) {
            widthIndex = length >= TileDaoUtils.getMaxLength(widths) ? -1 : --widthIndex;
        } else if (length - widths[widthIndex - 1] < widths[widthIndex] - length) {
            --widthIndex;
        }
        if (heightIndex == 0) {
            if (length < TileDaoUtils.getMinLength(heights)) {
                heightIndex = -1;
            }
        } else if (heightIndex == heights.length) {
            heightIndex = length >= TileDaoUtils.getMaxLength(heights) ? -1 : --heightIndex;
        } else if (length - heights[heightIndex - 1] < heights[heightIndex] - length) {
            --heightIndex;
        }
        if (widthIndex >= 0 && heightIndex >= 0 && (index = Math.min(widthIndex, heightIndex)) >= 0) {
            TileMatrix tileMatrix = tileMatrices.get(tileMatrices.size() - index - 1);
            zoomLevel = tileMatrix.getZoomLevel();
        }
        return zoomLevel;
    }

    public static double getMaxLength(double[] widths, double[] heights) {
        double maxWidth = TileDaoUtils.getMaxLength(widths);
        double maxHeight = TileDaoUtils.getMaxLength(heights);
        double maxLength = Math.min(maxWidth, maxHeight);
        return maxLength;
    }

    public static double getMinLength(double[] widths, double[] heights) {
        double minWidth = TileDaoUtils.getMinLength(widths);
        double minHeight = TileDaoUtils.getMinLength(heights);
        double minLength = Math.max(minWidth, minHeight);
        return minLength;
    }

    private static double getMaxLength(double[] lengths) {
        return lengths[lengths.length - 1] / 0.51;
    }

    private static double getMinLength(double[] lengths) {
        return lengths[0] * 0.51;
    }
}

