/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.db;

import com.j256.ormlite.support.ConnectionSource;
import java.io.Closeable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.CoreSQLUtils;

public abstract class GeoPackageCoreConnection
implements Closeable {
    public abstract ConnectionSource getConnectionSource();

    public abstract void execSQL(String var1);

    public abstract int delete(String var1, String var2, String[] var3);

    public abstract int count(String var1, String var2, String[] var3);

    public abstract Integer min(String var1, String var2, String var3, String[] var4);

    public abstract Integer max(String var1, String var2, String var3, String[] var4);

    @Override
    public abstract void close();

    public boolean tableExists(String tableName) {
        return this.count("sqlite_master", "tbl_name = ?", new String[]{tableName}) > 0;
    }

    public abstract boolean columnExists(String var1, String var2);

    public void addColumn(String tableName, String columnName, String columnDef) {
        this.execSQL("ALTER TABLE " + CoreSQLUtils.quoteWrap(tableName) + " ADD COLUMN " + CoreSQLUtils.quoteWrap(columnName) + " " + columnDef + ";");
    }

    public abstract String querySingleStringResult(String var1, String[] var2);

    public abstract Integer querySingleIntResult(String var1, String[] var2);

    public void setApplicationId() {
        this.setApplicationId("GPKG");
    }

    public void setApplicationId(String applicationId) {
        int applicationIdInt = ByteBuffer.wrap(applicationId.getBytes()).asIntBuffer().get();
        this.execSQL(String.format("PRAGMA application_id = %d;", applicationIdInt));
    }

    public String getApplicationId() {
        String applicationId = null;
        Integer applicationIdInteger = this.querySingleIntResult("PRAGMA application_id", null);
        if (applicationIdInteger != null) {
            try {
                applicationId = new String(ByteBuffer.allocate(4).putInt(applicationIdInteger).array(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new GeoPackageException("Unexpected application id character encoding", e);
            }
        }
        return applicationId;
    }

    public void setUserVersion() {
        this.setUserVersion(10200);
    }

    public void setUserVersion(int userVersion) {
        this.execSQL(String.format("PRAGMA user_version = %d;", userVersion));
    }

    public int getUserVersion() {
        int userVersion = -1;
        Integer userVersionInteger = this.querySingleIntResult("PRAGMA user_version", null);
        if (userVersionInteger != null) {
            userVersion = userVersionInteger;
        }
        return userVersion;
    }
}

