/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension;

import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.extension.BaseExtension;
import mil.nga.geopackage.extension.ExtensionScopeType;
import mil.nga.geopackage.extension.Extensions;
import mil.nga.geopackage.property.GeoPackageProperties;

public class CrsWktExtension
extends BaseExtension {
    public static final String NAME = "crs_wkt";
    public static final String EXTENSION_NAME = "gpkg_crs_wkt";
    public static final String DEFINITION = GeoPackageProperties.getProperty("geopackage.extensions", "crs_wkt");
    public static final String COLUMN_NAME = GeoPackageProperties.getProperty("geopackage.extensions.crs_wkt", "column_name");
    public static final String COLUMN_DEF = GeoPackageProperties.getProperty("geopackage.extensions.crs_wkt", "column_def");
    private GeoPackageCoreConnection connection = null;

    public CrsWktExtension(GeoPackageCore geoPackage) {
        super(geoPackage);
        this.connection = geoPackage.getDatabase();
    }

    public Extensions getOrCreate() {
        Extensions extension = this.getOrCreate(EXTENSION_NAME, null, null, DEFINITION, ExtensionScopeType.READ_WRITE);
        if (!this.hasColumn()) {
            this.createColumn();
        }
        return extension;
    }

    public boolean has() {
        boolean exists = this.has(EXTENSION_NAME, null, null);
        if (exists) {
            exists = this.hasColumn();
        }
        return exists;
    }

    public void updateDefinition(long srsId, String definition) {
        this.connection.execSQL("UPDATE gpkg_spatial_ref_sys SET " + COLUMN_NAME + " = '" + definition + "' WHERE " + "srs_id" + " = " + srsId);
    }

    public String getDefinition(long srsId) {
        String definition = this.connection.querySingleStringResult("SELECT " + COLUMN_NAME + " FROM " + "gpkg_spatial_ref_sys" + " WHERE " + "srs_id" + " = ?", new String[]{String.valueOf(srsId)});
        return definition;
    }

    private void createColumn() {
        this.connection.addColumn("gpkg_spatial_ref_sys", COLUMN_NAME, COLUMN_DEF);
        this.updateDefinition(GeoPackageProperties.getIntegerProperty("geopackage.srs.wgs84", "srs_id"), GeoPackageProperties.getProperty("geopackage.srs.wgs84", "definition_12_063"));
        this.updateDefinition(GeoPackageProperties.getIntegerProperty("geopackage.srs.undefined_cartesian", "srs_id"), GeoPackageProperties.getProperty("geopackage.srs.undefined_cartesian", "definition_12_063"));
        this.updateDefinition(GeoPackageProperties.getIntegerProperty("geopackage.srs.undefined_geographic", "srs_id"), GeoPackageProperties.getProperty("geopackage.srs.undefined_geographic", "definition_12_063"));
        this.updateDefinition(GeoPackageProperties.getIntegerProperty("geopackage.srs.web_mercator", "srs_id"), GeoPackageProperties.getProperty("geopackage.srs.web_mercator", "definition_12_063"));
    }

    private boolean hasColumn() {
        boolean exists = this.connection.columnExists("gpkg_spatial_ref_sys", COLUMN_NAME);
        return exists;
    }
}

