/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.elevation;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.core.contents.ContentsDataType;
import mil.nga.geopackage.extension.BaseExtension;
import mil.nga.geopackage.extension.ExtensionScopeType;
import mil.nga.geopackage.extension.Extensions;
import mil.nga.geopackage.extension.elevation.ElevationImage;
import mil.nga.geopackage.extension.elevation.ElevationRequest;
import mil.nga.geopackage.extension.elevation.ElevationSourcePixel;
import mil.nga.geopackage.extension.elevation.ElevationTileResults;
import mil.nga.geopackage.extension.elevation.ElevationTilesAlgorithm;
import mil.nga.geopackage.extension.elevation.GriddedCoverage;
import mil.nga.geopackage.extension.elevation.GriddedCoverageDao;
import mil.nga.geopackage.extension.elevation.GriddedCoverageDataType;
import mil.nga.geopackage.extension.elevation.GriddedTile;
import mil.nga.geopackage.extension.elevation.GriddedTileDao;
import mil.nga.geopackage.projection.Projection;
import mil.nga.geopackage.projection.ProjectionFactory;
import mil.nga.geopackage.projection.ProjectionTransform;
import mil.nga.geopackage.property.GeoPackageProperties;
import mil.nga.geopackage.tiles.matrix.TileMatrix;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSet;
import org.osgeo.proj4j.ProjCoordinate;

public abstract class ElevationTilesCore<TImage extends ElevationImage>
extends BaseExtension {
    public static final String EXTENSION_AUTHOR = "gpkg";
    public static final String EXTENSION_NAME_NO_AUTHOR = "elevation_tiles";
    public static final String EXTENSION_NAME = Extensions.buildExtensionName("gpkg", "elevation_tiles");
    public static final String EXTENSION_DEFINITION = GeoPackageProperties.getProperty("geopackage.extensions", "elevation_tiles");
    private final TileMatrixSet tileMatrixSet;
    private final GriddedCoverageDao griddedCoverageDao;
    private final GriddedTileDao griddedTileDao;
    private GriddedCoverage griddedCoverage;
    protected Integer width;
    protected Integer height;
    protected final Projection requestProjection;
    protected final Projection elevationProjection;
    protected final BoundingBox elevationBoundingBox;
    protected final boolean sameProjection;
    protected boolean zoomIn = true;
    protected boolean zoomOut = true;
    protected boolean zoomInBeforeOut = true;
    protected ElevationTilesAlgorithm algorithm = ElevationTilesAlgorithm.NEAREST_NEIGHBOR;

    protected ElevationTilesCore(GeoPackageCore geoPackage, TileMatrixSet tileMatrixSet, Integer width, Integer height, Projection requestProjection) {
        super(geoPackage);
        this.tileMatrixSet = tileMatrixSet;
        this.griddedCoverageDao = geoPackage.getGriddedCoverageDao();
        this.griddedTileDao = geoPackage.getGriddedTileDao();
        this.queryGriddedCoverage();
        this.width = width;
        this.height = height;
        this.requestProjection = requestProjection;
        this.elevationProjection = ProjectionFactory.getProjection(tileMatrixSet.getSrs());
        this.elevationBoundingBox = tileMatrixSet.getBoundingBox();
        this.sameProjection = requestProjection != null ? requestProjection.getUnit().name.equals(this.elevationProjection.getUnit().name) : true;
    }

    protected ElevationTilesCore(GeoPackageCore geoPackage, TileMatrixSet tileMatrixSet) {
        this(geoPackage, tileMatrixSet, null, null, null);
    }

    public abstract Double getElevationValue(GriddedTile var1, TImage var2, int var3, int var4);

    public abstract ElevationTileResults getElevations(ElevationRequest var1, Integer var2, Integer var3);

    public abstract ElevationTileResults getElevationsUnbounded(ElevationRequest var1);

    public TileMatrixSet getTileMatrixSet() {
        return this.tileMatrixSet;
    }

    public GriddedCoverageDao getGriddedCoverageDao() {
        return this.griddedCoverageDao;
    }

    public GriddedTileDao getGriddedTileDao() {
        return this.griddedTileDao;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public Projection getRequestProjection() {
        return this.requestProjection;
    }

    public Projection getElevationProjection() {
        return this.elevationProjection;
    }

    public BoundingBox getElevationBoundingBox() {
        return this.elevationBoundingBox;
    }

    public boolean isSameProjection() {
        return this.sameProjection;
    }

    public boolean isZoomIn() {
        return this.zoomIn;
    }

    public void setZoomIn(boolean zoomIn) {
        this.zoomIn = zoomIn;
    }

    public boolean isZoomOut() {
        return this.zoomOut;
    }

    public void setZoomOut(boolean zoomOut) {
        this.zoomOut = zoomOut;
    }

    public boolean isZoomInBeforeOut() {
        return this.zoomInBeforeOut;
    }

    public void setZoomInBeforeOut(boolean zoomInBeforeOut) {
        this.zoomInBeforeOut = zoomInBeforeOut;
    }

    public ElevationTilesAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(ElevationTilesAlgorithm algorithm) {
        if (algorithm == null) {
            algorithm = ElevationTilesAlgorithm.NEAREST_NEIGHBOR;
        }
        this.algorithm = algorithm;
    }

    public List<Extensions> getOrCreate() {
        this.geoPackage.createGriddedCoverageTable();
        this.geoPackage.createGriddedTileTable();
        ArrayList<Extensions> extensionList = new ArrayList<Extensions>();
        Extensions coverage = this.getOrCreate(EXTENSION_NAME, "gpkg_2d_gridded_coverage_ancillary", null, EXTENSION_DEFINITION, ExtensionScopeType.READ_WRITE);
        Extensions tile = this.getOrCreate(EXTENSION_NAME, "gpkg_2d_gridded_tile_ancillary", null, EXTENSION_DEFINITION, ExtensionScopeType.READ_WRITE);
        Extensions table = this.getOrCreate(EXTENSION_NAME, this.tileMatrixSet.getTableName(), "tile_data", EXTENSION_DEFINITION, ExtensionScopeType.READ_WRITE);
        extensionList.add(coverage);
        extensionList.add(tile);
        extensionList.add(table);
        return extensionList;
    }

    public boolean has() {
        boolean exists = this.has(EXTENSION_NAME, this.tileMatrixSet.getTableName(), "tile_data");
        return exists;
    }

    public GriddedCoverage getGriddedCoverage() {
        return this.griddedCoverage;
    }

    public GriddedCoverage queryGriddedCoverage() {
        try {
            if (this.griddedCoverageDao.isTableExists()) {
                this.griddedCoverage = this.griddedCoverageDao.query(this.tileMatrixSet);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to get Gridded Coverage for table name: " + this.tileMatrixSet.getTableName(), e);
        }
        return this.griddedCoverage;
    }

    public List<GriddedTile> getGriddedTile() {
        List<GriddedTile> griddedTile = null;
        try {
            if (this.griddedTileDao.isTableExists()) {
                griddedTile = this.griddedTileDao.query(this.tileMatrixSet.getTableName());
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to get Gridded Tile for table name: " + this.tileMatrixSet.getTableName(), e);
        }
        return griddedTile;
    }

    public GriddedTile getGriddedTile(long tileId) {
        GriddedTile griddedTile = null;
        try {
            if (this.griddedTileDao.isTableExists()) {
                griddedTile = this.griddedTileDao.query(this.tileMatrixSet.getTableName(), tileId);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to get Gridded Tile for table name: " + this.tileMatrixSet.getTableName() + ", tile id: " + tileId, e);
        }
        return griddedTile;
    }

    public Double getDataNull() {
        Double dataNull = null;
        if (this.griddedCoverage != null) {
            dataNull = this.griddedCoverage.getDataNull();
        }
        return dataNull;
    }

    public boolean isDataNull(double value) {
        Double dataNull = this.getDataNull();
        boolean isDataNull = dataNull != null && dataNull == value;
        return isDataNull;
    }

    public static List<String> getTables(GeoPackageCore geoPackage) {
        return geoPackage.getTables(ContentsDataType.ELEVATION_TILES);
    }

    protected Double[][] reprojectElevations(Double[][] elevations, int requestedElevationsWidth, int requestedElevationsHeight, BoundingBox requestBoundingBox, ProjectionTransform transformRequestToElevation, BoundingBox elevationBoundingBox) {
        double requestedWidthUnitsPerPixel = (requestBoundingBox.getMaxLongitude() - requestBoundingBox.getMinLongitude()) / (double)requestedElevationsWidth;
        double requestedHeightUnitsPerPixel = (requestBoundingBox.getMaxLatitude() - requestBoundingBox.getMinLatitude()) / (double)requestedElevationsHeight;
        double tilesDistanceWidth = elevationBoundingBox.getMaxLongitude() - elevationBoundingBox.getMinLongitude();
        double tilesDistanceHeight = elevationBoundingBox.getMaxLatitude() - elevationBoundingBox.getMinLatitude();
        int width = elevations[0].length;
        int height = elevations.length;
        Double[][] projectedElevations = new Double[requestedElevationsHeight][requestedElevationsWidth];
        for (int y = 0; y < requestedElevationsHeight; ++y) {
            for (int x = 0; x < requestedElevationsWidth; ++x) {
                Double elevation;
                double longitude = requestBoundingBox.getMinLongitude() + (double)x * requestedWidthUnitsPerPixel;
                double latitude = requestBoundingBox.getMaxLatitude() - (double)y * requestedHeightUnitsPerPixel;
                ProjCoordinate fromCoord = new ProjCoordinate(longitude, latitude);
                ProjCoordinate toCoord = transformRequestToElevation.transform(fromCoord);
                double projectedLongitude = toCoord.x;
                double projectedLatitude = toCoord.y;
                int xPixel = (int)Math.round((projectedLongitude - elevationBoundingBox.getMinLongitude()) / tilesDistanceWidth * (double)width);
                int yPixel = (int)Math.round((elevationBoundingBox.getMaxLatitude() - projectedLatitude) / tilesDistanceHeight * (double)height);
                xPixel = Math.max(0, xPixel);
                xPixel = Math.min(width - 1, xPixel);
                yPixel = Math.max(0, yPixel);
                yPixel = Math.min(height - 1, yPixel);
                projectedElevations[y][x] = elevation = elevations[yPixel][xPixel];
            }
        }
        return projectedElevations;
    }

    protected Double[][] formatUnboundedResults(TileMatrix tileMatrix, Map<Long, Map<Long, Double[][]>> rowsMap, int tileCount, long minRow, long maxRow, long minColumn, long maxColumn) {
        Double[][] elevations = null;
        if (!rowsMap.isEmpty()) {
            if (tileCount == 1) {
                elevations = rowsMap.get(minRow).get(minColumn);
            } else {
                Double[][] topLeft = rowsMap.get(minRow).get(minColumn);
                Double[][] bottomRight = rowsMap.get(maxRow).get(maxColumn);
                int firstWidth = topLeft[0].length;
                int firstHeight = topLeft.length;
                int width = firstWidth;
                int height = firstHeight;
                if (minColumn < maxColumn) {
                    width += bottomRight[0].length;
                    long middleColumns = maxColumn - minColumn - 1L;
                    if (middleColumns > 0L) {
                        width = (int)((long)width + middleColumns * tileMatrix.getTileWidth());
                    }
                }
                if (minRow < maxRow) {
                    height += bottomRight.length;
                    long middleRows = maxRow - minRow - 1L;
                    if (middleRows > 0L) {
                        height = (int)((long)height + middleRows * tileMatrix.getTileHeight());
                    }
                }
                elevations = new Double[height][width];
                for (Map.Entry<Long, Map<Long, Double[][]>> rows : rowsMap.entrySet()) {
                    long row = rows.getKey();
                    int baseRow = 0;
                    if (minRow < row) {
                        baseRow = firstHeight + (int)((row - minRow - 1L) * tileMatrix.getTileHeight());
                    }
                    Map<Long, Double[][]> columnsMap = rows.getValue();
                    for (Map.Entry<Long, Double[][]> columns : columnsMap.entrySet()) {
                        long column = columns.getKey();
                        int baseColumn = 0;
                        if (minColumn < column) {
                            baseColumn = firstWidth + (int)((column - minColumn - 1L) * tileMatrix.getTileWidth());
                        }
                        Double[][] values = columns.getValue();
                        for (int localRow = 0; localRow < values.length; ++localRow) {
                            int globalRow = baseRow + localRow;
                            System.arraycopy(values[localRow], 0, elevations[globalRow], baseColumn, values[localRow].length);
                        }
                    }
                }
            }
        }
        return elevations;
    }

    protected float getXSource(int x, float destLeft, float srcLeft, float widthRatio) {
        float middleOfXDestPixel = (float)x - destLeft + 0.5f;
        float xSourcePixel = middleOfXDestPixel * widthRatio;
        float xSource = srcLeft + xSourcePixel;
        return xSource;
    }

    protected float getYSource(int y, float destTop, float srcTop, float heightRatio) {
        float middleOfYDestPixel = (float)y - destTop + 0.5f;
        float ySourcePixel = middleOfYDestPixel * heightRatio;
        float ySource = srcTop + ySourcePixel;
        return ySource;
    }

    protected List<int[]> getNearestNeighbors(float xSource, float ySource) {
        float yDistance;
        int secondY;
        int firstY;
        float xDistance;
        int secondX;
        int firstX;
        ArrayList<int[]> results = new ArrayList<int[]>();
        ElevationSourcePixel xPixel = this.getSourceMinAndMax(xSource);
        ElevationSourcePixel yPixel = this.getSourceMinAndMax(ySource);
        if ((double)xPixel.getOffset() > 0.5) {
            firstX = xPixel.getMax();
            secondX = xPixel.getMin();
            xDistance = 1.0f - xPixel.getOffset();
        } else {
            firstX = xPixel.getMin();
            secondX = xPixel.getMax();
            xDistance = xPixel.getOffset();
        }
        if ((double)yPixel.getOffset() > 0.5) {
            firstY = yPixel.getMax();
            secondY = yPixel.getMin();
            yDistance = 1.0f - yPixel.getOffset();
        } else {
            firstY = yPixel.getMin();
            secondY = yPixel.getMax();
            yDistance = yPixel.getOffset();
        }
        results.add(new int[]{firstX, firstY});
        if (xDistance <= yDistance) {
            results.add(new int[]{secondX, firstY});
            results.add(new int[]{firstX, secondY});
        } else {
            results.add(new int[]{firstX, secondY});
            results.add(new int[]{secondX, firstY});
        }
        results.add(new int[]{secondX, secondY});
        if (xPixel.getOffset() == 0.0f) {
            results.add(new int[]{xPixel.getMin() - 1, yPixel.getMin()});
            results.add(new int[]{xPixel.getMin() - 1, yPixel.getMax()});
        }
        if (yPixel.getOffset() == 0.0f) {
            results.add(new int[]{xPixel.getMin(), yPixel.getMin() - 1});
            results.add(new int[]{xPixel.getMax(), yPixel.getMin() - 1});
        }
        if (xPixel.getOffset() == 0.0f && yPixel.getOffset() == 0.0f) {
            results.add(new int[]{xPixel.getMin() - 1, yPixel.getMin() - 1});
        }
        return results;
    }

    protected ElevationSourcePixel getSourceMinAndMax(float source) {
        int floor;
        int min = floor = (int)Math.floor(source);
        int max = floor;
        float offset = source - (float)floor;
        if ((double)offset < 0.5) {
            --min;
            offset += 0.5f;
        } else if ((double)offset >= 0.5) {
            ++max;
            offset -= 0.5f;
        }
        return new ElevationSourcePixel(source, min, max, offset);
    }

    protected Double getBilinearInterpolationElevation(ElevationSourcePixel sourcePixelX, ElevationSourcePixel sourcePixelY, Double[][] values) {
        return this.getBilinearInterpolationElevation(sourcePixelX.getOffset(), sourcePixelY.getOffset(), sourcePixelX.getMin(), sourcePixelX.getMax(), sourcePixelY.getMin(), sourcePixelY.getMax(), values);
    }

    protected Double getBilinearInterpolationElevation(float offsetX, float offsetY, float minX, float maxX, float minY, float maxY, Double[][] values) {
        Double elevation = null;
        if (values != null) {
            elevation = this.getBilinearInterpolationElevation(offsetX, offsetY, minX, maxX, minY, maxY, values[0][0], values[0][1], values[1][0], values[1][1]);
        }
        return elevation;
    }

    protected Double getBilinearInterpolationElevation(float offsetX, float offsetY, float minX, float maxX, float minY, float maxY, Double topLeft, Double topRight, Double bottomLeft, Double bottomRight) {
        Double elevation = null;
        if (!(topLeft == null || topRight == null && minX != maxX || bottomLeft == null && minY != maxY || bottomRight == null && (minX != maxX || minY != maxY))) {
            double result;
            Double bottomRow;
            double topRow;
            float diffX = maxX - minX;
            if (diffX == 0.0f) {
                topRow = topLeft;
                bottomRow = bottomLeft;
            } else {
                float diffLeft = offsetX;
                float diffRight = diffX - offsetX;
                topRow = (double)(diffRight / diffX) * topLeft + (double)(diffLeft / diffX) * topRight;
                bottomRow = (double)(diffRight / diffX) * bottomLeft + (double)(diffLeft / diffX) * bottomRight;
            }
            float diffY = maxY - minY;
            if (diffY == 0.0f) {
                result = topRow;
            } else {
                float diffTop = offsetY;
                float diffBottom = diffY - offsetY;
                result = (double)(diffBottom / diffY) * topRow + (double)(diffTop / diffY) * bottomRow;
            }
            elevation = result;
        }
        return elevation;
    }

    protected Double getBicubicInterpolationElevation(Double[][] values, ElevationSourcePixel sourcePixelX, ElevationSourcePixel sourcePixelY) {
        return this.getBicubicInterpolationElevation(values, sourcePixelX.getOffset(), sourcePixelY.getOffset());
    }

    protected Double getBicubicInterpolationElevation(Double[][] values, float offsetX, float offsetY) {
        Double elevation = null;
        Double[] rowValues = new Double[4];
        for (int y = 0; y < 4; ++y) {
            Double rowElevation = this.getCubicInterpolationElevation(values[y][0], values[y][1], values[y][2], values[y][3], offsetX);
            if (rowElevation == null) {
                rowValues = null;
                break;
            }
            rowValues[y] = rowElevation;
        }
        if (rowValues != null) {
            elevation = this.getCubicInterpolationElevation(rowValues, offsetY);
        }
        return elevation;
    }

    protected Double getCubicInterpolationElevation(Double[] values, double offset) {
        Double elevation = null;
        if (values != null) {
            elevation = this.getCubicInterpolationElevation(values[0], values[1], values[2], values[3], offset);
        }
        return elevation;
    }

    protected Double getCubicInterpolationElevation(Double value0, Double value1, Double value2, Double value3, double offset) {
        Double elevation = null;
        if (value0 != null && value1 != null && value2 != null && value3 != null) {
            double coefficient0 = 2.0 * value1;
            double coefficient1 = value2 - value0;
            double coefficient2 = 2.0 * value0 - 5.0 * value1 + 4.0 * value2 - value3;
            double coefficient3 = -value0.doubleValue() + 3.0 * value1 - 3.0 * value2 + value3;
            elevation = (coefficient3 * offset * offset * offset + coefficient2 * offset * offset + coefficient1 * offset + coefficient0) / 2.0;
        }
        return elevation;
    }

    protected BoundingBox padBoundingBox(TileMatrix tileMatrix, BoundingBox boundingBox, int overlap) {
        double lonPixelPadding = tileMatrix.getPixelXSize() * (double)overlap;
        double latPixelPadding = tileMatrix.getPixelYSize() * (double)overlap;
        BoundingBox paddedBoundingBox = new BoundingBox(boundingBox.getMinLongitude() - lonPixelPadding, boundingBox.getMaxLongitude() + lonPixelPadding, boundingBox.getMinLatitude() - latPixelPadding, boundingBox.getMaxLatitude() + latPixelPadding);
        return paddedBoundingBox;
    }

    public short getPixelValue(short[] pixelValues, int width, int x, int y) {
        return pixelValues[y * width + x];
    }

    public int getUnsignedPixelValue(short[] pixelValues, int width, int x, int y) {
        short pixelValue = this.getPixelValue(pixelValues, width, x, y);
        int unsignedPixelValue = this.getUnsignedPixelValue(pixelValue);
        return unsignedPixelValue;
    }

    public int getUnsignedPixelValue(int[] unsignedPixelValues, int width, int x, int y) {
        return unsignedPixelValues[y * width + x];
    }

    public int getUnsignedPixelValue(short pixelValue) {
        return pixelValue & 0xFFFF;
    }

    public short getPixelValue(int unsignedPixelValue) {
        return (short)unsignedPixelValue;
    }

    public int[] getUnsignedPixelValues(short[] pixelValues) {
        int[] unsignedValues = new int[pixelValues.length];
        for (int i = 0; i < pixelValues.length; ++i) {
            unsignedValues[i] = this.getUnsignedPixelValue(pixelValues[i]);
        }
        return unsignedValues;
    }

    public Double getElevationValue(GriddedTile griddedTile, short pixelValue) {
        int unsignedPixelValue = this.getUnsignedPixelValue(pixelValue);
        Double elevation = this.getElevationValue(griddedTile, unsignedPixelValue);
        return elevation;
    }

    public Double getElevationValue(GriddedTile griddedTile, int unsignedPixelValue) {
        Double elevation = null;
        if (!this.isDataNull(unsignedPixelValue)) {
            elevation = this.pixelValueToElevation(griddedTile, new Double(unsignedPixelValue));
        }
        return elevation;
    }

    private Double pixelValueToElevation(GriddedTile griddedTile, Double pixelValue) {
        Double elevation = pixelValue;
        if (this.griddedCoverage != null && this.griddedCoverage.getDataType() == GriddedCoverageDataType.INTEGER) {
            if (griddedTile != null) {
                if (griddedTile.getScale() != null) {
                    elevation = elevation * griddedTile.getScale();
                }
                if (griddedTile.getOffset() != null) {
                    elevation = elevation + griddedTile.getOffset();
                }
            }
            if (this.griddedCoverage.getScale() != null) {
                elevation = elevation * this.griddedCoverage.getScale();
            }
            if (this.griddedCoverage.getOffset() != null) {
                elevation = elevation + this.griddedCoverage.getOffset();
            }
        }
        return elevation;
    }

    public Double[] getElevationValues(GriddedTile griddedTile, short[] pixelValues) {
        Double[] elevations = new Double[pixelValues.length];
        for (int i = 0; i < pixelValues.length; ++i) {
            elevations[i] = this.getElevationValue(griddedTile, pixelValues[i]);
        }
        return elevations;
    }

    public Double[] getElevationValues(GriddedTile griddedTile, int[] unsignedPixelValues) {
        Double[] elevations = new Double[unsignedPixelValues.length];
        for (int i = 0; i < unsignedPixelValues.length; ++i) {
            elevations[i] = this.getElevationValue(griddedTile, unsignedPixelValues[i]);
        }
        return elevations;
    }

    public static TileMatrixSet createTileTableWithMetadata(GeoPackageCore geoPackage, String tableName, BoundingBox contentsBoundingBox, long contentsSrsId, BoundingBox tileMatrixSetBoundingBox, long tileMatrixSetSrsId) {
        TileMatrixSet tileMatrixSet = geoPackage.createTileTableWithMetadata(ContentsDataType.ELEVATION_TILES, tableName, contentsBoundingBox, contentsSrsId, tileMatrixSetBoundingBox, tileMatrixSetSrsId);
        return tileMatrixSet;
    }

    public int getUnsignedPixelValue(GriddedTile griddedTile, Double elevation) {
        int unsignedPixelValue = 0;
        if (elevation == null) {
            if (this.griddedCoverage != null) {
                unsignedPixelValue = this.griddedCoverage.getDataNull().intValue();
            }
        } else {
            double value = this.elevationToPixelValue(griddedTile, elevation);
            unsignedPixelValue = (int)Math.round(value);
        }
        return unsignedPixelValue;
    }

    private double elevationToPixelValue(GriddedTile griddedTile, double elevation) {
        double pixelValue = elevation;
        if (this.griddedCoverage != null && this.griddedCoverage.getDataType() == GriddedCoverageDataType.INTEGER) {
            if (this.griddedCoverage.getOffset() != null) {
                pixelValue -= this.griddedCoverage.getOffset().doubleValue();
            }
            if (this.griddedCoverage.getScale() != null) {
                pixelValue /= this.griddedCoverage.getScale().doubleValue();
            }
            if (griddedTile != null) {
                if (griddedTile.getOffset() != null) {
                    pixelValue -= griddedTile.getOffset().doubleValue();
                }
                if (griddedTile.getScale() != null) {
                    pixelValue /= griddedTile.getScale().doubleValue();
                }
            }
        }
        return pixelValue;
    }

    public short getPixelValue(GriddedTile griddedTile, Double elevation) {
        int unsignedPixelValue = this.getUnsignedPixelValue(griddedTile, elevation);
        short pixelValue = this.getPixelValue(unsignedPixelValue);
        return pixelValue;
    }

    public float getPixelValue(float[] pixelValues, int width, int x, int y) {
        return pixelValues[y * width + x];
    }

    public Double getElevationValue(GriddedTile griddedTile, float pixelValue) {
        Double elevation = null;
        if (!this.isDataNull(pixelValue)) {
            elevation = this.pixelValueToElevation(griddedTile, new Double(pixelValue));
        }
        return elevation;
    }

    public Double[] getElevationValues(GriddedTile griddedTile, float[] pixelValues) {
        Double[] elevations = new Double[pixelValues.length];
        for (int i = 0; i < pixelValues.length; ++i) {
            elevations[i] = this.getElevationValue(griddedTile, pixelValues[i]);
        }
        return elevations;
    }

    public float getFloatPixelValue(GriddedTile griddedTile, Double elevation) {
        double value = 0.0;
        if (elevation == null) {
            if (this.griddedCoverage != null) {
                value = this.griddedCoverage.getDataNull();
            }
        } else {
            value = this.elevationToPixelValue(griddedTile, elevation);
        }
        float pixelValue = (float)value;
        return pixelValue;
    }

    public Double getElevation(double latitude, double longitude) {
        ElevationRequest request = new ElevationRequest(latitude, longitude);
        ElevationTileResults elevations = this.getElevations(request, (Integer)1, (Integer)1);
        Double elevation = null;
        if (elevations != null) {
            elevation = elevations.getElevations()[0][0];
        }
        return elevation;
    }

    public ElevationTileResults getElevations(BoundingBox requestBoundingBox) {
        ElevationRequest request = new ElevationRequest(requestBoundingBox);
        ElevationTileResults elevations = this.getElevations(request);
        return elevations;
    }

    public ElevationTileResults getElevations(BoundingBox requestBoundingBox, Integer width, Integer height) {
        ElevationRequest request = new ElevationRequest(requestBoundingBox);
        ElevationTileResults elevations = this.getElevations(request, width, height);
        return elevations;
    }

    public ElevationTileResults getElevations(ElevationRequest request) {
        ElevationTileResults elevations = this.getElevations(request, this.width, this.height);
        return elevations;
    }

    public ElevationTileResults getElevationsUnbounded(BoundingBox requestBoundingBox) {
        ElevationRequest request = new ElevationRequest(requestBoundingBox);
        return this.getElevationsUnbounded(request);
    }

    protected Double getBilinearInterpolationElevation(GriddedTile griddedTile, TImage image, Double[][] leftLastColumns, Double[][] topLeftRows, Double[][] topRows, int y, int x, float widthRatio, float heightRatio, float destTop, float destLeft, float srcTop, float srcLeft) {
        float xSource = this.getXSource(x, destLeft, srcLeft, widthRatio);
        float ySource = this.getYSource(y, destTop, srcTop, heightRatio);
        ElevationSourcePixel sourcePixelX = this.getSourceMinAndMax(xSource);
        ElevationSourcePixel sourcePixelY = this.getSourceMinAndMax(ySource);
        Double[][] values = new Double[2][2];
        this.populateElevationValues(griddedTile, image, leftLastColumns, topLeftRows, topRows, sourcePixelX, sourcePixelY, values);
        Double elevation = null;
        if (values != null) {
            elevation = this.getBilinearInterpolationElevation(sourcePixelX, sourcePixelY, values);
        }
        return elevation;
    }

    protected Double getBicubicInterpolationElevation(GriddedTile griddedTile, TImage image, Double[][] leftLastColumns, Double[][] topLeftRows, Double[][] topRows, int y, int x, float widthRatio, float heightRatio, float destTop, float destLeft, float srcTop, float srcLeft) {
        float xSource = this.getXSource(x, destLeft, srcLeft, widthRatio);
        float ySource = this.getYSource(y, destTop, srcTop, heightRatio);
        ElevationSourcePixel sourcePixelX = this.getSourceMinAndMax(xSource);
        sourcePixelX.setMin(sourcePixelX.getMin() - 1);
        sourcePixelX.setMax(sourcePixelX.getMax() + 1);
        ElevationSourcePixel sourcePixelY = this.getSourceMinAndMax(ySource);
        sourcePixelY.setMin(sourcePixelY.getMin() - 1);
        sourcePixelY.setMax(sourcePixelY.getMax() + 1);
        Double[][] values = new Double[4][4];
        this.populateElevationValues(griddedTile, image, leftLastColumns, topLeftRows, topRows, sourcePixelX, sourcePixelY, values);
        Double elevation = null;
        if (values != null) {
            elevation = this.getBicubicInterpolationElevation(values, sourcePixelX, sourcePixelY);
        }
        return elevation;
    }

    private void populateElevationValues(GriddedTile griddedTile, TImage image, Double[][] leftLastColumns, Double[][] topLeftRows, Double[][] topRows, ElevationSourcePixel pixelX, ElevationSourcePixel pixelY, Double[][] values) {
        this.populateElevationValues(griddedTile, image, leftLastColumns, topLeftRows, topRows, pixelX.getMin(), pixelX.getMax(), pixelY.getMin(), pixelY.getMax(), values);
    }

    private void populateElevationValues(GriddedTile griddedTile, TImage image, Double[][] leftLastColumns, Double[][] topLeftRows, Double[][] topRows, int minX, int maxX, int minY, int maxY, Double[][] values) {
        block0: for (int yLocation = maxY; values != null && yLocation >= minY; --yLocation) {
            for (int xLocation = maxX; xLocation >= minX; --xLocation) {
                Double value = this.getElevationValueOverBorders(griddedTile, image, leftLastColumns, topLeftRows, topRows, xLocation, yLocation);
                if (value == null) {
                    values = null;
                    continue block0;
                }
                values[yLocation - minY][xLocation - minX] = value;
            }
        }
    }

    protected Double getNearestNeighborElevation(GriddedTile griddedTile, TImage image, Double[][] leftLastColumns, Double[][] topLeftRows, Double[][] topRows, int y, int x, float widthRatio, float heightRatio, float destTop, float destLeft, float srcTop, float srcLeft) {
        int[] nearestNeighbor;
        float xSource = this.getXSource(x, destLeft, srcLeft, widthRatio);
        float ySource = this.getYSource(y, destTop, srcTop, heightRatio);
        List<int[]> nearestNeighbors = this.getNearestNeighbors(xSource, ySource);
        Double elevation = null;
        Iterator<int[]> iterator = nearestNeighbors.iterator();
        while (iterator.hasNext() && (elevation = this.getElevationValueOverBorders(griddedTile, image, leftLastColumns, topLeftRows, topRows, (nearestNeighbor = iterator.next())[0], nearestNeighbor[1])) == null) {
        }
        return elevation;
    }

    private Double getElevationValueOverBorders(GriddedTile griddedTile, TImage image, Double[][] leftLastColumns, Double[][] topLeftRows, Double[][] topRows, int x, int y) {
        Double elevation = null;
        if (x < image.getWidth() && y < image.getHeight()) {
            int column;
            int row;
            if (x >= 0 && y >= 0) {
                elevation = this.getElevationValue(griddedTile, image, x, y);
            } else if (x < 0 && y < 0) {
                int column2;
                int row2;
                if (topLeftRows != null && (row2 = -1 * y - 1) < topLeftRows.length && (column2 = x + topLeftRows[row2].length) >= 0) {
                    elevation = topLeftRows[row2][column2];
                }
            } else if (x < 0) {
                int row3;
                int column3;
                if (leftLastColumns != null && (column3 = -1 * x - 1) < leftLastColumns.length && (row3 = y) < leftLastColumns[column3].length) {
                    elevation = leftLastColumns[column3][row3];
                }
            } else if (topRows != null && (row = -1 * y - 1) < topRows.length && (column = x) < topRows[row].length) {
                elevation = topRows[row][column];
            }
        }
        return elevation;
    }
}

