/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.elevation;

import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import mil.nga.geopackage.extension.elevation.GriddedCoverageDao;
import mil.nga.geopackage.extension.elevation.GriddedCoverageDataType;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSet;

@DatabaseTable(tableName="gpkg_2d_gridded_coverage_ancillary", daoClass=GriddedCoverageDao.class)
public class GriddedCoverage {
    public static final String TABLE_NAME = "gpkg_2d_gridded_coverage_ancillary";
    public static final String COLUMN_ID = "id";
    public static final String COLUMN_TILE_MATRIX_SET_NAME = "tile_matrix_set_name";
    public static final String COLUMN_DATATYPE = "datatype";
    public static final String COLUMN_SCALE = "scale";
    public static final String COLUMN_OFFSET = "offset";
    public static final String COLUMN_PRECISION = "precision";
    public static final String COLUMN_DATA_NULL = "data_null";
    @DatabaseField(columnName="id", generatedId=true, canBeNull=false)
    private long id;
    @DatabaseField(columnName="tile_matrix_set_name", canBeNull=false, foreign=true, foreignAutoRefresh=true)
    private TileMatrixSet tileMatrixSet;
    @DatabaseField(columnName="tile_matrix_set_name", canBeNull=false)
    private String tileMatrixSetName;
    @DatabaseField(columnName="datatype", canBeNull=false)
    private String datatype;
    @DatabaseField(columnName="scale")
    private Double scale = 1.0;
    @DatabaseField(columnName="offset")
    private Double offset = 0.0;
    @DatabaseField(columnName="precision")
    private Double precision = 1.0;
    @DatabaseField(columnName="data_null")
    private Double dataNull;

    public long getId() {
        return this.id;
    }

    public TileMatrixSet getTileMatrixSet() {
        return this.tileMatrixSet;
    }

    public void setTileMatrixSet(TileMatrixSet tileMatrixSet) {
        this.tileMatrixSet = tileMatrixSet;
        this.tileMatrixSetName = tileMatrixSet != null ? tileMatrixSet.getTableName() : null;
    }

    public String getTileMatrixSetName() {
        return this.tileMatrixSetName;
    }

    public GriddedCoverageDataType getDataType() {
        return GriddedCoverageDataType.fromName(this.datatype);
    }

    public void setDataType(GriddedCoverageDataType datatype) {
        this.datatype = datatype.getName();
    }

    public Double getScale() {
        return this.scale;
    }

    public double getScaleOrDefault() {
        return this.scale != null ? this.scale : 1.0;
    }

    public void setScale(Double scale) {
        this.scale = scale;
    }

    public Double getOffset() {
        return this.offset;
    }

    public double getOffsetOrDefault() {
        return this.offset != null ? this.offset : 0.0;
    }

    public void setOffset(Double offset) {
        this.offset = offset;
    }

    public double getPrecision() {
        return this.precision != null ? this.precision : 1.0;
    }

    public void setPrecision(Double precision) {
        this.precision = precision;
    }

    public Double getDataNull() {
        return this.dataNull;
    }

    public void setDataNull(Double dataNull) {
        this.dataNull = dataNull;
    }
}

