/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.features.user;

import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.GeoPackageDataType;
import mil.nga.geopackage.user.UserColumn;
import mil.nga.wkb.geom.GeometryType;

public class FeatureColumn
extends UserColumn {
    private final GeometryType geometryType;

    public static FeatureColumn createPrimaryKeyColumn(int index, String name) {
        return new FeatureColumn(index, name, GeoPackageDataType.INTEGER, null, true, null, true, null);
    }

    public static FeatureColumn createGeometryColumn(int index, String name, GeometryType type, boolean notNull, Object defaultValue) {
        if (type == null) {
            throw new GeoPackageException("Geometry Type is required to create geometry column: " + name);
        }
        return new FeatureColumn(index, name, null, null, notNull, defaultValue, false, type);
    }

    public static FeatureColumn createColumn(int index, String name, GeoPackageDataType type, boolean notNull, Object defaultValue) {
        return FeatureColumn.createColumn(index, name, type, null, notNull, defaultValue);
    }

    public static FeatureColumn createColumn(int index, String name, GeoPackageDataType type, Long max, boolean notNull, Object defaultValue) {
        return new FeatureColumn(index, name, type, max, notNull, defaultValue, false, null);
    }

    FeatureColumn(int index, String name, GeoPackageDataType dataType, Long max, boolean notNull, Object defaultValue, boolean primaryKey, GeometryType geometryType) {
        super(index, name, dataType, max, notNull, defaultValue, primaryKey);
        this.geometryType = geometryType;
        if (geometryType == null && dataType == null) {
            throw new GeoPackageException("Data Type is required to create column: " + name);
        }
    }

    public boolean isGeometry() {
        return this.geometryType != null;
    }

    public GeometryType getGeometryType() {
        return this.geometryType;
    }

    @Override
    public String getTypeName() {
        String type = this.isGeometry() ? this.geometryType.name() : super.getTypeName();
        return type;
    }
}

