/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.geom;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.extension.GeometryExtensions;
import mil.nga.wkb.geom.Geometry;
import mil.nga.wkb.geom.GeometryEnvelope;
import mil.nga.wkb.io.ByteReader;
import mil.nga.wkb.io.ByteWriter;
import mil.nga.wkb.io.WkbGeometryReader;
import mil.nga.wkb.io.WkbGeometryWriter;

public class GeoPackageGeometryData {
    private byte[] bytes;
    private boolean extended = false;
    private boolean empty = true;
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    private int srsId;
    private GeometryEnvelope envelope;
    private int wkbGeometryIndex;
    private Geometry geometry;

    public GeoPackageGeometryData(long srsId) {
        this.srsId = (int)srsId;
    }

    public GeoPackageGeometryData(byte[] bytes) {
        this.fromBytes(bytes);
    }

    public void fromBytes(byte[] bytes) {
        this.bytes = bytes;
        ByteReader reader = new ByteReader(bytes);
        String magic = null;
        try {
            magic = reader.readString(2);
        }
        catch (UnsupportedEncodingException e) {
            throw new GeoPackageException("Unexpected GeoPackage Geometry magic number character encoding: Expected: GP");
        }
        if (!magic.equals("GP")) {
            throw new GeoPackageException("Unexpected GeoPackage Geometry magic number: " + magic + ", Expected: " + "GP");
        }
        byte version = reader.readByte();
        if (version != 0) {
            throw new GeoPackageException("Unexpected GeoPackage Geometry version: " + version + ", Expected: " + 0);
        }
        byte flags = reader.readByte();
        int envelopeIndicator = this.readFlags(flags);
        reader.setByteOrder(this.byteOrder);
        this.srsId = reader.readInt();
        this.envelope = this.readEnvelope(envelopeIndicator, reader);
        this.wkbGeometryIndex = reader.getNextByte();
        if (!this.empty) {
            this.geometry = WkbGeometryReader.readGeometry((ByteReader)reader);
        }
    }

    public byte[] toBytes() throws IOException {
        ByteWriter writer = new ByteWriter();
        writer.writeString("GP");
        writer.writeByte((byte)0);
        byte flags = this.buildFlagsByte();
        writer.writeByte(flags);
        writer.setByteOrder(this.byteOrder);
        writer.writeInt(this.srsId);
        this.writeEnvelope(writer);
        this.wkbGeometryIndex = writer.size();
        if (!this.empty) {
            WkbGeometryWriter.writeGeometry((ByteWriter)writer, (Geometry)this.geometry);
        }
        this.bytes = writer.getBytes();
        writer.close();
        return this.bytes;
    }

    private int readFlags(byte flags) {
        int reserved7 = flags >> 7 & 1;
        int reserved6 = flags >> 6 & 1;
        if (reserved7 != 0 || reserved6 != 0) {
            throw new GeoPackageException("Unexpected GeoPackage Geometry flags. Flag bit 7 and 6 should both be 0, 7=" + reserved7 + ", 6=" + reserved6);
        }
        int binaryType = flags >> 5 & 1;
        this.extended = binaryType == 1;
        int emptyValue = flags >> 4 & 1;
        this.empty = emptyValue == 1;
        int envelopeIndicator = flags >> 1 & 7;
        if (envelopeIndicator > 4) {
            throw new GeoPackageException("Unexpected GeoPackage Geometry flags. Envelope contents indicator must be between 0 and 4. Actual: " + envelopeIndicator);
        }
        int byteOrderValue = flags & 1;
        this.byteOrder = byteOrderValue == 0 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        return envelopeIndicator;
    }

    private byte buildFlagsByte() {
        byte flag = 0;
        int binaryType = this.extended ? 1 : 0;
        flag = (byte)(flag + (binaryType << 5));
        int emptyValue = this.empty ? 1 : 0;
        flag = (byte)(flag + (emptyValue << 4));
        int envelopeIndicator = this.envelope == null ? 0 : GeoPackageGeometryData.getIndicator(this.envelope);
        flag = (byte)(flag + (envelopeIndicator << 1));
        int byteOrderValue = this.byteOrder == ByteOrder.BIG_ENDIAN ? 0 : 1;
        flag = (byte)(flag + byteOrderValue);
        return flag;
    }

    private GeometryEnvelope readEnvelope(int envelopeIndicator, ByteReader reader) {
        GeometryEnvelope envelope = null;
        if (envelopeIndicator > 0) {
            double minX = reader.readDouble();
            double maxX = reader.readDouble();
            double minY = reader.readDouble();
            double maxY = reader.readDouble();
            boolean hasZ = false;
            Double minZ = null;
            Double maxZ = null;
            boolean hasM = false;
            Double minM = null;
            Double maxM = null;
            if (envelopeIndicator == 2 || envelopeIndicator == 4) {
                hasZ = true;
                minZ = reader.readDouble();
                maxZ = reader.readDouble();
            }
            if (envelopeIndicator == 3 || envelopeIndicator == 4) {
                hasM = true;
                minM = reader.readDouble();
                maxM = reader.readDouble();
            }
            envelope = new GeometryEnvelope(hasZ, hasM);
            envelope.setMinX(minX);
            envelope.setMaxX(maxX);
            envelope.setMinY(minY);
            envelope.setMaxY(maxY);
            if (hasZ) {
                envelope.setMinZ(minZ);
                envelope.setMaxZ(maxZ);
            }
            if (hasM) {
                envelope.setMinM(minM);
                envelope.setMaxM(maxM);
            }
        }
        return envelope;
    }

    private void writeEnvelope(ByteWriter writer) throws IOException {
        if (this.envelope != null) {
            writer.writeDouble(this.envelope.getMinX());
            writer.writeDouble(this.envelope.getMaxX());
            writer.writeDouble(this.envelope.getMinY());
            writer.writeDouble(this.envelope.getMaxY());
            if (this.envelope.hasZ()) {
                writer.writeDouble(this.envelope.getMinZ().doubleValue());
                writer.writeDouble(this.envelope.getMaxZ().doubleValue());
            }
            if (this.envelope.hasM()) {
                writer.writeDouble(this.envelope.getMinM().doubleValue());
                writer.writeDouble(this.envelope.getMaxM().doubleValue());
            }
        }
    }

    public boolean isExtended() {
        return this.extended;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public int getSrsId() {
        return this.srsId;
    }

    public GeometryEnvelope getEnvelope() {
        return this.envelope;
    }

    public Geometry getGeometry() {
        return this.geometry;
    }

    public void setExtended(boolean extended) {
        this.extended = extended;
    }

    public void setEmpty(boolean empty) {
        this.empty = empty;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public void setSrsId(int srsId) {
        this.srsId = srsId;
    }

    public void setEnvelope(GeometryEnvelope envelope) {
        this.envelope = envelope;
    }

    public void setGeometry(Geometry geometry) {
        this.geometry = geometry;
        boolean bl = this.empty = geometry == null;
        if (geometry != null) {
            this.extended = GeometryExtensions.isExtension(geometry.getGeometryType());
        }
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public byte[] getHeaderBytes() {
        byte[] headerBytes = new byte[this.wkbGeometryIndex];
        System.arraycopy(this.bytes, 0, headerBytes, 0, this.wkbGeometryIndex);
        return headerBytes;
    }

    public ByteBuffer getHeaderByteBuffer() {
        return ByteBuffer.wrap(this.bytes, 0, this.wkbGeometryIndex).order(this.byteOrder);
    }

    public byte[] getWkbBytes() {
        int wkbByteCount = this.bytes.length - this.wkbGeometryIndex;
        byte[] wkbBytes = new byte[wkbByteCount];
        System.arraycopy(this.bytes, this.wkbGeometryIndex, wkbBytes, 0, wkbByteCount);
        return wkbBytes;
    }

    public ByteBuffer getWkbByteBuffer() {
        return ByteBuffer.wrap(this.bytes, this.wkbGeometryIndex, this.bytes.length - this.wkbGeometryIndex).order(this.byteOrder);
    }

    public int getWkbGeometryIndex() {
        return this.wkbGeometryIndex;
    }

    public static int getIndicator(GeometryEnvelope envelope) {
        int indicator = 1;
        if (envelope.hasZ()) {
            ++indicator;
        }
        if (envelope.hasM()) {
            indicator += 2;
        }
        return indicator;
    }
}

